/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.iterations.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class ArbitraryCycles {
    public static void main(String[] args) throws Exception {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
            ProjectSession ps = projectSessionh.create();
            System.out.print("\n   Creating ArbitraryCycles model");
            ps.initModel("ArbitraryCycles");
            ps.setProperty("condition1", "50");
            ps.setProperty("condition2", "50");
            ps.setProperty("randomNum", "0");
            ps.addNode("A", 1);
            ps.addNode("B", 3);
            ps.addNode("C", 3);
            ps.addNode("D", 3);
            ps.addNode("E", 3);
            ps.addNode("F", 3);
            ps.setNodeTraditional("A");
            ps.setNodeTraditional("B");
            ps.setNodeTraditional("C");
            ps.setNodeTraditional("D");
            ps.setNodeTraditional("E");
            ps.setNodeTraditional("F");
            ps.addEdge("A", "B");
            ps.addEdge("B", "C");
            ps.addEdge("C", "D");
            String fromDtoE = ps.addEdge("D", "E");
            String fromEtoF = ps.addEdge("E", "F");
            ps.setEdgeCondition(fromDtoE, "(new Integer(randomNum).intValue() >= new Integer(condition1).intValue())");
            ps.setEdgeCondition(fromEtoF, "(new Integer(randomNum).intValue() >= new Integer(condition2).intValue())");
            String generateRandomScript = "import hero.interfaces.*;\nimport java.util.Random; \nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  String name = n.getName(); \n  Random generator = new Random(System.currentTimeMillis()); \n  int newRnd = generator.nextInt(100); \n  prjSession.setProperty(\"randomNum\", Integer.toString(newRnd)); \n  System.out.print(\" --> BeforeTerminate, node '\" + name + \"' new random value : \" + newRnd); \n  BnProjectPropertyValue conditionProp; \n  if (name.equals(\"D\")) { \n    conditionProp = prjSession.getProperty(\"condition1\"); \n    if (newRnd < Integer.parseInt(conditionProp.getTheValue())) { \n      System.out.println(\" --> ITERATE --> next activity 'B'\"); \n    } else { \n      System.out.println(\" --> DON'T ITERATE --> next activity 'E'\"); \n    } \n  } else { \n    conditionProp = prjSession.getProperty(\"condition2\"); \n    if (newRnd < Integer.parseInt(conditionProp.getTheValue())) { \n      System.out.println(\" --> ITERATE --> next activity 'C'\"); \n    } else { \n      System.out.println(\" --> DON'T ITERATE --> next activity 'F'\"); \n    } \n  } \n} \n";
            ps.addNodeInterHook("D", "Generates random number and saves it in 'randomNum' var", "beforeTerminate", 6, generateRandomScript);
            ps.addNodeInterHook("E", "Generates random number and saves it in 'randomNum' var", "beforeTerminate", 6, generateRandomScript);
            ps.addIteration("D", "B", "(new Integer(randomNum).intValue() < new Integer(condition1).intValue())");
            ps.addIteration("E", "C", "(new Integer(randomNum).intValue() < new Integer(condition2).intValue())");
            ps.addRole("Administrator", "The system administator role");
            ps.setNodeRole("A", "Administrator");
            ps.addRoleMapper("Administrator", "AdministratorMapper", 1);
            ps.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

