/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.iterations.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class IterationInsideIteration {
    public static void main(String[] args) throws Exception {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
            ProjectSession ps = projectSessionh.create();
            System.out.print("\n   Creating IterationInsideIteration model");
            ps.initModel("IterationInsideIteration");
            ps.setProperty("condition1", "true");
            ps.setProperty("condition2", "true");
            ps.setProperty("repetitions1", "2");
            ps.setProperty("repetitions2", "2");
            ps.addNode("A", 1);
            ps.addNode("B", 1);
            ps.addNode("C", 1);
            ps.addNode("D", 1);
            ps.setNodeTraditional("A");
            ps.setNodeTraditional("B");
            ps.setNodeTraditional("C");
            ps.setNodeTraditional("D");
            ps.addEdge("A", "B");
            String fromBtoC = ps.addEdge("B", "C");
            String fromCtoD = ps.addEdge("C", "D");
            ps.setEdgeCondition(fromBtoC, "condition1.equals(\"false\")");
            ps.setEdgeCondition(fromCtoD, "condition2.equals(\"false\")");
            String repeat1Script = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue repetitions1Prop = prjSession.getProperty(\"repetitions1\"); \n  int repetitions1 = Integer.parseInt(repetitions1Prop.getTheValue()); \n  repetitions1--; \n  if (repetitions1 == 0) { \n    prjSession.setProperty(\"repetitions1\", \"2\"); \n    prjSession.setProperty(\"condition1\", \"false\"); \n  } else { \n     prjSession.setProperty(\"repetitions1\", Integer.toString(repetitions1)); \n  } \n} \n";
            ps.addNodeInterHook("B", "Repeat1 hook", "beforeTerminate", 6, repeat1Script);
            ps.addIteration("B", "B", "condition1.equals(\"true\")");
            String repeat2Script = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue repetitions2Prop = prjSession.getProperty(\"repetitions2\"); \n  int repetitions2 = Integer.parseInt(repetitions2Prop.getTheValue()); \n  repetitions2--; \n  if (repetitions2 == 0) { \n    prjSession.setProperty(\"condition2\", \"false\"); \n  } else { \n     prjSession.setProperty(\"repetitions2\", Integer.toString(repetitions2)); \n    prjSession.setProperty(\"condition1\", \"true\"); \n  } \n} \n";
            ps.addNodeInterHook("C", "Repeat2 hook", "beforeTerminate", 6, repeat2Script);
            ps.addIteration("C", "A", "condition2.equals(\"true\")");
            ps.addRole("Administrator", "The system administator role");
            ps.setNodeRole("A", "Administrator");
            ps.setNodeRole("B", "Administrator");
            ps.setNodeRole("C", "Administrator");
            ps.setNodeRole("D", "Administrator");
            ps.addRoleMapper("Administrator", "AdministratorMapper", 1);
            ps.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

