/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern06MultiChoice {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 06 - Multi Choice");
            prjSession.initModel("Pattern 06 - Multi Choice");
            prjSession.addNode("evaluate_damage", 1);
            prjSession.addNode("contact_fire_department", 1);
            prjSession.addNode("contact_police", 1);
            prjSession.addNode("contact_hospital", 1);
            prjSession.setNodeTraditional("evaluate_damage");
            prjSession.setNodeTraditional("contact_fire_department");
            prjSession.setNodeTraditional("contact_police");
            prjSession.setNodeTraditional("contact_hospital");
            String toFireDep = prjSession.addEdge("evaluate_damage", "contact_fire_department");
            String toPolice = prjSession.addEdge("evaluate_damage", "contact_police");
            String toHospital = prjSession.addEdge("evaluate_damage", "contact_hospital");
            prjSession.setNodeProperty("evaluate_damage", "call_fire_department", "false", false);
            prjSession.setNodeProperty("evaluate_damage", "call_police", "true", false);
            prjSession.setNodeProperty("evaluate_damage", "call_hospital", "true", false);
            prjSession.setEdgeCondition(toFireDep, "call_fire_department.equals(\"true\")");
            prjSession.setEdgeCondition(toPolice, "call_police.equals(\"true\")");
            prjSession.setEdgeCondition(toHospital, "call_hospital.equals(\"true\")");
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("evaluate_damage", "Executor");
            prjSession.setNodeRole("contact_fire_department", "Executor");
            prjSession.setNodeRole("contact_police", "Executor");
            prjSession.setNodeRole("contact_hospital", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

