/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern18Milestone {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 18 - Milestone");
            prjSession.initModel("Pattern 18 - Milestone");
            prjSession.addNode("B", 1);
            prjSession.addNode("A", 1);
            prjSession.addNode("C", 1);
            prjSession.setNodeTraditional("B");
            prjSession.setNodeTraditional("A");
            prjSession.setNodeTraditional("C");
            prjSession.addEdge("B", "C");
            prjSession.addEdge("B", "A");
            String cancelScript = "import hero.interfaces.*; \nbeforeStart(Object engine, Object currentNode) { \n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  if (prjSession.getNodeState(\"A\") == hero.interfaces.Constants.Nd.READY) { \n    UserSessionHome userHome = UserSessionUtil.getHome(); \n    UserSession userSession = userHome.create(); \n    userSession.cancelActivity(currentNode.getBnProject().getName(), \"A\"); \n   } \n}";
            prjSession.addNodeInterHook("C", "C Hook", "beforeStart", 6, cancelScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("B", "Executor");
            prjSession.setNodeRole("A", "Executor");
            prjSession.setNodeRole("C", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

