/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.interfaces.BnAuthRole;
import hero.interfaces.BnAuthRoleHome;
import hero.interfaces.BnAuthRoleUtil;
import hero.interfaces.BnProject;
import hero.interfaces.BnProjectHome;
import hero.interfaces.BnProjectUtil;
import hero.interfaces.BnUser;
import hero.interfaces.BnUserHome;
import hero.interfaces.BnUserUtil;
import hero.interfaces.InsertAuthRoleUser;
import hero.interfaces.InsertAuthRoleUserHome;
import hero.interfaces.InsertAuthRoleUserUtil;
import hero.util.BonitaProjectLocator;
import hero.util.BonitaServiceException;
import hero.util.HeroException;
import java.util.Collection;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DbReset
extends TestCase {
    private BnUserHome uhome;
    private BnAuthRoleHome arhome;
    private BnProjectHome pHome;
    private BnUserHome uHome;
    private BnAuthRoleHome aHome;

    public DbReset(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(DbReset.class);
    }

    public void setUp() throws Exception {
    }

    public void testDbReset() throws Exception {
        this.pHome = BnProjectUtil.getHome();
        Collection projects = this.pHome.findAll();
        for (BnProject project : projects) {
            try {
                if (project.getType().equals("Model")) {
                    BonitaProjectLocator.getInstance().cleanModelValue(project.getName(), project.getVersion());
                }
            }
            catch (BonitaServiceException se) {
                throw new HeroException(se.getMessage());
            }
            project.remove();
        }
        this.uHome = BnUserUtil.getHome();
        Collection users = this.uHome.findAll();
        for (BnUser user : users) {
            user.remove();
        }
        this.aHome = BnAuthRoleUtil.getHome();
        Collection auths = this.aHome.findAll();
        for (BnAuthRole auth : auths) {
            auth.remove();
        }
        InsertAuthRoleUserHome lHome = InsertAuthRoleUserUtil.getHome();
        InsertAuthRoleUser lBean = lHome.create();
        lBean.initializeUser("admin", "toto", "toxic@loria.fr");
        lBean.initializeUser("admin2", "toto2", "toxic@loria.fr");
        lBean.initializeUser("nobody", "nobody", "toxic@loria.fr");
        lBean.initializeAuthRole("BONITAUSER", "BONITAUSER");
        lBean.initializeAuthRole("nobody", "nobody");
        lBean.initialize("admin", "BONITAUSER");
        lBean.initialize("admin", "nobody");
        lBean.initialize("admin2", "BONITAUSER");
        lBean.initialize("admin2", "nobody");
        lBean.initialize("nobody", "nobody");
    }
}

