/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.interfaces.BnEdgeValue;
import hero.interfaces.BnNodePropertyValue;
import hero.interfaces.BnNodeValue;
import hero.interfaces.BnProjectHome;
import hero.interfaces.BnProjectPropertyValue;
import hero.interfaces.BnProjectValue;
import hero.interfaces.BnRoleMapperValue;
import hero.interfaces.BnUser;
import hero.interfaces.BnUserHome;
import hero.interfaces.BnUserLightValue;
import hero.interfaces.BnUserUtil;
import hero.interfaces.BnUserValue;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import hero.util.DuplicatedEdgeException;
import hero.util.HeroException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ProjectSessionTests
extends TestCase {
    private BnProjectHome projecth;
    private ProjectSessionHome projectSessionh;

    public ProjectSessionTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(ProjectSessionTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testCreateProjectSession() throws Exception {
        int i;
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectsession");
        BnProjectValue pv = lProject.getDetails();
        BnUserLightValue[] uv = pv.getBnUsers();
        for (i = 0; i < uv.length && !uv[i].getName().equals("admin"); ++i) {
        }
        ProjectSessionTests.assertTrue((String)"Admin is in the projet", (i < uv.length ? 1 : 0) != 0);
    }

    public void testCloneProjectSession() throws Exception {
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectsource");
        lProject.addNode("nclone", 1);
        lProject.addNode("c1", 1);
        lProject.addNode("c2", 1);
        lProject.setNodeRole("nclone", "admin");
        lProject.setNodeRole("c1", "admin");
        lProject.setNodeRole("c2", "admin");
        String edge1 = lProject.addEdge("c1", "c2");
        lProject = lHome.create();
        lProject.initProject("projectsource", "tralara");
        BnProjectValue pv = lProject.getDetails();
        ProjectSessionTests.assertTrue((String)"Clone failure1", (pv.getBnNodes().length == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Clone failure2", (boolean)pv.getName().equalsIgnoreCase("tralara"));
    }

    public void testImportProject() throws Exception {
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectS");
        lProject.addNode("nclone", 1);
        lProject.addNode("c1", 1);
        lProject.addNode("c2", 1);
        lProject.setNodeRole("nclone", "admin");
        lProject.setNodeRole("c1", "admin");
        lProject.setNodeRole("c2", "admin");
        String edge1 = lProject.addEdge("c1", "c2");
        lProject = lHome.create();
        lProject.initProject("pDest");
        lProject.addNode("nclone2", 1);
        lProject.setNodeRole("nclone2", "admin");
        lProject.importProject("projectS", "1.0", "pDest");
        BnProjectValue pv = lProject.getDetails();
        ProjectSessionTests.assertTrue((String)"Clone failure1", (pv.getBnNodes().length == 4 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Clone failure2", (boolean)pv.getName().equalsIgnoreCase("pDest"));
    }

    public void testAddUserToProject() throws Exception {
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectadduser");
        BnUserHome uHome = BnUserUtil.getHome();
        BnUserValue pdata = new BnUserValue();
        pdata.setName("bidochon");
        pdata.setPassword("bidochon");
        pdata.setEmail("bidochon@loria.fr");
        BnUser lUser = uHome.create(pdata);
        lProject.addUser("bidochon");
        pdata.setName("marcel");
        pdata.setPassword("marcel");
        pdata.setEmail("marcel@loria.fr");
        lUser = uHome.create(pdata);
        lProject.addUser("marcel");
        pdata.setName("germaine");
        pdata.setPassword("germaine");
        pdata.setEmail("germaine@loria.fr");
        lUser = uHome.create(pdata);
        lProject.addUser("germaine");
        ProjectSessionTests.assertTrue((boolean)lProject.containsUser("bidochon"));
    }

    public void testAddNodeToProject() throws Exception {
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectaddnode");
        lProject.addNode("thenode", 1);
        BnNodeValue nv = lProject.getNodeValue("thenode");
        ProjectSessionTests.assertTrue((String)"Creator not correctly set", (boolean)nv.getCreator().equals("admin"));
    }

    public void testAddEdgeToProject() throws Exception {
        ProjectSessionHome lHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = lHome.create();
        lProject.initProject("projectaddedge");
        lProject.addNode("thenode", 1);
        lProject.addNode("thenode2", 1);
        String ename = lProject.addEdge("thenode", "thenode2");
        BnEdgeValue ev = lProject.getEdgeValue(ename);
        BnNodeValue nv = lProject.getNodeValue("thenode2");
        ProjectSessionTests.assertTrue((String)"addEdge failed a1", (ev.getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"bad node state test3", (nv.getState() == 0 ? 1 : 0) != 0);
    }

    public void testProjectSessionAddUser() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("pst");
        try {
            pss.addUser("badUser");
            ProjectSessionTests.assertTrue((String)"Should have throw EJBException", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testProjectSessionAddNode() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("pst2");
        pss.addNode("test", 1);
        BnNodeValue pv = pss.getNodeValue("test");
        ProjectSessionTests.assertTrue((String)"Creator not correctly set", (boolean)pv.getCreator().equals("admin"));
    }

    public void testProjectSessionAddEdgesState() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("w");
        pss.addNode("node1", 1);
        pss.addNode("node2", 1);
        pss.addNode("node3", 1);
        String edname = pss.addEdge("node1", "node2");
        BnEdgeValue ev = pss.getEdgeValue(edname);
        BnNodeValue nv = pss.getNodeValue("node2");
        ProjectSessionTests.assertTrue((String)"addEdge failed a1", (ev.getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"addEdge failed a1/n2", (nv.getState() == 0 ? 1 : 0) != 0);
        edname = pss.addEdge("node2", "node3");
        ev = pss.getEdgeValue(edname);
        BnNodeValue nv2 = pss.getNodeValue("node2");
        BnNodeValue nv3 = pss.getNodeValue("node3");
        ProjectSessionTests.assertTrue((String)"addEdge failed a2", (ev.getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"addEdge failed a2/nv2", (nv2.getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"addEdge failed a2/nv3", (nv3.getState() == 0 ? 1 : 0) != 0);
    }

    public void testcheckDuplicateEdge() throws Exception {
        try {
            ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
            ProjectSession pss = projectSessionh.create();
            pss.initProject("wde");
            pss.addNode("node1", 1);
            pss.addNode("node2", 1);
            pss.addEdge("node1", "node2");
            pss.addNode("node3", 1);
            pss.addEdge("node2", "node3");
            pss.addNode("node4", 1);
            pss.addEdge("node1", "node4");
            pss.addEdge("node1", "node2");
            ProjectSessionTests.assertTrue((String)"Should have thrown a DuplicatedEdgeException", (boolean)false);
        }
        catch (DuplicatedEdgeException duplicatedEdgeException) {
            // empty catch block
        }
    }

    public void testDynamicProject() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("dynamic");
        pss.addNode("n1", 1);
        pss.addNode("n2", 1);
        pss.addEdge("n1", "n2");
        pss.setNodeRole("n1", "admin");
        pss.setNodeRole("n1", "admin");
        UserSession usr = usersh.create();
        usr.startActivity("dynamic", "n1");
        pss.addNode("n3", 1);
        String edge2 = pss.addEdge("n2", "n3");
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1", (pss.getNodeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2", (pss.getNodeValue("n2").getState() == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3", (pss.getNodeValue("n3").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity("dynamic", "n2");
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1.1", (pss.getNodeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2.1", (pss.getNodeValue("n2").getState() == 5 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3.1", (pss.getNodeValue("n3").getState() == 3 ? 1 : 0) != 0);
        pss.deleteEdge(edge2);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1.2", (pss.getNodeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2.2", (pss.getNodeValue("n2").getState() == 5 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3.2", (pss.getNodeValue("n3").getState() == 1 ? 1 : 0) != 0);
        pss.addEdge("n2", "n3");
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1.3", (pss.getNodeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2.3", (pss.getNodeValue("n2").getState() == 5 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3.3", (pss.getNodeValue("n3").getState() == 3 ? 1 : 0) != 0);
    }

    public void TestDynamicProject2() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("dynamic2");
        pss.addNode("n1", 1);
        pss.addNode("n2", 1);
        String edge1 = pss.addEdge("n1", "n2");
        pss.setNodeRole("n1", "admin");
        pss.setNodeRole("n2", "admin");
        UserSession usr = usersh.create();
        usr.startActivity("dynamic2", "n1");
        pss.addNode("n3", 1);
        pss.addEdge("n2", "n3");
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1", (pss.getEdgeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2", (pss.getEdgeValue("n2").getState() == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3", (pss.getEdgeValue("n3").getState() == 0 ? 1 : 0) != 0);
        pss.addNode("n4", 1);
        pss.addEdge("n1", "n4");
        pss.deleteEdge(edge1);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n1.1", (pss.getEdgeValue("n1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n2.1", (pss.getEdgeValue("n2").getState() == 1 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n3.1", (pss.getEdgeValue("n3").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"dynamic change failed - n4.1", (pss.getEdgeValue("n4").getState() == 3 ? 1 : 0) != 0);
    }

    public void testDeleteNode() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("deleteNode");
        pss.addNode("n1", 1);
        pss.addNode("n2", 1);
        String edge1 = pss.addEdge("n1", "n2");
        pss.setNodeRole("n1", "admin");
        pss.setNodeRole("n2", "admin");
        try {
            pss.deleteNode("n2");
        }
        catch (HeroException he) {
            ProjectSessionTests.assertTrue((String)"Deletion Failed", (boolean)false);
        }
        UserSession usr = usersh.create();
        usr.startActivity("deleteNode", "n1");
        try {
            pss.deleteNode("n1");
            ProjectSessionTests.assertTrue((String)"Deletion Should have Failed", (boolean)false);
        }
        catch (HeroException he) {
            // empty catch block
        }
    }

    public void testPropertyNode() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.addNode("n1", 1);
        pss.addNode("n2", 1);
        String edge1 = pss.addEdge("n1", "n2");
        pss.setNodeRole("n1", "admin");
        pss.setNodeRole("n2", "admin");
        pss.setNodeProperty("n1", "kpn1", "vpn1");
        pss.setNodeProperty("n2", "kpn2", "vpn2");
        pss.setNodeProperty("n2", "kpn2", "vpn22");
        pss.deleteNode("n2");
    }

    public void testDeletePropertyNode() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.deleteNodeProperty("n1", "kpn1");
    }

    public void testPropertyProject() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.setProperty("maintenant", "ara");
        pss.setProperty("deja", "ahora");
        pss.setProperty("deja", "ja");
    }

    public void testDeletePropertyProject() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.deleteProperty("maintenant");
    }

    public void testNodePropertyPropagate() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.addNode("n5", 1);
        pss.addNode("n6", 1);
        String edge1 = pss.addEdge("n5", "n6");
        pss.setNodeRole("n5", "admin");
        pss.setNodeRole("n6", "admin");
        pss.setNodeProperty("n5", "value", "15");
        pss.setNodeProperty("n5", "value2", "10");
        pss.setNodeProperty("n6", "value", "25");
        UserSession usr = usersh.create();
        usr.startActivity("propertyNode", "n5");
        usr.terminateActivity("propertyNode", "n5");
    }

    public void testGetPropertiesNode() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.addNode("p1", 1);
        pss.setNodeProperty("p1", "k1", "10");
        Collection c = pss.getNodeProperties("p1");
        for (BnNodePropertyValue p : c) {
            String key = p.getTheKey();
            String value = p.getTheValue();
            ProjectSessionTests.assertTrue((String)"Get BnNode Properties", (boolean)key.equalsIgnoreCase("k1"));
        }
    }

    public void testGetProperties() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("propertyNode");
        pss.setProperty("pk1", "xxx");
        Collection c = pss.getProperties();
        for (BnProjectPropertyValue p : c) {
            String key = p.getTheKey();
            String value = p.getTheValue();
            if (!value.equals("xxx")) continue;
            ProjectSessionTests.assertTrue((String)"Get Properties", (boolean)key.equals("pk1"));
        }
    }

    public void testNodeDeadline() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("deadlineNode");
        pss.addNode("d1", 1);
        pss.setNodeRole("d1", "admin");
        pss.setNodeDeadline("d1", System.currentTimeMillis() + 10000L);
    }

    public void testJavaHook() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("hookProject");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.addNodeHook("h1", "hero.hook.TestHook", "afterStart", 0);
        pss.setNodeRole("h1", "admin");
        usr.startActivity("hookProject", "h1");
        usr.terminateActivity("hookProject", "h1");
        usr.startActivity("hookProject", "h2");
        pss.deleteNodeHook("h1", "hero.hook.TestHook");
        usr.terminateActivity("hookProject", "h2");
    }

    public void testJavaHookInstance() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initModel("hookProjectInst");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.addNodeHook("h1", "hero.hook.TestHook", "afterStart", 0);
        pss.setNodeRole("h1", "admin");
        String instName = pss.instantiateProject("hookProjectInst");
        usr.startActivity(instName, "h1");
        usr.terminateActivity(instName, "h1");
        usr.startActivity(instName, "h2");
        usr.terminateActivity(instName, "h2");
    }

    public void testProjectJavaHook() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initModel("ProjectJavahook");
        pss.addNode("h1", 1);
        pss.addNode("h2", 1);
        pss.addEdge("h1", "h2");
        pss.addHook("hero.hook.TestProcessHook", "onInstantiate", 0);
        pss.instantiateProject("ProjectJavahook");
    }

    public void testNodeInterHook() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("hookInterNode");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.setNodeRole("h1", "admin");
        String edge1 = pss.addEdge("h1", "h2");
        String script = "import hero.interfaces.BnProjectLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"InteractiveBnNodee Hook test, node: \"+n.getName());}";
        pss.addNodeInterHook("h1", "interTest", "afterStart", 6, script);
        usr.startActivity("hookInterNode", "h1");
        usr.terminateActivity("hookInterNode", "h1");
    }

    public void testNodeInterHookProperty() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("hookInterNodeP");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.setNodeProperty("h1", "testp1", "testv1", true);
        pss.setNodeProperty("h1", "testp2", "testv2", true);
        pss.setNodeRole("h1", "admin");
        String edge1 = pss.addEdge("h1", "h2");
        String script = "import hero.interfaces.BnProjectLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"InteractiveBnNodee Hook properties tests, node: \"+n.getName());\nSystem.out.println(\"property \"+testp2);\n}";
        pss.addNodeInterHook("h1", "interTest", "afterStart", 6, script);
        usr.startActivity("hookInterNodeP", "h1");
        usr.terminateActivity("hookInterNodeP", "h1");
    }

    public void testProjectInterHook() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("hookInterProject");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.setNodeRole("h1", "admin");
        String edge1 = pss.addEdge("h1", "h2");
        String script = "import hero.interfaces.BnProjectLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"InteractiveBnProjectt Hook test, node: \"+n.getName());}";
        pss.addInterHook("projectInterTest", "afterStart", 6, script);
        usr.startActivity("hookInterProject", "h1");
        usr.terminateActivity("hookInterProject", "h1");
    }

    public void testDuplicatedInterHook() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("dupliHookInter");
        pss.addNode("h2", 1);
        pss.setNodeRole("h2", "admin");
        pss.addNode("h1", 1);
        pss.setNodeRole("h1", "admin");
        String edge1 = pss.addEdge("h1", "h2");
        String script = "import hero.interfaces.BnProjectLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"InteractiveBnProjectt Hook test, node: \"+n.getName()+\" project: \"+(n.getBnProject()).getName());}";
        pss.addInterHook("projectInterTest", "afterStart", 6, script);
        try {
            pss.addInterHook("projectInterTest", "afterStart", 6, script);
            ProjectSessionTests.assertTrue((String)"should have failed", (boolean)false);
        }
        catch (HeroException h) {
            // empty catch block
        }
        usr.startActivity("dupliHookInter", "h1");
        usr.terminateActivity("dupliHookInter", "h1");
    }

    public void testSubProcess() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("SubProject");
        pss.addNode("subNode1", 1);
        pss.addNode("subNode2", 1);
        pss.addRoleMapper("InitialRole", "mapper1", 1);
        pss.addEdge("subNode1", "subNode2");
        ProjectSession pss1 = projectSessionh.create();
        pss1 = projectSessionh.create();
        pss1.initProject("ParentProject");
        pss1.addRoleMapper("InitialRole", "mapper1", 1);
        pss1.addNode("node1", 1);
        pss1.addNode("node2", 1);
        pss1.addNodeSubProcess("nodeSub", "SubProject");
        pss1.addEdge("node1", "nodeSub");
        pss1.addEdge("nodeSub", "node2");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity("ParentProject", "node1");
        usr.terminateActivity("ParentProject", "node1");
        ProjectSessionTests.assertTrue((String)"SubProcess Error", (pss1.getNodeState("nodeSub") == 6 ? 1 : 0) != 0);
        usr.startActivity("SubProject", "subNode1");
        usr.startActivity("SubProject", "subNode2");
        usr.terminateActivity("SubProject", "subNode1");
        usr.terminateActivity("SubProject", "subNode2");
        ProjectSessionTests.assertTrue((String)"SubProcess Error 3", (pss1.getNodeState("nodeSub") == 10 ? 1 : 0) != 0);
    }

    public void testGetParent() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps = projectSessionh.create();
        ps.initModel("getParent");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("getParent2");
        ps.addNodeSubProcess("node", "getParent2");
        ps.initProject("getParent");
        String p = ps.getParent();
        ProjectSessionTests.assertTrue((String)"Error in getParent 2 when add subProcess", (boolean)p.equals("getParent"));
        ps2.initProject("getParent2");
        String p2 = ps2.getParent();
        ProjectSessionTests.assertTrue((String)"Error in getParent when add subProcess", (boolean)p2.equals("getParent2"));
        String instance = ps.instantiateProject("getParent");
        String pInstance = ps.getParent();
        ProjectSessionTests.assertTrue((String)"Error in getParent when instantiate", (boolean)pInstance.equals(ps.getName()));
    }

    public void testUnsetUserRole() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initProject("unset");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initProject("unset2");
        ps.addUser("admin2");
        ps.setUserRole("admin2", "InitialRole");
        ps2.addUser("admin2");
        ps2.setUserRole("admin2", "InitialRole");
        ps.unsetUserRole("admin2", "InitialRole");
        Collection names = ps.getUserRolesInProjectNames("admin2");
        ProjectSessionTests.assertTrue((String)"Error in unset user roles: InitialRole", (!names.contains("InitialRole") ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in unset user roles: admin", (boolean)names.contains("admin2"));
    }

    public void testMapper() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        String projectName = "TestMapperProperties5";
        pss.initModel(projectName);
        String role1 = "Admintata";
        pss.addRole(role1, "role pour activity 1");
        pss.addNode("node1", 1);
        pss.setNodeRole("node1", role1);
        pss.addRoleMapper(role1, "mapper1", 1);
        Collection co = null;
        co = pss.getRoleMappers();
        Iterator it = co.iterator();
        String mapperName = "";
        int mapperType = 100;
        while (it.hasNext()) {
            BnRoleMapperValue mv = (BnRoleMapperValue)it.next();
            mapperName = mv.getName();
            mapperType = mv.getType();
        }
        System.out.println("mapperName = " + mapperName);
        ProjectSessionTests.assertTrue((String)"Error retreiving the created mapper name", (boolean)"mapper1".equals(mapperName));
        ProjectSessionTests.assertTrue((String)"Error retreiving the created mapper id", (1 == mapperType ? 1 : 0) != 0);
        pss.instantiateProject(projectName);
        String creator = pss.getCreator();
        co = pss.getUserRolesInProjectNames(creator);
        ProjectSessionTests.assertTrue((String)"Role Admintata has not been set to the creator", (boolean)co.contains(creator));
    }

    public void testLazyInstantiation() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("LazyProject");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 2);
        ps.setNodeTraditional("node4");
        ps.addNode("node5", 1);
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        ps.addRoleMapper("InitialRole", "roleMapperTest", 1);
        String instName = ps.instantiateProject("LazyProject");
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after instantiation, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 1 ? 1 : 0) != 0);
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession us = userSessionh.create();
        ProjectSessionTests.assertTrue((String)"Error in roleMapper", (boolean)us.getToDoList(instName).contains("node0"));
    }

    public void testLazyInstantiationexecution() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("LazyProjectExec");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 2);
        ps.setNodeTraditional("node4");
        ps.addNode("node5", 1);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.setNodeTraditional("node8");
        ps.addNode("node9", 3);
        ps.setNodeTraditional("node9");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        ps.addEdge("node3", "node6");
        ps.addEdge("node4", "node6");
        ps.addEdge("node4", "node2");
        ps.addEdge("node5", "node6");
        ps.addEdge("node6", "node7");
        ps.addEdge("node3", "node8");
        ps.addEdge("node8", "node9");
        ps.addEdge("node5", "node4");
        String instName = ps.instantiateProject("LazyProjectExec");
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession us = userSessionh.create();
        us.startActivity(instName, "node0");
        ProjectSessionTests.assertTrue((String)"Error in state of node0 after start node0", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node1 after start node0", (ps.getNodeValue("node1").getState() == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node3 after start node0", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node4 after start node0", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node5 after start node0", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after start node0, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 5 ? 1 : 0) != 0);
        us.terminateActivity(instName, "node0");
        ProjectSessionTests.assertTrue((String)"Error in state of node0 after terminate node0", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node1 after terminate node0", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node3 after terminate node0", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node4 after terminate node0", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node5 after terminate node0", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after terminate node0, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 5 ? 1 : 0) != 0);
        us.startActivity(instName, "node1");
        ProjectSessionTests.assertTrue((String)"Error in state of node1 after start node1", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node3 after start node1", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node4 after start node1", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node5 after start node1", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node6 after start node1", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node8 after start node1", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after start node1, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 7 ? 1 : 0) != 0);
        us.startActivity(instName, "node3");
        us.startActivity(instName, "node5");
        ProjectSessionTests.assertTrue((String)"Error in state of node1 after start node3 and node5", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node3 after start node3 and node5", (ps.getNodeValue("node3").getState() == 5 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node4 after start node3 and node5", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node5 after start node3 and node5", (ps.getNodeValue("node5").getState() == 5 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node6 after start node3 and node5", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node8 after start node3 and node5", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after start node3 and node5, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 7 ? 1 : 0) != 0);
        us.terminateActivity(instName, "node1");
        us.terminateActivity(instName, "node3");
        us.terminateActivity(instName, "node5");
        ProjectSessionTests.assertTrue((String)"Error in state of node1 after terminate node1,node3 and node5", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node2 after terminate node1,node3 and node5", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node3 after terminate node1,node3 and node5", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node4 after terminate node1,node3 and node5", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node5 after terminate node1,node3 and node5", (ps.getNodeValue("node5").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node6 after terminate node1,node3 and node5", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node8 after terminate node1,node3 and node5", (ps.getNodeValue("node8").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in state of node9 after terminate node1,node3 and node5", (ps.getNodeValue("node9").getState() == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)("Error in number of nodes after start node3 and node5, number of nodes:" + ps.getNodesNames().size()), (ps.getNodesNames().size() == 9 ? 1 : 0) != 0);
        us.startActivity(instName, "node4");
        us.terminateActivity(instName, "node4");
        us.startActivity(instName, "node6");
        us.terminateActivity(instName, "node6");
        us.startActivity(instName, "node7");
        us.terminateActivity(instName, "node7");
        try {
            us.terminate(instName);
            ProjectSessionTests.assertTrue((String)"Error in terminate project, terminate project should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        us.startActivity(instName, "node2");
        us.terminateActivity(instName, "node2");
    }

    public void testUnsetUser() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initProject("unsetUser");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initProject("unsetUser2");
        ps.addUser("admin2");
        ProjectSessionTests.assertTrue((String)"Error in add user: ", (boolean)ps.getUsers().contains("admin2"));
        ps2.addUser("admin2");
        ProjectSessionTests.assertTrue((String)"Error in add user (2): ", (boolean)ps2.getUsers().contains("admin2"));
        ps.unsetUser("admin2");
        ProjectSessionTests.assertTrue((String)"Error in unset user: ", (!ps.getUsers().contains("admin2") ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error in add user (3): ", (boolean)ps2.getUsers().contains("admin2"));
        ps2.unsetUser("admin2");
        ProjectSessionTests.assertTrue((String)"Error in unset user (2): ", (!ps2.getUsers().contains("admin2") ? 1 : 0) != 0);
    }

    public void testGetUsersRole() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initProject("getUsersRole");
        ps.addUser("admin2");
        ps.addRole("roleTest", "");
        ps.setUserRole("admin2", "roleTest");
        ProjectSessionTests.assertTrue((String)"Error in getUsersRole (1): ", (boolean)ps.getUsersRole("roleTest").contains("admin2"));
        ProjectSessionTests.assertTrue((String)"Error in getUsersRole (1): ", (!ps.getUsersRole("roleTest").contains("admin") ? 1 : 0) != 0);
    }

    public void testPropertyPossibleValues() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initProject("ProjectPossibleValues");
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ps.setPropertyPossibleValues("key1", values);
        try {
            ps.setProperty("key1", "value3");
            ProjectSessionTests.assertTrue((String)"Error setProperty should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        ps.setProperty("key1", "value2");
    }

    public void testNodePropertyPossibleValues() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession user = usersh.create();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ProjectNodesPossibleValues");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        ps.setNodeRole("node1", "admin");
        ps.setNodeRole("node2", "admin");
        ps.setNodeRole("node3", "admin");
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ps.setNodePropertyPossibleValues("node1", "key1", values);
        try {
            ps.setNodeProperty("node1", "key1", "value3");
            ProjectSessionTests.assertTrue((String)"Error setNodeProperty should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        ps.setNodeProperty("node1", "key1", "value2", true);
        String instName = ps.instantiateProject("ProjectNodesPossibleValues");
        user.startActivity(instName, "node1");
        user.terminateActivity(instName, "node1");
        BnNodePropertyValue pv = ps.getNodeProperty("node2", "key1");
        ProjectSessionTests.assertTrue((String)"Error testNodeProperty after instantiation", (pv.getPossibleValues().size() == 2 ? 1 : 0) != 0);
        user.startActivity(instName, "node2");
        user.terminateActivity(instName, "node2");
        pv = ps.getNodeProperty("node3", "key1");
        ProjectSessionTests.assertTrue((String)"Error testNodeProperty after instantiation 2", (pv.getPossibleValues().size() == 2 ? 1 : 0) != 0);
    }

    public void testUpdateNodePropertyPossibleValues() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession user = usersh.create();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("UpdateProjectNodesPossibleValues");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        ps.setNodeRole("node1", "admin");
        ps.setNodeRole("node2", "admin");
        ps.setNodeRole("node3", "admin");
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ps.setNodePropertyPossibleValues("node1", "key1", values);
        try {
            ps.setNodeProperty("node1", "key1", "value3");
            ProjectSessionTests.assertTrue((String)"Error setNodeProperty should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        ps.setNodeProperty("node1", "key1", "value2", true);
        String instName = ps.instantiateProject("UpdateProjectNodesPossibleValues");
        user.startActivity(instName, "node1");
        user.terminateActivity(instName, "node1");
        BnNodePropertyValue pv = ps.getNodeProperty("node2", "key1");
        ProjectSessionTests.assertTrue((String)"Error testNodeProperty after instantiation", (pv.getPossibleValues().size() == 2 ? 1 : 0) != 0);
        values = new ArrayList();
        values.add("value3");
        values.add("value4");
        values.add("value5");
        ArrayList<String> ardf = new ArrayList<String>();
        ardf.add("value3");
        ps.updateNodePropertyPossibleValues("node2", "key1", values, ardf);
        pv = ps.getNodeProperty("node2", "key1");
        ProjectSessionTests.assertTrue((String)"Error testNodeProperty after instantiation", (pv.getPossibleValues().size() == 3 ? 1 : 0) != 0);
        user.startActivity(instName, "node2");
        user.terminateActivity(instName, "node2");
        pv = ps.getNodeProperty("node3", "key1");
        ProjectSessionTests.assertTrue((String)"Error testNodeProperty after instantiation 2", (pv.getPossibleValues().size() == 3 ? 1 : 0) != 0);
    }

    public void testUpdatePropertyPossibleValues() throws Exception {
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession user = usersh.create();
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("UpdateProjectPossibleValues");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        ps.setNodeRole("node1", "admin");
        ps.setNodeRole("node2", "admin");
        ps.setNodeRole("node3", "admin");
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ps.setPropertyPossibleValues("key1", values);
        try {
            ps.setProperty("key1", "value3");
            ProjectSessionTests.assertTrue((String)"Error setNodeProperty should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        ps.setProperty("key1", "value2");
        String instName = ps.instantiateProject("UpdateProjectPossibleValues");
        user.startActivity(instName, "node1");
        user.terminateActivity(instName, "node1");
        BnProjectPropertyValue pv = ps.getProperty("key1");
        ProjectSessionTests.assertTrue((String)"Error testProperty after instantiation", (pv.getPossibleValues().size() == 2 ? 1 : 0) != 0);
        values = new ArrayList();
        values.add("value3");
        values.add("value4");
        values.add("value5");
        ArrayList<String> ardf = new ArrayList<String>();
        ardf.add("value3");
        ps.updatePropertyPossibleValues("key1", values, ardf);
        pv = ps.getProperty("key1");
        ProjectSessionTests.assertTrue((String)"Error testProperty after instantiation", (pv.getPossibleValues().size() == 3 ? 1 : 0) != 0);
        user.startActivity(instName, "node2");
        user.terminateActivity(instName, "node2");
        pv = ps.getProperty("key1");
        ProjectSessionTests.assertTrue((String)"Error testProperty after instantiation 2", (pv.getPossibleValues().size() == 3 ? 1 : 0) != 0);
    }

    public void testAddDeleteInitiatorMapper() throws Exception {
        ProjectSessionHome pHome = ProjectSessionUtil.getHome();
        ProjectSession lProject = pHome.create();
        lProject.initModel("InitiatorModel");
        lProject.addInitiatorMapper("hero.initiatorMapper.CustomGroupMembers", 1);
        String instName = lProject.instantiateProject("InitiatorModel");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession user = uHome.create();
        user.removeProject(instName);
        user.removeProject("InitiatorModel");
        ProjectSessionTests.assertTrue((String)"Error testAddDeleteInitiator", (!lProject.existingProject("InitiatorProject") ? 1 : 0) != 0);
    }

    public void testSimpleVersioningTest() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initModelWithVersion("Approval_workflow_versioned", "1.0");
        pss.addNode("Approval", 1);
        pss.addNode("Approval2", 1);
        pss.addEdge("Approval", "Approval2");
        pss.initModelWithVersion("Approval_workflow_versioned", "1.1");
        pss.addNode("Approval", 1);
        pss.addNode("Approval2", 1);
        pss.addEdge("Approval", "Approval2");
        String instName = pss.instantiateProject("Approval_workflow_versioned", "1.1");
        ProjectSessionTests.assertTrue((String)"Error instance version", (boolean)pss.getDetails().getVersion().equals("1.1"));
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession uss = userSessionh.create();
        uss.startActivity(instName, "Approval");
        ProjectSessionTests.assertTrue((String)"Error Approval activity state", (pss.getNodeState("Approval") == 6 ? 1 : 0) != 0);
        uss.terminateActivity(instName, "Approval");
        ProjectSessionTests.assertTrue((String)"Error Approval activity state", (pss.getNodeState("Approval") == 10 ? 1 : 0) != 0);
        uss.startActivity(instName, "Approval2");
        ProjectSessionTests.assertTrue((String)"Error Approval2 activity state", (pss.getNodeState("Approval2") == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error Approval2 model version", (boolean)pss.getNodeValue("Approval2").getBnProject().getVersion().equals("1.1"));
        uss.terminateActivity(instName, "Approval2");
        String instName2 = pss.instantiateProject("Approval_workflow_versioned", "1.0");
        ProjectSessionTests.assertTrue((String)"Error instance version 2", (boolean)pss.getDetails().getVersion().equals("1.0"));
        uss.startActivity(instName2, "Approval");
        ProjectSessionTests.assertTrue((String)"Error Approval activity state 2", (pss.getNodeState("Approval") == 6 ? 1 : 0) != 0);
        uss.terminateActivity(instName2, "Approval");
        ProjectSessionTests.assertTrue((String)"Error Approval activity state 2", (pss.getNodeState("Approval") == 10 ? 1 : 0) != 0);
        uss.startActivity(instName2, "Approval2");
        ProjectSessionTests.assertTrue((String)"Error Approval2 activity state 2", (pss.getNodeState("Approval2") == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error Approval2 model version 2", (boolean)pss.getNodeValue("Approval2").getBnProject().getVersion().equals("1.0"));
        uss.terminateActivity(instName2, "Approval2");
        instName = pss.instantiateProject("Approval_workflow_versioned", "1.1");
        uss.removeInstance(instName);
        instName = pss.instantiateProject("Approval_workflow_versioned", "1.0");
        uss.removeInstance(instName);
        try {
            uss.removeInstance(instName);
            ProjectSessionTests.assertTrue((String)"Should have throw EJBException", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        uss.removeProject("Approval_workflow_versioned", "1.0");
        uss.removeProject("Approval_workflow_versioned", "1.1");
    }

    public void testDynamicEnumerationPropagation() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initModelWithVersion("DynamicEnumPropagation", "1.0");
        pss.addNode("start", 1);
        pss.addNode("appro3", 1);
        pss.addNode("appro3OK", 3);
        pss.addNode("approv3bis", 3);
        pss.addNode("End", 1);
        pss.addNodeHook("appro3OK", "hero.hook.UpdateEnumDyn", "beforeTerminate", 0);
        pss.addEdge("start", "appro3");
        pss.addEdge("appro3", "appro3OK");
        pss.addEdge("appro3OK", "approv3bis");
        pss.addEdge("appro3OK", "End");
        ArrayList<String> cas = new ArrayList<String>();
        cas.add("cas1");
        cas.add("cas2");
        cas.add("cas3");
        pss.setNodePropertyPossibleValues("start", "cas", cas);
        pss.setNodeProperty("start", "cas", "cas3", true);
        ArrayList<String> approv = new ArrayList<String>();
        approv.add("yes");
        approv.add("no");
        pss.setNodePropertyPossibleValues("start", "approv", approv);
        pss.setNodeProperty("start", "approv", "yes", true);
        ArrayList<String> enumdyn = new ArrayList<String>();
        enumdyn.add("default");
        pss.setNodePropertyPossibleValues("start", "enumdyn", enumdyn);
        pss.setNodeProperty("start", "enumdyn", "default", true);
        pss.setNodeProperty("appro3", "mykey", "myvalue");
        String instName = pss.instantiateProject("DynamicEnumPropagation", "1.0");
        ProjectSessionTests.assertTrue((String)"Error instance version", (boolean)pss.getDetails().getVersion().equals("1.0"));
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession uss = userSessionh.create();
        uss.startActivity(instName, "start");
        ProjectSessionTests.assertTrue((String)"Error start activity state", (pss.getNodeState("start") == 6 ? 1 : 0) != 0);
        uss.terminateActivity(instName, "start");
        ProjectSessionTests.assertTrue((String)"Error start activity state", (pss.getNodeState("start") == 10 ? 1 : 0) != 0);
        uss.startActivity(instName, "appro3");
        ProjectSessionTests.assertTrue((String)"Error appro3 activity state", (pss.getNodeState("appro3") == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error appro3 model version", (boolean)pss.getNodeValue("appro3").getBnProject().getVersion().equals("1.0"));
        uss.terminateActivity(instName, "appro3");
        ProjectSessionTests.assertTrue((String)"Error End activity state", (pss.getNodeState("End") == 1 ? 1 : 0) != 0);
    }

    public void testPropertiesPropagation() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initModelWithVersion("PropertiesPropagation", "1.0");
        pss.addNode("appro3OK", 3);
        pss.addNode("approv3bis", 3);
        pss.addNode("MyManual", 1);
        pss.addNode("End", 1);
        pss.addNodeHook("appro3OK", "hero.hook.UpdateEnumDyn", "beforeTerminate", 0);
        pss.addNodeHook("MyManual", "hero.hook.UpdateEnumDyn2", "beforeTerminate", 0);
        pss.addNodeHook("End", "hero.hook.UpdateEnumDyn3", "onReady", 0);
        pss.addEdge("appro3OK", "approv3bis");
        pss.addEdge("appro3OK", "MyManual");
        pss.addEdge("MyManual", "End");
        ArrayList<String> cas = new ArrayList<String>();
        cas.add("cas1");
        cas.add("cas2");
        cas.add("cas3");
        pss.setNodePropertyPossibleValues("appro3OK", "cas", cas);
        pss.setNodeProperty("appro3OK", "cas", "cas3", true);
        pss.setNodeProperty("appro3OK", "testProp", "yes", true);
        ArrayList<String> enumdyn = new ArrayList<String>();
        enumdyn.add("default");
        pss.setNodePropertyPossibleValues("appro3OK", "enumdyn", enumdyn);
        pss.setNodeProperty("appro3OK", "enumdyn", "default", true);
        String instName = pss.instantiateProject("PropertiesPropagation", "1.0");
        ProjectSessionTests.assertTrue((String)"Error instance version", (boolean)pss.getDetails().getVersion().equals("1.0"));
        ProjectSessionTests.assertTrue((String)"Error start activity state 1 ", (pss.getNodeState("appro3OK") == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error start activity state 2 ", (pss.getNodeState("approv3bis") == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error value property enumdyn ", (boolean)pss.getNodeProperty("approv3bis", "enumdyn").getTheValue().equals("miguel"));
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession uss = userSessionh.create();
        uss.startActivity(instName, "MyManual");
        ProjectSessionTests.assertTrue((String)"Error start activity state", (pss.getNodeState("MyManual") == 6 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error value property testprop ", (boolean)pss.getNodeProperty("MyManual", "testProp").getTheValue().equals("yes"));
        uss.terminateActivity(instName, "MyManual");
        ProjectSessionTests.assertTrue((String)"Error start activity state", (pss.getNodeState("MyManual") == 10 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error End activity state", (pss.getNodeState("End") == 1 ? 1 : 0) != 0);
        ProjectSessionTests.assertTrue((String)"Error value property enumdyn ", (boolean)pss.getNodeProperty("MyManual", "enumdyn").getTheValue().equals("new1"));
        ProjectSessionTests.assertTrue((String)"Error value property enumdyn ", (boolean)pss.getNodeProperty("End", "enumdyn").getTheValue().equals("newValue"));
        ProjectSessionTests.assertTrue((String)"Error value property testprop ", (boolean)pss.getNodeProperty("End", "testProp").getTheValue().equals("yes"));
    }
}

