/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test.performance;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PerformanceTests
extends TestCase {
    public PerformanceTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(PerformanceTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testUsersInteraction() throws Exception {
        int i = 0;
        UserSessionHome uHome = UserSessionUtil.getHome();
        for (i = 0; i < 15; ++i) {
            String uName = "user" + i;
            char[] password = uName.toCharArray();
            SimpleCallbackHandler handler = new SimpleCallbackHandler(uName, password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            UserSession us = uHome.create();
            Collection instances = us.getProjectListNames();
            for (String name : instances) {
                if (!name.matches("Stress.*")) continue;
                ProjectSessionHome pHome = ProjectSessionUtil.getHome();
                ProjectSession ps = pHome.create();
                ps.initProject(name);
                ps.setUserRole("user" + i, "InitialRole");
                Collection task = us.getToDoList(name);
                Iterator tsk = task.iterator();
                while (tsk.hasNext()) {
                    us.startActivity(name, (String)tsk.next());
                    task = us.getToDoList(name);
                    tsk = task.iterator();
                }
                ps.remove();
            }
            us.remove();
        }
    }
}

