/*
 * Decompiled with CFR 0.152.
 */
package hero.client.xpdl;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.XPDLSessionImport;
import hero.interfaces.XPDLSessionImportHome;
import hero.interfaces.XPDLSessionImportUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class XPDLStartImport {
    public static void main(String[] args) {
        String user = "admin";
        char[] password = new char[]{'t', 'o', 't', 'o'};
        String filename = null;
        for (int argn = 0; argn < args.length; ++argn) {
            String arg = args[argn];
            if (arg.equals("-user")) {
                if (++argn >= args.length) continue;
                user = args[argn];
                continue;
            }
            if (arg.equals("-passwd")) {
                if (++argn >= args.length) continue;
                String spwd = args[argn];
                password = new char[spwd.length()];
                for (int i = 0; i < spwd.length(); ++i) {
                    password[i] = spwd.charAt(i);
                }
                continue;
            }
            if (!arg.equals("-xpdl") || ++argn >= args.length) continue;
            filename = args[argn];
        }
        if (filename == null) {
            System.err.println("Error: The xpdl file name argument is mandatory");
            System.exit(-1);
        }
        XPDLSessionImportHome home = null;
        XPDLSessionImport xpdl = null;
        SimpleCallbackHandler handler = new SimpleCallbackHandler(user, password);
        try {
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
        }
        catch (LoginException he) {
            System.err.println("Error while login for the client : " + he.getMessage());
            he.printStackTrace();
            System.exit(-1);
        }
        try {
            home = XPDLSessionImportUtil.getHome();
        }
        catch (NamingException na) {
            System.err.println("Error obtaining the remote home interface for XPDLSessionImport Bean : " + na.getMessage());
            na.printStackTrace();
            System.exit(-1);
        }
        try {
            xpdl = home.create();
        }
        catch (CreateException re) {
            System.err.println("There was the following exception : " + re.getMessage());
            re.printStackTrace();
            System.exit(-1);
        }
        catch (RemoteException re) {
            System.err.println("There was the following exception : " + re.getMessage());
            re.printStackTrace();
            System.exit(-1);
        }
        System.out.println("******* Start of XPDL import into Bonita Workflow Engine ********");
        BufferedReader buff = null;
        try {
            buff = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot find the file for the xpdl document : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        String xpdl_file = "";
        try {
            String line = buff.readLine();
            while ((line = buff.readLine()) != null) {
                xpdl_file = xpdl_file + line;
            }
        }
        catch (IOException e) {
            System.err.println("Exception while reading lines : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            String absoluteName = new File(filename).getAbsolutePath();
            String repositoryName = new File(absoluteName).getParent();
            String baseName = new File(absoluteName).getName();
            xpdl.openMainDocument(repositoryName, baseName, xpdl_file);
            System.out.println("******* End of XPDL import into Bonita Workflow Engine *******");
            xpdl.printHashTables();
        }
        catch (Exception e) {
            System.err.println("Error during XPDL import operation : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Throwable exc) {
            System.err.println("Runtime Exception caught !");
            exc.printStackTrace();
        }
    }
}

