/*
 * Decompiled with CFR 0.152.
 */
package hero.mapper;

import hero.interfaces.BnRoleLocal;
import hero.mapper.CustomMapper;
import hero.mapper.LdapMapper;
import hero.mapper.PropertiesMapper;
import hero.util.HeroException;
import java.io.Serializable;
import java.util.Collection;

public abstract class Mapper
implements Serializable {
    public static final int LDAP = 0;
    public static final int PROPERTIES = 1;
    public static final int CUSTOM = 2;
    private String name;
    private int type;

    public static Mapper make(String name, int type) throws HeroException {
        if (type == 0) {
            return new LdapMapper(name, type);
        }
        if (type == 1) {
            return new PropertiesMapper(name, type);
        }
        if (type == 2) {
            return new CustomMapper(name, type);
        }
        throw new HeroException("Wrong Mapper Type " + type);
    }

    protected Mapper(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toXML() {
        String result = new String();
        result = "<mapper name=\"" + this.getName() + "\" type=\"" + this.getType() + "\"/>";
        return result;
    }

    public abstract Collection execute(Object var1, int var2, BnRoleLocal var3, String var4) throws HeroException;
}

