/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.interfaces.BnEdgeLocal;
import hero.interfaces.BnIterationLocal;
import hero.interfaces.BnNodeHookLocal;
import hero.interfaces.BnNodeInterHookLocal;
import hero.interfaces.BnNodeLocal;
import hero.interfaces.BnNodePropertyLocal;
import hero.interfaces.BnProjectHookLocal;
import hero.interfaces.BnProjectInterHookLocal;
import hero.interfaces.BnProjectLocal;
import hero.interfaces.BnProjectLocalHome;
import hero.interfaces.BnProjectPropertyLocal;
import hero.interfaces.BnProjectUtil;
import hero.interfaces.BnRoleLocal;
import hero.interfaces.BnUserLocal;
import hero.interfaces.BnUserLocalHome;
import hero.interfaces.BnUserUtil;
import hero.util.BonitaServiceException;
import hero.util.HeroException;
import hero.util.KeyModelsCache;
import hero.util.values.BonitaEdgeValue;
import hero.util.values.BonitaHookValue;
import hero.util.values.BonitaInterHookValue;
import hero.util.values.BonitaIterationValue;
import hero.util.values.BonitaMapperValue;
import hero.util.values.BonitaNodeValue;
import hero.util.values.BonitaPerformerValue;
import hero.util.values.BonitaProjectValue;
import hero.util.values.BonitaPropertyValue;
import hero.util.values.BonitaRoleValue;
import hero.util.values.BonitaUserValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class BonitaProjectLocator {
    private static BonitaProjectLocator bpl;
    private Map modelsCache = new HashMap();

    private BonitaProjectLocator() {
    }

    public static synchronized BonitaProjectLocator getInstance() {
        if (bpl == null) {
            bpl = new BonitaProjectLocator();
        }
        return bpl;
    }

    public synchronized BonitaProjectValue getModelValue(String model, String version) throws BonitaServiceException {
        BonitaProjectValue pv = null;
        try {
            KeyModelsCache keyMap = new KeyModelsCache(model, version);
            if (this.modelsCache.containsKey(keyMap)) {
                pv = (BonitaProjectValue)this.modelsCache.get(keyMap);
            } else {
                pv = this.generateProjectValue(model, version);
                this.modelsCache.put(keyMap, pv);
            }
        }
        catch (Exception ex) {
            throw new BonitaServiceException(ex.getMessage());
        }
        return pv;
    }

    public synchronized void cleanModelValue(String model, String version) throws BonitaServiceException {
        KeyModelsCache keyMap = new KeyModelsCache(model, version);
        if (this.modelsCache.containsKey(keyMap)) {
            this.modelsCache.remove(keyMap);
        }
    }

    private BonitaProjectValue generateProjectValue(String projectName, String projectVersion) throws BonitaServiceException {
        BnProjectLocalHome pHome = null;
        BnProjectLocal projectModel = null;
        BonitaProjectValue pv = null;
        try {
            pHome = BnProjectUtil.getLocalHome();
            projectModel = pHome.findByNameVersion(projectName, projectVersion);
        }
        catch (NamingException ne) {
            throw new BonitaServiceException(ne.getMessage());
        }
        catch (FinderException fe) {
            throw new BonitaServiceException(fe.getMessage());
        }
        try {
            pv = this.getProjectData(projectModel);
        }
        catch (HeroException he) {
            throw new BonitaServiceException(he.getMessage());
        }
        return pv;
    }

    private BonitaProjectValue getProjectData(BnProjectLocal projectModel) throws HeroException {
        BonitaProjectValue pv = new BonitaProjectValue();
        pv.setName(projectModel.getName());
        pv.setVersion(projectModel.getVersion());
        pv.setType(projectModel.getType());
        pv.setStatus(projectModel.getStatus());
        Collection iterations = projectModel.getBnIterations();
        Iterator iter = iterations.iterator();
        ArrayList<BonitaIterationValue> iterPro = new ArrayList<BonitaIterationValue>();
        while (iter.hasNext()) {
            BnIterationLocal it = (BnIterationLocal)iter.next();
            BonitaIterationValue iteration = new BonitaIterationValue();
            iteration.setCondition(it.getCondition());
            iteration.setFromNode(it.getFromNode());
            iteration.setToNode(it.getToNode());
            iterPro.add(iteration);
        }
        pv.setIterations(iterPro);
        ArrayList<BonitaNodeValue> nodesPro = new ArrayList<BonitaNodeValue>();
        Collection nodes = projectModel.getBnNodes();
        for (BnNodeLocal nd : nodes) {
            BonitaNodeValue node = new BonitaNodeValue();
            node.setProjectName(projectModel.getName());
            node.setDescription(nd.getDescription());
            node.setDeadlines(nd.getDeadlines());
            node.setRelativeDeadlines(nd.getRelativeDeadlines());
            node.setCreator(nd.getCreator());
            node.setExecutor(nd.getExecutor());
            node.setName(nd.getName());
            node.setRole(nd.getBnRole().getName());
            node.setType(nd.getType());
            node.setReference(nd.getReference());
            node.setProjectParent(nd.getBnProject().getParent());
            node.setAnticipable(nd.getAnticipable());
            Collection inEdges = nd.getInBnEdges();
            Iterator inEdgesI = inEdges.iterator();
            ArrayList<BonitaEdgeValue> nodeInEdges = new ArrayList<BonitaEdgeValue>();
            while (inEdgesI.hasNext()) {
                BnEdgeLocal el = (BnEdgeLocal)inEdgesI.next();
                BonitaEdgeValue inEdge = new BonitaEdgeValue();
                inEdge.setName(el.getName());
                inEdge.setCondition(el.getCondition());
                inEdge.setState(el.getState());
                inEdge.setInNode(el.getInBnNode().getName());
                inEdge.setOutNode(el.getOutBnNode().getName());
                nodeInEdges.add(inEdge);
            }
            node.setInEdges(nodeInEdges);
            Collection outEdges = nd.getOutBnEdges();
            Iterator outEdgesI = outEdges.iterator();
            ArrayList<BonitaEdgeValue> nodeOutEdges = new ArrayList<BonitaEdgeValue>();
            while (outEdgesI.hasNext()) {
                BnEdgeLocal el = (BnEdgeLocal)outEdgesI.next();
                BonitaEdgeValue outEdge = new BonitaEdgeValue();
                outEdge.setName(el.getName());
                outEdge.setCondition(el.getCondition());
                outEdge.setState(el.getState());
                outEdge.setInNode(el.getInBnNode().getName());
                outEdge.setOutNode(el.getOutBnNode().getName());
                nodeOutEdges.add(outEdge);
            }
            node.setOutEdges(nodeOutEdges);
            Collection props = nd.getBnProperties();
            Iterator propsI = props.iterator();
            ArrayList<BonitaPropertyValue> nodeProps = new ArrayList<BonitaPropertyValue>();
            while (propsI.hasNext()) {
                BnNodePropertyLocal pl = (BnNodePropertyLocal)propsI.next();
                BonitaPropertyValue property = new BonitaPropertyValue();
                property.setKey(pl.getTheKey());
                property.setValue(pl.getTheValue());
                property.setPropagate(pl.getPropagate());
                property.setPossibleValues(pl.getPossibleValues());
                nodeProps.add(property);
            }
            node.setProperties(nodeProps);
            BonitaPerformerValue performer = new BonitaPerformerValue();
            performer.setNodeName(nd.getName());
            if (nd.getBnNodePerformerAssign() != null) {
                performer.setName(nd.getBnNodePerformerAssign().getName());
                performer.setType(nd.getBnNodePerformerAssign().getType());
                performer.setPropertyName(nd.getBnNodePerformerAssign().getPropertyName());
                node.setPerformer(performer);
            }
            Collection nodeHooks = projectModel.getBnNode(nd.getName()).getBnHooks();
            Iterator nodeHooksI = nodeHooks.iterator();
            ArrayList<BonitaHookValue> nodeHks = new ArrayList<BonitaHookValue>();
            while (nodeHooksI.hasNext()) {
                BnNodeHookLocal ph = (BnNodeHookLocal)nodeHooksI.next();
                BonitaHookValue hook = new BonitaHookValue();
                hook.setName(ph.getName());
                hook.setEvent(ph.getEvent());
                hook.setType(ph.getType());
                nodeHks.add(hook);
            }
            node.setHooks(nodeHks);
            Collection nodeInterHooks = projectModel.getBnNode(nd.getName()).getBnInterHooks();
            Iterator nodeInterHooksI = nodeInterHooks.iterator();
            ArrayList<BonitaInterHookValue> nodeInterHks = new ArrayList<BonitaInterHookValue>();
            while (nodeInterHooksI.hasNext()) {
                BnNodeInterHookLocal pih = (BnNodeInterHookLocal)nodeInterHooksI.next();
                BonitaInterHookValue interHook = new BonitaInterHookValue();
                interHook.setName(pih.getName());
                interHook.setEvent(pih.getEvent());
                interHook.setType(pih.getType());
                interHook.setScript(pih.getScript());
                nodeInterHks.add(interHook);
            }
            node.setInterHooks(nodeInterHks);
            nodesPro.add(node);
        }
        pv.setNodes(nodesPro);
        Collection projectProps = projectModel.getBnProperties();
        Iterator projectPropsI = projectProps.iterator();
        ArrayList<BonitaPropertyValue> projectPrs = new ArrayList<BonitaPropertyValue>();
        while (projectPropsI.hasNext()) {
            BnProjectPropertyLocal pl = (BnProjectPropertyLocal)projectPropsI.next();
            BonitaPropertyValue property = new BonitaPropertyValue();
            property.setKey(pl.getTheKey());
            property.setValue(pl.getTheValue());
            property.setPossibleValues(pl.getPossibleValues());
            projectPrs.add(property);
        }
        pv.setProperties(projectPrs);
        Collection projectHooks = projectModel.getBnHooks();
        Iterator projectHooksI = projectHooks.iterator();
        ArrayList<BonitaHookValue> projectHks = new ArrayList<BonitaHookValue>();
        while (projectHooksI.hasNext()) {
            BnProjectHookLocal ph = (BnProjectHookLocal)projectHooksI.next();
            BonitaHookValue hook = new BonitaHookValue();
            hook.setName(ph.getName());
            hook.setEvent(ph.getEvent());
            hook.setType(ph.getType());
            projectHks.add(hook);
        }
        pv.setHooks(projectHks);
        Collection projectInterHooks = projectModel.getBnInterHooks();
        Iterator projectInterHooksI = projectInterHooks.iterator();
        ArrayList<BonitaInterHookValue> projectInterHks = new ArrayList<BonitaInterHookValue>();
        while (projectInterHooksI.hasNext()) {
            BnProjectInterHookLocal pih = (BnProjectInterHookLocal)projectInterHooksI.next();
            BonitaInterHookValue interHook = new BonitaInterHookValue();
            interHook.setName(pih.getName());
            interHook.setEvent(pih.getEvent());
            interHook.setType(pih.getType());
            interHook.setScript(pih.getScript());
            projectInterHks.add(interHook);
        }
        pv.setInterHooks(projectInterHks);
        Collection roles = projectModel.getBnRoles();
        Iterator rolesI = roles.iterator();
        ArrayList<BonitaRoleValue> rolesP = new ArrayList<BonitaRoleValue>();
        while (rolesI.hasNext()) {
            BnRoleLocal rl = (BnRoleLocal)rolesI.next();
            BonitaRoleValue role = new BonitaRoleValue();
            role.setName(rl.getName());
            role.setDescription(rl.getDescription());
            if (rl.getBnRoleMapper() != null) {
                BonitaMapperValue mapper = new BonitaMapperValue();
                mapper.setRoleName(rl.getName());
                mapper.setName(rl.getBnRoleMapper().getName());
                mapper.setType(rl.getBnRoleMapper().getType());
                role.setMapper(mapper);
            }
            rolesP.add(role);
        }
        pv.setRoles(rolesP);
        Collection users = projectModel.getBnUsers();
        Iterator usersI = users.iterator();
        ArrayList<BonitaUserValue> usersP = new ArrayList<BonitaUserValue>();
        while (usersI.hasNext()) {
            BnUserLocal ul = (BnUserLocal)usersI.next();
            BonitaUserValue user = new BonitaUserValue();
            user.setName(ul.getName());
            Collection userRoles = this.getUserRolesInProjectNames(projectModel, ul.getName());
            Iterator uRolesI = userRoles.iterator();
            ArrayList<String> uRolesP = new ArrayList<String>();
            while (uRolesI.hasNext()) {
                String roleName = (String)uRolesI.next();
                uRolesP.add(roleName);
            }
            user.setRoles(uRolesP);
            usersP.add(user);
        }
        pv.setUsers(usersP);
        return pv;
    }

    private Collection getUserRolesInProjectNames(BnProjectLocal mProject, String userName) throws HeroException {
        BnUserLocal user;
        BnUserLocalHome uHome;
        ArrayList<String> result = new ArrayList<String>();
        try {
            uHome = BnUserUtil.getLocalHome();
        }
        catch (NamingException be) {
            throw new HeroException(be.getMessage());
        }
        try {
            user = uHome.findByName(userName);
        }
        catch (FinderException f) {
            throw new HeroException("FinderException");
        }
        Collection userRoles = user.getBnRoles();
        Collection projectRoles = mProject.getBnRoles();
        for (BnRoleLocal ur : userRoles) {
            for (BnRoleLocal up : projectRoles) {
                if (!ur.getId().equals(up.getId())) continue;
                result.add(ur.getBnRoleValue().getName());
            }
        }
        return result;
    }
}

