/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.util.BonitaServiceException;
import hero.util.ServerType;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class BonitaServiceLocator {
    private static BonitaServiceLocator msl;
    private Map cache;
    private static Context initial;
    static final String TOPIC_CONNECTION_FACTORY_NAME;
    static final String TOPIC_NAME = "testTopic";
    static final String MAIL_SERVICE_NAME = "Mail";

    private BonitaServiceLocator() throws BonitaServiceException {
        try {
            initial = new InitialContext();
            this.cache = new HashMap();
        }
        catch (NamingException ne) {
            throw new BonitaServiceException(ne.getMessage());
        }
    }

    public static BonitaServiceLocator getInstance() throws BonitaServiceException {
        if (msl == null) {
            msl = new BonitaServiceLocator();
        }
        return msl;
    }

    private static String getServiceName(int service) {
        switch (service) {
            case 0: {
                return TOPIC_CONNECTION_FACTORY_NAME;
            }
            case 1: {
                return TOPIC_NAME;
            }
            case 2: {
                return MAIL_SERVICE_NAME;
            }
        }
        return null;
    }

    public Object getResource(int s) throws BonitaServiceException {
        Object resource = null;
        try {
            String serv = BonitaServiceLocator.getServiceName(s);
            if (this.cache.containsKey(serv)) {
                resource = this.cache.get(serv);
            } else {
                Object objref;
                resource = objref = initial.lookup(serv);
                this.cache.put(serv, resource);
            }
        }
        catch (NamingException ex) {
            throw new BonitaServiceException("ServiceException");
        }
        catch (Exception ex) {
            System.out.println("ServiceLocator Exception");
            ex.printStackTrace();
        }
        return resource;
    }

    public Object getMailSession(int s) throws BonitaServiceException {
        Object mail = null;
        try {
            String serv = BonitaServiceLocator.getServiceName(s);
            if (this.cache.containsKey(serv)) {
                mail = this.cache.get(serv);
            } else {
                Object objref = initial.lookup(serv);
                mail = PortableRemoteObject.narrow((Object)objref, Session.class);
                this.cache.put(serv, mail);
            }
        }
        catch (NamingException ex) {
            throw new BonitaServiceException("ServiceException");
        }
        catch (Exception ex) {
            System.out.println("ServiceLocator Exception");
            ex.printStackTrace();
        }
        return mail;
    }

    static {
        TOPIC_CONNECTION_FACTORY_NAME = ServerType.isJonas() ? "TCF" : "java:/XAConnectionFactory";
    }

    public class Services {
        public static final int TOPIC_CONNECTION_FACTORY = 0;
        public static final int TOPIC = 1;
        public static final int MAIL_SERVICE = 2;
    }
}

