/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.util.BonitaServiceException;
import hero.util.BonitaServiceLocator;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public final class MailNotification
implements Serializable,
Cloneable {
    private Session session;
    public static final String CHARACTER_ENCODING = "UTF-8";

    public void initMailService() {
        try {
            BonitaServiceLocator serviceLocator = BonitaServiceLocator.getInstance();
            this.session = (Session)serviceLocator.getMailSession(2);
        }
        catch (BonitaServiceException e) {
            e.printStackTrace();
        }
    }

    public void sendMail(String toAccount, String title, String body) throws Exception {
        try {
            this.initMailService();
            MimeMessage m = new MimeMessage(this.session);
            m.setFrom();
            InternetAddress[] to = new InternetAddress[]{new InternetAddress(toAccount)};
            m.setRecipients(Message.RecipientType.TO, (Address[])to);
            m.setSubject(title);
            m.setSentDate(new Date());
            m.setContent((Object)body, "text/plain;charset=UTF-8");
            Transport.send((Message)m);
        }
        catch (MessagingException e) {
            System.out.println("mail-service.xml configuration error: " + (Object)((Object)e));
        }
    }

    public void sendMail(Vector toAccount, String title, String body) throws Exception {
        try {
            this.initMailService();
            MimeMessage m = new MimeMessage(this.session);
            m.setFrom();
            for (int i = 0; i < toAccount.size(); ++i) {
                InternetAddress to = new InternetAddress((String)toAccount.elementAt(i));
                m.addRecipient(Message.RecipientType.TO, (Address)to);
            }
            m.setSubject(title);
            m.setSentDate(new Date());
            m.setContent((Object)body, "text/plain;charset=UTF-8");
            Transport.send((Message)m);
        }
        catch (MessagingException e) {
            System.out.println("mail-service.xml configuration error: " + (Object)((Object)e));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

