/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.UserAgentUtil;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class UserAgent
extends HttpCondition {
    public static UserAgent matches(String pattern) {
        return new PatternUserAgent(pattern);
    }

    public static ClassificationUserAgent isMobile() {
        return new ClassificationUserAgent(Classification.MOBILE){

            public String toString() {
                return "UserAgent.isMobile()";
            }
        };
    }

    public static ClassificationUserAgent isTablet() {
        return new ClassificationUserAgent(Classification.TABLET){

            public String toString() {
                return "UserAgent.isTablet()";
            }
        };
    }

    public static ClassificationUserAgent isDesktop() {
        return new ClassificationUserAgent(Classification.DESKTOP){

            public String toString() {
                return "UserAgent.isDesktop()";
            }
        };
    }

    private static class PatternUserAgent
    extends UserAgent
    implements Parameterized {
        private final RegexParameterizedPatternParser expression;

        private PatternUserAgent(String pattern) {
            Assert.notNull((Object)pattern, (String)"Scheme must not be null.");
            this.expression = new RegexParameterizedPatternParser(pattern);
        }

        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            String agent = ((HttpServletRequest)event.getRequest()).getHeader("user-agent");
            return agent != null && this.expression.parse(agent).submit((Rewrite)event, context);
        }

        public String toString() {
            return this.expression.toString();
        }

        public Set<String> getRequiredParameterNames() {
            return this.expression.getRequiredParameterNames();
        }

        public void setParameterStore(ParameterStore store) {
            this.expression.setParameterStore(store);
        }
    }

    private static enum Classification {
        MOBILE,
        TABLET,
        DESKTOP;

    }

    private static abstract class ClassificationUserAgent
    extends UserAgent {
        private final Classification type;

        private ClassificationUserAgent(Classification type) {
            Assert.notNull((Object)((Object)type), (String)"Classification must not be null.");
            this.type = type;
        }

        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            String userAgentStr = ((HttpServletRequest)event.getRequest()).getHeader("user-agent");
            String httpAccept = ((HttpServletRequest)event.getRequest()).getHeader("Accept");
            UserAgentUtil util = new UserAgentUtil(userAgentStr, httpAccept);
            switch (this.type) {
                case DESKTOP: {
                    return !util.detectMobileQuick() && !util.detectTierTablet();
                }
                case MOBILE: {
                    return util.detectMobileQuick();
                }
                case TABLET: {
                    return util.detectTierTablet();
                }
            }
            return false;
        }
    }
}

