/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;

public class HandlerChainImpl
implements HandlerChain {
    private final ClassContext context;
    private AnnotatedElement element;
    private final List<AnnotationHandler<Annotation>> handlers;
    private int pos = 0;

    public HandlerChainImpl(ClassContext context, AnnotatedElement element, List<? extends AnnotationHandler<?>> handlers) {
        this.context = context;
        this.element = element;
        this.handlers = new ArrayList<AnnotationHandler<Annotation>>();
        this.handlers.addAll(handlers);
    }

    @Override
    public void proceed() {
        if (this.pos < this.handlers.size()) {
            AnnotationHandler<Annotation> handler = this.handlers.get(this.pos++);
            Annotation annotation = this.element.getAnnotation(handler.handles());
            Assert.notNull(annotation, "Could not find annotation [" + handler.handles().getName() + "] on: " + this.element);
            handler.process(this.context, annotation, this);
        }
    }
}

