/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public final class Perform
extends DefaultOperationBuilder
implements CompositeOperation {
    private final Operation[] operations;

    private Perform(Operation ... operations) {
        this.operations = operations;
    }

    public static Perform all(Operation ... operations) {
        Assert.notNull(operations, "At least one operation is required.");
        Assert.assertTrue(operations.length > 0, "At least one operation is required.");
        return new Perform(Perform.flattenOperations(Arrays.asList(operations)).toArray(new Operation[0]));
    }

    private static List<Operation> flattenOperations(List<Operation> operations) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        for (Operation operation : operations) {
            if (operation instanceof Perform) {
                result.addAll(Perform.flattenOperations(((Perform)operation).getOperations()));
                continue;
            }
            result.add(operation);
        }
        return result;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i].perform(event, context);
        }
    }

    @Override
    public List<Operation> getOperations() {
        return Arrays.asList(this.operations);
    }

    public String toString() {
        return "Perform.all(" + Strings.join(this.getOperations(), ", ") + ")";
    }
}

