/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.form.FormNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormControlImplementationAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkActuateAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeTargetFrameAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormMethodAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormEnctypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormAllowDeletesAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormAllowInsertsAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormAllowUpdatesAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormApplyFilterAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormCommandTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormCommandAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormDatasourceAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormMasterFieldsAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormDetailFieldsAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormEscapeProcessingAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormFilterAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormIgnoreResultAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormNavigationModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormOrderAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormTabCycleAttribute;

import org.odftoolkit.odfdom.dom.element.office.OfficeEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element form:form}.
 *
 */
public class FormFormElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.FORM, "form" );

	/**
	 * The value set of {@odf.attribute xlink:actuate}.
	 */
	 public enum XlinkActuateAttributeValue {
	 
	 ONREQUEST( XlinkActuateAttribute.Value.ONREQUEST.toString() );
              
		private String mValue;
	 	
		XlinkActuateAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static XlinkActuateAttributeValue enumValueOf( String value )
	    {
	        for( XlinkActuateAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}
	public static final String  DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE = XlinkActuateAttribute.Value.ONREQUEST.toString();

	/**
	 * Create the instance of <code>FormFormElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public FormFormElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element form:form}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}



	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormNameAttribute</code> , See {@odf.attribute form:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormNameAttribute()
	{
		FormNameAttribute attr = (FormNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormNameAttribute</code> , See {@odf.attribute form:name}
	 *
	 * @param formNameValue   The type is <code>String</code>
	 */
	public void setFormNameAttribute( String formNameValue )
	{
		FormNameAttribute attr =  new FormNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormControlImplementationAttribute</code> , See {@odf.attribute form:control-implementation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormControlImplementationAttribute()
	{
		FormControlImplementationAttribute attr = (FormControlImplementationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "control-implementation" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormControlImplementationAttribute</code> , See {@odf.attribute form:control-implementation}
	 *
	 * @param formControlImplementationValue   The type is <code>String</code>
	 */
	public void setFormControlImplementationAttribute( String formControlImplementationValue )
	{
		FormControlImplementationAttribute attr =  new FormControlImplementationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formControlImplementationValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkTypeAttribute()
	{
		XlinkTypeAttribute attr = (XlinkTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return XlinkTypeAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See {@odf.attribute xlink:type}
	 *
	 * @param xlinkTypeValue   The type is <code>String</code>
	 */
	public void setXlinkTypeAttribute( String xlinkTypeValue )
	{
		XlinkTypeAttribute attr =  new XlinkTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkHrefAttribute()
	{
		XlinkHrefAttribute attr = (XlinkHrefAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "href" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See {@odf.attribute xlink:href}
	 *
	 * @param xlinkHrefValue   The type is <code>String</code>
	 */
	public void setXlinkHrefAttribute( String xlinkHrefValue )
	{
		XlinkHrefAttribute attr =  new XlinkHrefAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkHrefValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getXlinkActuateAttribute()
	{
		XlinkActuateAttribute attr = (XlinkActuateAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.XLINK), "actuate" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return DEFAULT_VALUE_XLINK_ACTUATE_ATTRIBUTE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See {@odf.attribute xlink:actuate}
	 *
	 * @param xlinkActuateValue   The type is <code>String</code>
	 */
	public void setXlinkActuateAttribute( String xlinkActuateValue )
	{
		XlinkActuateAttribute attr =  new XlinkActuateAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( xlinkActuateValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeTargetFrameAttribute</code> , See {@odf.attribute office:target-frame}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeTargetFrameAttribute()
	{
		OfficeTargetFrameAttribute attr = (OfficeTargetFrameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "target-frame" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return OfficeTargetFrameAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeTargetFrameAttribute</code> , See {@odf.attribute office:target-frame}
	 *
	 * @param officeTargetFrameValue   The type is <code>String</code>
	 */
	public void setOfficeTargetFrameAttribute( String officeTargetFrameValue )
	{
		OfficeTargetFrameAttribute attr =  new OfficeTargetFrameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeTargetFrameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormMethodAttribute</code> , See {@odf.attribute form:method}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormMethodAttribute()
	{
		FormMethodAttribute attr = (FormMethodAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "method" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return FormMethodAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormMethodAttribute</code> , See {@odf.attribute form:method}
	 *
	 * @param formMethodValue   The type is <code>String</code>
	 */
	public void setFormMethodAttribute( String formMethodValue )
	{
		FormMethodAttribute attr =  new FormMethodAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formMethodValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormEnctypeAttribute</code> , See {@odf.attribute form:enctype}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormEnctypeAttribute()
	{
		FormEnctypeAttribute attr = (FormEnctypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "enctype" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return FormEnctypeAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormEnctypeAttribute</code> , See {@odf.attribute form:enctype}
	 *
	 * @param formEnctypeValue   The type is <code>String</code>
	 */
	public void setFormEnctypeAttribute( String formEnctypeValue )
	{
		FormEnctypeAttribute attr =  new FormEnctypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formEnctypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormAllowDeletesAttribute</code> , See {@odf.attribute form:allow-deletes}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormAllowDeletesAttribute()
	{
		FormAllowDeletesAttribute attr = (FormAllowDeletesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "allow-deletes" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormAllowDeletesAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormAllowDeletesAttribute</code> , See {@odf.attribute form:allow-deletes}
	 *
	 * @param formAllowDeletesValue   The type is <code>Boolean</code>
	 */
	public void setFormAllowDeletesAttribute( Boolean formAllowDeletesValue )
	{
		FormAllowDeletesAttribute attr =  new FormAllowDeletesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formAllowDeletesValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormAllowInsertsAttribute</code> , See {@odf.attribute form:allow-inserts}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormAllowInsertsAttribute()
	{
		FormAllowInsertsAttribute attr = (FormAllowInsertsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "allow-inserts" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormAllowInsertsAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormAllowInsertsAttribute</code> , See {@odf.attribute form:allow-inserts}
	 *
	 * @param formAllowInsertsValue   The type is <code>Boolean</code>
	 */
	public void setFormAllowInsertsAttribute( Boolean formAllowInsertsValue )
	{
		FormAllowInsertsAttribute attr =  new FormAllowInsertsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formAllowInsertsValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormAllowUpdatesAttribute</code> , See {@odf.attribute form:allow-updates}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormAllowUpdatesAttribute()
	{
		FormAllowUpdatesAttribute attr = (FormAllowUpdatesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "allow-updates" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormAllowUpdatesAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormAllowUpdatesAttribute</code> , See {@odf.attribute form:allow-updates}
	 *
	 * @param formAllowUpdatesValue   The type is <code>Boolean</code>
	 */
	public void setFormAllowUpdatesAttribute( Boolean formAllowUpdatesValue )
	{
		FormAllowUpdatesAttribute attr =  new FormAllowUpdatesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formAllowUpdatesValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormApplyFilterAttribute</code> , See {@odf.attribute form:apply-filter}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormApplyFilterAttribute()
	{
		FormApplyFilterAttribute attr = (FormApplyFilterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "apply-filter" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormApplyFilterAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormApplyFilterAttribute</code> , See {@odf.attribute form:apply-filter}
	 *
	 * @param formApplyFilterValue   The type is <code>Boolean</code>
	 */
	public void setFormApplyFilterAttribute( Boolean formApplyFilterValue )
	{
		FormApplyFilterAttribute attr =  new FormApplyFilterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formApplyFilterValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormCommandTypeAttribute</code> , See {@odf.attribute form:command-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormCommandTypeAttribute()
	{
		FormCommandTypeAttribute attr = (FormCommandTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "command-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return FormCommandTypeAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormCommandTypeAttribute</code> , See {@odf.attribute form:command-type}
	 *
	 * @param formCommandTypeValue   The type is <code>String</code>
	 */
	public void setFormCommandTypeAttribute( String formCommandTypeValue )
	{
		FormCommandTypeAttribute attr =  new FormCommandTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formCommandTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormCommandAttribute</code> , See {@odf.attribute form:command}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormCommandAttribute()
	{
		FormCommandAttribute attr = (FormCommandAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "command" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormCommandAttribute</code> , See {@odf.attribute form:command}
	 *
	 * @param formCommandValue   The type is <code>String</code>
	 */
	public void setFormCommandAttribute( String formCommandValue )
	{
		FormCommandAttribute attr =  new FormCommandAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formCommandValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormDatasourceAttribute</code> , See {@odf.attribute form:datasource}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormDatasourceAttribute()
	{
		FormDatasourceAttribute attr = (FormDatasourceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "datasource" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormDatasourceAttribute</code> , See {@odf.attribute form:datasource}
	 *
	 * @param formDatasourceValue   The type is <code>String</code>
	 */
	public void setFormDatasourceAttribute( String formDatasourceValue )
	{
		FormDatasourceAttribute attr =  new FormDatasourceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formDatasourceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormMasterFieldsAttribute</code> , See {@odf.attribute form:master-fields}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormMasterFieldsAttribute()
	{
		FormMasterFieldsAttribute attr = (FormMasterFieldsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "master-fields" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormMasterFieldsAttribute</code> , See {@odf.attribute form:master-fields}
	 *
	 * @param formMasterFieldsValue   The type is <code>String</code>
	 */
	public void setFormMasterFieldsAttribute( String formMasterFieldsValue )
	{
		FormMasterFieldsAttribute attr =  new FormMasterFieldsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formMasterFieldsValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormDetailFieldsAttribute</code> , See {@odf.attribute form:detail-fields}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormDetailFieldsAttribute()
	{
		FormDetailFieldsAttribute attr = (FormDetailFieldsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "detail-fields" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormDetailFieldsAttribute</code> , See {@odf.attribute form:detail-fields}
	 *
	 * @param formDetailFieldsValue   The type is <code>String</code>
	 */
	public void setFormDetailFieldsAttribute( String formDetailFieldsValue )
	{
		FormDetailFieldsAttribute attr =  new FormDetailFieldsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formDetailFieldsValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormEscapeProcessingAttribute</code> , See {@odf.attribute form:escape-processing}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormEscapeProcessingAttribute()
	{
		FormEscapeProcessingAttribute attr = (FormEscapeProcessingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "escape-processing" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormEscapeProcessingAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormEscapeProcessingAttribute</code> , See {@odf.attribute form:escape-processing}
	 *
	 * @param formEscapeProcessingValue   The type is <code>Boolean</code>
	 */
	public void setFormEscapeProcessingAttribute( Boolean formEscapeProcessingValue )
	{
		FormEscapeProcessingAttribute attr =  new FormEscapeProcessingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formEscapeProcessingValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormFilterAttribute</code> , See {@odf.attribute form:filter}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormFilterAttribute()
	{
		FormFilterAttribute attr = (FormFilterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "filter" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormFilterAttribute</code> , See {@odf.attribute form:filter}
	 *
	 * @param formFilterValue   The type is <code>String</code>
	 */
	public void setFormFilterAttribute( String formFilterValue )
	{
		FormFilterAttribute attr =  new FormFilterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formFilterValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormIgnoreResultAttribute</code> , See {@odf.attribute form:ignore-result}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getFormIgnoreResultAttribute()
	{
		FormIgnoreResultAttribute attr = (FormIgnoreResultAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "ignore-result" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( FormIgnoreResultAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormIgnoreResultAttribute</code> , See {@odf.attribute form:ignore-result}
	 *
	 * @param formIgnoreResultValue   The type is <code>Boolean</code>
	 */
	public void setFormIgnoreResultAttribute( Boolean formIgnoreResultValue )
	{
		FormIgnoreResultAttribute attr =  new FormIgnoreResultAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( formIgnoreResultValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormNavigationModeAttribute</code> , See {@odf.attribute form:navigation-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormNavigationModeAttribute()
	{
		FormNavigationModeAttribute attr = (FormNavigationModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "navigation-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormNavigationModeAttribute</code> , See {@odf.attribute form:navigation-mode}
	 *
	 * @param formNavigationModeValue   The type is <code>String</code>
	 */
	public void setFormNavigationModeAttribute( String formNavigationModeValue )
	{
		FormNavigationModeAttribute attr =  new FormNavigationModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formNavigationModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormOrderAttribute</code> , See {@odf.attribute form:order}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormOrderAttribute()
	{
		FormOrderAttribute attr = (FormOrderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "order" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormOrderAttribute</code> , See {@odf.attribute form:order}
	 *
	 * @param formOrderValue   The type is <code>String</code>
	 */
	public void setFormOrderAttribute( String formOrderValue )
	{
		FormOrderAttribute attr =  new FormOrderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formOrderValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FormTabCycleAttribute</code> , See {@odf.attribute form:tab-cycle}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFormTabCycleAttribute()
	{
		FormTabCycleAttribute attr = (FormTabCycleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FORM), "tab-cycle" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FormTabCycleAttribute</code> , See {@odf.attribute form:tab-cycle}
	 *
	 * @param formTabCycleValue   The type is <code>String</code>
	 */
	public void setFormTabCycleAttribute( String formTabCycleValue )
	{
		FormTabCycleAttribute attr =  new FormTabCycleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( formTabCycleValue );
	}

	/**
	 * Create child element {@odf.element form:properties}.
	 *
	 * @return   return  the element {@odf.element form:properties}
	 * DifferentQName 
	 */
	public FormPropertiesElement newFormPropertiesElement()
	{
		FormPropertiesElement  formProperties = ((OdfFileDom)this.ownerDocument).newOdfElement(FormPropertiesElement.class);
		this.appendChild( formProperties);
		return  formProperties;
	}                   
               
	/**
	 * Create child element {@odf.element office:event-listeners}.
	 *
	 * @return   return  the element {@odf.element office:event-listeners}
	 * DifferentQName 
	 */
	public OfficeEventListenersElement newOfficeEventListenersElement()
	{
		OfficeEventListenersElement  officeEventListeners = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeEventListenersElement.class);
		this.appendChild( officeEventListeners);
		return  officeEventListeners;
	}                   
               
	/**
	 * Create child element {@odf.element form:text}.
	 *
	 * @return   return  the element {@odf.element form:text}
	 * DifferentQName 
	 */
	public FormTextElement newFormTextElement()
	{
		FormTextElement  formText = ((OdfFileDom)this.ownerDocument).newOdfElement(FormTextElement.class);
		this.appendChild( formText);
		return  formText;
	}                   
               
	/**
	 * Create child element {@odf.element form:textarea}.
	 *
	 * @return   return  the element {@odf.element form:textarea}
	 * DifferentQName 
	 */
	public FormTextareaElement newFormTextareaElement()
	{
		FormTextareaElement  formTextarea = ((OdfFileDom)this.ownerDocument).newOdfElement(FormTextareaElement.class);
		this.appendChild( formTextarea);
		return  formTextarea;
	}                   
               
	/**
	 * Create child element {@odf.element form:formatted-text}.
	 *
	 * @return   return  the element {@odf.element form:formatted-text}
	 * DifferentQName 
	 */
	public FormFormattedTextElement newFormFormattedTextElement()
	{
		FormFormattedTextElement  formFormattedText = ((OdfFileDom)this.ownerDocument).newOdfElement(FormFormattedTextElement.class);
		this.appendChild( formFormattedText);
		return  formFormattedText;
	}                   
               
	/**
	 * Create child element {@odf.element form:number}.
	 *
	 * @return   return  the element {@odf.element form:number}
	 * DifferentQName 
	 */
	public FormNumberElement newFormNumberElement()
	{
		FormNumberElement  formNumber = ((OdfFileDom)this.ownerDocument).newOdfElement(FormNumberElement.class);
		this.appendChild( formNumber);
		return  formNumber;
	}                   
               
	/**
	 * Create child element {@odf.element form:date}.
	 *
	 * @return   return  the element {@odf.element form:date}
	 * DifferentQName 
	 */
	public FormDateElement newFormDateElement()
	{
		FormDateElement  formDate = ((OdfFileDom)this.ownerDocument).newOdfElement(FormDateElement.class);
		this.appendChild( formDate);
		return  formDate;
	}                   
               
	/**
	 * Create child element {@odf.element form:time}.
	 *
	 * @return   return  the element {@odf.element form:time}
	 * DifferentQName 
	 */
	public FormTimeElement newFormTimeElement()
	{
		FormTimeElement  formTime = ((OdfFileDom)this.ownerDocument).newOdfElement(FormTimeElement.class);
		this.appendChild( formTime);
		return  formTime;
	}                   
               
	/**
	 * Create child element {@odf.element form:combobox}.
	 *
	 * @return   return  the element {@odf.element form:combobox}
	 * DifferentQName 
	 */
	public FormComboboxElement newFormComboboxElement()
	{
		FormComboboxElement  formCombobox = ((OdfFileDom)this.ownerDocument).newOdfElement(FormComboboxElement.class);
		this.appendChild( formCombobox);
		return  formCombobox;
	}                   
               
	/**
	 * Create child element {@odf.element form:listbox}.
	 *
	 * @return   return  the element {@odf.element form:listbox}
	 * DifferentQName 
	 */
	public FormListboxElement newFormListboxElement()
	{
		FormListboxElement  formListbox = ((OdfFileDom)this.ownerDocument).newOdfElement(FormListboxElement.class);
		this.appendChild( formListbox);
		return  formListbox;
	}                   
               
	/**
	 * Create child element {@odf.element form:checkbox}.
	 *
    
	 * @return   return  the element {@odf.element form:checkbox}
	 * DifferentQName 
	 */
    
	public FormCheckboxElement newFormCheckboxElement()
	{
		FormCheckboxElement  formCheckbox = ((OdfFileDom)this.ownerDocument).newOdfElement(FormCheckboxElement.class);
		this.appendChild( formCheckbox);
		return  formCheckbox;      
	}
    
	/**
	 * Create child element {@odf.element form:checkbox}.
	 *
     * @param formImagePositionAttributeValue  the <code>String</code> value of <code>FormImagePositionAttribute</code>, see {@odf.attribute  form:image-position} at specification
	 * @return   return  the element {@odf.element form:checkbox}
	 * DifferentQName 
	 */
    
	public FormCheckboxElement newFormCheckboxElement(String formImagePositionAttributeValue)
	{
		FormCheckboxElement  formCheckbox = ((OdfFileDom)this.ownerDocument).newOdfElement(FormCheckboxElement.class);
		formCheckbox.setFormImagePositionAttribute( formImagePositionAttributeValue );
		this.appendChild( formCheckbox);
		return  formCheckbox;      
	}
    
	/**
	 * Create child element {@odf.element form:password}.
	 *
	 * @return   return  the element {@odf.element form:password}
	 * DifferentQName 
	 */
	public FormPasswordElement newFormPasswordElement()
	{
		FormPasswordElement  formPassword = ((OdfFileDom)this.ownerDocument).newOdfElement(FormPasswordElement.class);
		this.appendChild( formPassword);
		return  formPassword;
	}                   
               
	/**
	 * Create child element {@odf.element form:file}.
	 *
	 * @return   return  the element {@odf.element form:file}
	 * DifferentQName 
	 */
	public FormFileElement newFormFileElement()
	{
		FormFileElement  formFile = ((OdfFileDom)this.ownerDocument).newOdfElement(FormFileElement.class);
		this.appendChild( formFile);
		return  formFile;
	}                   
               
	/**
	 * Create child element {@odf.element form:fixed-text}.
	 *
	 * @return   return  the element {@odf.element form:fixed-text}
	 * DifferentQName 
	 */
	public FormFixedTextElement newFormFixedTextElement()
	{
		FormFixedTextElement  formFixedText = ((OdfFileDom)this.ownerDocument).newOdfElement(FormFixedTextElement.class);
		this.appendChild( formFixedText);
		return  formFixedText;
	}                   
               
	/**
	 * Create child element {@odf.element form:button}.
	 *
    
	 * @return   return  the element {@odf.element form:button}
	 * DifferentQName 
	 */
    
	public FormButtonElement newFormButtonElement()
	{
		FormButtonElement  formButton = ((OdfFileDom)this.ownerDocument).newOdfElement(FormButtonElement.class);
		this.appendChild( formButton);
		return  formButton;      
	}
    
	/**
	 * Create child element {@odf.element form:button}.
	 *
     * @param formImagePositionAttributeValue  the <code>String</code> value of <code>FormImagePositionAttribute</code>, see {@odf.attribute  form:image-position} at specification
	 * @return   return  the element {@odf.element form:button}
	 * DifferentQName 
	 */
    
	public FormButtonElement newFormButtonElement(String formImagePositionAttributeValue)
	{
		FormButtonElement  formButton = ((OdfFileDom)this.ownerDocument).newOdfElement(FormButtonElement.class);
		formButton.setFormImagePositionAttribute( formImagePositionAttributeValue );
		this.appendChild( formButton);
		return  formButton;      
	}
    
	/**
	 * Create child element {@odf.element form:image}.
	 *
	 * @return   return  the element {@odf.element form:image}
	 * DifferentQName 
	 */
	public FormImageElement newFormImageElement()
	{
		FormImageElement  formImage = ((OdfFileDom)this.ownerDocument).newOdfElement(FormImageElement.class);
		this.appendChild( formImage);
		return  formImage;
	}                   
               
	/**
	 * Create child element {@odf.element form:radio}.
	 *
    
	 * @return   return  the element {@odf.element form:radio}
	 * DifferentQName 
	 */
    
	public FormRadioElement newFormRadioElement()
	{
		FormRadioElement  formRadio = ((OdfFileDom)this.ownerDocument).newOdfElement(FormRadioElement.class);
		this.appendChild( formRadio);
		return  formRadio;      
	}
    
	/**
	 * Create child element {@odf.element form:radio}.
	 *
     * @param formImagePositionAttributeValue  the <code>String</code> value of <code>FormImagePositionAttribute</code>, see {@odf.attribute  form:image-position} at specification
	 * @return   return  the element {@odf.element form:radio}
	 * DifferentQName 
	 */
    
	public FormRadioElement newFormRadioElement(String formImagePositionAttributeValue)
	{
		FormRadioElement  formRadio = ((OdfFileDom)this.ownerDocument).newOdfElement(FormRadioElement.class);
		formRadio.setFormImagePositionAttribute( formImagePositionAttributeValue );
		this.appendChild( formRadio);
		return  formRadio;      
	}
    
	/**
	 * Create child element {@odf.element form:frame}.
	 *
	 * @return   return  the element {@odf.element form:frame}
	 * DifferentQName 
	 */
	public FormFrameElement newFormFrameElement()
	{
		FormFrameElement  formFrame = ((OdfFileDom)this.ownerDocument).newOdfElement(FormFrameElement.class);
		this.appendChild( formFrame);
		return  formFrame;
	}                   
               
	/**
	 * Create child element {@odf.element form:image-frame}.
	 *
	 * @return   return  the element {@odf.element form:image-frame}
	 * DifferentQName 
	 */
	public FormImageFrameElement newFormImageFrameElement()
	{
		FormImageFrameElement  formImageFrame = ((OdfFileDom)this.ownerDocument).newOdfElement(FormImageFrameElement.class);
		this.appendChild( formImageFrame);
		return  formImageFrame;
	}                   
               
	/**
	 * Create child element {@odf.element form:hidden}.
	 *
	 * @return   return  the element {@odf.element form:hidden}
	 * DifferentQName 
	 */
	public FormHiddenElement newFormHiddenElement()
	{
		FormHiddenElement  formHidden = ((OdfFileDom)this.ownerDocument).newOdfElement(FormHiddenElement.class);
		this.appendChild( formHidden);
		return  formHidden;
	}                   
               
	/**
	 * Create child element {@odf.element form:grid}.
	 *
	 * @return   return  the element {@odf.element form:grid}
	 * DifferentQName 
	 */
	public FormGridElement newFormGridElement()
	{
		FormGridElement  formGrid = ((OdfFileDom)this.ownerDocument).newOdfElement(FormGridElement.class);
		this.appendChild( formGrid);
		return  formGrid;
	}                   
               
	/**
	 * Create child element {@odf.element form:value-range}.
	 *
	 * @return   return  the element {@odf.element form:value-range}
	 * DifferentQName 
	 */
	public FormValueRangeElement newFormValueRangeElement()
	{
		FormValueRangeElement  formValueRange = ((OdfFileDom)this.ownerDocument).newOdfElement(FormValueRangeElement.class);
		this.appendChild( formValueRange);
		return  formValueRange;
	}                   
               
	/**
	 * Create child element {@odf.element form:generic-control}.
	 *
	 * @return   return  the element {@odf.element form:generic-control}
	 * DifferentQName 
	 */
	public FormGenericControlElement newFormGenericControlElement()
	{
		FormGenericControlElement  formGenericControl = ((OdfFileDom)this.ownerDocument).newOdfElement(FormGenericControlElement.class);
		this.appendChild( formGenericControl);
		return  formGenericControl;
	}                   
               
	/**
	 * Create child element {@odf.element form:form}.
	 *
	 * @return   return  the element {@odf.element form:form}
	 * DifferentQName 
	 */
	public FormFormElement newFormFormElement()
	{
		FormFormElement  formForm = ((OdfFileDom)this.ownerDocument).newOdfElement(FormFormElement.class);
		this.appendChild( formForm);
		return  formForm;
	}                   
               
	/**
	 * Create child element {@odf.element form:connection-resource}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @return   return  the element {@odf.element form:connection-resource}
	 * DifferentQName 
	 */
    
	public FormConnectionResourceElement newFormConnectionResourceElement(String xlinkHrefAttributeValue)
	{
		FormConnectionResourceElement  formConnectionResource = ((OdfFileDom)this.ownerDocument).newOdfElement(FormConnectionResourceElement.class);
		formConnectionResource.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		this.appendChild( formConnectionResource);
		return  formConnectionResource;      
	}
    
}
