/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeVersionAttribute;
import org.odftoolkit.odfdom.dom.attribute.grddl.GrddlTransformationAttribute;

import org.odftoolkit.odfdom.dom.element.config.ConfigConfigItemSetElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:document-settings}.
 *
 */
public class OfficeDocumentSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "document-settings" );


	/**
	 * Create the instance of <code>OfficeDocumentSettingsElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeDocumentSettingsElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:document-settings}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  OfficeDocumentSettingsElement}
	 *
     * @param officeVersionAttributeValue  The mandatory attribute {@odf.attribute  office:version}"
     *
	 */
	public void init(String officeVersionAttributeValue)
	{
		setOfficeVersionAttribute( officeVersionAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeVersionAttribute()
	{
		OfficeVersionAttribute attr = (OfficeVersionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "version" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @param officeVersionValue   The type is <code>String</code>
	 */
	public void setOfficeVersionAttribute( String officeVersionValue )
	{
		OfficeVersionAttribute attr =  new OfficeVersionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeVersionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getGrddlTransformationAttribute()
	{
		GrddlTransformationAttribute attr = (GrddlTransformationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.GRDDL), "transformation" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @param grddlTransformationValue   The type is <code>String</code>
	 */
	public void setGrddlTransformationAttribute( String grddlTransformationValue )
	{
		GrddlTransformationAttribute attr =  new GrddlTransformationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( grddlTransformationValue );
	}

	/**
	 * Create child element {@odf.element config:config-item-set}.
	 *
     * @param configNameAttributeValue  the <code>String</code> value of <code>ConfigNameAttribute</code>, see {@odf.attribute  config:name} at specification
	 * @return   return  the element {@odf.element config:config-item-set}
	 * DifferentQName 
	 */
    
	public ConfigConfigItemSetElement newConfigConfigItemSetElement(String configNameAttributeValue)
	{
		ConfigConfigItemSetElement  configConfigItemSet = ((OdfFileDom)this.ownerDocument).newOdfElement(ConfigConfigItemSetElement.class);
		configConfigItemSet.setConfigNameAttribute( configNameAttributeValue );
		this.appendChild( configConfigItemSet);
		return  configConfigItemSet;      
	}
    
}
