/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShapeIdAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationEffectAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationSpeedAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDelayAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationStartScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationPathIdAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element presentation:hide-text}.
 *
 */
public class PresentationHideTextElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.PRESENTATION, "hide-text" );


	/**
	 * Create the instance of <code>PresentationHideTextElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public PresentationHideTextElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element presentation:hide-text}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  PresentationHideTextElement}
	 *
     * @param drawShapeIdAttributeValue  The mandatory attribute {@odf.attribute  draw:shape-id}"
     *
	 */
	public void init(String drawShapeIdAttributeValue)
	{
		setDrawShapeIdAttribute( drawShapeIdAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShapeIdAttribute</code> , See {@odf.attribute draw:shape-id}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShapeIdAttribute()
	{
		DrawShapeIdAttribute attr = (DrawShapeIdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shape-id" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShapeIdAttribute</code> , See {@odf.attribute draw:shape-id}
	 *
	 * @param drawShapeIdValue   The type is <code>String</code>
	 */
	public void setDrawShapeIdAttribute( String drawShapeIdValue )
	{
		DrawShapeIdAttribute attr =  new DrawShapeIdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShapeIdValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationEffectAttribute</code> , See {@odf.attribute presentation:effect}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationEffectAttribute()
	{
		PresentationEffectAttribute attr = (PresentationEffectAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "effect" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationEffectAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationEffectAttribute</code> , See {@odf.attribute presentation:effect}
	 *
	 * @param presentationEffectValue   The type is <code>String</code>
	 */
	public void setPresentationEffectAttribute( String presentationEffectValue )
	{
		PresentationEffectAttribute attr =  new PresentationEffectAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationEffectValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDirectionAttribute</code> , See {@odf.attribute presentation:direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationDirectionAttribute()
	{
		PresentationDirectionAttribute attr = (PresentationDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationDirectionAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDirectionAttribute</code> , See {@odf.attribute presentation:direction}
	 *
	 * @param presentationDirectionValue   The type is <code>String</code>
	 */
	public void setPresentationDirectionAttribute( String presentationDirectionValue )
	{
		PresentationDirectionAttribute attr =  new PresentationDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationSpeedAttribute</code> , See {@odf.attribute presentation:speed}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationSpeedAttribute()
	{
		PresentationSpeedAttribute attr = (PresentationSpeedAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "speed" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationSpeedAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationSpeedAttribute</code> , See {@odf.attribute presentation:speed}
	 *
	 * @param presentationSpeedValue   The type is <code>String</code>
	 */
	public void setPresentationSpeedAttribute( String presentationSpeedValue )
	{
		PresentationSpeedAttribute attr =  new PresentationSpeedAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationSpeedValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationDelayAttribute</code> , See {@odf.attribute presentation:delay}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationDelayAttribute()
	{
		PresentationDelayAttribute attr = (PresentationDelayAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "delay" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationDelayAttribute</code> , See {@odf.attribute presentation:delay}
	 *
	 * @param presentationDelayValue   The type is <code>String</code>
	 */
	public void setPresentationDelayAttribute( String presentationDelayValue )
	{
		PresentationDelayAttribute attr =  new PresentationDelayAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationDelayValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationStartScaleAttribute</code> , See {@odf.attribute presentation:start-scale}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationStartScaleAttribute()
	{
		PresentationStartScaleAttribute attr = (PresentationStartScaleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "start-scale" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return PresentationStartScaleAttribute.DEFAULT_VALUE;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationStartScaleAttribute</code> , See {@odf.attribute presentation:start-scale}
	 *
	 * @param presentationStartScaleValue   The type is <code>String</code>
	 */
	public void setPresentationStartScaleAttribute( String presentationStartScaleValue )
	{
		PresentationStartScaleAttribute attr =  new PresentationStartScaleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationStartScaleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>PresentationPathIdAttribute</code> , See {@odf.attribute presentation:path-id}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getPresentationPathIdAttribute()
	{
		PresentationPathIdAttribute attr = (PresentationPathIdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION), "path-id" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>PresentationPathIdAttribute</code> , See {@odf.attribute presentation:path-id}
	 *
	 * @param presentationPathIdValue   The type is <code>String</code>
	 */
	public void setPresentationPathIdAttribute( String presentationPathIdValue )
	{
		PresentationPathIdAttribute attr =  new PresentationPathIdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( presentationPathIdValue );
	}

	/**
	 * Create child element {@odf.element presentation:sound}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element presentation:sound}
	 * DifferentQName 
	 */
    
	public PresentationSoundElement newPresentationSoundElement(String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		PresentationSoundElement  presentationSound = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationSoundElement.class);
		presentationSound.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		presentationSound.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( presentationSound);
		return  presentationSound;      
	}
    
}
