/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStrokeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStrokeDashAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStrokeDashNamesAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgStrokeWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgStrokeColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerStartAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerEndAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerStartWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerEndWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerStartCenterAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMarkerEndCenterAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgStrokeOpacityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStrokeLinejoinAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgStrokeLinecapAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawSymbolColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationStartInsideAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationStopInsideAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationRepeatAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationDelayAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnimationStepsAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawAutoGrowWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawAutoGrowHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFitToSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFitToContourAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextareaVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextareaHorizontalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWrapOptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShrinkToFitAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawColorModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawColorInversionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawLuminanceAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawContrastAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGammaAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawRedAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGreenAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawBlueAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawImageOpacityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShadowOffsetXAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShadowOffsetYAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShadowColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShadowOpacityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStartLineSpacingHorizontalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStartLineSpacingVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawEndLineSpacingHorizontalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawEndLineSpacingVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawLineDistanceAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGuideOverhangAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGuideDistanceAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStartGuideAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawEndGuideAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawPlacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawParallelAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMeasureAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMeasureVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawUnitAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawShowUnitAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawDecimalPlacesAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionAngleTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionGapAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionEscapeDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionEscapeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionLineLengthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawCaptionFitLineLengthAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dHorizontalSegmentsAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dVerticalSegmentsAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dEdgeRoundingAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dEdgeRoundingModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dBackScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dDepthAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dBackfaceCullingAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dEndAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dCloseFrontAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dCloseBackAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dLightingModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dNormalsKindAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dNormalsDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dTextureGenerationModeXAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dTextureGenerationModeYAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dTextureKindAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dTextureFilterAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dTextureModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dAmbientColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dEmissiveColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dSpecularColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dDiffuseColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dShininessAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRelWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRelHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMinWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMinHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMaxHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMaxWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintContentAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleProtectAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleHorizontalPosAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgXAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleHorizontalRelAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalPosAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgYAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalRelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorPageNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBackgroundTransparencyAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleEditableAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWrapAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWrapDynamicThresholdAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumberWrappedParagraphsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWrapContourAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWrapContourModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRunThroughAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFlowWithTextAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleOverflowBehaviorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleMirrorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoClipAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawWrapInfluenceOnPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFrameDisplayScrollbarAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFrameDisplayBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFrameMarginHorizontalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFrameMarginVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawVisibleAreaLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawVisibleAreaTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawVisibleAreaWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawVisibleAreaHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawDrawAspectAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawOleDrawAspectAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawSecondaryFillColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillGradientNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGradientStepCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillHatchNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillHatchSolidAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRepeatAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointXAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointYAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawFillImageRefPointAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTileRepeatOffsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawOpacityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawOpacityNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgFillRuleAttribute;

import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:graphic-properties}.
 *
 */
public class StyleGraphicPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.STYLE, "graphic-properties" );

	/**
	 * The value set of {@odf.attribute dr3d:lighting-mode}.
	 */
	 public enum Dr3dLightingModeAttributeValue {
	 
	 DOUBLE_SIDED( Dr3dLightingModeAttribute.Value.DOUBLE_SIDED.toString() ), STANDARD( Dr3dLightingModeAttribute.Value.STANDARD.toString() );
              
		private String mValue;
	 	
		Dr3dLightingModeAttributeValue( String value )
		{
			mValue = value;
		}
		
		@Override
		public String toString()
		{
			return mValue;
		}
		
		public static Dr3dLightingModeAttributeValue enumValueOf( String value )
	    {
	        for( Dr3dLightingModeAttributeValue aIter : values() )
	        {
	            if( value.equals( aIter.toString() ) )
	            {
	                return aIter;
	            }
	        }
	        return null;
	    }
	}

	/**
	 * Create the instance of <code>StyleGraphicPropertiesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StyleGraphicPropertiesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:graphic-properties}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

    public final static OdfStyleProperty Stroke = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "stroke"));
    public final static OdfStyleProperty StrokeDash = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "stroke-dash"));
    public final static OdfStyleProperty StrokeDashNames = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "stroke-dash-names"));
    public final static OdfStyleProperty StrokeWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "stroke-width"));
    public final static OdfStyleProperty StrokeColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "stroke-color"));
    public final static OdfStyleProperty MarkerStart = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-start"));
    public final static OdfStyleProperty MarkerEnd = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-end"));
    public final static OdfStyleProperty MarkerStartWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-start-width"));
    public final static OdfStyleProperty MarkerEndWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-end-width"));
    public final static OdfStyleProperty MarkerStartCenter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-start-center"));
    public final static OdfStyleProperty MarkerEndCenter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "marker-end-center"));
    public final static OdfStyleProperty StrokeOpacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "stroke-opacity"));
    public final static OdfStyleProperty StrokeLinejoin = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "stroke-linejoin"));
    public final static OdfStyleProperty StrokeLinecap = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "stroke-linecap"));
    public final static OdfStyleProperty SymbolColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "symbol-color"));
    public final static OdfStyleProperty Animation = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation"));
    public final static OdfStyleProperty AnimationDirection = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-direction"));
    public final static OdfStyleProperty AnimationStartInside = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-start-inside"));
    public final static OdfStyleProperty AnimationStopInside = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-stop-inside"));
    public final static OdfStyleProperty AnimationRepeat = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-repeat"));
    public final static OdfStyleProperty AnimationDelay = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-delay"));
    public final static OdfStyleProperty AnimationSteps = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "animation-steps"));
    public final static OdfStyleProperty AutoGrowWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "auto-grow-width"));
    public final static OdfStyleProperty AutoGrowHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "auto-grow-height"));
    public final static OdfStyleProperty FitToSize = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fit-to-size"));
    public final static OdfStyleProperty FitToContour = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fit-to-contour"));
    public final static OdfStyleProperty TextareaVerticalAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "textarea-vertical-align"));
    public final static OdfStyleProperty TextareaHorizontalAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "textarea-horizontal-align"));
    public final static OdfStyleProperty WrapOption = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "wrap-option"));
    public final static OdfStyleProperty ShrinkToFit = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "shrink-to-fit"));
    public final static OdfStyleProperty ColorMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "color-mode"));
    public final static OdfStyleProperty ColorInversion = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "color-inversion"));
    public final static OdfStyleProperty Luminance = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "luminance"));
    public final static OdfStyleProperty Contrast = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "contrast"));
    public final static OdfStyleProperty Gamma = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "gamma"));
    public final static OdfStyleProperty Red = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "red"));
    public final static OdfStyleProperty Green = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "green"));
    public final static OdfStyleProperty Blue = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "blue"));
    public final static OdfStyleProperty ImageOpacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "image-opacity"));
    public final static OdfStyleProperty DrawShadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "shadow"));
    public final static OdfStyleProperty ShadowOffsetX = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "shadow-offset-x"));
    public final static OdfStyleProperty ShadowOffsetY = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "shadow-offset-y"));
    public final static OdfStyleProperty ShadowColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "shadow-color"));
    public final static OdfStyleProperty ShadowOpacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "shadow-opacity"));
    public final static OdfStyleProperty StartLineSpacingHorizontal = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "start-line-spacing-horizontal"));
    public final static OdfStyleProperty StartLineSpacingVertical = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "start-line-spacing-vertical"));
    public final static OdfStyleProperty EndLineSpacingHorizontal = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "end-line-spacing-horizontal"));
    public final static OdfStyleProperty EndLineSpacingVertical = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "end-line-spacing-vertical"));
    public final static OdfStyleProperty LineDistance = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "line-distance"));
    public final static OdfStyleProperty GuideOverhang = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "guide-overhang"));
    public final static OdfStyleProperty GuideDistance = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "guide-distance"));
    public final static OdfStyleProperty StartGuide = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "start-guide"));
    public final static OdfStyleProperty EndGuide = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "end-guide"));
    public final static OdfStyleProperty Placing = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "placing"));
    public final static OdfStyleProperty Parallel = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "parallel"));
    public final static OdfStyleProperty MeasureAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "measure-align"));
    public final static OdfStyleProperty MeasureVerticalAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "measure-vertical-align"));
    public final static OdfStyleProperty Unit = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "unit"));
    public final static OdfStyleProperty ShowUnit = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "show-unit"));
    public final static OdfStyleProperty DecimalPlaces = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "decimal-places"));
    public final static OdfStyleProperty CaptionType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-type"));
    public final static OdfStyleProperty CaptionAngleType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-angle-type"));
    public final static OdfStyleProperty CaptionAngle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-angle"));
    public final static OdfStyleProperty CaptionGap = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-gap"));
    public final static OdfStyleProperty CaptionEscapeDirection = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-escape-direction"));
    public final static OdfStyleProperty CaptionEscape = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-escape"));
    public final static OdfStyleProperty CaptionLineLength = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-line-length"));
    public final static OdfStyleProperty CaptionFitLineLength = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "caption-fit-line-length"));
    public final static OdfStyleProperty HorizontalSegments = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "horizontal-segments"));
    public final static OdfStyleProperty VerticalSegments = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "vertical-segments"));
    public final static OdfStyleProperty EdgeRounding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "edge-rounding"));
    public final static OdfStyleProperty EdgeRoundingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "edge-rounding-mode"));
    public final static OdfStyleProperty BackScale = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "back-scale"));
    public final static OdfStyleProperty Depth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "depth"));
    public final static OdfStyleProperty BackfaceCulling = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "backface-culling"));
    public final static OdfStyleProperty EndAngle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "end-angle"));
    public final static OdfStyleProperty CloseFront = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "close-front"));
    public final static OdfStyleProperty CloseBack = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "close-back"));
    public final static OdfStyleProperty LightingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "lighting-mode"));
    public final static OdfStyleProperty NormalsKind = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "normals-kind"));
    public final static OdfStyleProperty NormalsDirection = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "normals-direction"));
    public final static OdfStyleProperty TextureGenerationModeX = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "texture-generation-mode-x"));
    public final static OdfStyleProperty TextureGenerationModeY = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "texture-generation-mode-y"));
    public final static OdfStyleProperty TextureKind = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "texture-kind"));
    public final static OdfStyleProperty TextureFilter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "texture-filter"));
    public final static OdfStyleProperty TextureMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "texture-mode"));
    public final static OdfStyleProperty AmbientColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "ambient-color"));
    public final static OdfStyleProperty EmissiveColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "emissive-color"));
    public final static OdfStyleProperty SpecularColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "specular-color"));
    public final static OdfStyleProperty DiffuseColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "diffuse-color"));
    public final static OdfStyleProperty Shininess = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "shininess"));
    public final static OdfStyleProperty Dr3dShadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DR3D, "shadow"));
    public final static OdfStyleProperty Width = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "width"));
    public final static OdfStyleProperty Height = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "height"));
    public final static OdfStyleProperty RelWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "rel-width"));
    public final static OdfStyleProperty RelHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "rel-height"));
    public final static OdfStyleProperty MinWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "min-width"));
    public final static OdfStyleProperty MinHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "min-height"));
    public final static OdfStyleProperty MaxHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "max-height"));
    public final static OdfStyleProperty MaxWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "max-width"));
    public final static OdfStyleProperty MarginLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-left"));
    public final static OdfStyleProperty MarginRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-right"));
    public final static OdfStyleProperty MarginTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-top"));
    public final static OdfStyleProperty MarginBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "margin-bottom"));
    public final static OdfStyleProperty Margin = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "margin"));
    public final static OdfStyleProperty PrintContent = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "print-content"));
    public final static OdfStyleProperty Protect = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "protect"));
    public final static OdfStyleProperty HorizontalPos = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "horizontal-pos"));
    public final static OdfStyleProperty X = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "x"));
    public final static OdfStyleProperty HorizontalRel = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "horizontal-rel"));
    public final static OdfStyleProperty VerticalPos = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "vertical-pos"));
    public final static OdfStyleProperty Y = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "y"));
    public final static OdfStyleProperty VerticalRel = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "vertical-rel"));
    public final static OdfStyleProperty AnchorType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "anchor-type"));
    public final static OdfStyleProperty AnchorPageNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.TEXT, "anchor-page-number"));
    public final static OdfStyleProperty Border = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "border"));
    public final static OdfStyleProperty BorderTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "border-top"));
    public final static OdfStyleProperty BorderBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "border-bottom"));
    public final static OdfStyleProperty BorderLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "border-left"));
    public final static OdfStyleProperty BorderRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "border-right"));
    public final static OdfStyleProperty BorderLineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width"));
    public final static OdfStyleProperty BorderLineWidthTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-top"));
    public final static OdfStyleProperty BorderLineWidthBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-bottom"));
    public final static OdfStyleProperty BorderLineWidthLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-left"));
    public final static OdfStyleProperty BorderLineWidthRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "border-line-width-right"));
    public final static OdfStyleProperty Padding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "padding"));
    public final static OdfStyleProperty PaddingTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-top"));
    public final static OdfStyleProperty PaddingBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-bottom"));
    public final static OdfStyleProperty PaddingLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-left"));
    public final static OdfStyleProperty PaddingRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "padding-right"));
    public final static OdfStyleProperty Shadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "shadow"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "background-color"));
    public final static OdfStyleProperty BackgroundTransparency = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "background-transparency"));
    public final static OdfStyleProperty Editable = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "editable"));
    public final static OdfStyleProperty Wrap = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "wrap"));
    public final static OdfStyleProperty WrapDynamicThreshold = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "wrap-dynamic-threshold"));
    public final static OdfStyleProperty NumberWrappedParagraphs = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "number-wrapped-paragraphs"));
    public final static OdfStyleProperty WrapContour = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "wrap-contour"));
    public final static OdfStyleProperty WrapContourMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "wrap-contour-mode"));
    public final static OdfStyleProperty RunThrough = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "run-through"));
    public final static OdfStyleProperty FlowWithText = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "flow-with-text"));
    public final static OdfStyleProperty OverflowBehavior = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "overflow-behavior"));
    public final static OdfStyleProperty Mirror = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "mirror"));
    public final static OdfStyleProperty Clip = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.FO, "clip"));
    public final static OdfStyleProperty WrapInfluenceOnPosition = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "wrap-influence-on-position"));
    public final static OdfStyleProperty WritingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "writing-mode"));
    public final static OdfStyleProperty FrameDisplayScrollbar = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "frame-display-scrollbar"));
    public final static OdfStyleProperty FrameDisplayBorder = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "frame-display-border"));
    public final static OdfStyleProperty FrameMarginHorizontal = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "frame-margin-horizontal"));
    public final static OdfStyleProperty FrameMarginVertical = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "frame-margin-vertical"));
    public final static OdfStyleProperty VisibleAreaLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "visible-area-left"));
    public final static OdfStyleProperty VisibleAreaTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "visible-area-top"));
    public final static OdfStyleProperty VisibleAreaWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "visible-area-width"));
    public final static OdfStyleProperty VisibleAreaHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "visible-area-height"));
    public final static OdfStyleProperty DrawAspect = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "draw-aspect"));
    public final static OdfStyleProperty OleDrawAspect = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "ole-draw-aspect"));
    public final static OdfStyleProperty Fill = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill"));
    public final static OdfStyleProperty FillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-color"));
    public final static OdfStyleProperty SecondaryFillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "secondary-fill-color"));
    public final static OdfStyleProperty FillGradientName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-gradient-name"));
    public final static OdfStyleProperty GradientStepCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "gradient-step-count"));
    public final static OdfStyleProperty FillHatchName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-hatch-name"));
    public final static OdfStyleProperty FillHatchSolid = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-hatch-solid"));
    public final static OdfStyleProperty FillImageName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-name"));
    public final static OdfStyleProperty Repeat = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.STYLE, "repeat"));
    public final static OdfStyleProperty FillImageWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-width"));
    public final static OdfStyleProperty FillImageHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-height"));
    public final static OdfStyleProperty FillImageRefPointX = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point-x"));
    public final static OdfStyleProperty FillImageRefPointY = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point-y"));
    public final static OdfStyleProperty FillImageRefPoint = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "fill-image-ref-point"));
    public final static OdfStyleProperty TileRepeatOffset = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "tile-repeat-offset"));
    public final static OdfStyleProperty Opacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "opacity"));
    public final static OdfStyleProperty OpacityName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.DRAW, "opacity-name"));
    public final static OdfStyleProperty FillRule = 
        OdfStyleProperty.get(OdfStylePropertiesSet.GraphicProperties, OdfName.newName(OdfNamespaceNames.SVG, "fill-rule"));


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStrokeAttribute</code> , See {@odf.attribute draw:stroke}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStrokeAttribute()
	{
		DrawStrokeAttribute attr = (DrawStrokeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "stroke" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStrokeAttribute</code> , See {@odf.attribute draw:stroke}
	 *
	 * @param drawStrokeValue   The type is <code>String</code>
	 */
	public void setDrawStrokeAttribute( String drawStrokeValue )
	{
		DrawStrokeAttribute attr =  new DrawStrokeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStrokeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStrokeDashAttribute</code> , See {@odf.attribute draw:stroke-dash}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStrokeDashAttribute()
	{
		DrawStrokeDashAttribute attr = (DrawStrokeDashAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "stroke-dash" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStrokeDashAttribute</code> , See {@odf.attribute draw:stroke-dash}
	 *
	 * @param drawStrokeDashValue   The type is <code>String</code>
	 */
	public void setDrawStrokeDashAttribute( String drawStrokeDashValue )
	{
		DrawStrokeDashAttribute attr =  new DrawStrokeDashAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStrokeDashValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStrokeDashNamesAttribute</code> , See {@odf.attribute draw:stroke-dash-names}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStrokeDashNamesAttribute()
	{
		DrawStrokeDashNamesAttribute attr = (DrawStrokeDashNamesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "stroke-dash-names" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStrokeDashNamesAttribute</code> , See {@odf.attribute draw:stroke-dash-names}
	 *
	 * @param drawStrokeDashNamesValue   The type is <code>String</code>
	 */
	public void setDrawStrokeDashNamesAttribute( String drawStrokeDashNamesValue )
	{
		DrawStrokeDashNamesAttribute attr =  new DrawStrokeDashNamesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStrokeDashNamesValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgStrokeWidthAttribute</code> , See {@odf.attribute svg:stroke-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgStrokeWidthAttribute()
	{
		SvgStrokeWidthAttribute attr = (SvgStrokeWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "stroke-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgStrokeWidthAttribute</code> , See {@odf.attribute svg:stroke-width}
	 *
	 * @param svgStrokeWidthValue   The type is <code>String</code>
	 */
	public void setSvgStrokeWidthAttribute( String svgStrokeWidthValue )
	{
		SvgStrokeWidthAttribute attr =  new SvgStrokeWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgStrokeWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgStrokeColorAttribute</code> , See {@odf.attribute svg:stroke-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgStrokeColorAttribute()
	{
		SvgStrokeColorAttribute attr = (SvgStrokeColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "stroke-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgStrokeColorAttribute</code> , See {@odf.attribute svg:stroke-color}
	 *
	 * @param svgStrokeColorValue   The type is <code>String</code>
	 */
	public void setSvgStrokeColorAttribute( String svgStrokeColorValue )
	{
		SvgStrokeColorAttribute attr =  new SvgStrokeColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgStrokeColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerStartAttribute</code> , See {@odf.attribute draw:marker-start}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMarkerStartAttribute()
	{
		DrawMarkerStartAttribute attr = (DrawMarkerStartAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-start" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerStartAttribute</code> , See {@odf.attribute draw:marker-start}
	 *
	 * @param drawMarkerStartValue   The type is <code>String</code>
	 */
	public void setDrawMarkerStartAttribute( String drawMarkerStartValue )
	{
		DrawMarkerStartAttribute attr =  new DrawMarkerStartAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMarkerStartValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerEndAttribute</code> , See {@odf.attribute draw:marker-end}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMarkerEndAttribute()
	{
		DrawMarkerEndAttribute attr = (DrawMarkerEndAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-end" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerEndAttribute</code> , See {@odf.attribute draw:marker-end}
	 *
	 * @param drawMarkerEndValue   The type is <code>String</code>
	 */
	public void setDrawMarkerEndAttribute( String drawMarkerEndValue )
	{
		DrawMarkerEndAttribute attr =  new DrawMarkerEndAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMarkerEndValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerStartWidthAttribute</code> , See {@odf.attribute draw:marker-start-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMarkerStartWidthAttribute()
	{
		DrawMarkerStartWidthAttribute attr = (DrawMarkerStartWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-start-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerStartWidthAttribute</code> , See {@odf.attribute draw:marker-start-width}
	 *
	 * @param drawMarkerStartWidthValue   The type is <code>String</code>
	 */
	public void setDrawMarkerStartWidthAttribute( String drawMarkerStartWidthValue )
	{
		DrawMarkerStartWidthAttribute attr =  new DrawMarkerStartWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMarkerStartWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerEndWidthAttribute</code> , See {@odf.attribute draw:marker-end-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMarkerEndWidthAttribute()
	{
		DrawMarkerEndWidthAttribute attr = (DrawMarkerEndWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-end-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerEndWidthAttribute</code> , See {@odf.attribute draw:marker-end-width}
	 *
	 * @param drawMarkerEndWidthValue   The type is <code>String</code>
	 */
	public void setDrawMarkerEndWidthAttribute( String drawMarkerEndWidthValue )
	{
		DrawMarkerEndWidthAttribute attr =  new DrawMarkerEndWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMarkerEndWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerStartCenterAttribute</code> , See {@odf.attribute draw:marker-start-center}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawMarkerStartCenterAttribute()
	{
		DrawMarkerStartCenterAttribute attr = (DrawMarkerStartCenterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-start-center" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerStartCenterAttribute</code> , See {@odf.attribute draw:marker-start-center}
	 *
	 * @param drawMarkerStartCenterValue   The type is <code>Boolean</code>
	 */
	public void setDrawMarkerStartCenterAttribute( Boolean drawMarkerStartCenterValue )
	{
		DrawMarkerStartCenterAttribute attr =  new DrawMarkerStartCenterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawMarkerStartCenterValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMarkerEndCenterAttribute</code> , See {@odf.attribute draw:marker-end-center}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawMarkerEndCenterAttribute()
	{
		DrawMarkerEndCenterAttribute attr = (DrawMarkerEndCenterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "marker-end-center" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMarkerEndCenterAttribute</code> , See {@odf.attribute draw:marker-end-center}
	 *
	 * @param drawMarkerEndCenterValue   The type is <code>Boolean</code>
	 */
	public void setDrawMarkerEndCenterAttribute( Boolean drawMarkerEndCenterValue )
	{
		DrawMarkerEndCenterAttribute attr =  new DrawMarkerEndCenterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawMarkerEndCenterValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgStrokeOpacityAttribute</code> , See {@odf.attribute svg:stroke-opacity}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getSvgStrokeOpacityAttribute()
	{
		SvgStrokeOpacityAttribute attr = (SvgStrokeOpacityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "stroke-opacity" ) ;
		if( attr != null ){
			return Double.valueOf( attr.doubleValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgStrokeOpacityAttribute</code> , See {@odf.attribute svg:stroke-opacity}
	 *
	 * @param svgStrokeOpacityValue   The type is <code>Double</code>
	 */
	public void setSvgStrokeOpacityAttribute( Double svgStrokeOpacityValue )
	{
		SvgStrokeOpacityAttribute attr =  new SvgStrokeOpacityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setDoubleValue( svgStrokeOpacityValue.doubleValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStrokeLinejoinAttribute</code> , See {@odf.attribute draw:stroke-linejoin}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStrokeLinejoinAttribute()
	{
		DrawStrokeLinejoinAttribute attr = (DrawStrokeLinejoinAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "stroke-linejoin" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStrokeLinejoinAttribute</code> , See {@odf.attribute draw:stroke-linejoin}
	 *
	 * @param drawStrokeLinejoinValue   The type is <code>String</code>
	 */
	public void setDrawStrokeLinejoinAttribute( String drawStrokeLinejoinValue )
	{
		DrawStrokeLinejoinAttribute attr =  new DrawStrokeLinejoinAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStrokeLinejoinValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgStrokeLinecapAttribute</code> , See {@odf.attribute svg:stroke-linecap}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgStrokeLinecapAttribute()
	{
		SvgStrokeLinecapAttribute attr = (SvgStrokeLinecapAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "stroke-linecap" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgStrokeLinecapAttribute</code> , See {@odf.attribute svg:stroke-linecap}
	 *
	 * @param svgStrokeLinecapValue   The type is <code>String</code>
	 */
	public void setSvgStrokeLinecapAttribute( String svgStrokeLinecapValue )
	{
		SvgStrokeLinecapAttribute attr =  new SvgStrokeLinecapAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgStrokeLinecapValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawSymbolColorAttribute</code> , See {@odf.attribute draw:symbol-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawSymbolColorAttribute()
	{
		DrawSymbolColorAttribute attr = (DrawSymbolColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "symbol-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawSymbolColorAttribute</code> , See {@odf.attribute draw:symbol-color}
	 *
	 * @param drawSymbolColorValue   The type is <code>String</code>
	 */
	public void setDrawSymbolColorAttribute( String drawSymbolColorValue )
	{
		DrawSymbolColorAttribute attr =  new DrawSymbolColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawSymbolColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationAttribute</code> , See {@odf.attribute text:animation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnimationAttribute()
	{
		TextAnimationAttribute attr = (TextAnimationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationAttribute</code> , See {@odf.attribute text:animation}
	 *
	 * @param textAnimationValue   The type is <code>String</code>
	 */
	public void setTextAnimationAttribute( String textAnimationValue )
	{
		TextAnimationAttribute attr =  new TextAnimationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnimationValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationDirectionAttribute</code> , See {@odf.attribute text:animation-direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnimationDirectionAttribute()
	{
		TextAnimationDirectionAttribute attr = (TextAnimationDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationDirectionAttribute</code> , See {@odf.attribute text:animation-direction}
	 *
	 * @param textAnimationDirectionValue   The type is <code>String</code>
	 */
	public void setTextAnimationDirectionAttribute( String textAnimationDirectionValue )
	{
		TextAnimationDirectionAttribute attr =  new TextAnimationDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnimationDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationStartInsideAttribute</code> , See {@odf.attribute text:animation-start-inside}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextAnimationStartInsideAttribute()
	{
		TextAnimationStartInsideAttribute attr = (TextAnimationStartInsideAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-start-inside" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationStartInsideAttribute</code> , See {@odf.attribute text:animation-start-inside}
	 *
	 * @param textAnimationStartInsideValue   The type is <code>Boolean</code>
	 */
	public void setTextAnimationStartInsideAttribute( Boolean textAnimationStartInsideValue )
	{
		TextAnimationStartInsideAttribute attr =  new TextAnimationStartInsideAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textAnimationStartInsideValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationStopInsideAttribute</code> , See {@odf.attribute text:animation-stop-inside}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextAnimationStopInsideAttribute()
	{
		TextAnimationStopInsideAttribute attr = (TextAnimationStopInsideAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-stop-inside" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationStopInsideAttribute</code> , See {@odf.attribute text:animation-stop-inside}
	 *
	 * @param textAnimationStopInsideValue   The type is <code>Boolean</code>
	 */
	public void setTextAnimationStopInsideAttribute( Boolean textAnimationStopInsideValue )
	{
		TextAnimationStopInsideAttribute attr =  new TextAnimationStopInsideAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( textAnimationStopInsideValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationRepeatAttribute</code> , See {@odf.attribute text:animation-repeat}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTextAnimationRepeatAttribute()
	{
		TextAnimationRepeatAttribute attr = (TextAnimationRepeatAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-repeat" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationRepeatAttribute</code> , See {@odf.attribute text:animation-repeat}
	 *
	 * @param textAnimationRepeatValue   The type is <code>Integer</code>
	 */
	public void setTextAnimationRepeatAttribute( Integer textAnimationRepeatValue )
	{
		TextAnimationRepeatAttribute attr =  new TextAnimationRepeatAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( textAnimationRepeatValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationDelayAttribute</code> , See {@odf.attribute text:animation-delay}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnimationDelayAttribute()
	{
		TextAnimationDelayAttribute attr = (TextAnimationDelayAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-delay" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationDelayAttribute</code> , See {@odf.attribute text:animation-delay}
	 *
	 * @param textAnimationDelayValue   The type is <code>String</code>
	 */
	public void setTextAnimationDelayAttribute( String textAnimationDelayValue )
	{
		TextAnimationDelayAttribute attr =  new TextAnimationDelayAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnimationDelayValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnimationStepsAttribute</code> , See {@odf.attribute text:animation-steps}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnimationStepsAttribute()
	{
		TextAnimationStepsAttribute attr = (TextAnimationStepsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "animation-steps" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnimationStepsAttribute</code> , See {@odf.attribute text:animation-steps}
	 *
	 * @param textAnimationStepsValue   The type is <code>String</code>
	 */
	public void setTextAnimationStepsAttribute( String textAnimationStepsValue )
	{
		TextAnimationStepsAttribute attr =  new TextAnimationStepsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnimationStepsValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawAutoGrowWidthAttribute</code> , See {@odf.attribute draw:auto-grow-width}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawAutoGrowWidthAttribute()
	{
		DrawAutoGrowWidthAttribute attr = (DrawAutoGrowWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "auto-grow-width" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawAutoGrowWidthAttribute</code> , See {@odf.attribute draw:auto-grow-width}
	 *
	 * @param drawAutoGrowWidthValue   The type is <code>Boolean</code>
	 */
	public void setDrawAutoGrowWidthAttribute( Boolean drawAutoGrowWidthValue )
	{
		DrawAutoGrowWidthAttribute attr =  new DrawAutoGrowWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawAutoGrowWidthValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawAutoGrowHeightAttribute</code> , See {@odf.attribute draw:auto-grow-height}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawAutoGrowHeightAttribute()
	{
		DrawAutoGrowHeightAttribute attr = (DrawAutoGrowHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "auto-grow-height" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawAutoGrowHeightAttribute</code> , See {@odf.attribute draw:auto-grow-height}
	 *
	 * @param drawAutoGrowHeightValue   The type is <code>Boolean</code>
	 */
	public void setDrawAutoGrowHeightAttribute( Boolean drawAutoGrowHeightValue )
	{
		DrawAutoGrowHeightAttribute attr =  new DrawAutoGrowHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawAutoGrowHeightValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFitToSizeAttribute</code> , See {@odf.attribute draw:fit-to-size}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFitToSizeAttribute()
	{
		DrawFitToSizeAttribute attr = (DrawFitToSizeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fit-to-size" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFitToSizeAttribute</code> , See {@odf.attribute draw:fit-to-size}
	 *
	 * @param drawFitToSizeValue   The type is <code>Boolean</code>
	 */
	public void setDrawFitToSizeAttribute( Boolean drawFitToSizeValue )
	{
		DrawFitToSizeAttribute attr =  new DrawFitToSizeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFitToSizeValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFitToContourAttribute</code> , See {@odf.attribute draw:fit-to-contour}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFitToContourAttribute()
	{
		DrawFitToContourAttribute attr = (DrawFitToContourAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fit-to-contour" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFitToContourAttribute</code> , See {@odf.attribute draw:fit-to-contour}
	 *
	 * @param drawFitToContourValue   The type is <code>Boolean</code>
	 */
	public void setDrawFitToContourAttribute( Boolean drawFitToContourValue )
	{
		DrawFitToContourAttribute attr =  new DrawFitToContourAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFitToContourValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawTextareaVerticalAlignAttribute</code> , See {@odf.attribute draw:textarea-vertical-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawTextareaVerticalAlignAttribute()
	{
		DrawTextareaVerticalAlignAttribute attr = (DrawTextareaVerticalAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "textarea-vertical-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawTextareaVerticalAlignAttribute</code> , See {@odf.attribute draw:textarea-vertical-align}
	 *
	 * @param drawTextareaVerticalAlignValue   The type is <code>String</code>
	 */
	public void setDrawTextareaVerticalAlignAttribute( String drawTextareaVerticalAlignValue )
	{
		DrawTextareaVerticalAlignAttribute attr =  new DrawTextareaVerticalAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawTextareaVerticalAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawTextareaHorizontalAlignAttribute</code> , See {@odf.attribute draw:textarea-horizontal-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawTextareaHorizontalAlignAttribute()
	{
		DrawTextareaHorizontalAlignAttribute attr = (DrawTextareaHorizontalAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "textarea-horizontal-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawTextareaHorizontalAlignAttribute</code> , See {@odf.attribute draw:textarea-horizontal-align}
	 *
	 * @param drawTextareaHorizontalAlignValue   The type is <code>String</code>
	 */
	public void setDrawTextareaHorizontalAlignAttribute( String drawTextareaHorizontalAlignValue )
	{
		DrawTextareaHorizontalAlignAttribute attr =  new DrawTextareaHorizontalAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawTextareaHorizontalAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoWrapOptionAttribute</code> , See {@odf.attribute fo:wrap-option}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoWrapOptionAttribute()
	{
		FoWrapOptionAttribute attr = (FoWrapOptionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "wrap-option" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoWrapOptionAttribute</code> , See {@odf.attribute fo:wrap-option}
	 *
	 * @param foWrapOptionValue   The type is <code>String</code>
	 */
	public void setFoWrapOptionAttribute( String foWrapOptionValue )
	{
		FoWrapOptionAttribute attr =  new FoWrapOptionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foWrapOptionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleShrinkToFitAttribute</code> , See {@odf.attribute style:shrink-to-fit}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleShrinkToFitAttribute()
	{
		StyleShrinkToFitAttribute attr = (StyleShrinkToFitAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "shrink-to-fit" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleShrinkToFitAttribute</code> , See {@odf.attribute style:shrink-to-fit}
	 *
	 * @param styleShrinkToFitValue   The type is <code>Boolean</code>
	 */
	public void setStyleShrinkToFitAttribute( Boolean styleShrinkToFitValue )
	{
		StyleShrinkToFitAttribute attr =  new StyleShrinkToFitAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleShrinkToFitValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawColorModeAttribute</code> , See {@odf.attribute draw:color-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawColorModeAttribute()
	{
		DrawColorModeAttribute attr = (DrawColorModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "color-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawColorModeAttribute</code> , See {@odf.attribute draw:color-mode}
	 *
	 * @param drawColorModeValue   The type is <code>String</code>
	 */
	public void setDrawColorModeAttribute( String drawColorModeValue )
	{
		DrawColorModeAttribute attr =  new DrawColorModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawColorModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawColorInversionAttribute</code> , See {@odf.attribute draw:color-inversion}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawColorInversionAttribute()
	{
		DrawColorInversionAttribute attr = (DrawColorInversionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "color-inversion" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawColorInversionAttribute</code> , See {@odf.attribute draw:color-inversion}
	 *
	 * @param drawColorInversionValue   The type is <code>Boolean</code>
	 */
	public void setDrawColorInversionAttribute( Boolean drawColorInversionValue )
	{
		DrawColorInversionAttribute attr =  new DrawColorInversionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawColorInversionValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawLuminanceAttribute</code> , See {@odf.attribute draw:luminance}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawLuminanceAttribute()
	{
		DrawLuminanceAttribute attr = (DrawLuminanceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "luminance" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawLuminanceAttribute</code> , See {@odf.attribute draw:luminance}
	 *
	 * @param drawLuminanceValue   The type is <code>String</code>
	 */
	public void setDrawLuminanceAttribute( String drawLuminanceValue )
	{
		DrawLuminanceAttribute attr =  new DrawLuminanceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawLuminanceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawContrastAttribute</code> , See {@odf.attribute draw:contrast}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawContrastAttribute()
	{
		DrawContrastAttribute attr = (DrawContrastAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "contrast" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawContrastAttribute</code> , See {@odf.attribute draw:contrast}
	 *
	 * @param drawContrastValue   The type is <code>String</code>
	 */
	public void setDrawContrastAttribute( String drawContrastValue )
	{
		DrawContrastAttribute attr =  new DrawContrastAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawContrastValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGammaAttribute</code> , See {@odf.attribute draw:gamma}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawGammaAttribute()
	{
		DrawGammaAttribute attr = (DrawGammaAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "gamma" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGammaAttribute</code> , See {@odf.attribute draw:gamma}
	 *
	 * @param drawGammaValue   The type is <code>String</code>
	 */
	public void setDrawGammaAttribute( String drawGammaValue )
	{
		DrawGammaAttribute attr =  new DrawGammaAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawGammaValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawRedAttribute</code> , See {@odf.attribute draw:red}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawRedAttribute()
	{
		DrawRedAttribute attr = (DrawRedAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "red" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawRedAttribute</code> , See {@odf.attribute draw:red}
	 *
	 * @param drawRedValue   The type is <code>String</code>
	 */
	public void setDrawRedAttribute( String drawRedValue )
	{
		DrawRedAttribute attr =  new DrawRedAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawRedValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGreenAttribute</code> , See {@odf.attribute draw:green}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawGreenAttribute()
	{
		DrawGreenAttribute attr = (DrawGreenAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "green" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGreenAttribute</code> , See {@odf.attribute draw:green}
	 *
	 * @param drawGreenValue   The type is <code>String</code>
	 */
	public void setDrawGreenAttribute( String drawGreenValue )
	{
		DrawGreenAttribute attr =  new DrawGreenAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawGreenValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawBlueAttribute</code> , See {@odf.attribute draw:blue}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawBlueAttribute()
	{
		DrawBlueAttribute attr = (DrawBlueAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "blue" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawBlueAttribute</code> , See {@odf.attribute draw:blue}
	 *
	 * @param drawBlueValue   The type is <code>String</code>
	 */
	public void setDrawBlueAttribute( String drawBlueValue )
	{
		DrawBlueAttribute attr =  new DrawBlueAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawBlueValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawImageOpacityAttribute</code> , See {@odf.attribute draw:image-opacity}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawImageOpacityAttribute()
	{
		DrawImageOpacityAttribute attr = (DrawImageOpacityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "image-opacity" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawImageOpacityAttribute</code> , See {@odf.attribute draw:image-opacity}
	 *
	 * @param drawImageOpacityValue   The type is <code>String</code>
	 */
	public void setDrawImageOpacityAttribute( String drawImageOpacityValue )
	{
		DrawImageOpacityAttribute attr =  new DrawImageOpacityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawImageOpacityValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShadowAttribute</code> , See {@odf.attribute draw:shadow}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShadowAttribute()
	{
		DrawShadowAttribute attr = (DrawShadowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shadow" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShadowAttribute</code> , See {@odf.attribute draw:shadow}
	 *
	 * @param drawShadowValue   The type is <code>String</code>
	 */
	public void setDrawShadowAttribute( String drawShadowValue )
	{
		DrawShadowAttribute attr =  new DrawShadowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShadowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShadowOffsetXAttribute</code> , See {@odf.attribute draw:shadow-offset-x}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShadowOffsetXAttribute()
	{
		DrawShadowOffsetXAttribute attr = (DrawShadowOffsetXAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shadow-offset-x" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShadowOffsetXAttribute</code> , See {@odf.attribute draw:shadow-offset-x}
	 *
	 * @param drawShadowOffsetXValue   The type is <code>String</code>
	 */
	public void setDrawShadowOffsetXAttribute( String drawShadowOffsetXValue )
	{
		DrawShadowOffsetXAttribute attr =  new DrawShadowOffsetXAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShadowOffsetXValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShadowOffsetYAttribute</code> , See {@odf.attribute draw:shadow-offset-y}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShadowOffsetYAttribute()
	{
		DrawShadowOffsetYAttribute attr = (DrawShadowOffsetYAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shadow-offset-y" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShadowOffsetYAttribute</code> , See {@odf.attribute draw:shadow-offset-y}
	 *
	 * @param drawShadowOffsetYValue   The type is <code>String</code>
	 */
	public void setDrawShadowOffsetYAttribute( String drawShadowOffsetYValue )
	{
		DrawShadowOffsetYAttribute attr =  new DrawShadowOffsetYAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShadowOffsetYValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShadowColorAttribute</code> , See {@odf.attribute draw:shadow-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShadowColorAttribute()
	{
		DrawShadowColorAttribute attr = (DrawShadowColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shadow-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShadowColorAttribute</code> , See {@odf.attribute draw:shadow-color}
	 *
	 * @param drawShadowColorValue   The type is <code>String</code>
	 */
	public void setDrawShadowColorAttribute( String drawShadowColorValue )
	{
		DrawShadowColorAttribute attr =  new DrawShadowColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShadowColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShadowOpacityAttribute</code> , See {@odf.attribute draw:shadow-opacity}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawShadowOpacityAttribute()
	{
		DrawShadowOpacityAttribute attr = (DrawShadowOpacityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "shadow-opacity" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShadowOpacityAttribute</code> , See {@odf.attribute draw:shadow-opacity}
	 *
	 * @param drawShadowOpacityValue   The type is <code>String</code>
	 */
	public void setDrawShadowOpacityAttribute( String drawShadowOpacityValue )
	{
		DrawShadowOpacityAttribute attr =  new DrawShadowOpacityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawShadowOpacityValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStartLineSpacingHorizontalAttribute</code> , See {@odf.attribute draw:start-line-spacing-horizontal}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStartLineSpacingHorizontalAttribute()
	{
		DrawStartLineSpacingHorizontalAttribute attr = (DrawStartLineSpacingHorizontalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "start-line-spacing-horizontal" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStartLineSpacingHorizontalAttribute</code> , See {@odf.attribute draw:start-line-spacing-horizontal}
	 *
	 * @param drawStartLineSpacingHorizontalValue   The type is <code>String</code>
	 */
	public void setDrawStartLineSpacingHorizontalAttribute( String drawStartLineSpacingHorizontalValue )
	{
		DrawStartLineSpacingHorizontalAttribute attr =  new DrawStartLineSpacingHorizontalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStartLineSpacingHorizontalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStartLineSpacingVerticalAttribute</code> , See {@odf.attribute draw:start-line-spacing-vertical}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStartLineSpacingVerticalAttribute()
	{
		DrawStartLineSpacingVerticalAttribute attr = (DrawStartLineSpacingVerticalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "start-line-spacing-vertical" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStartLineSpacingVerticalAttribute</code> , See {@odf.attribute draw:start-line-spacing-vertical}
	 *
	 * @param drawStartLineSpacingVerticalValue   The type is <code>String</code>
	 */
	public void setDrawStartLineSpacingVerticalAttribute( String drawStartLineSpacingVerticalValue )
	{
		DrawStartLineSpacingVerticalAttribute attr =  new DrawStartLineSpacingVerticalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStartLineSpacingVerticalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawEndLineSpacingHorizontalAttribute</code> , See {@odf.attribute draw:end-line-spacing-horizontal}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawEndLineSpacingHorizontalAttribute()
	{
		DrawEndLineSpacingHorizontalAttribute attr = (DrawEndLineSpacingHorizontalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "end-line-spacing-horizontal" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawEndLineSpacingHorizontalAttribute</code> , See {@odf.attribute draw:end-line-spacing-horizontal}
	 *
	 * @param drawEndLineSpacingHorizontalValue   The type is <code>String</code>
	 */
	public void setDrawEndLineSpacingHorizontalAttribute( String drawEndLineSpacingHorizontalValue )
	{
		DrawEndLineSpacingHorizontalAttribute attr =  new DrawEndLineSpacingHorizontalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawEndLineSpacingHorizontalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawEndLineSpacingVerticalAttribute</code> , See {@odf.attribute draw:end-line-spacing-vertical}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawEndLineSpacingVerticalAttribute()
	{
		DrawEndLineSpacingVerticalAttribute attr = (DrawEndLineSpacingVerticalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "end-line-spacing-vertical" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawEndLineSpacingVerticalAttribute</code> , See {@odf.attribute draw:end-line-spacing-vertical}
	 *
	 * @param drawEndLineSpacingVerticalValue   The type is <code>String</code>
	 */
	public void setDrawEndLineSpacingVerticalAttribute( String drawEndLineSpacingVerticalValue )
	{
		DrawEndLineSpacingVerticalAttribute attr =  new DrawEndLineSpacingVerticalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawEndLineSpacingVerticalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawLineDistanceAttribute</code> , See {@odf.attribute draw:line-distance}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawLineDistanceAttribute()
	{
		DrawLineDistanceAttribute attr = (DrawLineDistanceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "line-distance" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawLineDistanceAttribute</code> , See {@odf.attribute draw:line-distance}
	 *
	 * @param drawLineDistanceValue   The type is <code>String</code>
	 */
	public void setDrawLineDistanceAttribute( String drawLineDistanceValue )
	{
		DrawLineDistanceAttribute attr =  new DrawLineDistanceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawLineDistanceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGuideOverhangAttribute</code> , See {@odf.attribute draw:guide-overhang}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawGuideOverhangAttribute()
	{
		DrawGuideOverhangAttribute attr = (DrawGuideOverhangAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "guide-overhang" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGuideOverhangAttribute</code> , See {@odf.attribute draw:guide-overhang}
	 *
	 * @param drawGuideOverhangValue   The type is <code>String</code>
	 */
	public void setDrawGuideOverhangAttribute( String drawGuideOverhangValue )
	{
		DrawGuideOverhangAttribute attr =  new DrawGuideOverhangAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawGuideOverhangValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGuideDistanceAttribute</code> , See {@odf.attribute draw:guide-distance}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawGuideDistanceAttribute()
	{
		DrawGuideDistanceAttribute attr = (DrawGuideDistanceAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "guide-distance" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGuideDistanceAttribute</code> , See {@odf.attribute draw:guide-distance}
	 *
	 * @param drawGuideDistanceValue   The type is <code>String</code>
	 */
	public void setDrawGuideDistanceAttribute( String drawGuideDistanceValue )
	{
		DrawGuideDistanceAttribute attr =  new DrawGuideDistanceAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawGuideDistanceValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawStartGuideAttribute</code> , See {@odf.attribute draw:start-guide}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawStartGuideAttribute()
	{
		DrawStartGuideAttribute attr = (DrawStartGuideAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "start-guide" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawStartGuideAttribute</code> , See {@odf.attribute draw:start-guide}
	 *
	 * @param drawStartGuideValue   The type is <code>String</code>
	 */
	public void setDrawStartGuideAttribute( String drawStartGuideValue )
	{
		DrawStartGuideAttribute attr =  new DrawStartGuideAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawStartGuideValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawEndGuideAttribute</code> , See {@odf.attribute draw:end-guide}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawEndGuideAttribute()
	{
		DrawEndGuideAttribute attr = (DrawEndGuideAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "end-guide" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawEndGuideAttribute</code> , See {@odf.attribute draw:end-guide}
	 *
	 * @param drawEndGuideValue   The type is <code>String</code>
	 */
	public void setDrawEndGuideAttribute( String drawEndGuideValue )
	{
		DrawEndGuideAttribute attr =  new DrawEndGuideAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawEndGuideValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawPlacingAttribute</code> , See {@odf.attribute draw:placing}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawPlacingAttribute()
	{
		DrawPlacingAttribute attr = (DrawPlacingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "placing" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawPlacingAttribute</code> , See {@odf.attribute draw:placing}
	 *
	 * @param drawPlacingValue   The type is <code>String</code>
	 */
	public void setDrawPlacingAttribute( String drawPlacingValue )
	{
		DrawPlacingAttribute attr =  new DrawPlacingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawPlacingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawParallelAttribute</code> , See {@odf.attribute draw:parallel}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawParallelAttribute()
	{
		DrawParallelAttribute attr = (DrawParallelAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "parallel" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawParallelAttribute</code> , See {@odf.attribute draw:parallel}
	 *
	 * @param drawParallelValue   The type is <code>Boolean</code>
	 */
	public void setDrawParallelAttribute( Boolean drawParallelValue )
	{
		DrawParallelAttribute attr =  new DrawParallelAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawParallelValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMeasureAlignAttribute</code> , See {@odf.attribute draw:measure-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMeasureAlignAttribute()
	{
		DrawMeasureAlignAttribute attr = (DrawMeasureAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "measure-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMeasureAlignAttribute</code> , See {@odf.attribute draw:measure-align}
	 *
	 * @param drawMeasureAlignValue   The type is <code>String</code>
	 */
	public void setDrawMeasureAlignAttribute( String drawMeasureAlignValue )
	{
		DrawMeasureAlignAttribute attr =  new DrawMeasureAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMeasureAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawMeasureVerticalAlignAttribute</code> , See {@odf.attribute draw:measure-vertical-align}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawMeasureVerticalAlignAttribute()
	{
		DrawMeasureVerticalAlignAttribute attr = (DrawMeasureVerticalAlignAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "measure-vertical-align" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawMeasureVerticalAlignAttribute</code> , See {@odf.attribute draw:measure-vertical-align}
	 *
	 * @param drawMeasureVerticalAlignValue   The type is <code>String</code>
	 */
	public void setDrawMeasureVerticalAlignAttribute( String drawMeasureVerticalAlignValue )
	{
		DrawMeasureVerticalAlignAttribute attr =  new DrawMeasureVerticalAlignAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawMeasureVerticalAlignValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawUnitAttribute</code> , See {@odf.attribute draw:unit}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawUnitAttribute()
	{
		DrawUnitAttribute attr = (DrawUnitAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "unit" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawUnitAttribute</code> , See {@odf.attribute draw:unit}
	 *
	 * @param drawUnitValue   The type is <code>String</code>
	 */
	public void setDrawUnitAttribute( String drawUnitValue )
	{
		DrawUnitAttribute attr =  new DrawUnitAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawUnitValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawShowUnitAttribute</code> , See {@odf.attribute draw:show-unit}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawShowUnitAttribute()
	{
		DrawShowUnitAttribute attr = (DrawShowUnitAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "show-unit" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawShowUnitAttribute</code> , See {@odf.attribute draw:show-unit}
	 *
	 * @param drawShowUnitValue   The type is <code>Boolean</code>
	 */
	public void setDrawShowUnitAttribute( Boolean drawShowUnitValue )
	{
		DrawShowUnitAttribute attr =  new DrawShowUnitAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawShowUnitValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawDecimalPlacesAttribute</code> , See {@odf.attribute draw:decimal-places}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDrawDecimalPlacesAttribute()
	{
		DrawDecimalPlacesAttribute attr = (DrawDecimalPlacesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "decimal-places" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawDecimalPlacesAttribute</code> , See {@odf.attribute draw:decimal-places}
	 *
	 * @param drawDecimalPlacesValue   The type is <code>Integer</code>
	 */
	public void setDrawDecimalPlacesAttribute( Integer drawDecimalPlacesValue )
	{
		DrawDecimalPlacesAttribute attr =  new DrawDecimalPlacesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( drawDecimalPlacesValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionTypeAttribute</code> , See {@odf.attribute draw:caption-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionTypeAttribute()
	{
		DrawCaptionTypeAttribute attr = (DrawCaptionTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionTypeAttribute</code> , See {@odf.attribute draw:caption-type}
	 *
	 * @param drawCaptionTypeValue   The type is <code>String</code>
	 */
	public void setDrawCaptionTypeAttribute( String drawCaptionTypeValue )
	{
		DrawCaptionTypeAttribute attr =  new DrawCaptionTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionAngleTypeAttribute</code> , See {@odf.attribute draw:caption-angle-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionAngleTypeAttribute()
	{
		DrawCaptionAngleTypeAttribute attr = (DrawCaptionAngleTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-angle-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionAngleTypeAttribute</code> , See {@odf.attribute draw:caption-angle-type}
	 *
	 * @param drawCaptionAngleTypeValue   The type is <code>String</code>
	 */
	public void setDrawCaptionAngleTypeAttribute( String drawCaptionAngleTypeValue )
	{
		DrawCaptionAngleTypeAttribute attr =  new DrawCaptionAngleTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionAngleTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionAngleAttribute</code> , See {@odf.attribute draw:caption-angle}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionAngleAttribute()
	{
		DrawCaptionAngleAttribute attr = (DrawCaptionAngleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-angle" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionAngleAttribute</code> , See {@odf.attribute draw:caption-angle}
	 *
	 * @param drawCaptionAngleValue   The type is <code>String</code>
	 */
	public void setDrawCaptionAngleAttribute( String drawCaptionAngleValue )
	{
		DrawCaptionAngleAttribute attr =  new DrawCaptionAngleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionAngleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionGapAttribute</code> , See {@odf.attribute draw:caption-gap}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionGapAttribute()
	{
		DrawCaptionGapAttribute attr = (DrawCaptionGapAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-gap" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionGapAttribute</code> , See {@odf.attribute draw:caption-gap}
	 *
	 * @param drawCaptionGapValue   The type is <code>String</code>
	 */
	public void setDrawCaptionGapAttribute( String drawCaptionGapValue )
	{
		DrawCaptionGapAttribute attr =  new DrawCaptionGapAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionGapValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionEscapeDirectionAttribute</code> , See {@odf.attribute draw:caption-escape-direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionEscapeDirectionAttribute()
	{
		DrawCaptionEscapeDirectionAttribute attr = (DrawCaptionEscapeDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-escape-direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionEscapeDirectionAttribute</code> , See {@odf.attribute draw:caption-escape-direction}
	 *
	 * @param drawCaptionEscapeDirectionValue   The type is <code>String</code>
	 */
	public void setDrawCaptionEscapeDirectionAttribute( String drawCaptionEscapeDirectionValue )
	{
		DrawCaptionEscapeDirectionAttribute attr =  new DrawCaptionEscapeDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionEscapeDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionEscapeAttribute</code> , See {@odf.attribute draw:caption-escape}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionEscapeAttribute()
	{
		DrawCaptionEscapeAttribute attr = (DrawCaptionEscapeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-escape" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionEscapeAttribute</code> , See {@odf.attribute draw:caption-escape}
	 *
	 * @param drawCaptionEscapeValue   The type is <code>String</code>
	 */
	public void setDrawCaptionEscapeAttribute( String drawCaptionEscapeValue )
	{
		DrawCaptionEscapeAttribute attr =  new DrawCaptionEscapeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionEscapeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionLineLengthAttribute</code> , See {@odf.attribute draw:caption-line-length}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawCaptionLineLengthAttribute()
	{
		DrawCaptionLineLengthAttribute attr = (DrawCaptionLineLengthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-line-length" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionLineLengthAttribute</code> , See {@odf.attribute draw:caption-line-length}
	 *
	 * @param drawCaptionLineLengthValue   The type is <code>String</code>
	 */
	public void setDrawCaptionLineLengthAttribute( String drawCaptionLineLengthValue )
	{
		DrawCaptionLineLengthAttribute attr =  new DrawCaptionLineLengthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawCaptionLineLengthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawCaptionFitLineLengthAttribute</code> , See {@odf.attribute draw:caption-fit-line-length}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawCaptionFitLineLengthAttribute()
	{
		DrawCaptionFitLineLengthAttribute attr = (DrawCaptionFitLineLengthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "caption-fit-line-length" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawCaptionFitLineLengthAttribute</code> , See {@odf.attribute draw:caption-fit-line-length}
	 *
	 * @param drawCaptionFitLineLengthValue   The type is <code>Boolean</code>
	 */
	public void setDrawCaptionFitLineLengthAttribute( Boolean drawCaptionFitLineLengthValue )
	{
		DrawCaptionFitLineLengthAttribute attr =  new DrawCaptionFitLineLengthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawCaptionFitLineLengthValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dHorizontalSegmentsAttribute</code> , See {@odf.attribute dr3d:horizontal-segments}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDr3dHorizontalSegmentsAttribute()
	{
		Dr3dHorizontalSegmentsAttribute attr = (Dr3dHorizontalSegmentsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "horizontal-segments" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dHorizontalSegmentsAttribute</code> , See {@odf.attribute dr3d:horizontal-segments}
	 *
	 * @param dr3dHorizontalSegmentsValue   The type is <code>Integer</code>
	 */
	public void setDr3dHorizontalSegmentsAttribute( Integer dr3dHorizontalSegmentsValue )
	{
		Dr3dHorizontalSegmentsAttribute attr =  new Dr3dHorizontalSegmentsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( dr3dHorizontalSegmentsValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dVerticalSegmentsAttribute</code> , See {@odf.attribute dr3d:vertical-segments}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDr3dVerticalSegmentsAttribute()
	{
		Dr3dVerticalSegmentsAttribute attr = (Dr3dVerticalSegmentsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "vertical-segments" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dVerticalSegmentsAttribute</code> , See {@odf.attribute dr3d:vertical-segments}
	 *
	 * @param dr3dVerticalSegmentsValue   The type is <code>Integer</code>
	 */
	public void setDr3dVerticalSegmentsAttribute( Integer dr3dVerticalSegmentsValue )
	{
		Dr3dVerticalSegmentsAttribute attr =  new Dr3dVerticalSegmentsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( dr3dVerticalSegmentsValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dEdgeRoundingAttribute</code> , See {@odf.attribute dr3d:edge-rounding}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dEdgeRoundingAttribute()
	{
		Dr3dEdgeRoundingAttribute attr = (Dr3dEdgeRoundingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "edge-rounding" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dEdgeRoundingAttribute</code> , See {@odf.attribute dr3d:edge-rounding}
	 *
	 * @param dr3dEdgeRoundingValue   The type is <code>String</code>
	 */
	public void setDr3dEdgeRoundingAttribute( String dr3dEdgeRoundingValue )
	{
		Dr3dEdgeRoundingAttribute attr =  new Dr3dEdgeRoundingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dEdgeRoundingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dEdgeRoundingModeAttribute</code> , See {@odf.attribute dr3d:edge-rounding-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dEdgeRoundingModeAttribute()
	{
		Dr3dEdgeRoundingModeAttribute attr = (Dr3dEdgeRoundingModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "edge-rounding-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dEdgeRoundingModeAttribute</code> , See {@odf.attribute dr3d:edge-rounding-mode}
	 *
	 * @param dr3dEdgeRoundingModeValue   The type is <code>String</code>
	 */
	public void setDr3dEdgeRoundingModeAttribute( String dr3dEdgeRoundingModeValue )
	{
		Dr3dEdgeRoundingModeAttribute attr =  new Dr3dEdgeRoundingModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dEdgeRoundingModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dBackScaleAttribute</code> , See {@odf.attribute dr3d:back-scale}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dBackScaleAttribute()
	{
		Dr3dBackScaleAttribute attr = (Dr3dBackScaleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "back-scale" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dBackScaleAttribute</code> , See {@odf.attribute dr3d:back-scale}
	 *
	 * @param dr3dBackScaleValue   The type is <code>String</code>
	 */
	public void setDr3dBackScaleAttribute( String dr3dBackScaleValue )
	{
		Dr3dBackScaleAttribute attr =  new Dr3dBackScaleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dBackScaleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dDepthAttribute</code> , See {@odf.attribute dr3d:depth}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dDepthAttribute()
	{
		Dr3dDepthAttribute attr = (Dr3dDepthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "depth" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dDepthAttribute</code> , See {@odf.attribute dr3d:depth}
	 *
	 * @param dr3dDepthValue   The type is <code>String</code>
	 */
	public void setDr3dDepthAttribute( String dr3dDepthValue )
	{
		Dr3dDepthAttribute attr =  new Dr3dDepthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dDepthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dBackfaceCullingAttribute</code> , See {@odf.attribute dr3d:backface-culling}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dBackfaceCullingAttribute()
	{
		Dr3dBackfaceCullingAttribute attr = (Dr3dBackfaceCullingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "backface-culling" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dBackfaceCullingAttribute</code> , See {@odf.attribute dr3d:backface-culling}
	 *
	 * @param dr3dBackfaceCullingValue   The type is <code>String</code>
	 */
	public void setDr3dBackfaceCullingAttribute( String dr3dBackfaceCullingValue )
	{
		Dr3dBackfaceCullingAttribute attr =  new Dr3dBackfaceCullingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dBackfaceCullingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dEndAngleAttribute</code> , See {@odf.attribute dr3d:end-angle}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dEndAngleAttribute()
	{
		Dr3dEndAngleAttribute attr = (Dr3dEndAngleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "end-angle" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dEndAngleAttribute</code> , See {@odf.attribute dr3d:end-angle}
	 *
	 * @param dr3dEndAngleValue   The type is <code>String</code>
	 */
	public void setDr3dEndAngleAttribute( String dr3dEndAngleValue )
	{
		Dr3dEndAngleAttribute attr =  new Dr3dEndAngleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dEndAngleValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dCloseFrontAttribute</code> , See {@odf.attribute dr3d:close-front}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDr3dCloseFrontAttribute()
	{
		Dr3dCloseFrontAttribute attr = (Dr3dCloseFrontAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "close-front" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dCloseFrontAttribute</code> , See {@odf.attribute dr3d:close-front}
	 *
	 * @param dr3dCloseFrontValue   The type is <code>Boolean</code>
	 */
	public void setDr3dCloseFrontAttribute( Boolean dr3dCloseFrontValue )
	{
		Dr3dCloseFrontAttribute attr =  new Dr3dCloseFrontAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( dr3dCloseFrontValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dCloseBackAttribute</code> , See {@odf.attribute dr3d:close-back}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDr3dCloseBackAttribute()
	{
		Dr3dCloseBackAttribute attr = (Dr3dCloseBackAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "close-back" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dCloseBackAttribute</code> , See {@odf.attribute dr3d:close-back}
	 *
	 * @param dr3dCloseBackValue   The type is <code>Boolean</code>
	 */
	public void setDr3dCloseBackAttribute( Boolean dr3dCloseBackValue )
	{
		Dr3dCloseBackAttribute attr =  new Dr3dCloseBackAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( dr3dCloseBackValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dLightingModeAttribute</code> , See {@odf.attribute dr3d:lighting-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dLightingModeAttribute()
	{
		Dr3dLightingModeAttribute attr = (Dr3dLightingModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "lighting-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dLightingModeAttribute</code> , See {@odf.attribute dr3d:lighting-mode}
	 *
	 * @param dr3dLightingModeValue   The type is <code>String</code>
	 */
	public void setDr3dLightingModeAttribute( String dr3dLightingModeValue )
	{
		Dr3dLightingModeAttribute attr =  new Dr3dLightingModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dLightingModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dNormalsKindAttribute</code> , See {@odf.attribute dr3d:normals-kind}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dNormalsKindAttribute()
	{
		Dr3dNormalsKindAttribute attr = (Dr3dNormalsKindAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "normals-kind" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dNormalsKindAttribute</code> , See {@odf.attribute dr3d:normals-kind}
	 *
	 * @param dr3dNormalsKindValue   The type is <code>String</code>
	 */
	public void setDr3dNormalsKindAttribute( String dr3dNormalsKindValue )
	{
		Dr3dNormalsKindAttribute attr =  new Dr3dNormalsKindAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dNormalsKindValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dNormalsDirectionAttribute</code> , See {@odf.attribute dr3d:normals-direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dNormalsDirectionAttribute()
	{
		Dr3dNormalsDirectionAttribute attr = (Dr3dNormalsDirectionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "normals-direction" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dNormalsDirectionAttribute</code> , See {@odf.attribute dr3d:normals-direction}
	 *
	 * @param dr3dNormalsDirectionValue   The type is <code>String</code>
	 */
	public void setDr3dNormalsDirectionAttribute( String dr3dNormalsDirectionValue )
	{
		Dr3dNormalsDirectionAttribute attr =  new Dr3dNormalsDirectionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dNormalsDirectionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dTextureGenerationModeXAttribute</code> , See {@odf.attribute dr3d:texture-generation-mode-x}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dTextureGenerationModeXAttribute()
	{
		Dr3dTextureGenerationModeXAttribute attr = (Dr3dTextureGenerationModeXAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "texture-generation-mode-x" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dTextureGenerationModeXAttribute</code> , See {@odf.attribute dr3d:texture-generation-mode-x}
	 *
	 * @param dr3dTextureGenerationModeXValue   The type is <code>String</code>
	 */
	public void setDr3dTextureGenerationModeXAttribute( String dr3dTextureGenerationModeXValue )
	{
		Dr3dTextureGenerationModeXAttribute attr =  new Dr3dTextureGenerationModeXAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dTextureGenerationModeXValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dTextureGenerationModeYAttribute</code> , See {@odf.attribute dr3d:texture-generation-mode-y}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dTextureGenerationModeYAttribute()
	{
		Dr3dTextureGenerationModeYAttribute attr = (Dr3dTextureGenerationModeYAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "texture-generation-mode-y" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dTextureGenerationModeYAttribute</code> , See {@odf.attribute dr3d:texture-generation-mode-y}
	 *
	 * @param dr3dTextureGenerationModeYValue   The type is <code>String</code>
	 */
	public void setDr3dTextureGenerationModeYAttribute( String dr3dTextureGenerationModeYValue )
	{
		Dr3dTextureGenerationModeYAttribute attr =  new Dr3dTextureGenerationModeYAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dTextureGenerationModeYValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dTextureKindAttribute</code> , See {@odf.attribute dr3d:texture-kind}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dTextureKindAttribute()
	{
		Dr3dTextureKindAttribute attr = (Dr3dTextureKindAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "texture-kind" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dTextureKindAttribute</code> , See {@odf.attribute dr3d:texture-kind}
	 *
	 * @param dr3dTextureKindValue   The type is <code>String</code>
	 */
	public void setDr3dTextureKindAttribute( String dr3dTextureKindValue )
	{
		Dr3dTextureKindAttribute attr =  new Dr3dTextureKindAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dTextureKindValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dTextureFilterAttribute</code> , See {@odf.attribute dr3d:texture-filter}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dTextureFilterAttribute()
	{
		Dr3dTextureFilterAttribute attr = (Dr3dTextureFilterAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "texture-filter" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dTextureFilterAttribute</code> , See {@odf.attribute dr3d:texture-filter}
	 *
	 * @param dr3dTextureFilterValue   The type is <code>String</code>
	 */
	public void setDr3dTextureFilterAttribute( String dr3dTextureFilterValue )
	{
		Dr3dTextureFilterAttribute attr =  new Dr3dTextureFilterAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dTextureFilterValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dTextureModeAttribute</code> , See {@odf.attribute dr3d:texture-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dTextureModeAttribute()
	{
		Dr3dTextureModeAttribute attr = (Dr3dTextureModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "texture-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dTextureModeAttribute</code> , See {@odf.attribute dr3d:texture-mode}
	 *
	 * @param dr3dTextureModeValue   The type is <code>String</code>
	 */
	public void setDr3dTextureModeAttribute( String dr3dTextureModeValue )
	{
		Dr3dTextureModeAttribute attr =  new Dr3dTextureModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dTextureModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dAmbientColorAttribute</code> , See {@odf.attribute dr3d:ambient-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dAmbientColorAttribute()
	{
		Dr3dAmbientColorAttribute attr = (Dr3dAmbientColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "ambient-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dAmbientColorAttribute</code> , See {@odf.attribute dr3d:ambient-color}
	 *
	 * @param dr3dAmbientColorValue   The type is <code>String</code>
	 */
	public void setDr3dAmbientColorAttribute( String dr3dAmbientColorValue )
	{
		Dr3dAmbientColorAttribute attr =  new Dr3dAmbientColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dAmbientColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dEmissiveColorAttribute</code> , See {@odf.attribute dr3d:emissive-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dEmissiveColorAttribute()
	{
		Dr3dEmissiveColorAttribute attr = (Dr3dEmissiveColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "emissive-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dEmissiveColorAttribute</code> , See {@odf.attribute dr3d:emissive-color}
	 *
	 * @param dr3dEmissiveColorValue   The type is <code>String</code>
	 */
	public void setDr3dEmissiveColorAttribute( String dr3dEmissiveColorValue )
	{
		Dr3dEmissiveColorAttribute attr =  new Dr3dEmissiveColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dEmissiveColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dSpecularColorAttribute</code> , See {@odf.attribute dr3d:specular-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dSpecularColorAttribute()
	{
		Dr3dSpecularColorAttribute attr = (Dr3dSpecularColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "specular-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dSpecularColorAttribute</code> , See {@odf.attribute dr3d:specular-color}
	 *
	 * @param dr3dSpecularColorValue   The type is <code>String</code>
	 */
	public void setDr3dSpecularColorAttribute( String dr3dSpecularColorValue )
	{
		Dr3dSpecularColorAttribute attr =  new Dr3dSpecularColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dSpecularColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dDiffuseColorAttribute</code> , See {@odf.attribute dr3d:diffuse-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dDiffuseColorAttribute()
	{
		Dr3dDiffuseColorAttribute attr = (Dr3dDiffuseColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "diffuse-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dDiffuseColorAttribute</code> , See {@odf.attribute dr3d:diffuse-color}
	 *
	 * @param dr3dDiffuseColorValue   The type is <code>String</code>
	 */
	public void setDr3dDiffuseColorAttribute( String dr3dDiffuseColorValue )
	{
		Dr3dDiffuseColorAttribute attr =  new Dr3dDiffuseColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dDiffuseColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dShininessAttribute</code> , See {@odf.attribute dr3d:shininess}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dShininessAttribute()
	{
		Dr3dShininessAttribute attr = (Dr3dShininessAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "shininess" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dShininessAttribute</code> , See {@odf.attribute dr3d:shininess}
	 *
	 * @param dr3dShininessValue   The type is <code>String</code>
	 */
	public void setDr3dShininessAttribute( String dr3dShininessValue )
	{
		Dr3dShininessAttribute attr =  new Dr3dShininessAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dShininessValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>Dr3dShadowAttribute</code> , See {@odf.attribute dr3d:shadow}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDr3dShadowAttribute()
	{
		Dr3dShadowAttribute attr = (Dr3dShadowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DR3D), "shadow" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>Dr3dShadowAttribute</code> , See {@odf.attribute dr3d:shadow}
	 *
	 * @param dr3dShadowValue   The type is <code>String</code>
	 */
	public void setDr3dShadowAttribute( String dr3dShadowValue )
	{
		Dr3dShadowAttribute attr =  new Dr3dShadowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dr3dShadowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgWidthAttribute</code> , See {@odf.attribute svg:width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgWidthAttribute()
	{
		SvgWidthAttribute attr = (SvgWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgWidthAttribute</code> , See {@odf.attribute svg:width}
	 *
	 * @param svgWidthValue   The type is <code>String</code>
	 */
	public void setSvgWidthAttribute( String svgWidthValue )
	{
		SvgWidthAttribute attr =  new SvgWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgHeightAttribute</code> , See {@odf.attribute svg:height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgHeightAttribute()
	{
		SvgHeightAttribute attr = (SvgHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgHeightAttribute</code> , See {@odf.attribute svg:height}
	 *
	 * @param svgHeightValue   The type is <code>String</code>
	 */
	public void setSvgHeightAttribute( String svgHeightValue )
	{
		SvgHeightAttribute attr =  new SvgHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRelWidthAttribute</code> , See {@odf.attribute style:rel-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRelWidthAttribute()
	{
		StyleRelWidthAttribute attr = (StyleRelWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "rel-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRelWidthAttribute</code> , See {@odf.attribute style:rel-width}
	 *
	 * @param styleRelWidthValue   The type is <code>String</code>
	 */
	public void setStyleRelWidthAttribute( String styleRelWidthValue )
	{
		StyleRelWidthAttribute attr =  new StyleRelWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleRelWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRelHeightAttribute</code> , See {@odf.attribute style:rel-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRelHeightAttribute()
	{
		StyleRelHeightAttribute attr = (StyleRelHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "rel-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRelHeightAttribute</code> , See {@odf.attribute style:rel-height}
	 *
	 * @param styleRelHeightValue   The type is <code>String</code>
	 */
	public void setStyleRelHeightAttribute( String styleRelHeightValue )
	{
		StyleRelHeightAttribute attr =  new StyleRelHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleRelHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMinWidthAttribute</code> , See {@odf.attribute fo:min-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMinWidthAttribute()
	{
		FoMinWidthAttribute attr = (FoMinWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "min-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMinWidthAttribute</code> , See {@odf.attribute fo:min-width}
	 *
	 * @param foMinWidthValue   The type is <code>String</code>
	 */
	public void setFoMinWidthAttribute( String foMinWidthValue )
	{
		FoMinWidthAttribute attr =  new FoMinWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMinWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMinHeightAttribute</code> , See {@odf.attribute fo:min-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMinHeightAttribute()
	{
		FoMinHeightAttribute attr = (FoMinHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "min-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMinHeightAttribute</code> , See {@odf.attribute fo:min-height}
	 *
	 * @param foMinHeightValue   The type is <code>String</code>
	 */
	public void setFoMinHeightAttribute( String foMinHeightValue )
	{
		FoMinHeightAttribute attr =  new FoMinHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMinHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMaxHeightAttribute</code> , See {@odf.attribute fo:max-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMaxHeightAttribute()
	{
		FoMaxHeightAttribute attr = (FoMaxHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "max-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMaxHeightAttribute</code> , See {@odf.attribute fo:max-height}
	 *
	 * @param foMaxHeightValue   The type is <code>String</code>
	 */
	public void setFoMaxHeightAttribute( String foMaxHeightValue )
	{
		FoMaxHeightAttribute attr =  new FoMaxHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMaxHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMaxWidthAttribute</code> , See {@odf.attribute fo:max-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMaxWidthAttribute()
	{
		FoMaxWidthAttribute attr = (FoMaxWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "max-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMaxWidthAttribute</code> , See {@odf.attribute fo:max-width}
	 *
	 * @param foMaxWidthValue   The type is <code>String</code>
	 */
	public void setFoMaxWidthAttribute( String foMaxWidthValue )
	{
		FoMaxWidthAttribute attr =  new FoMaxWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMaxWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginLeftAttribute()
	{
		FoMarginLeftAttribute attr = (FoMarginLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @param foMarginLeftValue   The type is <code>String</code>
	 */
	public void setFoMarginLeftAttribute( String foMarginLeftValue )
	{
		FoMarginLeftAttribute attr =  new FoMarginLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginRightAttribute()
	{
		FoMarginRightAttribute attr = (FoMarginRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @param foMarginRightValue   The type is <code>String</code>
	 */
	public void setFoMarginRightAttribute( String foMarginRightValue )
	{
		FoMarginRightAttribute attr =  new FoMarginRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginTopAttribute()
	{
		FoMarginTopAttribute attr = (FoMarginTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @param foMarginTopValue   The type is <code>String</code>
	 */
	public void setFoMarginTopAttribute( String foMarginTopValue )
	{
		FoMarginTopAttribute attr =  new FoMarginTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginBottomAttribute()
	{
		FoMarginBottomAttribute attr = (FoMarginBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @param foMarginBottomValue   The type is <code>String</code>
	 */
	public void setFoMarginBottomAttribute( String foMarginBottomValue )
	{
		FoMarginBottomAttribute attr =  new FoMarginBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginAttribute()
	{
		FoMarginAttribute attr = (FoMarginAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "margin" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @param foMarginValue   The type is <code>String</code>
	 */
	public void setFoMarginAttribute( String foMarginValue )
	{
		FoMarginAttribute attr =  new FoMarginAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foMarginValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePrintContentAttribute</code> , See {@odf.attribute style:print-content}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStylePrintContentAttribute()
	{
		StylePrintContentAttribute attr = (StylePrintContentAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "print-content" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePrintContentAttribute</code> , See {@odf.attribute style:print-content}
	 *
	 * @param stylePrintContentValue   The type is <code>Boolean</code>
	 */
	public void setStylePrintContentAttribute( Boolean stylePrintContentValue )
	{
		StylePrintContentAttribute attr =  new StylePrintContentAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( stylePrintContentValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleProtectAttribute</code> , See {@odf.attribute style:protect}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleProtectAttribute()
	{
		StyleProtectAttribute attr = (StyleProtectAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "protect" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleProtectAttribute</code> , See {@odf.attribute style:protect}
	 *
	 * @param styleProtectValue   The type is <code>String</code>
	 */
	public void setStyleProtectAttribute( String styleProtectValue )
	{
		StyleProtectAttribute attr =  new StyleProtectAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleProtectValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleHorizontalPosAttribute</code> , See {@odf.attribute style:horizontal-pos}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleHorizontalPosAttribute()
	{
		StyleHorizontalPosAttribute attr = (StyleHorizontalPosAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "horizontal-pos" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleHorizontalPosAttribute</code> , See {@odf.attribute style:horizontal-pos}
	 *
	 * @param styleHorizontalPosValue   The type is <code>String</code>
	 */
	public void setStyleHorizontalPosAttribute( String styleHorizontalPosValue )
	{
		StyleHorizontalPosAttribute attr =  new StyleHorizontalPosAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleHorizontalPosValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgXAttribute</code> , See {@odf.attribute svg:x}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgXAttribute()
	{
		SvgXAttribute attr = (SvgXAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "x" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgXAttribute</code> , See {@odf.attribute svg:x}
	 *
	 * @param svgXValue   The type is <code>String</code>
	 */
	public void setSvgXAttribute( String svgXValue )
	{
		SvgXAttribute attr =  new SvgXAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgXValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleHorizontalRelAttribute</code> , See {@odf.attribute style:horizontal-rel}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleHorizontalRelAttribute()
	{
		StyleHorizontalRelAttribute attr = (StyleHorizontalRelAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "horizontal-rel" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleHorizontalRelAttribute</code> , See {@odf.attribute style:horizontal-rel}
	 *
	 * @param styleHorizontalRelValue   The type is <code>String</code>
	 */
	public void setStyleHorizontalRelAttribute( String styleHorizontalRelValue )
	{
		StyleHorizontalRelAttribute attr =  new StyleHorizontalRelAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleHorizontalRelValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleVerticalPosAttribute</code> , See {@odf.attribute style:vertical-pos}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleVerticalPosAttribute()
	{
		StyleVerticalPosAttribute attr = (StyleVerticalPosAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "vertical-pos" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleVerticalPosAttribute</code> , See {@odf.attribute style:vertical-pos}
	 *
	 * @param styleVerticalPosValue   The type is <code>String</code>
	 */
	public void setStyleVerticalPosAttribute( String styleVerticalPosValue )
	{
		StyleVerticalPosAttribute attr =  new StyleVerticalPosAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleVerticalPosValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgYAttribute</code> , See {@odf.attribute svg:y}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgYAttribute()
	{
		SvgYAttribute attr = (SvgYAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "y" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgYAttribute</code> , See {@odf.attribute svg:y}
	 *
	 * @param svgYValue   The type is <code>String</code>
	 */
	public void setSvgYAttribute( String svgYValue )
	{
		SvgYAttribute attr =  new SvgYAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgYValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleVerticalRelAttribute</code> , See {@odf.attribute style:vertical-rel}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleVerticalRelAttribute()
	{
		StyleVerticalRelAttribute attr = (StyleVerticalRelAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "vertical-rel" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleVerticalRelAttribute</code> , See {@odf.attribute style:vertical-rel}
	 *
	 * @param styleVerticalRelValue   The type is <code>String</code>
	 */
	public void setStyleVerticalRelAttribute( String styleVerticalRelValue )
	{
		StyleVerticalRelAttribute attr =  new StyleVerticalRelAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleVerticalRelValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnchorTypeAttribute</code> , See {@odf.attribute text:anchor-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTextAnchorTypeAttribute()
	{
		TextAnchorTypeAttribute attr = (TextAnchorTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "anchor-type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnchorTypeAttribute</code> , See {@odf.attribute text:anchor-type}
	 *
	 * @param textAnchorTypeValue   The type is <code>String</code>
	 */
	public void setTextAnchorTypeAttribute( String textAnchorTypeValue )
	{
		TextAnchorTypeAttribute attr =  new TextAnchorTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( textAnchorTypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextAnchorPageNumberAttribute</code> , See {@odf.attribute text:anchor-page-number}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTextAnchorPageNumberAttribute()
	{
		TextAnchorPageNumberAttribute attr = (TextAnchorPageNumberAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "anchor-page-number" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TextAnchorPageNumberAttribute</code> , See {@odf.attribute text:anchor-page-number}
	 *
	 * @param textAnchorPageNumberValue   The type is <code>Integer</code>
	 */
	public void setTextAnchorPageNumberAttribute( Integer textAnchorPageNumberValue )
	{
		TextAnchorPageNumberAttribute attr =  new TextAnchorPageNumberAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( textAnchorPageNumberValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderAttribute()
	{
		FoBorderAttribute attr = (FoBorderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @param foBorderValue   The type is <code>String</code>
	 */
	public void setFoBorderAttribute( String foBorderValue )
	{
		FoBorderAttribute attr =  new FoBorderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderTopAttribute()
	{
		FoBorderTopAttribute attr = (FoBorderTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @param foBorderTopValue   The type is <code>String</code>
	 */
	public void setFoBorderTopAttribute( String foBorderTopValue )
	{
		FoBorderTopAttribute attr =  new FoBorderTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderBottomAttribute()
	{
		FoBorderBottomAttribute attr = (FoBorderBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @param foBorderBottomValue   The type is <code>String</code>
	 */
	public void setFoBorderBottomAttribute( String foBorderBottomValue )
	{
		FoBorderBottomAttribute attr =  new FoBorderBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderLeftAttribute()
	{
		FoBorderLeftAttribute attr = (FoBorderLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @param foBorderLeftValue   The type is <code>String</code>
	 */
	public void setFoBorderLeftAttribute( String foBorderLeftValue )
	{
		FoBorderLeftAttribute attr =  new FoBorderLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderRightAttribute()
	{
		FoBorderRightAttribute attr = (FoBorderRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "border-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @param foBorderRightValue   The type is <code>String</code>
	 */
	public void setFoBorderRightAttribute( String foBorderRightValue )
	{
		FoBorderRightAttribute attr =  new FoBorderRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBorderRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthAttribute()
	{
		StyleBorderLineWidthAttribute attr = (StyleBorderLineWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @param styleBorderLineWidthValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthAttribute( String styleBorderLineWidthValue )
	{
		StyleBorderLineWidthAttribute attr =  new StyleBorderLineWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthTopAttribute()
	{
		StyleBorderLineWidthTopAttribute attr = (StyleBorderLineWidthTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @param styleBorderLineWidthTopValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthTopAttribute( String styleBorderLineWidthTopValue )
	{
		StyleBorderLineWidthTopAttribute attr =  new StyleBorderLineWidthTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthBottomAttribute()
	{
		StyleBorderLineWidthBottomAttribute attr = (StyleBorderLineWidthBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @param styleBorderLineWidthBottomValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthBottomAttribute( String styleBorderLineWidthBottomValue )
	{
		StyleBorderLineWidthBottomAttribute attr =  new StyleBorderLineWidthBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthLeftAttribute()
	{
		StyleBorderLineWidthLeftAttribute attr = (StyleBorderLineWidthLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @param styleBorderLineWidthLeftValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthLeftAttribute( String styleBorderLineWidthLeftValue )
	{
		StyleBorderLineWidthLeftAttribute attr =  new StyleBorderLineWidthLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthRightAttribute()
	{
		StyleBorderLineWidthRightAttribute attr = (StyleBorderLineWidthRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "border-line-width-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @param styleBorderLineWidthRightValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthRightAttribute( String styleBorderLineWidthRightValue )
	{
		StyleBorderLineWidthRightAttribute attr =  new StyleBorderLineWidthRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBorderLineWidthRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingAttribute()
	{
		FoPaddingAttribute attr = (FoPaddingAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @param foPaddingValue   The type is <code>String</code>
	 */
	public void setFoPaddingAttribute( String foPaddingValue )
	{
		FoPaddingAttribute attr =  new FoPaddingAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingTopAttribute()
	{
		FoPaddingTopAttribute attr = (FoPaddingTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @param foPaddingTopValue   The type is <code>String</code>
	 */
	public void setFoPaddingTopAttribute( String foPaddingTopValue )
	{
		FoPaddingTopAttribute attr =  new FoPaddingTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingBottomAttribute()
	{
		FoPaddingBottomAttribute attr = (FoPaddingBottomAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-bottom" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @param foPaddingBottomValue   The type is <code>String</code>
	 */
	public void setFoPaddingBottomAttribute( String foPaddingBottomValue )
	{
		FoPaddingBottomAttribute attr =  new FoPaddingBottomAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingBottomValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingLeftAttribute()
	{
		FoPaddingLeftAttribute attr = (FoPaddingLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @param foPaddingLeftValue   The type is <code>String</code>
	 */
	public void setFoPaddingLeftAttribute( String foPaddingLeftValue )
	{
		FoPaddingLeftAttribute attr =  new FoPaddingLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingRightAttribute()
	{
		FoPaddingRightAttribute attr = (FoPaddingRightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "padding-right" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @param foPaddingRightValue   The type is <code>String</code>
	 */
	public void setFoPaddingRightAttribute( String foPaddingRightValue )
	{
		FoPaddingRightAttribute attr =  new FoPaddingRightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foPaddingRightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleShadowAttribute()
	{
		StyleShadowAttribute attr = (StyleShadowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "shadow" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @param styleShadowValue   The type is <code>String</code>
	 */
	public void setStyleShadowAttribute( String styleShadowValue )
	{
		StyleShadowAttribute attr =  new StyleShadowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleShadowValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBackgroundColorAttribute()
	{
		FoBackgroundColorAttribute attr = (FoBackgroundColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "background-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @param foBackgroundColorValue   The type is <code>String</code>
	 */
	public void setFoBackgroundColorAttribute( String foBackgroundColorValue )
	{
		FoBackgroundColorAttribute attr =  new FoBackgroundColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foBackgroundColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBackgroundTransparencyAttribute</code> , See {@odf.attribute style:background-transparency}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBackgroundTransparencyAttribute()
	{
		StyleBackgroundTransparencyAttribute attr = (StyleBackgroundTransparencyAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "background-transparency" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBackgroundTransparencyAttribute</code> , See {@odf.attribute style:background-transparency}
	 *
	 * @param styleBackgroundTransparencyValue   The type is <code>String</code>
	 */
	public void setStyleBackgroundTransparencyAttribute( String styleBackgroundTransparencyValue )
	{
		StyleBackgroundTransparencyAttribute attr =  new StyleBackgroundTransparencyAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleBackgroundTransparencyValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleEditableAttribute</code> , See {@odf.attribute style:editable}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleEditableAttribute()
	{
		StyleEditableAttribute attr = (StyleEditableAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "editable" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleEditableAttribute</code> , See {@odf.attribute style:editable}
	 *
	 * @param styleEditableValue   The type is <code>Boolean</code>
	 */
	public void setStyleEditableAttribute( Boolean styleEditableValue )
	{
		StyleEditableAttribute attr =  new StyleEditableAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleEditableValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWrapAttribute</code> , See {@odf.attribute style:wrap}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWrapAttribute()
	{
		StyleWrapAttribute attr = (StyleWrapAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "wrap" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWrapAttribute</code> , See {@odf.attribute style:wrap}
	 *
	 * @param styleWrapValue   The type is <code>String</code>
	 */
	public void setStyleWrapAttribute( String styleWrapValue )
	{
		StyleWrapAttribute attr =  new StyleWrapAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleWrapValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWrapDynamicThresholdAttribute</code> , See {@odf.attribute style:wrap-dynamic-threshold}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWrapDynamicThresholdAttribute()
	{
		StyleWrapDynamicThresholdAttribute attr = (StyleWrapDynamicThresholdAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "wrap-dynamic-threshold" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWrapDynamicThresholdAttribute</code> , See {@odf.attribute style:wrap-dynamic-threshold}
	 *
	 * @param styleWrapDynamicThresholdValue   The type is <code>String</code>
	 */
	public void setStyleWrapDynamicThresholdAttribute( String styleWrapDynamicThresholdValue )
	{
		StyleWrapDynamicThresholdAttribute attr =  new StyleWrapDynamicThresholdAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleWrapDynamicThresholdValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumberWrappedParagraphsAttribute</code> , See {@odf.attribute style:number-wrapped-paragraphs}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumberWrappedParagraphsAttribute()
	{
		StyleNumberWrappedParagraphsAttribute attr = (StyleNumberWrappedParagraphsAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "number-wrapped-paragraphs" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumberWrappedParagraphsAttribute</code> , See {@odf.attribute style:number-wrapped-paragraphs}
	 *
	 * @param styleNumberWrappedParagraphsValue   The type is <code>String</code>
	 */
	public void setStyleNumberWrappedParagraphsAttribute( String styleNumberWrappedParagraphsValue )
	{
		StyleNumberWrappedParagraphsAttribute attr =  new StyleNumberWrappedParagraphsAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleNumberWrappedParagraphsValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWrapContourAttribute</code> , See {@odf.attribute style:wrap-contour}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleWrapContourAttribute()
	{
		StyleWrapContourAttribute attr = (StyleWrapContourAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "wrap-contour" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWrapContourAttribute</code> , See {@odf.attribute style:wrap-contour}
	 *
	 * @param styleWrapContourValue   The type is <code>Boolean</code>
	 */
	public void setStyleWrapContourAttribute( Boolean styleWrapContourValue )
	{
		StyleWrapContourAttribute attr =  new StyleWrapContourAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleWrapContourValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWrapContourModeAttribute</code> , See {@odf.attribute style:wrap-contour-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWrapContourModeAttribute()
	{
		StyleWrapContourModeAttribute attr = (StyleWrapContourModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "wrap-contour-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWrapContourModeAttribute</code> , See {@odf.attribute style:wrap-contour-mode}
	 *
	 * @param styleWrapContourModeValue   The type is <code>String</code>
	 */
	public void setStyleWrapContourModeAttribute( String styleWrapContourModeValue )
	{
		StyleWrapContourModeAttribute attr =  new StyleWrapContourModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleWrapContourModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRunThroughAttribute</code> , See {@odf.attribute style:run-through}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRunThroughAttribute()
	{
		StyleRunThroughAttribute attr = (StyleRunThroughAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "run-through" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRunThroughAttribute</code> , See {@odf.attribute style:run-through}
	 *
	 * @param styleRunThroughValue   The type is <code>String</code>
	 */
	public void setStyleRunThroughAttribute( String styleRunThroughValue )
	{
		StyleRunThroughAttribute attr =  new StyleRunThroughAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleRunThroughValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleFlowWithTextAttribute</code> , See {@odf.attribute style:flow-with-text}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleFlowWithTextAttribute()
	{
		StyleFlowWithTextAttribute attr = (StyleFlowWithTextAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "flow-with-text" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleFlowWithTextAttribute</code> , See {@odf.attribute style:flow-with-text}
	 *
	 * @param styleFlowWithTextValue   The type is <code>Boolean</code>
	 */
	public void setStyleFlowWithTextAttribute( Boolean styleFlowWithTextValue )
	{
		StyleFlowWithTextAttribute attr =  new StyleFlowWithTextAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( styleFlowWithTextValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleOverflowBehaviorAttribute</code> , See {@odf.attribute style:overflow-behavior}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleOverflowBehaviorAttribute()
	{
		StyleOverflowBehaviorAttribute attr = (StyleOverflowBehaviorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "overflow-behavior" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleOverflowBehaviorAttribute</code> , See {@odf.attribute style:overflow-behavior}
	 *
	 * @param styleOverflowBehaviorValue   The type is <code>String</code>
	 */
	public void setStyleOverflowBehaviorAttribute( String styleOverflowBehaviorValue )
	{
		StyleOverflowBehaviorAttribute attr =  new StyleOverflowBehaviorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleOverflowBehaviorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleMirrorAttribute</code> , See {@odf.attribute style:mirror}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleMirrorAttribute()
	{
		StyleMirrorAttribute attr = (StyleMirrorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "mirror" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleMirrorAttribute</code> , See {@odf.attribute style:mirror}
	 *
	 * @param styleMirrorValue   The type is <code>String</code>
	 */
	public void setStyleMirrorAttribute( String styleMirrorValue )
	{
		StyleMirrorAttribute attr =  new StyleMirrorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleMirrorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoClipAttribute</code> , See {@odf.attribute fo:clip}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoClipAttribute()
	{
		FoClipAttribute attr = (FoClipAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.FO), "clip" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>FoClipAttribute</code> , See {@odf.attribute fo:clip}
	 *
	 * @param foClipValue   The type is <code>String</code>
	 */
	public void setFoClipAttribute( String foClipValue )
	{
		FoClipAttribute attr =  new FoClipAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( foClipValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawWrapInfluenceOnPositionAttribute</code> , See {@odf.attribute draw:wrap-influence-on-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawWrapInfluenceOnPositionAttribute()
	{
		DrawWrapInfluenceOnPositionAttribute attr = (DrawWrapInfluenceOnPositionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "wrap-influence-on-position" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawWrapInfluenceOnPositionAttribute</code> , See {@odf.attribute draw:wrap-influence-on-position}
	 *
	 * @param drawWrapInfluenceOnPositionValue   The type is <code>String</code>
	 */
	public void setDrawWrapInfluenceOnPositionAttribute( String drawWrapInfluenceOnPositionValue )
	{
		DrawWrapInfluenceOnPositionAttribute attr =  new DrawWrapInfluenceOnPositionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawWrapInfluenceOnPositionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWritingModeAttribute()
	{
		StyleWritingModeAttribute attr = (StyleWritingModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "writing-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @param styleWritingModeValue   The type is <code>String</code>
	 */
	public void setStyleWritingModeAttribute( String styleWritingModeValue )
	{
		StyleWritingModeAttribute attr =  new StyleWritingModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleWritingModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFrameDisplayScrollbarAttribute</code> , See {@odf.attribute draw:frame-display-scrollbar}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFrameDisplayScrollbarAttribute()
	{
		DrawFrameDisplayScrollbarAttribute attr = (DrawFrameDisplayScrollbarAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "frame-display-scrollbar" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFrameDisplayScrollbarAttribute</code> , See {@odf.attribute draw:frame-display-scrollbar}
	 *
	 * @param drawFrameDisplayScrollbarValue   The type is <code>Boolean</code>
	 */
	public void setDrawFrameDisplayScrollbarAttribute( Boolean drawFrameDisplayScrollbarValue )
	{
		DrawFrameDisplayScrollbarAttribute attr =  new DrawFrameDisplayScrollbarAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFrameDisplayScrollbarValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFrameDisplayBorderAttribute</code> , See {@odf.attribute draw:frame-display-border}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFrameDisplayBorderAttribute()
	{
		DrawFrameDisplayBorderAttribute attr = (DrawFrameDisplayBorderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "frame-display-border" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFrameDisplayBorderAttribute</code> , See {@odf.attribute draw:frame-display-border}
	 *
	 * @param drawFrameDisplayBorderValue   The type is <code>Boolean</code>
	 */
	public void setDrawFrameDisplayBorderAttribute( Boolean drawFrameDisplayBorderValue )
	{
		DrawFrameDisplayBorderAttribute attr =  new DrawFrameDisplayBorderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFrameDisplayBorderValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFrameMarginHorizontalAttribute</code> , See {@odf.attribute draw:frame-margin-horizontal}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFrameMarginHorizontalAttribute()
	{
		DrawFrameMarginHorizontalAttribute attr = (DrawFrameMarginHorizontalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "frame-margin-horizontal" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFrameMarginHorizontalAttribute</code> , See {@odf.attribute draw:frame-margin-horizontal}
	 *
	 * @param drawFrameMarginHorizontalValue   The type is <code>String</code>
	 */
	public void setDrawFrameMarginHorizontalAttribute( String drawFrameMarginHorizontalValue )
	{
		DrawFrameMarginHorizontalAttribute attr =  new DrawFrameMarginHorizontalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFrameMarginHorizontalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFrameMarginVerticalAttribute</code> , See {@odf.attribute draw:frame-margin-vertical}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFrameMarginVerticalAttribute()
	{
		DrawFrameMarginVerticalAttribute attr = (DrawFrameMarginVerticalAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "frame-margin-vertical" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFrameMarginVerticalAttribute</code> , See {@odf.attribute draw:frame-margin-vertical}
	 *
	 * @param drawFrameMarginVerticalValue   The type is <code>String</code>
	 */
	public void setDrawFrameMarginVerticalAttribute( String drawFrameMarginVerticalValue )
	{
		DrawFrameMarginVerticalAttribute attr =  new DrawFrameMarginVerticalAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFrameMarginVerticalValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawVisibleAreaLeftAttribute</code> , See {@odf.attribute draw:visible-area-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawVisibleAreaLeftAttribute()
	{
		DrawVisibleAreaLeftAttribute attr = (DrawVisibleAreaLeftAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "visible-area-left" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawVisibleAreaLeftAttribute</code> , See {@odf.attribute draw:visible-area-left}
	 *
	 * @param drawVisibleAreaLeftValue   The type is <code>String</code>
	 */
	public void setDrawVisibleAreaLeftAttribute( String drawVisibleAreaLeftValue )
	{
		DrawVisibleAreaLeftAttribute attr =  new DrawVisibleAreaLeftAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawVisibleAreaLeftValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawVisibleAreaTopAttribute</code> , See {@odf.attribute draw:visible-area-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawVisibleAreaTopAttribute()
	{
		DrawVisibleAreaTopAttribute attr = (DrawVisibleAreaTopAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "visible-area-top" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawVisibleAreaTopAttribute</code> , See {@odf.attribute draw:visible-area-top}
	 *
	 * @param drawVisibleAreaTopValue   The type is <code>String</code>
	 */
	public void setDrawVisibleAreaTopAttribute( String drawVisibleAreaTopValue )
	{
		DrawVisibleAreaTopAttribute attr =  new DrawVisibleAreaTopAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawVisibleAreaTopValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawVisibleAreaWidthAttribute</code> , See {@odf.attribute draw:visible-area-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawVisibleAreaWidthAttribute()
	{
		DrawVisibleAreaWidthAttribute attr = (DrawVisibleAreaWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "visible-area-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawVisibleAreaWidthAttribute</code> , See {@odf.attribute draw:visible-area-width}
	 *
	 * @param drawVisibleAreaWidthValue   The type is <code>String</code>
	 */
	public void setDrawVisibleAreaWidthAttribute( String drawVisibleAreaWidthValue )
	{
		DrawVisibleAreaWidthAttribute attr =  new DrawVisibleAreaWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawVisibleAreaWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawVisibleAreaHeightAttribute</code> , See {@odf.attribute draw:visible-area-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawVisibleAreaHeightAttribute()
	{
		DrawVisibleAreaHeightAttribute attr = (DrawVisibleAreaHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "visible-area-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawVisibleAreaHeightAttribute</code> , See {@odf.attribute draw:visible-area-height}
	 *
	 * @param drawVisibleAreaHeightValue   The type is <code>String</code>
	 */
	public void setDrawVisibleAreaHeightAttribute( String drawVisibleAreaHeightValue )
	{
		DrawVisibleAreaHeightAttribute attr =  new DrawVisibleAreaHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawVisibleAreaHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawDrawAspectAttribute</code> , See {@odf.attribute draw:draw-aspect}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawDrawAspectAttribute()
	{
		DrawDrawAspectAttribute attr = (DrawDrawAspectAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "draw-aspect" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawDrawAspectAttribute</code> , See {@odf.attribute draw:draw-aspect}
	 *
	 * @param drawDrawAspectValue   The type is <code>String</code>
	 */
	public void setDrawDrawAspectAttribute( String drawDrawAspectValue )
	{
		DrawDrawAspectAttribute attr =  new DrawDrawAspectAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawDrawAspectValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawOleDrawAspectAttribute</code> , See {@odf.attribute draw:ole-draw-aspect}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDrawOleDrawAspectAttribute()
	{
		DrawOleDrawAspectAttribute attr = (DrawOleDrawAspectAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "ole-draw-aspect" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawOleDrawAspectAttribute</code> , See {@odf.attribute draw:ole-draw-aspect}
	 *
	 * @param drawOleDrawAspectValue   The type is <code>Integer</code>
	 */
	public void setDrawOleDrawAspectAttribute( Integer drawOleDrawAspectValue )
	{
		DrawOleDrawAspectAttribute attr =  new DrawOleDrawAspectAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( drawOleDrawAspectValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillAttribute</code> , See {@odf.attribute draw:fill}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillAttribute()
	{
		DrawFillAttribute attr = (DrawFillAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillAttribute</code> , See {@odf.attribute draw:fill}
	 *
	 * @param drawFillValue   The type is <code>String</code>
	 */
	public void setDrawFillAttribute( String drawFillValue )
	{
		DrawFillAttribute attr =  new DrawFillAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillColorAttribute</code> , See {@odf.attribute draw:fill-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillColorAttribute()
	{
		DrawFillColorAttribute attr = (DrawFillColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillColorAttribute</code> , See {@odf.attribute draw:fill-color}
	 *
	 * @param drawFillColorValue   The type is <code>String</code>
	 */
	public void setDrawFillColorAttribute( String drawFillColorValue )
	{
		DrawFillColorAttribute attr =  new DrawFillColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawSecondaryFillColorAttribute</code> , See {@odf.attribute draw:secondary-fill-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawSecondaryFillColorAttribute()
	{
		DrawSecondaryFillColorAttribute attr = (DrawSecondaryFillColorAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "secondary-fill-color" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawSecondaryFillColorAttribute</code> , See {@odf.attribute draw:secondary-fill-color}
	 *
	 * @param drawSecondaryFillColorValue   The type is <code>String</code>
	 */
	public void setDrawSecondaryFillColorAttribute( String drawSecondaryFillColorValue )
	{
		DrawSecondaryFillColorAttribute attr =  new DrawSecondaryFillColorAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawSecondaryFillColorValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillGradientNameAttribute</code> , See {@odf.attribute draw:fill-gradient-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillGradientNameAttribute()
	{
		DrawFillGradientNameAttribute attr = (DrawFillGradientNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-gradient-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillGradientNameAttribute</code> , See {@odf.attribute draw:fill-gradient-name}
	 *
	 * @param drawFillGradientNameValue   The type is <code>String</code>
	 */
	public void setDrawFillGradientNameAttribute( String drawFillGradientNameValue )
	{
		DrawFillGradientNameAttribute attr =  new DrawFillGradientNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillGradientNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawGradientStepCountAttribute</code> , See {@odf.attribute draw:gradient-step-count}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getDrawGradientStepCountAttribute()
	{
		DrawGradientStepCountAttribute attr = (DrawGradientStepCountAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "gradient-step-count" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawGradientStepCountAttribute</code> , See {@odf.attribute draw:gradient-step-count}
	 *
	 * @param drawGradientStepCountValue   The type is <code>Integer</code>
	 */
	public void setDrawGradientStepCountAttribute( Integer drawGradientStepCountValue )
	{
		DrawGradientStepCountAttribute attr =  new DrawGradientStepCountAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( drawGradientStepCountValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillHatchNameAttribute</code> , See {@odf.attribute draw:fill-hatch-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillHatchNameAttribute()
	{
		DrawFillHatchNameAttribute attr = (DrawFillHatchNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-hatch-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillHatchNameAttribute</code> , See {@odf.attribute draw:fill-hatch-name}
	 *
	 * @param drawFillHatchNameValue   The type is <code>String</code>
	 */
	public void setDrawFillHatchNameAttribute( String drawFillHatchNameValue )
	{
		DrawFillHatchNameAttribute attr =  new DrawFillHatchNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillHatchNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillHatchSolidAttribute</code> , See {@odf.attribute draw:fill-hatch-solid}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getDrawFillHatchSolidAttribute()
	{
		DrawFillHatchSolidAttribute attr = (DrawFillHatchSolidAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-hatch-solid" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillHatchSolidAttribute</code> , See {@odf.attribute draw:fill-hatch-solid}
	 *
	 * @param drawFillHatchSolidValue   The type is <code>Boolean</code>
	 */
	public void setDrawFillHatchSolidAttribute( Boolean drawFillHatchSolidValue )
	{
		DrawFillHatchSolidAttribute attr =  new DrawFillHatchSolidAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( drawFillHatchSolidValue.booleanValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageNameAttribute</code> , See {@odf.attribute draw:fill-image-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageNameAttribute()
	{
		DrawFillImageNameAttribute attr = (DrawFillImageNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageNameAttribute</code> , See {@odf.attribute draw:fill-image-name}
	 *
	 * @param drawFillImageNameValue   The type is <code>String</code>
	 */
	public void setDrawFillImageNameAttribute( String drawFillImageNameValue )
	{
		DrawFillImageNameAttribute attr =  new DrawFillImageNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRepeatAttribute</code> , See {@odf.attribute style:repeat}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRepeatAttribute()
	{
		StyleRepeatAttribute attr = (StyleRepeatAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.STYLE), "repeat" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRepeatAttribute</code> , See {@odf.attribute style:repeat}
	 *
	 * @param styleRepeatValue   The type is <code>String</code>
	 */
	public void setStyleRepeatAttribute( String styleRepeatValue )
	{
		StyleRepeatAttribute attr =  new StyleRepeatAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( styleRepeatValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageWidthAttribute</code> , See {@odf.attribute draw:fill-image-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageWidthAttribute()
	{
		DrawFillImageWidthAttribute attr = (DrawFillImageWidthAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-width" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageWidthAttribute</code> , See {@odf.attribute draw:fill-image-width}
	 *
	 * @param drawFillImageWidthValue   The type is <code>String</code>
	 */
	public void setDrawFillImageWidthAttribute( String drawFillImageWidthValue )
	{
		DrawFillImageWidthAttribute attr =  new DrawFillImageWidthAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageWidthValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageHeightAttribute</code> , See {@odf.attribute draw:fill-image-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageHeightAttribute()
	{
		DrawFillImageHeightAttribute attr = (DrawFillImageHeightAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-height" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageHeightAttribute</code> , See {@odf.attribute draw:fill-image-height}
	 *
	 * @param drawFillImageHeightValue   The type is <code>String</code>
	 */
	public void setDrawFillImageHeightAttribute( String drawFillImageHeightValue )
	{
		DrawFillImageHeightAttribute attr =  new DrawFillImageHeightAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageHeightValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointXAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-x}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointXAttribute()
	{
		DrawFillImageRefPointXAttribute attr = (DrawFillImageRefPointXAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point-x" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointXAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-x}
	 *
	 * @param drawFillImageRefPointXValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointXAttribute( String drawFillImageRefPointXValue )
	{
		DrawFillImageRefPointXAttribute attr =  new DrawFillImageRefPointXAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointXValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointYAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-y}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointYAttribute()
	{
		DrawFillImageRefPointYAttribute attr = (DrawFillImageRefPointYAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point-y" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointYAttribute</code> , See {@odf.attribute draw:fill-image-ref-point-y}
	 *
	 * @param drawFillImageRefPointYValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointYAttribute( String drawFillImageRefPointYValue )
	{
		DrawFillImageRefPointYAttribute attr =  new DrawFillImageRefPointYAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointYValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawFillImageRefPointAttribute</code> , See {@odf.attribute draw:fill-image-ref-point}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawFillImageRefPointAttribute()
	{
		DrawFillImageRefPointAttribute attr = (DrawFillImageRefPointAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "fill-image-ref-point" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawFillImageRefPointAttribute</code> , See {@odf.attribute draw:fill-image-ref-point}
	 *
	 * @param drawFillImageRefPointValue   The type is <code>String</code>
	 */
	public void setDrawFillImageRefPointAttribute( String drawFillImageRefPointValue )
	{
		DrawFillImageRefPointAttribute attr =  new DrawFillImageRefPointAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawFillImageRefPointValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawTileRepeatOffsetAttribute</code> , See {@odf.attribute draw:tile-repeat-offset}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawTileRepeatOffsetAttribute()
	{
		DrawTileRepeatOffsetAttribute attr = (DrawTileRepeatOffsetAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "tile-repeat-offset" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawTileRepeatOffsetAttribute</code> , See {@odf.attribute draw:tile-repeat-offset}
	 *
	 * @param drawTileRepeatOffsetValue   The type is <code>String</code>
	 */
	public void setDrawTileRepeatOffsetAttribute( String drawTileRepeatOffsetValue )
	{
		DrawTileRepeatOffsetAttribute attr =  new DrawTileRepeatOffsetAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawTileRepeatOffsetValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawOpacityAttribute</code> , See {@odf.attribute draw:opacity}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawOpacityAttribute()
	{
		DrawOpacityAttribute attr = (DrawOpacityAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "opacity" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawOpacityAttribute</code> , See {@odf.attribute draw:opacity}
	 *
	 * @param drawOpacityValue   The type is <code>String</code>
	 */
	public void setDrawOpacityAttribute( String drawOpacityValue )
	{
		DrawOpacityAttribute attr =  new DrawOpacityAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawOpacityValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DrawOpacityNameAttribute</code> , See {@odf.attribute draw:opacity-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDrawOpacityNameAttribute()
	{
		DrawOpacityNameAttribute attr = (DrawOpacityNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DRAW), "opacity-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DrawOpacityNameAttribute</code> , See {@odf.attribute draw:opacity-name}
	 *
	 * @param drawOpacityNameValue   The type is <code>String</code>
	 */
	public void setDrawOpacityNameAttribute( String drawOpacityNameValue )
	{
		DrawOpacityNameAttribute attr =  new DrawOpacityNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( drawOpacityNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>SvgFillRuleAttribute</code> , See {@odf.attribute svg:fill-rule}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getSvgFillRuleAttribute()
	{
		SvgFillRuleAttribute attr = (SvgFillRuleAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.SVG), "fill-rule" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>SvgFillRuleAttribute</code> , See {@odf.attribute svg:fill-rule}
	 *
	 * @param svgFillRuleValue   The type is <code>String</code>
	 */
	public void setSvgFillRuleAttribute( String svgFillRuleValue )
	{
		SvgFillRuleAttribute attr =  new SvgFillRuleAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( svgFillRuleValue );
	}

	/**
	 * Create child element {@odf.element text:list-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:list-style}
	 * DifferentQName 
	 */
    
	public TextListStyleElement newTextListStyleElement(String styleNameAttributeValue)
	{
		TextListStyleElement  textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
		textListStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textListStyle);
		return  textListStyle;      
	}
    
	/**
	 * Create child element {@odf.element office:binary-data}.
	 *
	 * @return   return  the element {@odf.element office:binary-data}
	 * DifferentQName 
	 */
	public OfficeBinaryDataElement newOfficeBinaryDataElement()
	{
		OfficeBinaryDataElement  officeBinaryData = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeBinaryDataElement.class);
		this.appendChild( officeBinaryData);
		return  officeBinaryData;
	}                   
               
	/**
	 * Create child element {@odf.element style:column-sep}.
	 *
     * @param styleWidthAttributeValue  the <code>String</code> value of <code>StyleWidthAttribute</code>, see {@odf.attribute  style:width} at specification
	 * @return   return  the element {@odf.element style:column-sep}
	 * DifferentQName 
	 */
    
	public StyleColumnSepElement newStyleColumnSepElement(String styleWidthAttributeValue)
	{
		StyleColumnSepElement  styleColumnSep = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleColumnSepElement.class);
		styleColumnSep.setStyleWidthAttribute( styleWidthAttributeValue );
		this.appendChild( styleColumnSep);
		return  styleColumnSep;      
	}
    
	/**
	 * Create child element {@odf.element style:column}.
	 *
     * @param styleRelWidthAttributeValue  the <code>String</code> value of <code>StyleRelWidthAttribute</code>, see {@odf.attribute  style:rel-width} at specification
	 * @return   return  the element {@odf.element style:column}
	 * DifferentQName 
	 */
    
	public StyleColumnElement newStyleColumnElement(String styleRelWidthAttributeValue)
	{
		StyleColumnElement  styleColumn = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleColumnElement.class);
		styleColumn.setStyleRelWidthAttribute( styleRelWidthAttributeValue );
		this.appendChild( styleColumn);
		return  styleColumn;      
	}
    
}
