/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableSortModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableDataFieldAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableOrderAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element table:data-pilot-sort-info}.
 *
 */
public class TableDataPilotSortInfoElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "data-pilot-sort-info" );


	/**
	 * Create the instance of <code>TableDataPilotSortInfoElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableDataPilotSortInfoElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:data-pilot-sort-info}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TableDataPilotSortInfoElement}
	 *
     * @param tableSortModeAttributeValue  The mandatory attribute {@odf.attribute  table:sort-mode}"
     * @param tableDataFieldAttributeValue  The mandatory attribute {@odf.attribute  table:data-field}"
     * @param tableOrderAttributeValue  The mandatory attribute {@odf.attribute  table:order}"
     *
	 */
	public void init(String tableSortModeAttributeValue, String tableDataFieldAttributeValue, String tableOrderAttributeValue)
	{
		setTableSortModeAttribute( tableSortModeAttributeValue );
		setTableDataFieldAttribute( tableDataFieldAttributeValue );
		setTableOrderAttribute( tableOrderAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableSortModeAttribute</code> , See {@odf.attribute table:sort-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableSortModeAttribute()
	{
		TableSortModeAttribute attr = (TableSortModeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "sort-mode" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableSortModeAttribute</code> , See {@odf.attribute table:sort-mode}
	 *
	 * @param tableSortModeValue   The type is <code>String</code>
	 */
	public void setTableSortModeAttribute( String tableSortModeValue )
	{
		TableSortModeAttribute attr =  new TableSortModeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableSortModeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableDataFieldAttribute</code> , See {@odf.attribute table:data-field}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableDataFieldAttribute()
	{
		TableDataFieldAttribute attr = (TableDataFieldAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "data-field" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableDataFieldAttribute</code> , See {@odf.attribute table:data-field}
	 *
	 * @param tableDataFieldValue   The type is <code>String</code>
	 */
	public void setTableDataFieldAttribute( String tableDataFieldValue )
	{
		TableDataFieldAttribute attr =  new TableDataFieldAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableDataFieldValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableOrderAttribute</code> , See {@odf.attribute table:order}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableOrderAttribute()
	{
		TableOrderAttribute attr = (TableOrderAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "order" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableOrderAttribute</code> , See {@odf.attribute table:order}
	 *
	 * @param tableOrderValue   The type is <code>String</code>
	 */
	public void setTableOrderAttribute( String tableOrderValue )
	{
		TableOrderAttribute attr =  new TableOrderAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableOrderValue );
	}

}
