/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;


/**
 * DOM implementation of OpenDocument element  {@odf.element table:filter-or}.
 *
 */
public class TableFilterOrElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "filter-or" );


	/**
	 * Create the instance of <code>TableFilterOrElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableFilterOrElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:filter-or}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}


	/**
	 * Create child element {@odf.element table:filter-and}.
	 *
	 * @return   return  the element {@odf.element table:filter-and}
	 * DifferentQName 
	 */
	public TableFilterAndElement newTableFilterAndElement()
	{
		TableFilterAndElement  tableFilterAnd = ((OdfFileDom)this.ownerDocument).newOdfElement(TableFilterAndElement.class);
		this.appendChild( tableFilterAnd);
		return  tableFilterAnd;
	}                   
               
	/**
	 * Create child element {@odf.element table:filter-condition}.
	 *
     * @param tableFieldNumberAttributeValue  the <code>int</code> value of <code>TableFieldNumberAttribute</code>, see {@odf.attribute  table:field-number} at specification
	 * @param tableOperatorAttributeValue  the <code>String</code> value of <code>TableOperatorAttribute</code>, see {@odf.attribute  table:operator} at specification
	 * @param tableValueAttributeValue  the <code>String</code> value of <code>TableValueAttribute</code>, see {@odf.attribute  table:value} at specification
	 * @return   return  the element {@odf.element table:filter-condition}
	 * DifferentQName 
	 */
    
	public TableFilterConditionElement newTableFilterConditionElement(int tableFieldNumberAttributeValue, String tableOperatorAttributeValue, String tableValueAttributeValue)
	{
		TableFilterConditionElement  tableFilterCondition = ((OdfFileDom)this.ownerDocument).newOdfElement(TableFilterConditionElement.class);
		tableFilterCondition.setTableFieldNumberAttribute( Integer.valueOf(tableFieldNumberAttributeValue) );
		tableFilterCondition.setTableOperatorAttribute( tableOperatorAttributeValue );
		tableFilterCondition.setTableValueAttribute( tableValueAttributeValue );
		this.appendChild( tableFilterCondition);
		return  tableFilterCondition;      
	}
    
}
