/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableColumnAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableRowAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableTableAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStartColumnAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStartRowAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStartTableAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableEndColumnAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableEndRowAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableEndTableAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element table:target-range-address}.
 *
 */
public class TableTargetRangeAddressElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "target-range-address" );


	/**
	 * Create the instance of <code>TableTargetRangeAddressElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableTargetRangeAddressElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:target-range-address}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TableTargetRangeAddressElement}
	 *
     * @param tableColumnAttributeValue  The mandatory attribute {@odf.attribute  table:column}"
     * @param tableRowAttributeValue  The mandatory attribute {@odf.attribute  table:row}"
     * @param tableTableAttributeValue  The mandatory attribute {@odf.attribute  table:table}"
     * @param tableStartColumnAttributeValue  The mandatory attribute {@odf.attribute  table:start-column}"
     * @param tableStartRowAttributeValue  The mandatory attribute {@odf.attribute  table:start-row}"
     * @param tableStartTableAttributeValue  The mandatory attribute {@odf.attribute  table:start-table}"
     * @param tableEndColumnAttributeValue  The mandatory attribute {@odf.attribute  table:end-column}"
     * @param tableEndRowAttributeValue  The mandatory attribute {@odf.attribute  table:end-row}"
     * @param tableEndTableAttributeValue  The mandatory attribute {@odf.attribute  table:end-table}"
     *
	 */
	public void init(int tableColumnAttributeValue, int tableRowAttributeValue, int tableTableAttributeValue, int tableStartColumnAttributeValue, int tableStartRowAttributeValue, int tableStartTableAttributeValue, int tableEndColumnAttributeValue, int tableEndRowAttributeValue, int tableEndTableAttributeValue)
	{
		setTableColumnAttribute( Integer.valueOf(tableColumnAttributeValue) );
		setTableRowAttribute( Integer.valueOf(tableRowAttributeValue) );
		setTableTableAttribute( Integer.valueOf(tableTableAttributeValue) );
		setTableStartColumnAttribute( Integer.valueOf(tableStartColumnAttributeValue) );
		setTableStartRowAttribute( Integer.valueOf(tableStartRowAttributeValue) );
		setTableStartTableAttribute( Integer.valueOf(tableStartTableAttributeValue) );
		setTableEndColumnAttribute( Integer.valueOf(tableEndColumnAttributeValue) );
		setTableEndRowAttribute( Integer.valueOf(tableEndRowAttributeValue) );
		setTableEndTableAttribute( Integer.valueOf(tableEndTableAttributeValue) );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableColumnAttribute</code> , See {@odf.attribute table:column}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableColumnAttribute()
	{
		TableColumnAttribute attr = (TableColumnAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "column" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableColumnAttribute</code> , See {@odf.attribute table:column}
	 *
	 * @param tableColumnValue   The type is <code>Integer</code>
	 */
	public void setTableColumnAttribute( Integer tableColumnValue )
	{
		TableColumnAttribute attr =  new TableColumnAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableColumnValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableRowAttribute</code> , See {@odf.attribute table:row}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableRowAttribute()
	{
		TableRowAttribute attr = (TableRowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "row" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableRowAttribute</code> , See {@odf.attribute table:row}
	 *
	 * @param tableRowValue   The type is <code>Integer</code>
	 */
	public void setTableRowAttribute( Integer tableRowValue )
	{
		TableRowAttribute attr =  new TableRowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableRowValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableTableAttribute</code> , See {@odf.attribute table:table}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableTableAttribute()
	{
		TableTableAttribute attr = (TableTableAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "table" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableTableAttribute</code> , See {@odf.attribute table:table}
	 *
	 * @param tableTableValue   The type is <code>Integer</code>
	 */
	public void setTableTableAttribute( Integer tableTableValue )
	{
		TableTableAttribute attr =  new TableTableAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableTableValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableStartColumnAttribute</code> , See {@odf.attribute table:start-column}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableStartColumnAttribute()
	{
		TableStartColumnAttribute attr = (TableStartColumnAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "start-column" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableStartColumnAttribute</code> , See {@odf.attribute table:start-column}
	 *
	 * @param tableStartColumnValue   The type is <code>Integer</code>
	 */
	public void setTableStartColumnAttribute( Integer tableStartColumnValue )
	{
		TableStartColumnAttribute attr =  new TableStartColumnAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableStartColumnValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableStartRowAttribute</code> , See {@odf.attribute table:start-row}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableStartRowAttribute()
	{
		TableStartRowAttribute attr = (TableStartRowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "start-row" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableStartRowAttribute</code> , See {@odf.attribute table:start-row}
	 *
	 * @param tableStartRowValue   The type is <code>Integer</code>
	 */
	public void setTableStartRowAttribute( Integer tableStartRowValue )
	{
		TableStartRowAttribute attr =  new TableStartRowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableStartRowValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableStartTableAttribute</code> , See {@odf.attribute table:start-table}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableStartTableAttribute()
	{
		TableStartTableAttribute attr = (TableStartTableAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "start-table" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableStartTableAttribute</code> , See {@odf.attribute table:start-table}
	 *
	 * @param tableStartTableValue   The type is <code>Integer</code>
	 */
	public void setTableStartTableAttribute( Integer tableStartTableValue )
	{
		TableStartTableAttribute attr =  new TableStartTableAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableStartTableValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableEndColumnAttribute</code> , See {@odf.attribute table:end-column}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableEndColumnAttribute()
	{
		TableEndColumnAttribute attr = (TableEndColumnAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "end-column" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableEndColumnAttribute</code> , See {@odf.attribute table:end-column}
	 *
	 * @param tableEndColumnValue   The type is <code>Integer</code>
	 */
	public void setTableEndColumnAttribute( Integer tableEndColumnValue )
	{
		TableEndColumnAttribute attr =  new TableEndColumnAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableEndColumnValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableEndRowAttribute</code> , See {@odf.attribute table:end-row}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableEndRowAttribute()
	{
		TableEndRowAttribute attr = (TableEndRowAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "end-row" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableEndRowAttribute</code> , See {@odf.attribute table:end-row}
	 *
	 * @param tableEndRowValue   The type is <code>Integer</code>
	 */
	public void setTableEndRowAttribute( Integer tableEndRowValue )
	{
		TableEndRowAttribute attr =  new TableEndRowAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableEndRowValue.intValue() );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableEndTableAttribute</code> , See {@odf.attribute table:end-table}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableEndTableAttribute()
	{
		TableEndTableAttribute attr = (TableEndTableAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "end-table" ) ;
		if( attr != null ){
			return Integer.valueOf( attr.intValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableEndTableAttribute</code> , See {@odf.attribute table:end-table}
	 *
	 * @param tableEndTableValue   The type is <code>Integer</code>
	 */
	public void setTableEndTableAttribute( Integer tableEndTableValue )
	{
		TableEndTableAttribute attr =  new TableEndTableAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setIntValue( tableEndTableValue.intValue() );
	}

}
