/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableTrackChangesAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element table:tracked-changes}.
 *
 */
public class TableTrackedChangesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "tracked-changes" );


	/**
	 * Create the instance of <code>TableTrackedChangesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableTrackedChangesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:tracked-changes}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}



	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableTrackChangesAttribute</code> , See {@odf.attribute table:track-changes}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableTrackChangesAttribute()
	{
		TableTrackChangesAttribute attr = (TableTrackChangesAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "track-changes" ) ;
		if( attr != null ){
			return Boolean.valueOf( attr.booleanValue() );
		}
		return Boolean.valueOf( TableTrackChangesAttribute.DEFAULT_VALUE );
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableTrackChangesAttribute</code> , See {@odf.attribute table:track-changes}
	 *
	 * @param tableTrackChangesValue   The type is <code>Boolean</code>
	 */
	public void setTableTrackChangesAttribute( Boolean tableTrackChangesValue )
	{
		TableTrackChangesAttribute attr =  new TableTrackChangesAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setBooleanValue( tableTrackChangesValue.booleanValue() );
	}

	/**
	 * Create child element {@odf.element table:cell-content-change}.
	 *
     * @param tableIdAttributeValue  the <code>String</code> value of <code>TableIdAttribute</code>, see {@odf.attribute  table:id} at specification
	 * @return   return  the element {@odf.element table:cell-content-change}
	 * DifferentQName 
	 */
    
	public TableCellContentChangeElement newTableCellContentChangeElement(String tableIdAttributeValue)
	{
		TableCellContentChangeElement  tableCellContentChange = ((OdfFileDom)this.ownerDocument).newOdfElement(TableCellContentChangeElement.class);
		tableCellContentChange.setTableIdAttribute( tableIdAttributeValue );
		this.appendChild( tableCellContentChange);
		return  tableCellContentChange;      
	}
    
	/**
	 * Create child element {@odf.element table:insertion}.
	 *
     * @param tableIdAttributeValue  the <code>String</code> value of <code>TableIdAttribute</code>, see {@odf.attribute  table:id} at specification
	 * @param tablePositionAttributeValue  the <code>int</code> value of <code>TablePositionAttribute</code>, see {@odf.attribute  table:position} at specification
	 * @param tableTypeAttributeValue  the <code>String</code> value of <code>TableTypeAttribute</code>, see {@odf.attribute  table:type} at specification
	 * @return   return  the element {@odf.element table:insertion}
	 * DifferentQName 
	 */
    
	public TableInsertionElement newTableInsertionElement(String tableIdAttributeValue, int tablePositionAttributeValue, String tableTypeAttributeValue)
	{
		TableInsertionElement  tableInsertion = ((OdfFileDom)this.ownerDocument).newOdfElement(TableInsertionElement.class);
		tableInsertion.setTableIdAttribute( tableIdAttributeValue );
		tableInsertion.setTablePositionAttribute( Integer.valueOf(tablePositionAttributeValue) );
		tableInsertion.setTableTypeAttribute( tableTypeAttributeValue );
		this.appendChild( tableInsertion);
		return  tableInsertion;      
	}
    
	/**
	 * Create child element {@odf.element table:deletion}.
	 *
     * @param tableIdAttributeValue  the <code>String</code> value of <code>TableIdAttribute</code>, see {@odf.attribute  table:id} at specification
	 * @param tablePositionAttributeValue  the <code>int</code> value of <code>TablePositionAttribute</code>, see {@odf.attribute  table:position} at specification
	 * @param tableTypeAttributeValue  the <code>String</code> value of <code>TableTypeAttribute</code>, see {@odf.attribute  table:type} at specification
	 * @return   return  the element {@odf.element table:deletion}
	 * DifferentQName 
	 */
    
	public TableDeletionElement newTableDeletionElement(String tableIdAttributeValue, int tablePositionAttributeValue, String tableTypeAttributeValue)
	{
		TableDeletionElement  tableDeletion = ((OdfFileDom)this.ownerDocument).newOdfElement(TableDeletionElement.class);
		tableDeletion.setTableIdAttribute( tableIdAttributeValue );
		tableDeletion.setTablePositionAttribute( Integer.valueOf(tablePositionAttributeValue) );
		tableDeletion.setTableTypeAttribute( tableTypeAttributeValue );
		this.appendChild( tableDeletion);
		return  tableDeletion;      
	}
    
	/**
	 * Create child element {@odf.element table:movement}.
	 *
     * @param tableIdAttributeValue  the <code>String</code> value of <code>TableIdAttribute</code>, see {@odf.attribute  table:id} at specification
	 * @return   return  the element {@odf.element table:movement}
	 * DifferentQName 
	 */
    
	public TableMovementElement newTableMovementElement(String tableIdAttributeValue)
	{
		TableMovementElement  tableMovement = ((OdfFileDom)this.ownerDocument).newOdfElement(TableMovementElement.class);
		tableMovement.setTableIdAttribute( tableIdAttributeValue );
		this.appendChild( tableMovement);
		return  tableMovement;      
	}
    
}
