/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFSharpCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalProjectFileFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected boolean netCoreProjectFileFlag = false;
    protected String modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.PascalCase.name();
    protected String licenseUrl = "http://localhost";
    protected String licenseName = "NoLicense";
    protected String packageVersion = "1.0.0";
    protected String packageName = "OpenAPI";
    protected String packageTitle = "OpenAPI Library";
    protected String packageProductName = "OpenAPILibrary";
    protected String packageDescription = "A library generated from a OpenAPI doc";
    protected String packageCompany = "OpenAPI";
    protected String packageCopyright = "No Copyright";
    protected String packageAuthors = "OpenAPI";
    protected String interfacePrefix = "I";
    protected String projectFolder = this.packageName;
    protected String sourceFolder = this.projectFolder + File.separator + "src";
    protected String testFolder = this.projectFolder + ".Tests";
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected boolean supportNullable = Boolean.TRUE;
    protected Set<String> nullableType = new HashSet<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFSharpCodegen.class);

    public AbstractFSharpCodegen() {
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.importMapping.put("IDictionary", "System.Collections.Generic");
        this.outputFolder = this.getName();
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("list", "seq"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary"));
        this.reservedWords.addAll(Arrays.asList("localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "and", "as", "async", "await", "assert", "base", "begin", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "done", "double", "downcast", "downto", "dynamic", "elif", "else", "end", "enum", "event", "exception", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "fun", "function", "if", "in", "inherit", "inline", "int", "interface", "internal", "is", "lazy", "let", "let!", "lock", "match", "match!", "member", "module", "mutable", "namespace", "new", "not", "null", "of", "open", "option", "or", "override", "params", "private", "public", "raise", "rec", "return", "return!", "sealed", "select", "static", "string", "struct", "then", "to", "true", "try", "type", "upcast", "use", "use!", "val", "void", "volatile", "when", "while", "with", "yield", "yield!"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool", "char", "decimal", "int", "int16", "int64", "nativeint", "unativeint", "uint16", "uint32", "uint64", "float", "byte[]", "ICollection", "Collection", "list", "dict", "seq", "Dictionary", "List", "DateTime", "DataTimeOffset", "Double", "Int32", "Int64", "float", "float32", "single", "double", "System.IO.Stream", "obj"));
        this.instantiationTypes.put("array", "list");
        this.instantiationTypes.put("list", "list");
        this.instantiationTypes.put("map", "IDictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("list", "list");
        this.typeMapping.put("map", "IDictionary");
        this.typeMapping.put("object", "obj");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.nullableType = new HashSet<String>(Arrays.asList("decimal", "bool", "int", "float", "long", "double", "string", "Guid", "apiKey"));
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.typeMapping.put("array", "seq");
            this.typeMapping.put("list", "seq");
            this.instantiationTypes.put("array", "seq");
            this.instantiationTypes.put("list", "seq");
        }
    }

    public void setNetCoreProjectFileFlag(boolean flag) {
        this.netCoreProjectFileFlag = flag;
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        if (flag) {
            this.typeMapping.put("DateTime", "DateTimeOffset?");
        } else {
            this.typeMapping.put("DateTime", "DateTime?");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("packageAuthors")) {
            this.setPackageAuthors((String)this.additionalProperties.get("packageAuthors"));
        } else {
            this.additionalProperties.put("packageAuthors", this.packageAuthors);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(this.convertPropertyToBooleanAndWriteBack("useDateTimeOffset"));
        } else {
            this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        this.additionalProperties.put("interfacePrefix", this.interfacePrefix);
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.name.equalsIgnoreCase(cm.name)) continue;
                var.name = "_" + var.name;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> processed = super.postProcessAllModels(objs);
        this.postProcessEnumRefs(processed);
        return this.postProcessDependencyOrders(processed);
    }

    public Map<String, Object> postProcessDependencyOrders(Map<String, Object> objs) {
        HashMap<String, Set<String>> dependencies = new HashMap<String, Set<String>>();
        ArrayList<String> classNames = new ArrayList<String>();
        for (String k : objs.keySet()) {
            CodegenModel model = ModelUtils.getModelByName(k, objs);
            if (model == null || model.classname == null) {
                throw new RuntimeException("Null model encountered");
            }
            dependencies.put(model.classname, model.imports);
            classNames.add(model.classname);
        }
        Object[] sortedKeys = classNames.toArray();
        block1: for (int i1 = 0; i1 < sortedKeys.length; ++i1) {
            String k1 = sortedKeys[i1].toString();
            for (int i2 = i1 + 1; i2 < sortedKeys.length; ++i2) {
                String k2 = sortedKeys[i2].toString();
                if (!((Set)dependencies.get(k2)).contains(k1)) continue;
                sortedKeys[i2] = k1;
                sortedKeys[i1] = k2;
                i1 = -1;
                continue block1;
            }
        }
        LinkedHashMap<String, Object> sorted = new LinkedHashMap<String, Object>();
        for (int i = sortedKeys.length - 1; i >= 0; --i) {
            Object k = sortedKeys[i];
            sorted.put(k.toString(), objs.get(k));
        }
        return sorted;
    }

    private void postProcessEnumRefs(Map<String, Object> models) {
        HashMap<String, CodegenModel> enumRefs = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            CodegenModel model = ModelUtils.getModelByName(entry.getKey(), models);
            if (!model.isEnum) continue;
            enumRefs.put(entry.getKey(), model);
        }
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String openAPIName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName(openAPIName, models);
            if (model != null) {
                for (CodegenProperty var : model.allVars) {
                    if (!enumRefs.containsKey(var.dataType)) continue;
                    CodegenModel refModel = (CodegenModel)enumRefs.get(var.dataType);
                    var.allowableValues = refModel.allowableValues;
                    var.isEnum = true;
                    var.isPrimitiveType = true;
                }
                if (!model.isEnum) continue;
                Boolean isString = false;
                Boolean isInteger = false;
                Boolean isLong = false;
                Boolean isByte = false;
                if (model.dataType.startsWith("byte")) {
                    isByte = true;
                    model.vendorExtensions.put("x-enum-byte", true);
                } else if (model.dataType.startsWith("int32")) {
                    isInteger = true;
                    model.vendorExtensions.put("x-enum-integer", true);
                } else if (model.dataType.startsWith("int64")) {
                    isLong = true;
                    model.vendorExtensions.put("x-enum-long", true);
                } else {
                    isString = true;
                    model.vendorExtensions.put("x-enum-string", true);
                }
                ArrayList enumVars = (ArrayList)model.allowableValues.get("enumVars");
                ArrayList newEnumVars = new ArrayList();
                for (Map enumVar : enumVars) {
                    HashMap<String, Boolean> mixedVars = new HashMap<String, Boolean>();
                    mixedVars.putAll(enumVar);
                    mixedVars.put("isString", isString);
                    mixedVars.put("isLong", isLong);
                    mixedVars.put("isInteger", isInteger);
                    mixedVars.put("isByte", isByte);
                    newEnumVars.add(mixedVars);
                }
                if (newEnumVars.isEmpty()) continue;
                model.allowableValues.put("enumVars", newEnumVars);
                continue;
            }
            LOGGER.warn("Expected to retrieve model %s by name, but no model was found. Check your -Dmodels inclusions.", (Object)openAPIName);
        }
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        if (var.vendorExtensions == null) {
            var.vendorExtensions = new HashMap<String, Object>();
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum) {
            if ("byte".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-enum-byte", true);
                var.isString = false;
                var.isLong = false;
                var.isInteger = false;
            } else if ("int32".equals(var.dataFormat)) {
                var.isInteger = true;
                var.isString = false;
                var.isLong = false;
            } else if ("int64".equals(var.dataFormat)) {
                var.isLong = true;
                var.isString = false;
                var.isInteger = false;
            } else {
                var.isString = true;
                var.isInteger = false;
                var.isLong = false;
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.returnType != null) {
                    int n = operation.returnType.lastIndexOf(".");
                    String typeMapping = n > 0 ? operation.returnType.substring(n) : operation.returnType;
                    if (this.collectionTypes.contains(typeMapping)) {
                        int genericStart;
                        operation.isListContainer = true;
                        operation.returnContainer = operation.returnType;
                        if (this.returnICollection && (typeMapping.startsWith("List") || typeMapping.startsWith("Collection")) && (genericStart = typeMapping.indexOf("<")) > 0) {
                            operation.returnType = "ICollection" + typeMapping.substring(genericStart);
                        }
                    } else {
                        operation.returnContainer = operation.returnType;
                        operation.isMapContainer = this.mapTypes.contains(typeMapping);
                    }
                }
                if (operation.examples != null) {
                    for (Map map : operation.examples) {
                        for (Map.Entry entry : map.entrySet()) {
                            String val = ((String)entry.getValue()).replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                            entry.setValue(val);
                        }
                    }
                }
                if (!this.isSupportNullable()) {
                    for (CodegenParameter codegenParameter : operation.allParams) {
                        CodegenModel model = null;
                        for (Object modelHashMap : allModels) {
                            CodegenModel codegenModel = (CodegenModel)((HashMap)modelHashMap).get("model");
                            if (!codegenModel.getClassname().equals(codegenParameter.dataType)) continue;
                            model = codegenModel;
                            break;
                        }
                        if (model == null) {
                            codegenParameter.isNullable = true;
                            continue;
                        }
                        if (model.isEnum) {
                            codegenParameter.isEnum = true;
                            codegenParameter.allowableValues = model.allowableValues;
                            codegenParameter.isPrimitiveType = true;
                            codegenParameter.isNullable = false;
                            continue;
                        }
                        codegenParameter.isNullable = true;
                    }
                }
                this.processOperation(operation);
            }
        }
        return objs;
    }

    protected void processOperation(CodegenOperation operation) {
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId));
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toExampleValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getExample() != null) {
                return "\"" + p.getExample().toString() + "\"";
            }
        } else if (ModelUtils.isBooleanSchema(p) ? p.getExample() != null : !ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p) && (ModelUtils.isNumberSchema(p) ? p.getExample() != null : ModelUtils.isIntegerSchema(p) && p.getExample() != null)) {
            return p.getExample().toString();
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                if (ModelUtils.isFloatSchema(p)) {
                    return p.getDefault().toString() + "F";
                }
                if (ModelUtils.isDoubleSchema(p)) {
                    return p.getDefault().toString() + "D";
                }
                return p.getDefault().toString() + "M";
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            String _default = (String)p.getDefault();
            if (p.getEnum() == null) {
                return "\"" + _default + "\"";
            }
            return _default;
        }
        return null;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && this.nullableType.contains(type)) {
                return type + " option";
            }
            return type;
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            LOGGER.error("OpenAPI Type for {} is null. Default to UNKNOWN_OPENAPI_TYPE instead.", (Object)p.getName());
            openAPIType = "UNKNOWN_OPENAPI_TYPE";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            String languageType = this.getNullableType(p, type);
            if (languageType != null) {
                return languageType;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    private String getArrayTypeDeclaration(ArraySchema arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        return nestedType + "[]";
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toModelName(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder;
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.projectFolder = packageName;
        this.sourceFolder = this.projectFolder + File.separator + "src";
        this.testFolder = this.projectFolder + ".Tests";
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setPackageAuthors(String packageAuthors) {
        this.packageAuthors = packageAuthors;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    public boolean isSupportNullable() {
        return this.supportNullable;
    }

    public void setSupportNullable(boolean supportNullable) {
        this.supportNullable = supportNullable;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("byte")) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(this.getSymbolName(name));
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = StringUtils.camelize(enumName) + "Enum").matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equalsIgnoreCase(dataType) || "double?".equals(dataType) || "decimal?".equals(dataType) || "float?".equals(dataType) || "double".equals(dataType) || "decimal".equals(dataType) || "float".equals(dataType);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            codegenParameter.example = "true";
        } else if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            codegenParameter.example = "789";
        } else if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            codegenParameter.example = "56";
        } else if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            codegenParameter.example = "3.4F";
        } else if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            codegenParameter.example = "1.2D";
        } else if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            codegenParameter.example = "8.14";
        } else if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "BYTE_ARRAY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String fsharpPostProcessFile = System.getenv("FSHARP_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fsharpPostProcessFile)) {
            return;
        }
        if ("fs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = fsharpPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

