/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhpCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPhpCodegen.class);
    public static final String VARIABLE_NAMING_CONVENTION = "variableNamingConvention";
    public static final String PACKAGE_NAME = "packageName";
    public static final String SRC_BASE_PATH = "srcBasePath";
    protected String invokerPackage = "php";
    protected String packageName = "php-base";
    protected String artifactVersion = null;
    protected String srcBasePath = "lib";
    protected String testBasePath = "test";
    protected String docsBasePath = "docs";
    protected String apiDirName = "Api";
    protected String modelDirName = "Model";
    protected String variableNamingConvention = "snake_case";
    protected String apiDocPath = this.docsBasePath + "/" + this.apiDirName;
    protected String modelDocPath = this.docsBasePath + "/" + this.modelDirName;
    protected String interfaceNamePrefix = "";
    protected String interfaceNameSuffix = "Interface";
    protected String abstractNamePrefix = "Abstract";
    protected String abstractNameSuffix = "";
    protected String traitNamePrefix = "";
    protected String traitNameSuffix = "Trait";

    public AbstractPhpCodegen() {
        this.modelTemplateFiles.put("model.mustache", ".php");
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.apiTestTemplateFiles.put("api_test.mustache", ".php");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "object", "DateTime", "mixed", "number", "void", "byte"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("map", "map");
        String primitives = "'" + org.apache.commons.lang3.StringUtils.join((Iterable)this.languageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "\\DateTime");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "\\SplFileObject");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("AnyType", "mixed");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(VARIABLE_NAMING_CONVENTION, "naming convention of variable name, e.g. camelCase.").defaultValue("snake_case"));
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay\\Pets"));
        this.cliOptions.add(new CliOption(PACKAGE_NAME, "The main package name for classes. e.g. GeneratedPetstore"));
        this.cliOptions.add(new CliOption(SRC_BASE_PATH, "The directory to serve as source root."));
        this.cliOptions.add(new CliOption("artifactVersion", "The version to use in the composer package version field. e.g. 1.2.3"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PHP_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable PHP_POST_PROCESS_FILE not defined so the PHP code may not be properly formatted. To define it, try 'export PHP_POST_PROCESS_FILE=\"/usr/local/bin/prettier --write\"' (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PACKAGE_NAME)) {
            this.setPackageName((String)this.additionalProperties.get(PACKAGE_NAME));
        } else {
            this.additionalProperties.put(PACKAGE_NAME, this.packageName);
        }
        if (this.additionalProperties.containsKey(SRC_BASE_PATH)) {
            this.setSrcBasePath((String)this.additionalProperties.get(SRC_BASE_PATH));
        } else {
            this.additionalProperties.put(SRC_BASE_PATH, this.srcBasePath);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
            this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("modelPackage");
        }
        this.additionalProperties.put("modelPackage", this.modelPackage);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("apiPackage");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey(VARIABLE_NAMING_CONVENTION)) {
            this.setParameterNamingConvention((String)this.additionalProperties.get(VARIABLE_NAMING_CONVENTION));
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("apiSrcPath", "./" + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "./" + this.testBasePath + "/" + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "./" + this.testBasePath + "/" + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testBasePath", this.testBasePath);
        this.additionalProperties.put("interfaceNamePrefix", this.interfaceNamePrefix);
        this.additionalProperties.put("interfaceNameSuffix", this.interfaceNameSuffix);
        this.additionalProperties.put("abstractNamePrefix", this.abstractNamePrefix);
        this.additionalProperties.put("abstractNameSuffix", this.abstractNameSuffix);
        this.additionalProperties.put("traitNamePrefix", this.traitNamePrefix);
        this.additionalProperties.put("traitNameSuffix", this.traitNameSuffix);
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toSrcPath(String packageName, String basePath) {
        packageName = packageName.replace(this.invokerPackage, "");
        if (basePath != null && basePath.length() > 0) {
            basePath = basePath.replaceAll("[\\\\/]?$", "") + File.separator;
        }
        String packagePath = org.apache.commons.lang3.StringUtils.removeStart((String)packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement("/")), (String)File.separator);
        return org.apache.commons.lang3.StringUtils.removeEnd((String)(basePath + packagePath), (String)File.separator);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testBasePath + File.separator + this.apiDirName;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testBasePath + File.separator + this.modelDirName;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                LOGGER.warn(ap.getName() + "(array property) does not have a proper inner type defined.Default to string");
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            if (inner == null) {
                LOGGER.warn(p.getName() + "(map property) does not have a proper inner type defined. Default to string");
                inner = new StringSchema().description("TODO default missing map inner type to string");
            }
            return this.getSchemaType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)p.get$ref())) {
            String type = super.getTypeDeclaration(p);
            return !this.languageSpecificPrimitives.contains(type) ? "\\" + this.modelPackage + "\\" + type : type;
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return "\\" + this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
            if (this.instantiationTypes.containsKey(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSrcBasePath(String srcBasePath) {
        this.srcBasePath = srcBasePath;
    }

    public void setParameterNamingConvention(String variableNamingConvention) {
        this.variableNamingConvention = variableNamingConvention;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        name = "camelCase".equals(this.variableNamingConvention) ? StringUtils.camelize(name, true) : StringUtils.underscore(name);
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    private String toGenericName(String name) {
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("[^\\w\\\\]+", "_");
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (!(name = this.toGenericName(name)).matches("^\\\\.*")) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
                name = this.modelNamePrefix + "_" + name;
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
                name = name + "_" + this.modelNameSuffix;
            }
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    public String toInterfaceName(String name) {
        return StringUtils.camelize(this.interfaceNamePrefix + name + this.interfaceNameSuffix);
    }

    public String toAbstractName(String name) {
        return StringUtils.camelize(this.abstractNamePrefix + name + this.abstractNameSuffix);
    }

    public String toTraitName(String name) {
        return StringUtils.camelize(this.traitNamePrefix + name + this.traitNameSuffix);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
                return "'" + p.getDefault() + "'";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || p.isString) {
            if (example == null) {
                example = "'" + p.paramName + "_example'";
            }
            example = this.escapeText(example);
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("\\SplFileObject".equalsIgnoreCase(type) || p.isFile) {
            if (example == null) {
                example = "/path/to/file.txt";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("\\Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("\\DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("object".equals(type)) {
            example = "new \\stdClass";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.getTypeDeclaration(type) + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "NULL";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "array(" + example + ")";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "array('key' => " + example + ")";
        }
        p.example = example;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.underscore(this.toGenericName(property.name)).toUpperCase(Locale.ROOT);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("x-test-operation-id", StringUtils.camelize(op.operationId));
        }
        return objs;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return super.escapeText(input).trim();
    }

    public void escapeMediaType(List<CodegenOperation> operationList) {
        for (CodegenOperation op : operationList) {
            if (!op.hasProduces) continue;
            List<Map<String, String>> c = op.produces;
            for (Map<String, String> mediaType : c) {
                if (!"*/*".equals(mediaType.get("mediaType"))) continue;
                mediaType.put("mediaType", "*_/_*");
            }
        }
    }

    protected String extractSimpleName(String phpClassName) {
        if (phpClassName == null) {
            return null;
        }
        int lastBackslashIndex = phpClassName.lastIndexOf(92);
        return phpClassName.substring(lastBackslashIndex + 1);
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String phpPostProcessFile = System.getenv("PHP_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)phpPostProcessFile)) {
            return;
        }
        if ("php".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = phpPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

