/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.TemplateManager;
import org.openapitools.codegen.api.TemplatePathLocator;

public class GeneratorTemplateContentLocator
implements TemplatePathLocator {
    private final CodegenConfig codegenConfig;

    public GeneratorTemplateContentLocator(CodegenConfig codegenConfig) {
        this.codegenConfig = codegenConfig;
    }

    private String buildLibraryFilePath(String dir, String library, String file) {
        return dir + File.separator + "libraries" + File.separator + library + File.separator + file;
    }

    public boolean embeddedTemplateExists(String name) {
        return this.getClass().getClassLoader().getResource(TemplateManager.getCPResourcePath(name)) != null;
    }

    public String getFullTemplatePath(String relativeTemplateFile) {
        String embeddedLibTemplateFile;
        String libTemplateFile;
        CodegenConfig config = this.codegenConfig;
        String library = config.getLibrary();
        if (StringUtils.isNotEmpty((CharSequence)library) && (new File(libTemplateFile = this.buildLibraryFilePath(config.templateDir(), library, relativeTemplateFile)).exists() || this.getClass().getClassLoader().getResource(libTemplateFile) != null)) {
            return libTemplateFile;
        }
        String template = config.templateDir() + File.separator + relativeTemplateFile;
        if (new File(template).exists() || this.getClass().getClassLoader().getResource(template) != null) {
            return template;
        }
        if (StringUtils.isNotEmpty((CharSequence)library) && this.embeddedTemplateExists(embeddedLibTemplateFile = this.buildLibraryFilePath(config.embeddedTemplateDir(), library, relativeTemplateFile))) {
            return embeddedLibTemplateFile;
        }
        String loc = config.embeddedTemplateDir() + File.separator + relativeTemplateFile;
        if (this.embeddedTemplateExists(loc)) {
            return loc;
        }
        return null;
    }
}

