/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinSpringServerCodegen
extends AbstractKotlinCodegen
implements BeanValidationFeatures {
    private static Logger LOGGER = LoggerFactory.getLogger(KotlinSpringServerCodegen.class);
    private static final HashSet<String> VARIABLE_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ApiClient", "ApiException", "ApiResponse"));
    public static final String TITLE = "title";
    public static final String SERVER_PORT = "serverPort";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String SPRING_BOOT = "spring-boot";
    public static final String EXCEPTION_HANDLER = "exceptionHandler";
    public static final String GRADLE_BUILD_FILE = "gradleBuildFile";
    public static final String SWAGGER_ANNOTATIONS = "swaggerAnnotations";
    public static final String SERVICE_INTERFACE = "serviceInterface";
    public static final String SERVICE_IMPLEMENTATION = "serviceImplementation";
    public static final String REACTIVE = "reactive";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String DELEGATE_PATTERN = "delegatePattern";
    public static final String USE_TAGS = "useTags";
    private String basePackage;
    private String invokerPackage;
    private String serverPort = "8080";
    private String title = "OpenAPI Kotlin Spring";
    private String resourceFolder = "src/main/resources";
    private boolean useBeanValidation = true;
    private boolean exceptionHandler = true;
    private boolean gradleBuildFile = true;
    private boolean swaggerAnnotations = false;
    private boolean serviceInterface = false;
    private boolean serviceImplementation = false;
    private boolean reactive = false;
    private boolean interfaceOnly = false;
    private boolean delegatePattern = false;
    protected boolean useTags = false;

    public KotlinSpringServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.reservedWords.addAll(VARIABLE_RESERVED_WORDS);
        this.outputFolder = "generated-code/kotlin-spring";
        this.templateDir = "kotlin-spring";
        this.embeddedTemplateDir = "kotlin-spring";
        this.artifactId = "openapi-spring";
        this.invokerPackage = "org.openapitools";
        this.basePackage = "org.openapitools";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.updateOption("artifactId", this.artifactId);
        this.typeMapping.put("array", "kotlin.collections.List");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("file", "org.springframework.core.io.Resource");
        this.addOption(TITLE, "server title name or client service name", this.title);
        this.addOption(BASE_PACKAGE, "base package (invokerPackage) for generated code", this.basePackage);
        this.addOption(SERVER_PORT, "configuration the port in which the sever is to run on", this.serverPort);
        this.addOption("modelPackage", "model package for generated code", this.modelPackage);
        this.addOption("apiPackage", "api package for generated code", this.apiPackage);
        this.addSwitch(EXCEPTION_HANDLER, "generate default global exception handlers (not compatible with reactive. enabling reactive will disable exceptionHandler )", this.exceptionHandler);
        this.addSwitch(GRADLE_BUILD_FILE, "generate a gradle build file using the Kotlin DSL", this.gradleBuildFile);
        this.addSwitch(SWAGGER_ANNOTATIONS, "generate swagger annotations to go alongside controllers and models", this.swaggerAnnotations);
        this.addSwitch(SERVICE_INTERFACE, "generate service interfaces to go alongside controllers. In most cases this option would be used to update an existing project, so not to override implementations. Useful to help facilitate the generation gap pattern", this.serviceInterface);
        this.addSwitch(SERVICE_IMPLEMENTATION, "generate stub service implementations that extends service interfaces. If this is set to true service interfaces will also be generated", this.serviceImplementation);
        this.addSwitch("useBeanValidation", "Use BeanValidation API annotations to validate data types", this.useBeanValidation);
        this.addSwitch(REACTIVE, "use coroutines for reactive behavior", this.reactive);
        this.addSwitch(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.", this.interfaceOnly);
        this.addSwitch(DELEGATE_PATTERN, "Whether to generate the server files using the delegate pattern", this.delegatePattern);
        this.addSwitch(USE_TAGS, "Whether to use tags for creating interface and controller class names", this.useTags);
        this.supportedLibraries.put(SPRING_BOOT, "Spring-boot Server application.");
        this.setLibrary(SPRING_BOOT);
        CliOption cliOpt = new CliOption("library", "library template (sub-template)");
        cliOpt.setDefault(SPRING_BOOT);
        cliOpt.setEnum(this.supportedLibraries);
        this.cliOptions.add(cliOpt);
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(boolean exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean getGradleBuildFile() {
        return this.gradleBuildFile;
    }

    public void setGradleBuildFile(boolean gradleBuildFile) {
        this.gradleBuildFile = gradleBuildFile;
    }

    public boolean getSwaggerAnnotations() {
        return this.swaggerAnnotations;
    }

    public void setSwaggerAnnotations(boolean swaggerAnnotations) {
        this.swaggerAnnotations = swaggerAnnotations;
    }

    public boolean getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(boolean serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public boolean getServiceImplementation() {
        return this.serviceImplementation;
    }

    public void setServiceImplementation(boolean serviceImplementation) {
        this.serviceImplementation = serviceImplementation;
    }

    public boolean getUseBeanValidation() {
        return this.useBeanValidation;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setDelegatePattern(boolean delegatePattern) {
        this.delegatePattern = delegatePattern;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "kotlin-spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin Spring application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (!this.additionalProperties.containsKey("library")) {
            this.additionalProperties.put("library", this.library);
        }
        if (!this.additionalProperties.containsKey(BASE_PACKAGE) && this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            LOGGER.info("Set base package to invoker package (" + this.basePackage + ")");
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(SERVER_PORT)) {
            this.setServerPort((String)this.additionalProperties.get(SERVER_PORT));
        } else {
            this.additionalProperties.put(SERVER_PORT, this.serverPort);
        }
        if (this.additionalProperties.containsKey(EXCEPTION_HANDLER)) {
            this.setExceptionHandler(Boolean.parseBoolean(this.additionalProperties.get(EXCEPTION_HANDLER).toString()));
        }
        this.writePropertyBack(EXCEPTION_HANDLER, this.exceptionHandler);
        if (this.additionalProperties.containsKey(GRADLE_BUILD_FILE)) {
            this.setGradleBuildFile(Boolean.parseBoolean(this.additionalProperties.get(GRADLE_BUILD_FILE).toString()));
        }
        this.writePropertyBack(GRADLE_BUILD_FILE, this.gradleBuildFile);
        if (this.additionalProperties.containsKey(SWAGGER_ANNOTATIONS)) {
            this.setSwaggerAnnotations(Boolean.parseBoolean(this.additionalProperties.get(SWAGGER_ANNOTATIONS).toString()));
        }
        this.writePropertyBack(SWAGGER_ANNOTATIONS, this.swaggerAnnotations);
        if (this.additionalProperties.containsKey(SERVICE_INTERFACE)) {
            this.setServiceInterface(Boolean.parseBoolean(this.additionalProperties.get(SERVICE_INTERFACE).toString()));
        }
        this.writePropertyBack(SERVICE_INTERFACE, this.serviceInterface);
        if (this.additionalProperties.containsKey(SERVICE_IMPLEMENTATION)) {
            this.setServiceImplementation(Boolean.parseBoolean(this.additionalProperties.get(SERVICE_IMPLEMENTATION).toString()));
        }
        this.writePropertyBack(SERVICE_IMPLEMENTATION, this.serviceImplementation);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(REACTIVE) && this.library.equals(SPRING_BOOT)) {
            this.setReactive(this.convertPropertyToBoolean(REACTIVE));
            this.setExceptionHandler(false);
        }
        this.writePropertyBack(REACTIVE, this.reactive);
        this.writePropertyBack(EXCEPTION_HANDLER, this.exceptionHandler);
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey(DELEGATE_PATTERN)) {
            this.setDelegatePattern(Boolean.parseBoolean(this.additionalProperties.get(DELEGATE_PATTERN).toString()));
            if (!this.interfaceOnly) {
                this.setSwaggerAnnotations(true);
            }
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.parseBoolean(this.additionalProperties.get(USE_TAGS).toString()));
        }
        this.modelTemplateFiles.put("model.mustache", ".kt");
        if (!this.interfaceOnly && this.delegatePattern) {
            this.apiTemplateFiles.put("apiInterface.mustache", ".kt");
            this.apiTemplateFiles.put("apiController.mustache", "Controller.kt");
        } else if (this.interfaceOnly) {
            this.apiTemplateFiles.put("apiInterface.mustache", ".kt");
        } else {
            this.apiTemplateFiles.put("api.mustache", ".kt");
            this.apiTestTemplateFiles.put("api_test.mustache", ".kt");
        }
        if (SPRING_BOOT.equals(this.library)) {
            this.supportingFiles.add(new SupportingFile("apiUtil.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtil.kt"));
        }
        if (this.serviceInterface) {
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
        } else if (this.serviceImplementation) {
            LOGGER.warn("If you set `serviceImplementation` to true, `serviceInterface` will also be set to true");
            this.additionalProperties.put(SERVICE_INTERFACE, true);
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
            this.apiTemplateFiles.put("serviceImpl.mustache", "ServiceImpl.kt");
        }
        if (this.delegatePattern) {
            this.additionalProperties.put("isDelegate", "true");
            this.apiTemplateFiles.put("apiDelegate.mustache", "Delegate.kt");
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.exceptionHandler) {
            this.supportingFiles.add(new SupportingFile("exceptions.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.apiPackage), "Exceptions.kt"));
        }
        if (this.library.equals(SPRING_BOOT)) {
            LOGGER.info("Setup code generator for Kotlin Spring Boot");
            this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            if (this.gradleBuildFile) {
                this.supportingFiles.add(new SupportingFile("buildGradleKts.mustache", "", "build.gradle.kts"));
                this.supportingFiles.add(new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
            }
            if (!this.interfaceOnly) {
                this.supportingFiles.add(new SupportingFile("application.mustache", this.resourceFolder, "application.yaml"));
                this.supportingFiles.add(new SupportingFile("springBootApplication.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.basePackage), "Application.kt"));
            }
        }
        this.additionalProperties.put("jackson", "true");
        this.additionalProperties.put("lambdaEscapeDoubleQuote", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement("\\\""))));
        this.additionalProperties.put("lambdaRemoveLineBreak", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\\r|\\n", "")));
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"escapeDoubleQuote", (Object)new EscapeLambda("\"", "\\\""));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.library.equals(SPRING_BOOT) && !this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.equals("")) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
        } else {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, 8080));
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (model.discriminator != null && this.additionalProperties.containsKey("jackson")) {
            model.imports.addAll(Arrays.asList("JsonSubTypes", "JsonTypeInfo"));
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        models.stream().map(mo -> (Map)mo).map(mo -> (CodegenModel)mo.get("model")).filter(cm -> Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null).forEach(cm -> {
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            cm.imports.add((String)this.importMapping.get("JsonProperty"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            item.put("import", this.importMapping.get("JsonProperty"));
            imports.add(item);
        });
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            ops.forEach(operation -> {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    responses.forEach(resp -> {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner((CodegenResponse)resp){
                            final /* synthetic */ CodegenResponse val$resp;
                            {
                                this.val$resp = codegenResponse;
                            }

                            @Override
                            public void setReturnType(String returnType) {
                                this.val$resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                this.val$resp.containerType = returnContainer;
                            }
                        });
                    });
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner((CodegenOperation)operation){
                    final /* synthetic */ CodegenOperation val$operation;
                    {
                        this.val$operation = codegenOperation;
                    }

                    @Override
                    public void setReturnType(String returnType) {
                        this.val$operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        this.val$operation.returnContainer = returnContainer;
                    }
                });
            });
        }
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        if (returnType == null) {
            dataTypeAssigner.setReturnType("Unit");
        } else if (returnType.startsWith("kotlin.collections.List")) {
            int end2 = returnType.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (returnType.startsWith("kotlin.collections.Map") && (end = returnType.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.Map<".length(), end).split(",")[1].trim());
            dataTypeAssigner.setReturnContainer("Map");
        }
    }

    private static String sanitizeDirectory(String in) {
        return in.replace(".", File.separator);
    }

    @Override
    public String toModelName(String name) {
        if (name.startsWith("org.springframework.")) {
            return name;
        }
        return super.toModelName(name);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("org.springframework.") && super.needToImport(type);
        return imports;
    }

    private static class EscapeLambda
    implements Mustache.Lambda {
        private String from;
        private String to;

        EscapeLambda(String from, String to) {
            this.from = from;
            this.to = Matcher.quoteReplacement(to);
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll(this.from, this.to));
        }
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

