/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinClientCodegen
extends AbstractKotlinCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(KotlinClientCodegen.class);
    protected static final String JVM = "jvm";
    protected static final String JVM_OKHTTP = "jvm-okhttp";
    protected static final String JVM_OKHTTP4 = "jvm-okhttp4";
    protected static final String JVM_OKHTTP3 = "jvm-okhttp3";
    protected static final String JVM_RETROFIT2 = "jvm-retrofit2";
    protected static final String MULTIPLATFORM = "multiplatform";
    public static final String USE_RX_JAVA = "useRxJava";
    public static final String USE_RX_JAVA2 = "useRxJava2";
    public static final String USE_RX_JAVA3 = "useRxJava3";
    public static final String USE_COROUTINES = "useCoroutines";
    public static final String DO_NOT_USE_RX_AND_COROUTINES = "doNotUseRxAndCoroutines";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String REQUEST_DATE_CONVERTER = "requestDateConverter";
    public static final String COLLECTION_TYPE = "collectionType";
    public static final String MOSHI_CODE_GEN = "moshiCodeGen";
    public static final String SUPPORT_ANDROID_API_LEVEL_25_AND_BELLOW = "supportAndroidApiLevel25AndBelow";
    protected static final String VENDOR_EXTENSION_BASE_NAME_LITERAL = "x-base-name-literal";
    protected String dateLibrary;
    protected String requestDateConverter;
    protected String collectionType;
    protected boolean useRxJava;
    protected boolean useRxJava2;
    protected boolean useRxJava3;
    protected boolean useCoroutines;
    protected boolean doNotUseRxAndCoroutines;
    protected String authFolder;

    public KotlinClientCodegen() {
        this.dateLibrary = DateLibrary.JAVA8.value;
        this.requestDateConverter = RequestDateConverter.TO_JSON.value;
        this.collectionType = CollectionType.LIST.value;
        this.useRxJava = false;
        this.useRxJava2 = false;
        this.useRxJava3 = false;
        this.useCoroutines = false;
        this.doNotUseRxAndCoroutines = true;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.XML, WireFormatFeature.PROTOBUF}).excludeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OpenIDConnect, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Implicit}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.artifactId = "kotlin-client";
        this.packageName = "org.openapitools.client";
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-client";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "kotlin-client";
        this.embeddedTemplateDir = "kotlin-client";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(DateLibrary.THREETENBP.value, "Threetenbp - Backport of JSR310 (jvm only, preferred for jdk < 1.8)");
        dateOptions.put(DateLibrary.THREETENBP_LOCALDATETIME.value, "Threetenbp - Backport of JSR310 (jvm only, for legacy app only)");
        dateOptions.put(DateLibrary.STRING.value, "String");
        dateOptions.put(DateLibrary.JAVA8.value, "Java 8 native JSR310 (jvm only, preferred for jdk 1.8+)");
        dateOptions.put(DateLibrary.JAVA8_LOCALDATETIME.value, "Java 8 native JSR310 (jvm only, for legacy app only)");
        dateLibrary.setEnum(dateOptions);
        dateLibrary.setDefault(this.dateLibrary);
        this.cliOptions.add(dateLibrary);
        CliOption collectionType = new CliOption(COLLECTION_TYPE, "Option. Collection type to use");
        HashMap<String, String> collectionOptions = new HashMap<String, String>();
        collectionOptions.put(CollectionType.ARRAY.value, "kotlin.Array");
        collectionOptions.put(CollectionType.LIST.value, "kotlin.collections.List");
        collectionType.setEnum(collectionOptions);
        collectionType.setDefault(this.collectionType);
        this.cliOptions.add(collectionType);
        this.supportedLibraries.put(JVM_OKHTTP4, "[DEFAULT] Platform: Java Virtual Machine. HTTP client: OkHttp 4.2.0 (Android 5.0+ and Java 8+). JSON processing: Moshi 1.8.0.");
        this.supportedLibraries.put(JVM_OKHTTP3, "Platform: Java Virtual Machine. HTTP client: OkHttp 3.12.4 (Android 2.3+ and Java 7+). JSON processing: Moshi 1.8.0.");
        this.supportedLibraries.put(JVM_RETROFIT2, "Platform: Java Virtual Machine. HTTP client: Retrofit 2.6.2.");
        this.supportedLibraries.put(MULTIPLATFORM, "Platform: Kotlin multiplatform. HTTP client: Ktor 1.6.0. JSON processing: Kotlinx Serialization: 1.2.1.");
        CliOption libraryOption = new CliOption("library", "Library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(JVM_OKHTTP4);
        this.cliOptions.add(libraryOption);
        this.setLibrary(JVM_OKHTTP4);
        CliOption requestDateConverter = new CliOption(REQUEST_DATE_CONVERTER, "JVM-Option. Defines in how to handle date-time objects that are used for a request (as query or parameter)");
        HashMap<String, String> requestDateConverterOptions = new HashMap<String, String>();
        requestDateConverterOptions.put(RequestDateConverter.TO_JSON.value, "[DEFAULT] Date formater option using a json converter.");
        requestDateConverterOptions.put(RequestDateConverter.TO_STRING.value, "Use the 'toString'-method of the date-time object to retrieve the related string representation.");
        requestDateConverter.setEnum(requestDateConverterOptions);
        requestDateConverter.setDefault(this.requestDateConverter);
        this.cliOptions.add(requestDateConverter);
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA, "Whether to use the RxJava adapter with the retrofit2 library. IMPORTANT: this option has been deprecated. Please use `useRxJava3` instead."));
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA2, "Whether to use the RxJava2 adapter with the retrofit2 library. IMPORTANT: this option has been deprecated. Please use `useRxJava3` instead."));
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA3, "Whether to use the RxJava3 adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(USE_COROUTINES, "Whether to use the Coroutines adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(MOSHI_CODE_GEN, "Whether to enable codegen with the Moshi library. Refer to the [official Moshi doc](https://github.com/square/moshi#codegen) for more info."));
        this.cliOptions.add(CliOption.newBoolean(SUPPORT_ANDROID_API_LEVEL_25_AND_BELLOW, "[WARNING] This flag will generate code that has a known security vulnerability. It uses `kotlin.io.createTempFile` instead of `java.nio.file.Files.createTempFile` in oder to support Android API level 25 and bellow. For more info, please check the following links https://github.com/OpenAPITools/openapi-generator/security/advisories/GHSA-23x4-m842-fmwf, https://github.com/OpenAPITools/openapi-generator/pull/9284"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "kotlin";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin client.";
    }

    public void setUseRxJava(boolean useRxJava) {
        if (useRxJava) {
            this.useRxJava2 = false;
            this.useRxJava3 = false;
            this.doNotUseRxAndCoroutines = false;
            this.useCoroutines = false;
        }
        this.useRxJava = useRxJava;
    }

    public void setUseRxJava2(boolean useRxJava2) {
        if (useRxJava2) {
            this.useRxJava = false;
            this.useRxJava3 = false;
            this.doNotUseRxAndCoroutines = false;
            this.useCoroutines = false;
        }
        this.useRxJava2 = useRxJava2;
    }

    public void setUseRxJava3(boolean useRxJava3) {
        if (useRxJava3) {
            this.useRxJava = false;
            this.useRxJava2 = false;
            this.doNotUseRxAndCoroutines = false;
            this.useCoroutines = false;
        }
        this.useRxJava3 = useRxJava3;
    }

    public void setDoNotUseRxAndCoroutines(boolean doNotUseRxAndCoroutines) {
        if (doNotUseRxAndCoroutines) {
            this.useRxJava = false;
            this.useRxJava2 = false;
            this.useRxJava3 = false;
            this.useCoroutines = false;
        }
        this.doNotUseRxAndCoroutines = doNotUseRxAndCoroutines;
    }

    public void setUseCoroutines(boolean useCoroutines) {
        if (useCoroutines) {
            this.useRxJava = false;
            this.useRxJava2 = false;
            this.useRxJava3 = false;
            this.doNotUseRxAndCoroutines = false;
        }
        this.useCoroutines = useCoroutines;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setRequestDateConverter(String converter) {
        this.requestDateConverter = converter;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public void processOpts() {
        boolean hasConflict;
        super.processOpts();
        if (MULTIPLATFORM.equals(this.getLibrary())) {
            this.sourceFolder = "src/commonMain/kotlin";
        }
        boolean hasRx = this.additionalProperties.containsKey(USE_RX_JAVA);
        boolean hasRx2 = this.additionalProperties.containsKey(USE_RX_JAVA2);
        boolean hasRx3 = this.additionalProperties.containsKey(USE_RX_JAVA3);
        boolean hasCoroutines = this.additionalProperties.containsKey(USE_COROUTINES);
        int optionCount = 0;
        if (hasRx) {
            ++optionCount;
        }
        if (hasRx2) {
            ++optionCount;
        }
        if (hasRx3) {
            ++optionCount;
        }
        if (hasCoroutines) {
            ++optionCount;
        }
        boolean bl = hasConflict = optionCount > 1;
        if (hasConflict) {
            this.LOGGER.warn("You specified RxJava versions 1 and 2 and 3 or Coroutines together, please choose one of them.");
        } else if (hasRx) {
            this.setUseRxJava(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA).toString()));
        } else if (hasRx2) {
            this.setUseRxJava2(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA2).toString()));
        } else if (hasRx3) {
            this.setUseRxJava3(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA3).toString()));
        } else if (hasCoroutines) {
            this.setUseCoroutines(Boolean.parseBoolean(this.additionalProperties.get(USE_COROUTINES).toString()));
        }
        if (!(hasRx || hasRx2 || hasRx3 || hasCoroutines)) {
            this.setDoNotUseRxAndCoroutines(true);
            this.additionalProperties.put(DO_NOT_USE_RX_AND_COROUTINES, true);
        }
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", "/");
        this.authFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "auth").replace(".", "/");
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        if (this.additionalProperties.containsKey(REQUEST_DATE_CONVERTER)) {
            this.setRequestDateConverter(this.additionalProperties.get(REQUEST_DATE_CONVERTER).toString());
        }
        this.commonSupportingFiles();
        switch (this.getLibrary()) {
            case "jvm-okhttp3": 
            case "jvm-okhttp4": {
                this.processJVMOkHttpLibrary(infrastructureFolder);
                break;
            }
            case "jvm-retrofit2": {
                this.processJVMRetrofit2Library(infrastructureFolder);
                break;
            }
            case "multiplatform": {
                this.processMultiplatformLibrary(infrastructureFolder);
                break;
            }
        }
        this.processDateLibrary();
        this.processRequestDateConverter();
        if (this.additionalProperties.containsKey(COLLECTION_TYPE)) {
            this.setCollectionType(this.additionalProperties.get(COLLECTION_TYPE).toString());
        }
        if (CollectionType.LIST.value.equals(this.collectionType)) {
            this.typeMapping.put("array", "kotlin.collections.List");
            this.typeMapping.put("list", "kotlin.collections.List");
            this.additionalProperties.put("isList", true);
        }
        if (this.usesRetrofit2Library()) {
            if (ProcessUtils.hasOAuthMethods(this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.kt.mustache", this.authFolder, "ApiKeyAuth.kt"));
                this.supportingFiles.add(new SupportingFile("auth/OAuth.kt.mustache", this.authFolder, "OAuth.kt"));
                this.supportingFiles.add(new SupportingFile("auth/OAuthFlow.kt.mustache", this.authFolder, "OAuthFlow.kt"));
                this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.kt.mustache", this.authFolder, "OAuthOkHttpClient.kt"));
            }
            if (ProcessUtils.hasHttpBearerMethods(this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/HttpBearerAuth.kt.mustache", this.authFolder, "HttpBearerAuth.kt"));
            }
            if (ProcessUtils.hasHttpBasicMethods(this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.kt.mustache", this.authFolder, "HttpBasicAuth.kt"));
            }
        }
    }

    private void processDateLibrary() {
        if (DateLibrary.THREETENBP.value.equals(this.dateLibrary) || DateLibrary.THREETENBP_LOCALDATETIME.value.equals(this.dateLibrary)) {
            this.processThreeTeBpDate(this.dateLibrary);
        } else if (DateLibrary.STRING.value.equals(this.dateLibrary)) {
            this.processStringDate();
        } else if (DateLibrary.JAVA8.value.equals(this.dateLibrary) || DateLibrary.JAVA8_LOCALDATETIME.value.equals(this.dateLibrary)) {
            this.processJava8Date(this.dateLibrary);
        }
    }

    private void processRequestDateConverter() {
        if (RequestDateConverter.TO_JSON.value.equals(this.requestDateConverter)) {
            this.additionalProperties.put(RequestDateConverter.TO_JSON.value, true);
        } else if (RequestDateConverter.TO_STRING.value.equals(this.requestDateConverter)) {
            this.additionalProperties.put(RequestDateConverter.TO_STRING.value, true);
        }
    }

    private void processThreeTeBpDate(String dateLibrary) {
        this.additionalProperties.put(DateLibrary.THREETENBP.value, true);
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
        this.defaultIncludes.add("org.threeten.bp.LocalDate");
        if (dateLibrary.equals(DateLibrary.THREETENBP.value)) {
            this.typeMapping.put("date-time", "org.threeten.bp.OffsetDateTime");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("OffsetDateTime", "org.threeten.bp.OffsetDateTime");
            this.defaultIncludes.add("org.threeten.bp.OffsetDateTime");
        } else if (dateLibrary.equals(DateLibrary.THREETENBP_LOCALDATETIME.value)) {
            this.typeMapping.put("date-time", "org.threeten.bp.LocalDateTime");
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.importMapping.put("LocalDateTime", "org.threeten.bp.LocalDateTime");
            this.defaultIncludes.add("org.threeten.bp.LocalDateTime");
        }
    }

    private void processStringDate() {
        this.typeMapping.put("date-time", "kotlin.String");
        this.typeMapping.put("date", "kotlin.String");
        this.typeMapping.put("Date", "kotlin.String");
        this.typeMapping.put("DateTime", "kotlin.String");
    }

    private void processJava8Date(String dateLibrary) {
        this.additionalProperties.put(DateLibrary.JAVA8.value, true);
        if (dateLibrary.equals(DateLibrary.JAVA8.value)) {
            this.typeMapping.put("date-time", "java.time.OffsetDateTime");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        } else if (dateLibrary.equals(DateLibrary.JAVA8_LOCALDATETIME.value)) {
            this.typeMapping.put("date-time", "java.time.LocalDateTime");
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        }
    }

    private void processJVMRetrofit2Library(String infrastructureFolder) {
        this.additionalProperties.put(JVM, true);
        this.additionalProperties.put(JVM_RETROFIT2, true);
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiClient.kt.mustache", infrastructureFolder, "ApiClient.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ResponseExt.kt.mustache", infrastructureFolder, "ResponseExt.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/CollectionFormats.kt.mustache", infrastructureFolder, "CollectionFormats.kt"));
        this.addSupportingSerializerAdapters(infrastructureFolder);
    }

    private void addSupportingSerializerAdapters(String infrastructureFolder) {
        this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/Serializer.kt.mustache", infrastructureFolder, "Serializer.kt"));
        this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/ByteArrayAdapter.kt.mustache", infrastructureFolder, "ByteArrayAdapter.kt"));
        switch (this.getSerializationLibrary()) {
            case moshi: {
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/UUIDAdapter.kt.mustache", infrastructureFolder, "UUIDAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateAdapter.kt.mustache", infrastructureFolder, "LocalDateAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateTimeAdapter.kt.mustache", infrastructureFolder, "LocalDateTimeAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/OffsetDateTimeAdapter.kt.mustache", infrastructureFolder, "OffsetDateTimeAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/BigDecimalAdapter.kt.mustache", infrastructureFolder, "BigDecimalAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/BigIntegerAdapter.kt.mustache", infrastructureFolder, "BigIntegerAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/URIAdapter.kt.mustache", infrastructureFolder, "URIAdapter.kt"));
                break;
            }
            case gson: {
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/DateAdapter.kt.mustache", infrastructureFolder, "DateAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateAdapter.kt.mustache", infrastructureFolder, "LocalDateAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateTimeAdapter.kt.mustache", infrastructureFolder, "LocalDateTimeAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/OffsetDateTimeAdapter.kt.mustache", infrastructureFolder, "OffsetDateTimeAdapter.kt"));
                break;
            }
            case jackson: {
                break;
            }
            case kotlinx_serialization: {
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/AtomicBooleanAdapter.kt.mustache", infrastructureFolder, "AtomicBooleanAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/AtomicIntegerAdapter.kt.mustache", infrastructureFolder, "AtomicIntegerAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/AtomicLongAdapter.kt.mustache", infrastructureFolder, "AtomicLongAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/URIAdapter.kt.mustache", infrastructureFolder, "URIAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/URLAdapter.kt.mustache", infrastructureFolder, "URLAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/BigIntegerAdapter.kt.mustache", infrastructureFolder, "BigIntegerAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/BigDecimalAdapter.kt.mustache", infrastructureFolder, "BigDecimalAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/DateAdapter.kt.mustache", infrastructureFolder, "DateAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateAdapter.kt.mustache", infrastructureFolder, "LocalDateAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/LocalDateTimeAdapter.kt.mustache", infrastructureFolder, "LocalDateTimeAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/OffsetDateTimeAdapter.kt.mustache", infrastructureFolder, "OffsetDateTimeAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/UUIDAdapter.kt.mustache", infrastructureFolder, "UUIDAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/StringBuilderAdapter.kt.mustache", infrastructureFolder, "StringBuilderAdapter.kt"));
                this.supportingFiles.add(new SupportingFile("jvm-common/infrastructure/proguard-rules.pro.mustache", "", "proguard-rules.pro"));
            }
        }
    }

    private void processJVMOkHttpLibrary(String infrastructureFolder) {
        this.commonJvmMultiplatformSupportingFiles(infrastructureFolder);
        this.addSupportingSerializerAdapters(infrastructureFolder);
        this.additionalProperties.put(JVM, true);
        this.additionalProperties.put(JVM_OKHTTP, true);
        if (JVM_OKHTTP4.equals(this.getLibrary())) {
            this.additionalProperties.put(JVM_OKHTTP4, true);
        } else if (JVM_OKHTTP3.equals(this.getLibrary())) {
            this.additionalProperties.put(JVM_OKHTTP3, true);
        }
        this.supportedLibraries.put(JVM_OKHTTP, "A workaround to use the same template folder for both 'jvm-okhttp3' and 'jvm-okhttp4'.");
        this.setLibrary(JVM_OKHTTP);
        this.supportingFiles.add(new SupportingFile("infrastructure/Errors.kt.mustache", infrastructureFolder, "Errors.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ResponseExtensions.kt.mustache", infrastructureFolder, "ResponseExtensions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiInfrastructureResponse.kt.mustache", infrastructureFolder, "ApiInfrastructureResponse.kt"));
    }

    private void processMultiplatformLibrary(String infrastructureFolder) {
        this.commonJvmMultiplatformSupportingFiles(infrastructureFolder);
        this.additionalProperties.put(MULTIPLATFORM, true);
        this.setDateLibrary(DateLibrary.STRING.value);
        this.setRequestDateConverter(RequestDateConverter.TO_STRING.value);
        this.defaultIncludes.add("io.ktor.client.request.forms.InputProvider");
        this.defaultIncludes.add(this.packageName + ".infrastructure.Base64ByteArray");
        this.defaultIncludes.add(this.packageName + ".infrastructure.OctetByteArray");
        this.typeMapping.put("number", "kotlin.Double");
        this.typeMapping.put("file", "OctetByteArray");
        this.typeMapping.put("binary", "OctetByteArray");
        this.typeMapping.put("ByteArray", "Base64ByteArray");
        this.typeMapping.put("object", "kotlin.String");
        this.importMapping.put("BigDecimal", "kotlin.Double");
        this.importMapping.put("UUID", "kotlin.String");
        this.importMapping.put("URI", "kotlin.String");
        this.importMapping.put("InputProvider", "io.ktor.client.request.forms.InputProvider");
        this.importMapping.put("File", this.packageName + ".infrastructure.OctetByteArray");
        this.importMapping.put("Timestamp", "kotlin.String");
        this.importMapping.put("LocalDateTime", "kotlin.String");
        this.importMapping.put("LocalDate", "kotlin.String");
        this.importMapping.put("LocalTime", "kotlin.String");
        this.importMapping.put("Base64ByteArray", this.packageName + ".infrastructure.Base64ByteArray");
        this.importMapping.put("OctetByteArray", this.packageName + ".infrastructure.OctetByteArray");
        this.supportingFiles.add(new SupportingFile("infrastructure/Base64ByteArray.kt.mustache", infrastructureFolder, "Base64ByteArray.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/Bytes.kt.mustache", infrastructureFolder, "Bytes.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/HttpResponse.kt.mustache", infrastructureFolder, "HttpResponse.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/OctetByteArray.kt.mustache", infrastructureFolder, "OctetByteArray.kt"));
        this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.kt.mustache", this.authFolder, "ApiKeyAuth.kt"));
        this.supportingFiles.add(new SupportingFile("auth/Authentication.kt.mustache", this.authFolder, "Authentication.kt"));
        this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.kt.mustache", this.authFolder, "HttpBasicAuth.kt"));
        this.supportingFiles.add(new SupportingFile("auth/HttpBearerAuth.kt.mustache", this.authFolder, "HttpBearerAuth.kt"));
        this.supportingFiles.add(new SupportingFile("auth/OAuth.kt.mustache", this.authFolder, "OAuth.kt"));
        this.supportingFiles.add(new SupportingFile("commonTest/Coroutine.kt.mustache", "src/commonTest/kotlin/util", "Coroutine.kt"));
        this.supportingFiles.add(new SupportingFile("iosTest/Coroutine.kt.mustache", "src/iosTest/kotlin/util", "Coroutine.kt"));
        this.supportingFiles.add(new SupportingFile("jsTest/Coroutine.kt.mustache", "src/jsTest/kotlin/util", "Coroutine.kt"));
        this.supportingFiles.add(new SupportingFile("jvmTest/Coroutine.kt.mustache", "src/jvmTest/kotlin/util", "Coroutine.kt"));
    }

    private void commonJvmMultiplatformSupportingFiles(String infrastructureFolder) {
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiClient.kt.mustache", infrastructureFolder, "ApiClient.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiAbstractions.kt.mustache", infrastructureFolder, "ApiAbstractions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestConfig.kt.mustache", infrastructureFolder, "RequestConfig.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestMethod.kt.mustache", infrastructureFolder, "RequestMethod.kt"));
    }

    private void commonSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.getLibrary().equals(MULTIPLATFORM)) {
            this.supportingFiles.add(new SupportingFile("build.gradle.kts.mustache", "", "build.gradle.kts"));
            this.supportingFiles.add(new SupportingFile("settings.gradle.kts.mustache", "", "settings.gradle.kts"));
        } else {
            this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
            this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        }
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.jar"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> objects = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Object model : models) {
            Map mo = (Map)model;
            CodegenModel cm = (CodegenModel)mo.get("model");
            List vars = Stream.of(cm.vars, cm.allVars, cm.optionalVars, cm.requiredVars, cm.readOnlyVars, cm.readWriteVars, cm.parentVars).flatMap(Collection::stream).collect(Collectors.toList());
            for (CodegenProperty var : vars) {
                var.vendorExtensions.put(VENDOR_EXTENSION_BASE_NAME_LITERAL, var.baseName.replace("$", "\\$"));
            }
        }
        return objects;
    }

    private boolean usesRetrofit2Library() {
        return this.getLibrary() != null && this.getLibrary().contains(JVM_RETROFIT2);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (JVM_RETROFIT2.equals(this.getLibrary()) && StringUtils.isNotEmpty((CharSequence)operation.path) && operation.path.startsWith("/")) {
                    operation.path = operation.path.substring(1);
                }
                if (operation.hasConsumes == Boolean.TRUE && KotlinClientCodegen.isMultipartType(operation.consumes)) {
                    operation.isMultipart = Boolean.TRUE;
                }
                for (CodegenParameter param : operation.allParams) {
                    if (!Boolean.TRUE.equals(param.isFile)) continue;
                    operations.put("x-kotlin-multipart-import", true);
                }
                if (this.usesRetrofit2Library() && StringUtils.isNotEmpty((CharSequence)operation.path) && operation.path.startsWith("/")) {
                    operation.path = operation.path.substring(1);
                }
                if (operation.allParams != null) {
                    Collections.sort(operation.allParams, (one, another) -> {
                        if (one.isPathParam && another.isQueryParam) {
                            return -1;
                        }
                        if (one.isQueryParam && another.isPathParam) {
                            return 1;
                        }
                        return 0;
                    });
                }
                if (!MULTIPLATFORM.equals(this.getLibrary()) || operation.allParams == null) continue;
                for (CodegenParameter param : operation.allParams) {
                    if (param.dataFormat == null || !param.dataFormat.equals("binary")) continue;
                    param.dataType = "io.ktor.client.request.forms.InputProvider";
                    param.baseType = "io.ktor.client.request.forms.InputProvider";
                }
            }
        }
        return operations;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        if (firstType != null) {
            return "multipart/form-data".equals(firstType.get("mediaType"));
        }
        return false;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f      #");
        System.out.println("################################################################################");
    }

    public static enum CollectionType {
        ARRAY("array"),
        LIST("list");

        public final String value;

        private CollectionType(String value) {
            this.value = value;
        }
    }

    public static enum RequestDateConverter {
        TO_STRING("toString"),
        TO_JSON("toJson");

        public final String value;

        private RequestDateConverter(String value) {
            this.value = value;
        }
    }

    public static enum DateLibrary {
        STRING("string"),
        THREETENBP("threetenbp"),
        THREETENBP_LOCALDATETIME("threetenbp-localdatetime"),
        JAVA8("java8"),
        JAVA8_LOCALDATETIME("java8-localdatetime");

        public final String value;

        private DateLibrary(String value) {
            this.value = value;
        }
    }
}

