/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.joda.time.DateTime;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.templating.mustache.EscapeChar;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJuliaCodegen
extends DefaultCodegen {
    protected final Logger LOGGER = LoggerFactory.getLogger(AbstractJuliaCodegen.class);
    protected String srcPath = "src";
    protected String apiSrcPath = this.srcPath + "/apis/";
    protected String modelSrcPath = this.srcPath + "/models/";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String packageName;
    protected Boolean exportModels;
    protected Boolean exportOperations;
    protected final DateTimeFormatter OFFSET_DATE_TIME_FORMAT = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    protected final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
    protected final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);

    public AbstractJuliaCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Union, SchemaSupportFeature.allOf, SchemaSupportFeature.anyOf, SchemaSupportFeature.oneOf}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.XML}).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken)).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Callbacks, GlobalFeature.Examples, GlobalFeature.Produces, GlobalFeature.Consumes}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.reservedWords = new HashSet<String>(Arrays.asList("if", "else", "elseif", "while", "for", "begin", "end", "quote", "try", "catch", "return", "local", "function", "macro", "ccall", "finally", "break", "continue", "global", "module", "using", "import", "export", "const", "let", "do", "baremodule", "Type", "Enum", "Any", "DataType", "Base"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Integer", "Int128", "Int64", "Int32", "Int16", "Int8", "UInt128", "UInt64", "UInt32", "UInt16", "UInt8", "Float64", "Float32", "Float16", "Char", "Vector", "Dict", "Vector{UInt8}", "Bool", "String", "Date", "DateTime", "ZonedDateTime", "Nothing", "Any"));
        this.typeMapping.clear();
        this.typeMapping.put("int", "Int64");
        this.typeMapping.put("integer", "Int64");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("short", "Int32");
        this.typeMapping.put("byte", "UInt8");
        this.typeMapping.put("float", "Float32");
        this.typeMapping.put("double", "Float64");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("binary", "Vector{UInt8}");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("number", "Float64");
        this.typeMapping.put("decimal", "Float64");
        this.typeMapping.put("array", "Vector");
        this.typeMapping.put("set", "Vector");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "ZonedDateTime");
        this.typeMapping.put("File", "String");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("ByteArray", "Vector{UInt8}");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("Object", "Any");
        this.typeMapping.put("AnyType", "Any");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.JULIA;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setExportModels(Boolean exportModels) {
        this.exportModels = exportModels;
    }

    public void setExportOperations(Boolean exportOperations) {
        this.exportOperations = exportOperations;
    }

    protected static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWords.contains(name)) {
            return "__" + name + "__";
        }
        return name;
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/" + this.modelSrcPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/" + this.apiSrcPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelFilename(String name) {
        return "model_" + this.toModelName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return "api_" + StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        name = this.toVarName(name);
        CamelizeOption camelizeOption = CamelizeOption.UPPERCASE_FIRST_CHAR;
        name = StringUtils.camelize(this.sanitizeName(name), camelizeOption);
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        return this.escapeReservedWord(name);
    }

    @Override
    public String toApiVarName(String name) {
        CamelizeOption camelizeOption = CamelizeOption.UPPERCASE_FIRST_CHAR;
        name = StringUtils.camelize(this.sanitizeName(name), camelizeOption);
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        return this.escapeReservedWord(name);
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        return name;
    }

    @Override
    public String sanitizeName(String name) {
        if (name == null) {
            this.LOGGER.error("String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        name = name.replaceAll("/", "_");
        return name.replaceAll("[^a-zA-Z0-9_{}]", "");
    }

    protected boolean needsVarEscape(String name) {
        return !name.matches("[a-zA-Z0-9_]*") && !name.matches("var\".*\"") || this.reservedWords.contains(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        Object result = this.sanitizeName(name);
        if (this.isReservedWord((String)(result = ((String)result).replaceAll("$", "")))) {
            this.LOGGER.warn((String)result + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + (String)result));
            result = "model_" + (String)result;
        }
        if (((String)result).matches("^\\d.*")) {
            this.LOGGER.warn((String)result + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + (String)result));
            result = "model_" + (String)result;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            result = this.modelNamePrefix + "_" + (String)result;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            result = (String)result + "_" + this.modelNameSuffix;
        }
        result = AbstractJuliaCodegen.dropDots((String)result);
        result = StringUtils.camelize((String)result);
        return result;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (ModelUtils.isArraySchema(schema)) {
            Schema<?> inner = ModelUtils.getSchemaItems(schema);
            return this.getSchemaType(schema) + "{" + this.getTypeDeclaration(inner) + "}";
        }
        if (ModelUtils.isSet(schema)) {
            Schema inner = ModelUtils.getAdditionalProperties(schema);
            return this.getSchemaType(schema) + "{" + this.getTypeDeclaration(inner) + "}";
        }
        if (ModelUtils.isMapSchema(schema)) {
            Schema inner = ModelUtils.getAdditionalProperties(schema);
            return this.getSchemaType(schema) + "{String, " + this.getTypeDeclaration(inner) + "}";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = super.getSchemaType(schema);
        String type = null;
        if (openAPIType == null) {
            this.LOGGER.error("OpenAPI Type for {} is null. Default to Object instead.", (Object)schema.getName());
            openAPIType = "Object";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            if (ModelUtils.isBooleanSchema(schema)) {
                return schema.getDefault().toString();
            }
            if (ModelUtils.isDateSchema(schema)) {
                Object _default_obj = schema.getDefault();
                String _default = _default_obj instanceof Date ? this.DATE_FORMAT.format(_default_obj) : _default_obj.toString();
                return "OpenAPI.str2date(\"" + _default + "\")";
            }
            if (ModelUtils.isDateTimeSchema(schema)) {
                Object _default_obj = schema.getDefault();
                String _default = _default_obj instanceof DateTime ? this.DATE_TIME_FORMAT.format((DateTime)_default_obj) : (_default_obj instanceof OffsetDateTime ? this.OFFSET_DATE_TIME_FORMAT.format((OffsetDateTime)_default_obj) : _default_obj.toString());
                return "OpenAPI.str2zoneddatetime(\"" + _default + "\")";
            }
            if (ModelUtils.isIntegerSchema(schema) || ModelUtils.isLongSchema(schema) || ModelUtils.isNumberSchema(schema)) {
                return schema.getDefault().toString();
            }
            if (ModelUtils.isStringSchema(schema)) {
                String _default = String.valueOf(schema.getDefault());
                return "\"" + _default + "\"";
            }
        }
        return "nothing";
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("#=", "#_=").replace("=#", "=_#");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "\\\"");
    }

    protected String escapeRegex(String pattern) {
        pattern = pattern.replaceAll("\\\\\\\\", "\\\\");
        pattern = pattern.replaceAll("^/", "");
        pattern = pattern.replaceAll("/$", "");
        return pattern;
    }

    @Override
    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(param, imports);
        if (parameter.pattern != null) {
            parameter.pattern = this.escapeRegex(parameter.pattern);
        }
        return parameter;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema schema, boolean required) {
        CodegenProperty property = super.fromProperty(name, schema, required);
        if (this.needsVarEscape(property.name)) {
            property.name = "var\"" + property.name + "\"";
        }
        if (property.pattern != null) {
            property.pattern = this.escapeRegex(property.pattern);
        }
        return property;
    }

    @Override
    public String toOperationId(String operationId) {
        CamelizeOption camelizeOption = CamelizeOption.UPPERCASE_FIRST_CHAR;
        operationId = StringUtils.camelize(super.toOperationId(operationId), camelizeOption);
        operationId = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, operationId);
        return this.sanitizeName(operationId);
    }

    private void changeParamNames(List<CodegenParameter> paramsList, HashSet<String> reservedNames) {
        for (CodegenParameter param : paramsList) {
            if (!reservedNames.contains(param.paramName)) continue;
            do {
                param.paramName = param.paramName + "_";
            } while (reservedNames.contains(param.paramName + "param"));
            param.paramName = param.paramName + "param";
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        HashSet<String> reservedNames = new HashSet<String>();
        reservedNames.add(op.returnType);
        reservedNames.add(op.operationId);
        for (CodegenParameter param : op.allParams) {
            reservedNames.add(param.dataType);
        }
        this.changeParamNames(op.allParams, reservedNames);
        this.changeParamNames(op.bodyParams, reservedNames);
        this.changeParamNames(op.headerParams, reservedNames);
        this.changeParamNames(op.pathParams, reservedNames);
        this.changeParamNames(op.queryParams, reservedNames);
        this.changeParamNames(op.formParams, reservedNames);
        return op;
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"escapeDollar", (Object)new EscapeChar("(?<!\\\\)\\$", "\\\\\\$"));
    }
}

