/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;

public class CppRestSdkClientCodegen
extends AbstractCppCodegen {
    public static final String DECLSPEC = "declspec";
    public static final String DEFAULT_INCLUDE = "defaultInclude";
    public static final String GENERATE_GMOCKS_FOR_APIS = "generateGMocksForApis";
    public static final String DEFAULT_PACKAGE_NAME = "CppRestOpenAPIClient";
    protected String packageName = "";
    protected String packageVersion = "1.0.0";
    protected String declspec = "";
    protected String defaultInclude = "";
    protected String apiDirName = "api";
    protected String modelDirName = "model";
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-restsdk";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API client with C++ REST SDK (https://github.com/Microsoft/cpprestsdk).";
    }

    public CppRestSdkClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeDataTypeFeatures(new DataTypeFeature[]{DataTypeFeature.AnyType}));
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.templateDir = "cpp-rest-sdk-client";
        this.embeddedTemplateDir = "cpp-rest-sdk-client";
        this.cliOptions.clear();
        this.addOption("packageName", "C++ package (library) name.", DEFAULT_PACKAGE_NAME);
        this.addOption("modelPackage", "C++ namespace for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "C++ namespace for apis (convention: name.space.api).", this.apiPackage);
        this.addOption("packageVersion", "C++ package version.", this.packageVersion);
        this.addOption(DECLSPEC, "C++ preprocessor to place before the class name for handling dllexport/dllimport.", this.declspec);
        this.addOption(DEFAULT_INCLUDE, "The default include statement that should be placed in all headers for including things like the declspec (convention: #include \"Commons.h\" ", this.defaultInclude);
        this.addOption(GENERATE_GMOCKS_FOR_APIS, "Generate Google Mock classes for APIs.", null);
        this.addOption("reservedWordPrefix", "Prefix to prepend to reserved words in order to avoid conflicts", this.reservedWordPrefix);
        this.addOption("variableNameFirstCharacterUppercase", "Make first character of variable name uppercase (eg. value -> Value)", Boolean.toString(this.variableNameFirstCharacterUppercase));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "utility::datetime");
        this.typeMapping.put("DateTime", "utility::datetime");
        this.typeMapping.put("string", "utility::string_t");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("set", "std::set");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "HttpContent");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "HttpContent");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "utility::string_t");
        this.typeMapping.put("URI", "utility::string_t");
        this.typeMapping.put("ByteArray", "utility::string_t");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::set", "#include <set>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("HttpContent", "#include \"HttpContent.h\"");
        this.importMapping.put("Object", "#include \"Object.h\"");
        this.importMapping.put("AnyType", "#include \"AnyType.h\"");
        this.importMapping.put("utility::string_t", "#include <cpprest/details/basic_types.h>");
        this.importMapping.put("utility::datetime", "#include <cpprest/details/basic_types.h>");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.packageName = this.additionalProperties.getOrDefault("packageName", DEFAULT_PACKAGE_NAME);
        if (this.additionalProperties.containsKey(DECLSPEC)) {
            this.declspec = this.additionalProperties.get(DECLSPEC).toString();
        }
        if (this.additionalProperties.containsKey(DEFAULT_INCLUDE)) {
            this.defaultInclude = this.additionalProperties.get(DEFAULT_INCLUDE).toString();
        }
        if (this.additionalProperties.containsKey("reservedWordPrefix")) {
            this.reservedWordPrefix = (String)this.additionalProperties.get("reservedWordPrefix");
        }
        if (this.convertPropertyToBoolean(GENERATE_GMOCKS_FOR_APIS)) {
            this.apiTemplateFiles.put("api-gmock.mustache", "GMock.h");
            this.additionalProperties.put("gmockApis", "true");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("modelHeaderGuardPrefix", this.modelPackage.replaceAll("\\.", "_").toUpperCase(Locale.ROOT));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiHeaderGuardPrefix", this.apiPackage.replaceAll("\\.", "_").toUpperCase(Locale.ROOT));
        this.additionalProperties.put(DECLSPEC, this.declspec);
        this.additionalProperties.put(DEFAULT_INCLUDE, this.defaultInclude);
        this.additionalProperties.put("reservedWordPrefix", this.reservedWordPrefix);
        this.importMapping.put("HttpContent", "#include \"" + this.packageName + "/HttpContent.h\"");
        this.importMapping.put("Object", "#include \"" + this.packageName + "/Object.h\"");
        this.importMapping.put("AnyType", "#include \"" + this.packageName + "/AnyType.h\"");
        this.supportingFiles.add(new SupportingFile("modelbase-header.mustache", this.getHeaderFolder(), "ModelBase.h"));
        this.supportingFiles.add(new SupportingFile("modelbase-source.mustache", this.getSourceFolder(), "ModelBase.cpp"));
        this.supportingFiles.add(new SupportingFile("object-header.mustache", this.getHeaderFolder(), "Object.h"));
        this.supportingFiles.add(new SupportingFile("object-source.mustache", this.getSourceFolder(), "Object.cpp"));
        this.supportingFiles.add(new SupportingFile("anytype-header.mustache", this.getHeaderFolder(), "AnyType.h"));
        this.supportingFiles.add(new SupportingFile("anytype-source.mustache", this.getSourceFolder(), "AnyType.cpp"));
        this.supportingFiles.add(new SupportingFile("apiclient-header.mustache", this.getHeaderFolder(), "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("apiclient-source.mustache", this.getSourceFolder(), "ApiClient.cpp"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-header.mustache", this.getHeaderFolder(), "ApiConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-source.mustache", this.getSourceFolder(), "ApiConfiguration.cpp"));
        this.supportingFiles.add(new SupportingFile("apiexception-header.mustache", this.getHeaderFolder(), "ApiException.h"));
        this.supportingFiles.add(new SupportingFile("apiexception-source.mustache", this.getSourceFolder(), "ApiException.cpp"));
        this.supportingFiles.add(new SupportingFile("ihttpbody-header.mustache", this.getHeaderFolder(), "IHttpBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-header.mustache", this.getHeaderFolder(), "JsonBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-source.mustache", this.getSourceFolder(), "JsonBody.cpp"));
        this.supportingFiles.add(new SupportingFile("httpcontent-header.mustache", this.getHeaderFolder(), "HttpContent.h"));
        this.supportingFiles.add(new SupportingFile("httpcontent-source.mustache", this.getSourceFolder(), "HttpContent.cpp"));
        this.supportingFiles.add(new SupportingFile("multipart-header.mustache", this.getHeaderFolder(), "MultipartFormData.h"));
        this.supportingFiles.add(new SupportingFile("multipart-source.mustache", this.getSourceFolder(), "MultipartFormData.cpp"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("cmake-lists.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("cmake-config.mustache", "", "Config.cmake.in"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    protected String getHeaderFolder() {
        return "include/" + this.packageName;
    }

    protected String getSourceFolder() {
        return "src";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        String targetOutDir = suffix.equals(".h") ? this.getHeaderFolder() : this.getSourceFolder();
        return this.outputFolder + "/" + targetOutDir + "/" + this.apiDirName + "/" + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String modelFilename(String templateName, String modelName) {
        String suffix = this.modelTemplateFiles().get(templateName);
        String targetOutDir = suffix.equals(".h") ? this.getHeaderFolder() : this.getSourceFolder();
        return this.outputFolder + "/" + targetOutDir + "/" + this.modelDirName + "/" + this.toModelFilename(modelName) + suffix;
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + this.packageName + "/" + this.modelDirName + "/" + this.toModelFilename(name) + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        ApiResponse methodResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null) {
            Schema response = ModelUtils.getSchemaFromResponse(this.openAPI, methodResponse);
            if ((response = this.unaliasSchema(response)) != null) {
                CodegenProperty cm = this.fromProperty("response", response, false);
                op.vendorExtensions.put("x-codegen-response", cm);
                if ("std::shared_ptr<HttpContent>".equals(cm.dataType)) {
                    op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
                }
            }
        }
        return op;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.isFileSchema(property)) {
            property.vendorExtensions.put("x-codegen-file", true);
        }
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        block0: for (CodegenOperation op : operationList) {
            for (String hdr : op.imports) {
                if (this.importMapping.containsKey(hdr)) continue;
                operations.put("hasModelImport", true);
                continue block0;
            }
        }
        return objs;
    }

    protected boolean isFileSchema(CodegenProperty property) {
        return property.baseType.equals("HttpContent");
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<utility::string_t, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isFileSchema(p) || ModelUtils.isBinarySchema(p)) {
            return "std::shared_ptr<" + openAPIType + ">";
        }
        if (ModelUtils.isStringSchema(p) || ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return "std::shared_ptr<" + openAPIType + ">";
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "utility::datetime()";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "utility::datetime()";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (ModelUtils.isFloatSchema(p)) {
                return "0.0f";
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (ModelUtils.isLongSchema(p)) {
                return "0L";
            }
            return "0";
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "std::map<utility::string_t, " + inner + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            Object inner = this.getSchemaType(ModelUtils.getSchemaItems(p));
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + (String)inner + ">";
            }
            return "std::vector<" + (String)inner + ">()";
        }
        if (!StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return "new " + this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "utility::conversions::to_string_t(\"\")";
        }
        if (ModelUtils.isFreeFormObject(p)) {
            return "new Object()";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isString;
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = parameter.isPrimitiveType == Boolean.TRUE;
        boolean isArray = parameter.isArray == Boolean.TRUE;
        boolean isMap = parameter.isMap == Boolean.TRUE;
        boolean bl = isString = parameter.isString == Boolean.TRUE;
        if (!(isPrimitiveType || isArray || isMap || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> models) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, ModelsMap> models) {
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        if (child != null && child.vars != null && !child.vars.isEmpty()) {
            for (CodegenProperty childSchema : child.vars) {
                childPropertiesByName.put(childSchema.name, childSchema);
            }
        }
        if (parent != null && parent.vars != null && !parent.vars.isEmpty()) {
            for (CodegenProperty parentSchema : parent.vars) {
                CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(parentSchema.name);
                if (duplicatedByParent == null) continue;
                duplicatedByParent.isInherited = true;
            }
        }
    }
}

