/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import java.util.List;
import java.util.Objects;

public record ConjunctionExpression(MediaQuery left, MediaQuery right) implements MediaQuery
{
    public ConjunctionExpression {
        Objects.requireNonNull(mediaQuery, "left cannot be null");
        Objects.requireNonNull(mediaQuery2, "right cannot be null");
    }

    public static ConjunctionExpression of(List<MediaQuery> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        ConjunctionExpression conjunctionExpression = new ConjunctionExpression(list.get(0), list.get(1));
        for (int i = 2; i < list.size(); ++i) {
            conjunctionExpression = new ConjunctionExpression(conjunctionExpression, list.get(i));
        }
        return conjunctionExpression;
    }

    @Override
    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        return this.left.evaluate(mediaQueryContext) && this.right.evaluate(mediaQueryContext);
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.left) + " and " + String.valueOf(this.right) + ")";
    }
}

