/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.TextLine;
import com.sun.javafx.text.TextRun;

public class PrismTextLine
implements TextLine {
    private final TextRun[] runs;
    private final RectBounds bounds;
    private final int start;
    private final int length;
    private final float leading;
    private float lsb;
    private float rsb;

    public PrismTextLine(int n, int n2, TextRun[] textRunArray, float f, float f2, float f3, float f4) {
        this.start = n;
        this.length = n2;
        this.bounds = new RectBounds(0.0f, f2, f, f3 + f4);
        this.leading = f4;
        this.runs = textRunArray;
    }

    @Override
    public RectBounds getBounds() {
        return this.bounds;
    }

    public float getLeading() {
        return this.leading;
    }

    public TextRun[] getRuns() {
        return this.runs;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setSideBearings(float f, float f2) {
        this.lsb = f;
        this.rsb = f2;
    }

    @Override
    public float getLeftSideBearing() {
        return this.lsb;
    }

    @Override
    public float getRightSideBearing() {
        return this.rsb;
    }

    public void setAlignment(float f) {
        this.bounds.setMinX(f);
        this.bounds.setMaxX(f + this.bounds.getMaxX());
    }

    public void setWidth(float f) {
        this.bounds.setMaxX(this.bounds.getMinX() + f);
    }
}

