/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;

public class DefaultSelenium
implements Selenium {
    protected CommandProcessor commandProcessor;

    public DefaultSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this.commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browserStartCommand, browserURL);
    }

    public DefaultSelenium(CommandProcessor processor) {
        this.commandProcessor = processor;
    }

    public void start() {
        block2: {
            try {
                this.commandProcessor.start();
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("Connection refused: connect") == -1) break block2;
                throw new RuntimeException("Could not contact Selenium Server; have you started it?\n" + e.getMessage());
            }
        }
    }

    public void stop() {
        this.commandProcessor.stop();
    }

    public void click(String locator) {
        this.commandProcessor.doCommand("click", new String[]{locator});
    }

    public void fireEvent(String locator, String eventName) {
        this.commandProcessor.doCommand("fireEvent", new String[]{locator, eventName});
    }

    public void keyPress(String locator, String keycode) {
        this.commandProcessor.doCommand("keyPress", new String[]{locator, keycode});
    }

    public void keyDown(String locator, String keycode) {
        this.commandProcessor.doCommand("keyDown", new String[]{locator, keycode});
    }

    public void keyUp(String locator, String keycode) {
        this.commandProcessor.doCommand("keyUp", new String[]{locator, keycode});
    }

    public void mouseOver(String locator) {
        this.commandProcessor.doCommand("mouseOver", new String[]{locator});
    }

    public void mouseDown(String locator) {
        this.commandProcessor.doCommand("mouseDown", new String[]{locator});
    }

    public void type(String locator, String value) {
        this.commandProcessor.doCommand("type", new String[]{locator, value});
    }

    public void check(String locator) {
        this.commandProcessor.doCommand("check", new String[]{locator});
    }

    public void uncheck(String locator) {
        this.commandProcessor.doCommand("uncheck", new String[]{locator});
    }

    public void select(String selectLocator, String optionLocator) {
        this.commandProcessor.doCommand("select", new String[]{selectLocator, optionLocator});
    }

    public void addSelection(String locator, String optionLocator) {
        this.commandProcessor.doCommand("addSelection", new String[]{locator, optionLocator});
    }

    public void removeSelection(String locator, String optionLocator) {
        this.commandProcessor.doCommand("removeSelection", new String[]{locator, optionLocator});
    }

    public void submit(String formLocator) {
        this.commandProcessor.doCommand("submit", new String[]{formLocator});
    }

    public void open(String url) {
        this.commandProcessor.doCommand("open", new String[]{url});
    }

    public void selectWindow(String windowID) {
        this.commandProcessor.doCommand("selectWindow", new String[]{windowID});
    }

    public void waitForPopUp(String windowID, String timeout) {
        this.commandProcessor.doCommand("waitForPopUp", new String[]{windowID, timeout});
    }

    public void chooseCancelOnNextConfirmation() {
        this.commandProcessor.doCommand("chooseCancelOnNextConfirmation", new String[0]);
    }

    public void answerOnNextPrompt(String answer) {
        this.commandProcessor.doCommand("answerOnNextPrompt", new String[]{answer});
    }

    public void goBack() {
        this.commandProcessor.doCommand("goBack", new String[0]);
    }

    public void refresh() {
        this.commandProcessor.doCommand("refresh", new String[0]);
    }

    public void close() {
        this.commandProcessor.doCommand("close", new String[0]);
    }

    public boolean isAlertPresent() {
        return this.commandProcessor.getBoolean("isAlertPresent", new String[0]);
    }

    public boolean isPromptPresent() {
        return this.commandProcessor.getBoolean("isPromptPresent", new String[0]);
    }

    public boolean isConfirmationPresent() {
        return this.commandProcessor.getBoolean("isConfirmationPresent", new String[0]);
    }

    public String getAlert() {
        return this.commandProcessor.getString("getAlert", new String[0]);
    }

    public String getConfirmation() {
        return this.commandProcessor.getString("getConfirmation", new String[0]);
    }

    public String getPrompt() {
        return this.commandProcessor.getString("getPrompt", new String[0]);
    }

    public String getLocation() {
        return this.commandProcessor.getString("getLocation", new String[0]);
    }

    public String getTitle() {
        return this.commandProcessor.getString("getTitle", new String[0]);
    }

    public String getBodyText() {
        return this.commandProcessor.getString("getBodyText", new String[0]);
    }

    public String getValue(String locator) {
        return this.commandProcessor.getString("getValue", new String[]{locator});
    }

    public String getText(String locator) {
        return this.commandProcessor.getString("getText", new String[]{locator});
    }

    public String getEval(String script) {
        return this.commandProcessor.getString("getEval", new String[]{script});
    }

    public boolean isChecked(String locator) {
        return this.commandProcessor.getBoolean("isChecked", new String[]{locator});
    }

    public String getTable(String tableCellAddress) {
        return this.commandProcessor.getString("getTable", new String[]{tableCellAddress});
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedLabels", new String[]{selectLocator});
    }

    public String getSelectedLabel(String selectLocator) {
        return this.commandProcessor.getString("getSelectedLabel", new String[]{selectLocator});
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedValues", new String[]{selectLocator});
    }

    public String getSelectedValue(String selectLocator) {
        return this.commandProcessor.getString("getSelectedValue", new String[]{selectLocator});
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedIndexes", new String[]{selectLocator});
    }

    public String getSelectedIndex(String selectLocator) {
        return this.commandProcessor.getString("getSelectedIndex", new String[]{selectLocator});
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedIds", new String[]{selectLocator});
    }

    public String getSelectedId(String selectLocator) {
        return this.commandProcessor.getString("getSelectedId", new String[]{selectLocator});
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this.commandProcessor.getBoolean("isSomethingSelected", new String[]{selectLocator});
    }

    public String[] getSelectOptions(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectOptions", new String[]{selectLocator});
    }

    public String getAttribute(String attributeLocator) {
        return this.commandProcessor.getString("getAttribute", new String[]{attributeLocator});
    }

    public boolean isTextPresent(String pattern) {
        return this.commandProcessor.getBoolean("isTextPresent", new String[]{pattern});
    }

    public boolean isElementPresent(String locator) {
        return this.commandProcessor.getBoolean("isElementPresent", new String[]{locator});
    }

    public boolean isVisible(String locator) {
        return this.commandProcessor.getBoolean("isVisible", new String[]{locator});
    }

    public boolean isEditable(String locator) {
        return this.commandProcessor.getBoolean("isEditable", new String[]{locator});
    }

    public String[] getAllButtons() {
        return this.commandProcessor.getStringArray("getAllButtons", new String[0]);
    }

    public String[] getAllLinks() {
        return this.commandProcessor.getStringArray("getAllLinks", new String[0]);
    }

    public String[] getAllFields() {
        return this.commandProcessor.getStringArray("getAllFields", new String[0]);
    }

    public String getHtmlSource() {
        return this.commandProcessor.getString("getHtmlSource", new String[0]);
    }

    public void setCursorPosition(String locator, String position) {
        this.commandProcessor.doCommand("setCursorPosition", new String[]{locator, position});
    }

    public Number getCursorPosition(String locator) {
        return this.commandProcessor.getNumber("getCursorPosition", new String[]{locator});
    }

    public void setContext(String context, String logLevelThreshold) {
        this.commandProcessor.doCommand("setContext", new String[]{context, logLevelThreshold});
    }

    public String getExpression(String expression) {
        return this.commandProcessor.getString("getExpression", new String[]{expression});
    }

    public void waitForCondition(String script, String timeout) {
        this.commandProcessor.doCommand("waitForCondition", new String[]{script, timeout});
    }

    public void setTimeout(String timeout) {
        this.commandProcessor.doCommand("setTimeout", new String[]{timeout});
    }

    public void waitForPageToLoad(String timeout) {
        this.commandProcessor.doCommand("waitForPageToLoad", new String[]{timeout});
    }
}

