/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

public abstract class Wait {
    public long timeoutInMilliseconds = 30000L;
    public long intervalInMilliseconds = 500L;

    public Wait(String message) {
        this.wait(message);
    }

    public Wait(String message, long timeoutInMilliseconds) {
        this.wait(message);
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public Wait(String message, long timeoutInMilliseconds, long intervalInMilliseconds) {
        this.wait(message);
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.intervalInMilliseconds = intervalInMilliseconds;
    }

    abstract boolean until();

    public void wait(String message) {
        long start = System.currentTimeMillis();
        long end = start + this.timeoutInMilliseconds;
        while (System.currentTimeMillis() < end) {
            if (this.until()) {
                return;
            }
            try {
                Thread.sleep(this.intervalInMilliseconds);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new WaitTimedOutException(message);
    }

    public class WaitTimedOutException
    extends RuntimeException {
        public WaitTimedOutException() {
        }

        public WaitTimedOutException(String message, Throwable cause) {
            super(message, cause);
        }

        public WaitTimedOutException(String message) {
            super(message);
        }

        public WaitTimedOutException(Throwable cause) {
            super(cause);
        }
    }
}

