/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem {
    WINDOWS("win"){

        public String getLineEnding() {
            return "\r\n";
        }
    }
    ,
    MAC("mac"){

        public String getLineEnding() {
            return "\r";
        }
    }
    ,
    UNIX("x"){

        public String getLineEnding() {
            return "\n";
        }
    }
    ,
    ANY(null){

        public String getLineEnding() {
            throw new UnsupportedOperationException("getLineEnding");
        }
    };

    private static OperatingSystem currentOs;
    private final String partOfOsName;

    private OperatingSystem(String partOfOsName) {
        this.partOfOsName = partOfOsName;
    }

    public static OperatingSystem getCurrentPlatform() {
        if (currentOs != null) {
            return currentOs;
        }
        for (OperatingSystem os : OperatingSystem.values()) {
            if (!os.isCurrentPlatform()) continue;
            currentOs = os;
            return os;
        }
        currentOs = UNIX;
        return UNIX;
    }

    public abstract String getLineEnding();

    private boolean isCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(this.partOfOsName) != -1;
    }
}

