/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import org.openqa.selenium.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public enum OperatingSystem {
    WINDOWS(new String[]{"win"}){

        public String getLineEnding() {
            return "\r\n";
        }

        public Platform getPlatform() {
            return Platform.WINDOWS;
        }
    }
    ,
    MAC(new String[]{"mac", "darwin"}){

        public String getLineEnding() {
            return "\r";
        }

        public Platform getPlatform() {
            return Platform.MAC;
        }
    }
    ,
    UNIX(new String[]{"x"}){

        public String getLineEnding() {
            return "\n";
        }

        public Platform getPlatform() {
            return Platform.UNIX;
        }
    }
    ,
    ANY(new String[]{""}){

        public String getLineEnding() {
            throw new UnsupportedOperationException("getLineEnding");
        }

        public Platform getPlatform() {
            return Platform.ANY;
        }
    };

    private static OperatingSystem currentOs;
    private final String[] partOfOsName;

    private OperatingSystem(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
    }

    public static OperatingSystem getCurrentPlatform() {
        if (currentOs != null) {
            return currentOs;
        }
        OperatingSystem mostLikely = UNIX;
        String previousMatch = null;
        for (OperatingSystem os : OperatingSystem.values()) {
            for (String matcher : os.partOfOsName) {
                if ("".equals(matcher)) continue;
                if (os.isExactMatch(matcher)) {
                    currentOs = os;
                    return os;
                }
                if (!os.isCurrentPlatform(matcher) || !OperatingSystem.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        currentOs = mostLikely;
        return mostLikely;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        if (previous == null) {
            return true;
        }
        return matcher.length() >= previous.length();
    }

    public abstract String getLineEnding();

    public abstract Platform getPlatform();

    private boolean isCurrentPlatform(String matchAgainst) {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(matchAgainst) != -1;
    }

    private boolean isExactMatch(String matchAgainst) {
        String osName = System.getProperty("os.name").toLowerCase();
        return matchAgainst.equals(osName);
    }
}

