/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Platform {
    WINDOWS(new String[]{""}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP || compareWith == VISTA;
        }
    }
    ,
    XP(new String[]{"xp", "windows"}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP;
        }
    }
    ,
    VISTA(new String[]{"windows vista", "Windows Server 2008"}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == VISTA;
        }
    }
    ,
    MAC(new String[]{"mac", "darwin"}){

        public String getLineEnding() {
            return "\r";
        }
    }
    ,
    UNIX(new String[]{"linux", "solaris", "bsd"}){

        public String getLineEnding() {
            return "\n";
        }
    }
    ,
    ANY(new String[]{""}){

        public String getLineEnding() {
            throw new UnsupportedOperationException("getLineEnding");
        }

        public boolean is(Platform compareWith) {
            return true;
        }
    };

    private final String[] partOfOsName;

    private Platform(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
    }

    public static Platform getCurrent() {
        return Platform.extractFromSysProperty(System.getProperty("os.name"));
    }

    protected static Platform extractFromSysProperty(String osName) {
        osName = osName.toLowerCase();
        Platform mostLikely = UNIX;
        String previousMatch = null;
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if ("".equals(matcher)) continue;
                if (os.isExactMatch(osName, matcher)) {
                    return os;
                }
                if (!os.isCurrentPlatform(osName, matcher) || !Platform.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        return mostLikely;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        if (previous == null) {
            return true;
        }
        return matcher.length() >= previous.length();
    }

    public boolean is(Platform compareWith) {
        return this.equals((Object)compareWith);
    }

    public abstract String getLineEnding();

    private boolean isCurrentPlatform(String osName, String matchAgainst) {
        return osName.indexOf(matchAgainst) != -1;
    }

    private boolean isExactMatch(String osName, String matchAgainst) {
        return matchAgainst.equals(osName);
    }
}

