/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Cleanly;
import org.openqa.selenium.internal.OperatingSystem;

public class FirefoxBinary {
    private final File actualBinary;
    private Process process;

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File actualBinary) {
        this.actualBinary = this.locateFirefoxBinary(actualBinary);
    }

    public void startProfile(FirefoxProfile profile, String ... commandLineFlags) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.actualBinary.getAbsolutePath());
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.modifyLibraryPath(builder);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        builder.environment().put("XRE_PROFILE_PATH", profile.getProfileDir().getAbsolutePath());
        this.process = builder.start();
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.actualBinary.getAbsolutePath(), "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        this.process = builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            while (reader.readLine() != null) {
                this.sleep(100L);
            }
        }
        finally {
            reader.close();
        }
    }

    protected void modifyLibraryPath(ProcessBuilder builder) {
        String propertyName;
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        switch (os) {
            case MAC: {
                propertyName = "DYLD_LIBRARY_PATH";
                break;
            }
            case WINDOWS: {
                propertyName = "PATH";
                break;
            }
            default: {
                propertyName = "LD_LIBRARY_PATH";
            }
        }
        String libraryPath = System.getenv(propertyName);
        if (libraryPath == null) {
            libraryPath = "";
        }
        String firefoxLibraryPath = System.getProperty("webdriver.firefox.library.path", this.actualBinary.getParentFile().getAbsolutePath());
        libraryPath = firefoxLibraryPath + File.pathSeparator + libraryPath;
        builder.environment().put(propertyName, libraryPath);
    }

    protected File locateFirefoxBinary(File suggestedLocation) {
        if (suggestedLocation != null) {
            if (suggestedLocation.exists() && suggestedLocation.isFile()) {
                return suggestedLocation;
            }
            throw new RuntimeException("Given firefox binary location does not exist or is not a real file: " + suggestedLocation);
        }
        File binary = this.locateFirefoxBinaryFromSystemProperty();
        if (binary != null) {
            return binary;
        }
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        switch (os) {
            case WINDOWS: {
                String programFiles = System.getenv("PROGRAMFILES");
                if (programFiles == null) {
                    programFiles = "\\Program Files";
                }
                binary = new File(programFiles + "\\Mozilla Firefox\\firefox.exe");
                break;
            }
            case MAC: {
                binary = new File("/Applications/Firefox.app/Contents/MacOS/firefox");
                break;
            }
            default: {
                String name;
                String[] binaryNames;
                String[] arr$ = binaryNames = new String[]{"firefox3", "firefox2", "firefox"};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (binary = this.shellOutAndFindPathOfFirefox(name = arr$[i$])) == null; ++i$) {
                }
            }
        }
        if (binary == null) {
            throw new RuntimeException("Cannot find firefox binary in PATH. Make sure firefox is installed");
        }
        if (binary.exists()) {
            return binary;
        }
        throw new RuntimeException("Unable to locate firefox binary. Please check that it is installed in the default location, or the path given points to the firefox binary. I would have used: " + binary.getPath());
    }

    protected File locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists()) {
            return binary;
        }
        switch (OperatingSystem.getCurrentPlatform()) {
            case WINDOWS: {
                return null;
            }
            case MAC: {
                if (!binaryName.endsWith(".app")) {
                    binaryName = binaryName + ".app";
                }
                binaryName = binaryName + "/Contents/MacOS/firefox";
                return new File(binaryName);
            }
        }
        return this.shellOutAndFindPathOfFirefox(binaryName);
    }

    private File shellOutAndFindPathOfFirefox(String binaryName) {
        try {
            Process which = Runtime.getRuntime().exec(new String[]{"which", binaryName});
            String result = this.getNextLineOfOutputFrom(which);
            return result == null ? null : new File(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNextLineOfOutputFrom(Process process) {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = reader.readLine();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Cleanly.close(reader);
                throw throwable;
            }
        }
        Cleanly.close(reader);
        return string;
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void clean(FirefoxProfile profile) throws IOException {
        this.startProfile(profile, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (OperatingSystem.WINDOWS.equals((Object)OperatingSystem.getCurrentPlatform())) {
            while (profile.isRunning()) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning());
        }
    }
}

