/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.firefox.internal.Streams;

public class FirefoxBinary {
    private final StringBuffer stdOutBuffer = new StringBuffer();
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final Executable executable;
    private Process process;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    public void startProfile(FirefoxProfile profile, String ... commandLineFlags) throws IOException {
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profile.getProfileDir().getAbsolutePath());
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.executable.getPath());
        commands.add("--verbose");
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream();
        builder.environment().putAll(this.extraEnv);
        this.executable.setLibraryPath(builder, this.extraEnv);
        this.process = builder.start();
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.executable.getPath(), "--verbose", "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        this.process = builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException, IOException {
        String line;
        this.process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.stdOutBuffer.append(line).append("\n");
            this.sleep(100L);
        }
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        this.stdOutBuffer.append(new String(Streams.drainStream(this.process.getInputStream())));
        return this.stdOutBuffer.toString();
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void clean(FirefoxProfile profile) throws IOException {
        this.startProfile(profile, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            while (profile.isRunning()) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning());
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }
}

