/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpState;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.RenderedHtmlUnitDriverWebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName {
    private WebClient webClient;
    private WebWindow currentWindow;
    private Map<String, History> histories = new HashMap<String, History>();
    private boolean enableJavascript;
    private ProxyConfig proxyConfig;

    public HtmlUnitDriver(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
        this.webClient = this.newWebClient();
        this.webClient.addWebWindowListener(new WebWindowListener(){
            private boolean waitingToLoad;

            public void webWindowOpened(WebWindowEvent webWindowEvent) {
                this.waitingToLoad = true;
            }

            public void webWindowContentChanged(WebWindowEvent webWindowEvent) {
                WebWindow window = webWindowEvent.getWebWindow();
                if (this.waitingToLoad) {
                    this.waitingToLoad = false;
                    HtmlUnitDriver.this.webClient.setCurrentWindow(window);
                }
                String windowName = window.getName();
                History history = (History)HtmlUnitDriver.this.histories.get(windowName);
                if (history == null) {
                    history = new History(window);
                    HtmlUnitDriver.this.histories.put(windowName, history);
                }
                history.addNewPage(webWindowEvent.getNewPage());
            }

            public void webWindowClosed(WebWindowEvent webWindowEvent) {
                WebWindow window = webWindowEvent.getWebWindow();
                String windowName = window.getName();
                HtmlUnitDriver.this.histories.remove(windowName);
                HtmlUnitDriver.this.pickWindow();
            }
        });
    }

    public HtmlUnitDriver() {
        this(false);
    }

    private HtmlUnitDriver(boolean enableJavascript, WebWindow currentWindow) {
        this(enableJavascript);
        this.currentWindow = currentWindow;
    }

    @Deprecated
    protected WebClient newWebClient() {
        WebClient client = new WebClient();
        client.setThrowExceptionOnFailingStatusCode(false);
        client.setPrintContentOnFailingStatusCode(false);
        client.setJavaScriptEnabled(this.enableJavascript);
        client.setRedirectEnabled(true);
        try {
            client.setUseInsecureSSL(true);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if (this.proxyConfig != null) {
            client.setProxyConfig(this.proxyConfig);
        }
        return this.modifyWebClient(client);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public void setProxy(String host, int port) {
        this.proxyConfig = new ProxyConfig(host, port);
        this.webClient.setProxyConfig(this.proxyConfig);
    }

    public void get(String url) {
        try {
            URL fullUrl = new URL(url);
            this.webClient.getPage(fullUrl);
        }
        catch (UnknownHostException e) {
        }
        catch (ConnectException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pickWindow();
    }

    protected void pickWindow() {
        FrameWindow frame;
        this.currentWindow = this.webClient.getCurrentWindow();
        Page page = this.webClient.getCurrentWindow().getEnclosedPage();
        if (page == null) {
            return;
        }
        if (((HtmlPage)page).getFrames().size() > 0 && !((frame = (FrameWindow)((HtmlPage)page).getFrames().get(0)).getFrameElement() instanceof HtmlInlineFrame)) {
            this.switchTo().frame(0);
        }
    }

    public String getCurrentUrl() {
        return this.lastPage().getWebResponse().getUrl().toString();
    }

    public String getTitle() {
        HtmlPage htmlPage = this.lastPage();
        if (htmlPage == null) {
            return null;
        }
        return htmlPage.getTitleText();
    }

    public boolean getVisible() {
        return false;
    }

    public void setVisible(boolean visible) {
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getPageSource() {
        WebResponse webResponse = this.lastPage().getWebResponse();
        return webResponse.getContentAsString();
    }

    public void close() {
        this.webClient = this.newWebClient();
    }

    public void quit() {
        this.webClient = null;
        this.currentWindow = null;
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Object[] parameters = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof HtmlUnitWebElement || args[i] instanceof Number || args[i] instanceof String || args[i] instanceof Boolean)) {
                throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + args[i] + " (" + args[i].getClass() + ")");
            }
            if (args[i] instanceof HtmlUnitWebElement) {
                HtmlElement element = ((HtmlUnitWebElement)args[i]).getElement();
                parameters[i] = element.getScriptObject();
                continue;
            }
            parameters[i] = args[i];
        }
        script = "function() {" + script + "};";
        ScriptResult result = this.lastPage().executeJavaScript(script);
        Function func = (Function)result.getJavaScriptResult();
        result = this.lastPage().executeJavaScriptFunctionIfPossible(func, (Scriptable)((ScriptableObject)this.currentWindow.getScriptObject()), parameters, (DomNode)this.lastPage().getDocumentElement());
        Object value = result.getJavaScriptResult();
        if (value instanceof HTMLElement) {
            return new HtmlUnitWebElement(this, ((HTMLElement)value).getHtmlElementOrDie());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return result.getJavaScriptResult();
    }

    public WebDriver.TargetLocator switchTo() {
        return new HtmlUnitTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    private synchronized HtmlPage lastPage() {
        return (HtmlPage)this.currentWindow.getEnclosedPage();
    }

    public WebElement findElementByLinkText(String selector) {
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        List anchors = this.lastPage().getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText())) continue;
            return this.newHtmlUnitWebElement((HtmlElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + expectedText);
    }

    protected WebElement newHtmlUnitWebElement(HtmlElement element) {
        if (this.isJavascriptEnabled()) {
            return new RenderedHtmlUnitDriverWebElement(this, element);
        }
        return new HtmlUnitWebElement(this, element);
    }

    public List<WebElement> findElementsByLinkText(String selector) {
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        List anchors = this.lastPage().getAnchors();
        Iterator allAnchors = anchors.iterator();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        while (allAnchors.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)allAnchors.next();
            if (!expectedText.equals(anchor.asText())) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)anchor));
        }
        return elements;
    }

    public WebElement findElementById(String id) {
        try {
            HtmlElement element = this.lastPage().getHtmlElementById(id);
            return this.newHtmlUnitWebElement(element);
        }
        catch (ElementNotFoundException e) {
            throw new NoSuchElementException("Cannot find element with ID: " + id);
        }
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath("//*[@id='" + id + "']");
    }

    public WebElement findElementByName(String name) {
        List allElements = this.lastPage().getHtmlElementsByName(name);
        if (allElements.size() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.get(0));
        }
        throw new NoSuchElementException("Cannot find element with name: " + name);
    }

    public List<WebElement> findElementsByName(String using) {
        List allElements = this.lastPage().getHtmlElementsByName(using);
        return this.convertRawHtmlElementsToWebElements(allElements);
    }

    public WebElement findElementByXPath(String selector) {
        Object node = this.lastPage().getFirstByXPath(selector);
        if (node == null) {
            throw new NoSuchElementException("Cannot locate a node using " + selector);
        }
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new NoSuchElementException(String.format("Cannot find element with xpath %s", selector));
    }

    public List<WebElement> findElementsByXPath(String selector) {
        List nodes = this.lastPage().getByXPath(selector);
        return this.convertRawHtmlElementsToWebElements(nodes);
    }

    private List<WebElement> convertRawHtmlElementsToWebElements(List<?> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object node : nodes) {
            if (!(node instanceof HtmlElement)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)node));
        }
        return elements;
    }

    public boolean isJavascriptEnabled() {
        return this.webClient.isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
        this.webClient.setJavaScriptEnabled(enableJavascript);
    }

    protected WebDriver findActiveWindow() {
        FrameWindow frame;
        WebWindow window = this.webClient.getCurrentWindow();
        HtmlPage page = (HtmlPage)window.getEnclosedPage();
        if (page != null && page.getFrames().size() > 0 && !((frame = (FrameWindow)page.getFrames().get(0)).getFrameElement() instanceof HtmlInlineFrame)) {
            return new HtmlUnitDriver(this.isJavascriptEnabled(), (WebWindow)frame);
        }
        if (this.currentWindow != null && this.currentWindow.equals(window)) {
            return this;
        }
        return new HtmlUnitDriver(this.isJavascriptEnabled(), window);
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public WebDriver.Options manage() {
        return new HtmlUnitOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlUnitDriverIterator
    implements Iterator<WebDriver> {
        private Iterator<WebWindow> underlyingIterator;

        public HtmlUnitDriverIterator() {
            ArrayList<WebWindow> allWindows = new ArrayList<WebWindow>();
            for (WebWindow window : HtmlUnitDriver.this.webClient.getWebWindows()) {
                WebWindow top = window.getTopWindow();
                if (allWindows.contains(top)) continue;
                allWindows.add(top);
            }
            this.underlyingIterator = allWindows.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        @Override
        public WebDriver next() {
            WebWindow window = this.underlyingIterator.next();
            return new HtmlUnitDriver(HtmlUnitDriver.this.isJavascriptEnabled(), window);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlUnitOptions
    implements WebDriver.Options {
        private HttpState state;

        HtmlUnitOptions() {
            this.state = HtmlUnitDriver.this.webClient.getWebConnection().getState();
        }

        public void addCookie(Cookie cookie) {
            String domain = this.getDomainForCookie(cookie);
            this.state.addCookie(new org.apache.commons.httpclient.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
        }

        public void deleteCookieNamed(String name) {
            this.state.addCookie(new org.apache.commons.httpclient.Cookie(this.getHostName(), name, "", "/", new Date(0L), false));
            this.state.addCookie(new org.apache.commons.httpclient.Cookie("", name, "", "/", new Date(0L), false));
        }

        public void deleteCookie(Cookie cookie) {
            String domain = this.getDomainForCookie(cookie);
            this.state.addCookie(new org.apache.commons.httpclient.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), new Date(0L), cookie.isSecure()));
        }

        public void deleteAllCookies() {
            this.state.clearCookies();
        }

        public Set<Cookie> getCookies() {
            HttpState state = HtmlUnitDriver.this.webClient.getWebConnection().getState();
            org.apache.commons.httpclient.Cookie[] rawCookies = state.getCookies();
            HashSet<Cookie> retCookies = new HashSet<Cookie>();
            for (org.apache.commons.httpclient.Cookie c : rawCookies) {
                if (!"".equals(c.getDomain()) && this.getHostName().indexOf(c.getDomain()) == -1 || c.getPath() == null || !this.getPath().startsWith(c.getPath())) continue;
                retCookies.add((Cookie)new ReturnedCookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.getSecure()));
            }
            return retCookies;
        }

        private String getHostName() {
            return HtmlUnitDriver.this.lastPage().getWebResponse().getUrl().getHost().toLowerCase();
        }

        private String getPath() {
            return HtmlUnitDriver.this.lastPage().getWebResponse().getUrl().getPath();
        }

        public Speed getSpeed() {
            throw new UnsupportedOperationException();
        }

        public void setSpeed(Speed speed) {
            throw new UnsupportedOperationException();
        }

        private String getDomainForCookie(Cookie cookie) {
            URL current = HtmlUnitDriver.this.lastPage().getWebResponse().getUrl();
            String hostName = cookie.getDomain();
            if (hostName == null || "".equals(hostName)) {
                hostName = String.format("%s:%s", current.getHost(), current.getPort());
            }
            return hostName;
        }
    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            String windowName = HtmlUnitDriver.this.currentWindow.getName();
            History history = (History)HtmlUnitDriver.this.histories.get(windowName);
            history.goBack();
        }

        public void forward() {
            String windowName = HtmlUnitDriver.this.currentWindow.getName();
            History history = (History)HtmlUnitDriver.this.histories.get(windowName);
            history.goForward();
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }
    }

    private class History {
        private final WebWindow window;
        private List<Page> history = new ArrayList<Page>();
        private int index = -1;

        private History(WebWindow window) {
            this.window = window;
        }

        public void addNewPage(Page newPage) {
            ++this.index;
            while (this.history.size() > this.index) {
                this.history.remove(this.index);
            }
            this.history.add(newPage);
        }

        public void goBack() {
            if (this.index > 0) {
                --this.index;
                this.window.setEnclosedPage(this.history.get(this.index));
            }
        }

        public void goForward() {
            if (this.index < this.history.size() - 1) {
                ++this.index;
                this.window.setEnclosedPage(this.history.get(this.index));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlUnitTargetLocator
    implements WebDriver.TargetLocator {
        private HtmlUnitTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            HtmlPage page = (HtmlPage)HtmlUnitDriver.this.webClient.getCurrentWindow().getEnclosedPage();
            try {
                HtmlUnitDriver.this.currentWindow = (WebWindow)page.getFrames().get(frameIndex);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchFrameException("Cannot find frame: " + frameIndex);
            }
            return HtmlUnitDriver.this;
        }

        public WebDriver frame(String name) {
            String[] names;
            HtmlPage page = (HtmlPage)HtmlUnitDriver.this.webClient.getCurrentWindow().getEnclosedPage();
            WebWindow window = HtmlUnitDriver.this.webClient.getCurrentWindow();
            for (String frameName : names = name.split("\\.")) {
                try {
                    int index = Integer.parseInt(frameName);
                    window = (WebWindow)page.getFrames().get(index);
                }
                catch (NumberFormatException e) {
                    window = null;
                    for (FrameWindow frame : page.getFrames()) {
                        FrameWindow frameWindow = frame;
                        if (frameName.equals(frameWindow.getFrameElement().getId())) {
                            window = frameWindow;
                            break;
                        }
                        if (!frameName.equals(frameWindow.getName())) continue;
                        window = frameWindow;
                        break;
                    }
                    if (window == null) {
                        throw new NoSuchFrameException("Cannot find frame: " + name);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchFrameException("Cannot find frame: " + name);
                }
                page = (HtmlPage)window.getEnclosedPage();
            }
            HtmlUnitDriver.this.currentWindow = window;
            return HtmlUnitDriver.this;
        }

        public WebDriver window(String windowId) {
            WebWindow window = HtmlUnitDriver.this.webClient.getWebWindowByName(windowId);
            HtmlUnitDriver.this.webClient.setCurrentWindow(window);
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        public Iterable<WebDriver> windowIterable() {
            return new Iterable<WebDriver>(){

                @Override
                public Iterator<WebDriver> iterator() {
                    return new HtmlUnitDriverIterator();
                }
            };
        }

        public WebDriver defaultContent() {
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        public WebElement activeElement() {
            List allBodies;
            HtmlElement element;
            Page page = HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            if (page instanceof HtmlPage && (element = ((HtmlPage)page).getFocusedElement()) == null && (allBodies = ((HtmlPage)page).getDocumentElement().getHtmlElementsByTagName("body")).size() > 0) {
                return HtmlUnitDriver.this.newHtmlUnitWebElement((HtmlElement)allBodies.get(0));
            }
            throw new NoSuchElementException("Unable to locate element with focus or body tag");
        }

        public Alert alert() {
            return null;
        }
    }
}

