/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.Wait;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.AltLookupStrategy;
import org.openqa.selenium.internal.ClassLookupStrategy;
import org.openqa.selenium.internal.DomTraversalLookupStrategy;
import org.openqa.selenium.internal.ExactTextMatchingStrategy;
import org.openqa.selenium.internal.GlobTextMatchingStrategy;
import org.openqa.selenium.internal.IdLookupStrategy;
import org.openqa.selenium.internal.IdOptionSelectStrategy;
import org.openqa.selenium.internal.IdentifierLookupStrategy;
import org.openqa.selenium.internal.ImplicitLookupStrategy;
import org.openqa.selenium.internal.IndexOptionSelectStrategy;
import org.openqa.selenium.internal.LabelOptionSelectStrategy;
import org.openqa.selenium.internal.LinkLookupStrategy;
import org.openqa.selenium.internal.LookupStrategy;
import org.openqa.selenium.internal.NameLookupStrategy;
import org.openqa.selenium.internal.OptionSelectStrategy;
import org.openqa.selenium.internal.RegExTextMatchingStrategy;
import org.openqa.selenium.internal.TextMatchingStrategy;
import org.openqa.selenium.internal.ValueOptionSelectStrategy;
import org.openqa.selenium.internal.XPathLookupStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverBackedSelenium
implements Selenium {
    private static final Pattern STRATEGY_AND_VALUE_PATTERN = Pattern.compile("^(\\p{Alpha}+)=(.*)");
    private static final Pattern TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN = Pattern.compile("^(\\p{Alpha}+):(.*)");
    protected WebDriver driver;
    private final String baseUrl;
    private final Map<String, LookupStrategy> lookupStrategies = new HashMap<String, LookupStrategy>();
    private final Map<String, OptionSelectStrategy> optionSelectStrategies = new HashMap<String, OptionSelectStrategy>();
    private final Map<String, TextMatchingStrategy> textMatchingStrategies = new HashMap<String, TextMatchingStrategy>();
    private final Pattern NAME_VALUE_PAIR_PATTERN = Pattern.compile("([^\\s=\\[\\]\\(\\),\"\\/\\?@:;]+)=([^=\\[\\]\\(\\),\"\\/\\?@:;]*)");
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("max_age=(\\d+)");
    private static final Pattern PATH_PATTERN = Pattern.compile("path=([^\\s,]+)[,]?");
    private static final Pattern TABLE_PARTS = Pattern.compile("(.*)\\.(\\d+)\\.(\\d+)");
    private static final String injectableSelenium = "/org/openqa/selenium/internal/injectableSelenium.js";
    private static final String htmlUtils = "/org/openqa/selenium/internal/htmlutils.js";
    private boolean metaKeyDown;
    private boolean altKeyDown;
    private boolean controlKeyDown;
    private boolean shiftKeyDown;
    private String originalWindowHandle;
    private long timeout = 30000L;
    private TimeoutThread timeoutThread;

    public WebDriverBackedSelenium(WebDriver baseDriver, String baseUrl) {
        this.setUpElementFindingStrategies();
        this.setUpOptionFindingStrategies();
        this.setUpTextMatchingStrategies();
        this.driver = baseDriver;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.originalWindowHandle = this.driver.getWindowHandle();
    }

    private void stopTimeoutThreadIfExists() {
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
            this.timeoutThread = null;
        }
    }

    private void startTimeoutThread() {
        this.stopTimeoutThreadIfExists();
        this.timeoutThread = new TimeoutThread(Thread.currentThread(), this.timeout);
        this.timeoutThread.start();
    }

    private void setUpTextMatchingStrategies() {
        this.textMatchingStrategies.put("implicit", new GlobTextMatchingStrategy());
        this.textMatchingStrategies.put("glob", new GlobTextMatchingStrategy());
        this.textMatchingStrategies.put("regexp", new RegExTextMatchingStrategy());
        this.textMatchingStrategies.put("exact", new ExactTextMatchingStrategy());
    }

    private void setUpOptionFindingStrategies() {
        this.optionSelectStrategies.put("implicit", new LabelOptionSelectStrategy());
        this.optionSelectStrategies.put("id", new IdOptionSelectStrategy());
        this.optionSelectStrategies.put("index", new IndexOptionSelectStrategy());
        this.optionSelectStrategies.put("label", new LabelOptionSelectStrategy());
        this.optionSelectStrategies.put("value", new ValueOptionSelectStrategy());
    }

    private void setUpElementFindingStrategies() {
        this.lookupStrategies.put("alt", new AltLookupStrategy());
        this.lookupStrategies.put("class", new ClassLookupStrategy());
        this.lookupStrategies.put("id", new IdLookupStrategy());
        this.lookupStrategies.put("identifier", new IdentifierLookupStrategy());
        this.lookupStrategies.put("implicit", new ImplicitLookupStrategy());
        this.lookupStrategies.put("link", new LinkLookupStrategy());
        this.lookupStrategies.put("name", new NameLookupStrategy());
        this.lookupStrategies.put("xpath", new XPathLookupStrategy());
        this.lookupStrategies.put("dom", new DomTraversalLookupStrategy());
    }

    public void setExtensionJs(String s) {
        throw new UnsupportedOperationException("setExtensionJs");
    }

    public void start() {
    }

    public void start(String optionsString) {
    }

    public void start(Object optionsObject) {
    }

    public void stop() {
        this.driver.quit();
    }

    public void showContextualBanner() {
        throw new UnsupportedOperationException("showContextualBanner");
    }

    public void showContextualBanner(String className, String methodName) {
        throw new UnsupportedOperationException("showContextualBanner");
    }

    public void click(String locator) {
        WebElement element = this.findElement(locator);
        element.click();
    }

    public void doubleClick(String locator) {
        WebElement element = this.findElement(locator);
        element.click();
        element.click();
    }

    public void contextMenu(String locator) {
        throw new UnsupportedOperationException("contextMenu");
    }

    public void clickAt(String locator, String coordString) {
        throw new UnsupportedOperationException("clickAt");
    }

    public void doubleClickAt(String locator, String coordString) {
        throw new UnsupportedOperationException("doubleClickAt");
    }

    public void contextMenuAt(String locator, String coordString) {
        throw new UnsupportedOperationException("contextMenuAt");
    }

    public void fireEvent(String locator, String eventName) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("doFireEvent", element, eventName);
    }

    public void focus(String locator) {
        this.fireEvent(locator, "focus");
    }

    public void keyPress(String locator, String keySequence) {
        this.typeKeys(locator, keySequence);
    }

    public void shiftKeyDown() {
        this.shiftKeyDown = true;
    }

    public void shiftKeyUp() {
        this.shiftKeyDown = false;
    }

    public void metaKeyDown() {
        this.metaKeyDown = true;
    }

    public void metaKeyUp() {
        this.metaKeyDown = false;
    }

    public void altKeyDown() {
        this.altKeyDown = true;
    }

    public void altKeyUp() {
        this.altKeyDown = true;
    }

    public void controlKeyDown() {
        this.controlKeyDown = true;
    }

    public void controlKeyUp() {
        this.controlKeyDown = false;
    }

    public void keyDown(String locator, String keySequence) {
        this.callEmbeddedSelenium("doKeyDown", this.findElement(locator), keySequence, this.controlKeyDown, this.altKeyDown, this.shiftKeyDown, this.metaKeyDown);
    }

    public void keyUp(String locator, String keySequence) {
        this.callEmbeddedSelenium("doKeyUp", this.findElement(locator), keySequence, this.controlKeyDown, this.altKeyDown, this.shiftKeyDown, this.metaKeyDown);
    }

    public void mouseOver(String locator) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEvent", element, "mouseover", true);
    }

    public void mouseOut(String locator) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEvent", element, "mouseout", true);
    }

    public void mouseDown(String locator) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEvent", element, "mousedown", true);
    }

    public void mouseDownRight(String locator) {
        throw new UnsupportedOperationException("mouseDownRight");
    }

    public void mouseDownAt(String locator, String coordString) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEventAt", element, "mousedown", coordString);
    }

    public void mouseDownRightAt(String locator, String coordString) {
        throw new UnsupportedOperationException("mouseDownRightAt");
    }

    public void mouseUp(String locator) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEvent", element, "mouseup", true);
    }

    public void mouseUpRight(String locator) {
        throw new UnsupportedOperationException("mouseUpRight");
    }

    public void mouseUpAt(String locator, String coordString) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEventAt", element, "mouseup", coordString);
    }

    public void mouseUpRightAt(String locator, String coordString) {
        throw new UnsupportedOperationException("mouseUpRightAt");
    }

    public void mouseMove(String locator) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEvent", element, "mousemove", true);
    }

    public void mouseMoveAt(String locator, String coordString) {
        WebElement element = this.findElement(locator);
        this.callEmbeddedSelenium("triggerMouseEventAt", element, "mousemove", coordString);
    }

    public void type(String locator, String value) {
        if (this.controlKeyDown || this.altKeyDown || this.metaKeyDown) {
            throw new SeleniumException("type not supported immediately after call to controlKeyDown() or altKeyDown() or metaKeyDown()");
        }
        if (this.shiftKeyDown) {
            value = value.toUpperCase();
        }
        WebElement element = this.findElement(locator);
        if (this.driver instanceof JavascriptExecutor && ((JavascriptExecutor)this.driver).isJavascriptEnabled()) {
            this.callEmbeddedSelenium("replaceText", element, value);
        } else {
            element.sendKeys(new CharSequence[]{value});
        }
    }

    public void typeKeys(String locator, String value) {
        value = value.replace("\\38", (CharSequence)Keys.ARROW_UP);
        value = value.replace("\\40", (CharSequence)Keys.ARROW_DOWN);
        value = value.replace("\\37", (CharSequence)Keys.ARROW_LEFT);
        value = value.replace("\\39", (CharSequence)Keys.ARROW_RIGHT);
        this.findElement(locator).sendKeys(new CharSequence[]{value});
    }

    public void setSpeed(String value) {
        throw new UnsupportedOperationException("setSpeed");
    }

    public String getSpeed() {
        throw new UnsupportedOperationException("getSpeed");
    }

    public void check(String locator) {
        this.findElement(locator).setSelected();
    }

    public void uncheck(String locator) {
        WebElement element = this.findElement(locator);
        if (element.isSelected()) {
            element.toggle();
        }
    }

    public void select(String selectLocator, String optionLocator) {
        this.removeAllSelections(selectLocator);
        this.select(selectLocator, optionLocator, true, true);
    }

    public void addSelection(String locator, String optionLocator) {
        WebElement select = this.findElement(locator);
        if (!"multiple".equals(select.getAttribute("multiple"))) {
            throw new SeleniumException("You may only add a selection to a select that supports multiple selections");
        }
        this.select(locator, optionLocator, true, false);
    }

    public void removeSelection(String locator, String optionLocator) {
        WebElement select = this.findElement(locator);
        if (!"multiple".equals(select.getAttribute("multiple"))) {
            throw new SeleniumException("You may only remove a selection to a select that supports multiple selections");
        }
        this.select(locator, optionLocator, false, false);
    }

    public void removeAllSelections(String locator) {
        WebElement select = this.findElement(locator);
        List options = select.findElements(By.tagName((String)"option"));
        if (select.getAttribute("multiple") == null) {
            if (options.size() > 0) {
                ((WebElement)options.get(0)).setSelected();
            }
            return;
        }
        this.removeAllSelections(options);
    }

    private void removeAllSelections(List<WebElement> options) {
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.toggle();
        }
    }

    public void submit(String formLocator) {
        this.findElement(formLocator).submit();
    }

    public void open(String url) {
        String urlToOpen = url;
        if (url.indexOf("://") == -1) {
            urlToOpen = this.baseUrl + (!url.startsWith("/") ? "/" : "") + url;
        }
        this.startTimeoutThread();
        this.driver.get(urlToOpen);
        this.stopTimeoutThreadIfExists();
    }

    public void openWindow(String url, String windowID) {
        this.startTimeoutThread();
        this.getEval(String.format("window.open('%s', '%s');", url, windowID));
        this.stopTimeoutThreadIfExists();
    }

    public void selectWindow(String windowID) {
        if ("null".equals(windowID)) {
            this.driver.switchTo().window(this.originalWindowHandle);
        } else if ("_blank".equals(windowID)) {
            this.selectBlankWindow();
        } else {
            if (windowID.startsWith("title=")) {
                this.selectWindowWithTitle(windowID.substring("title=".length()));
                return;
            }
            if (windowID.startsWith("name=")) {
                windowID = windowID.substring("name=".length());
            }
            try {
                this.driver.switchTo().window(windowID);
            }
            catch (NoSuchWindowException e) {
                this.selectWindowWithTitle(windowID);
            }
        }
    }

    private void selectWindowWithTitle(String title) {
        String current = this.driver.getWindowHandle();
        for (String handle : this.driver.getWindowHandles()) {
            this.driver.switchTo().window(handle);
            if (!title.equals(this.driver.getTitle())) continue;
            return;
        }
        this.driver.switchTo().window(current);
        throw new SeleniumException("Unable to select window with title: " + title);
    }

    private void selectBlankWindow() {
        String current = this.driver.getWindowHandle();
        ArrayList handles = new ArrayList(this.driver.getWindowHandles());
        for (String handle : handles) {
            this.driver.switchTo().window(handle);
            String value = (String)((JavascriptExecutor)this.driver).executeScript("return window.name;", new Object[0]);
            if (value != null) continue;
            return;
        }
        this.driver.switchTo().window(current);
        throw new SeleniumException("Unable to select window _blank");
    }

    public void selectPopUp(String windowID) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void deselectPopUp() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void selectFrame(String locator) {
        if ("relative=top".equals(locator)) {
            this.driver.switchTo().defaultContent();
            return;
        }
        try {
            this.driver.switchTo().frame(locator);
        }
        catch (NoSuchFrameException e) {
            throw new SeleniumException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        throw new UnsupportedOperationException("getWhetherThisFrameMatchFrameExpression");
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        throw new UnsupportedOperationException("getWhetherThisWindowMatchWindowExpression");
    }

    public void waitForPopUp(final String windowID, String timeout) {
        long millis = Long.parseLong(timeout);
        String current = this.driver.getWindowHandle();
        this.startTimeoutThread();
        new Wait(){

            public boolean until() {
                try {
                    if ("_blank".equals(windowID)) {
                        WebDriverBackedSelenium.this.selectBlankWindow();
                    } else {
                        WebDriverBackedSelenium.this.driver.switchTo().window(windowID);
                    }
                    return !"about:blank".equals(WebDriverBackedSelenium.this.driver.getCurrentUrl());
                }
                catch (SeleniumException seleniumException) {
                    return false;
                }
            }
        }.wait(String.format("Timed out waiting for %s. Waited %s", windowID, timeout), millis);
        this.stopTimeoutThreadIfExists();
        this.driver.switchTo().window(current);
    }

    public void chooseCancelOnNextConfirmation() {
        throw new UnsupportedOperationException("chooseCancelOnNextConfirmation");
    }

    public void chooseOkOnNextConfirmation() {
        throw new UnsupportedOperationException("chooseOkOnNextConfirmation");
    }

    public void answerOnNextPrompt(String answer) {
        throw new UnsupportedOperationException("answerOnNextPrompt");
    }

    public void goBack() {
        this.startTimeoutThread();
        this.driver.navigate().back();
        this.stopTimeoutThreadIfExists();
    }

    public void refresh() {
        this.startTimeoutThread();
        this.driver.navigate().refresh();
        this.stopTimeoutThreadIfExists();
    }

    public void close() {
        this.driver.close();
    }

    public boolean isAlertPresent() {
        throw new UnsupportedOperationException("isAlertPresent");
    }

    public boolean isPromptPresent() {
        throw new UnsupportedOperationException("isPromptPresent");
    }

    public boolean isConfirmationPresent() {
        throw new UnsupportedOperationException("isConfirmationPresent");
    }

    public String getAlert() {
        throw new UnsupportedOperationException("getAlert");
    }

    public String getConfirmation() {
        throw new UnsupportedOperationException("getConfirmation");
    }

    public String getPrompt() {
        throw new UnsupportedOperationException("getPrompt");
    }

    public String getLocation() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public String getBodyText() {
        return this.driver.findElement(By.xpath((String)"//body")).getText();
    }

    public String getValue(String locator) {
        return this.findElement(locator).getValue();
    }

    public String getText(String locator) {
        return this.findElement(locator).getText().trim();
    }

    public void highlight(String locator) {
        this.callEmbeddedHtmlUtils("highlight", this.findElement(locator), new Object[0]);
    }

    public String getEval(String script) {
        script = script.replaceAll("\n", "\\\\n");
        script = String.format("return eval(\"%s\");", script);
        return String.valueOf(((JavascriptExecutor)this.driver).executeScript(script, new Object[0]));
    }

    public boolean isChecked(String locator) {
        return this.findElement(locator).isSelected();
    }

    public String getTable(String tableCellAddress) {
        Matcher matcher = TABLE_PARTS.matcher(tableCellAddress);
        if (!matcher.matches()) {
            throw new SeleniumException("Invalid target format. Correct format is tableName.rowNum.columnNum");
        }
        String tableName = matcher.group(1);
        long row = Long.parseLong(matcher.group(2));
        long col = Long.parseLong(matcher.group(3));
        WebElement table = this.findElement(tableName);
        String script = "var table = arguments[0]; var row = arguments[1]; var col = arguments[2];if (row > table.rows.length) { return \"Cannot access row \" + row + \" - table has \" + table.rows.length + \" rows\"; }if (col > table.rows[row].cells.length) { return \"Cannot access column \" + col + \" - table row has \" + table.rows[row].cells.length + \" columns\"; }return table.rows[row].cells[col];";
        Object value = this.executeScript(script, table, row, col);
        if (value instanceof WebElement) {
            return ((WebElement)value).getText().trim();
        }
        throw new SeleniumException((String)value);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.findSelectedOptionProperties(selectLocator, "text");
    }

    public String getSelectedLabel(String selectLocator) {
        String[] labels = this.findSelectedOptionProperties(selectLocator, "text");
        return labels[0];
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.findSelectedOptionProperties(selectLocator, "value");
    }

    public String getSelectedValue(String selectLocator) {
        return this.findSelectedOptionProperties(selectLocator, "value")[0];
    }

    public String[] getSelectedIndexes(String selectLocator) {
        List<WebElement> options = this.getOptions(selectLocator);
        ArrayList<String> selected = new ArrayList<String>();
        for (int i = 0; i < options.size(); ++i) {
            WebElement option = options.get(i);
            if (!option.isSelected()) continue;
            selected.add(String.valueOf(i));
        }
        return selected.toArray(new String[selected.size()]);
    }

    public String getSelectedIndex(String selectLocator) {
        List<WebElement> options = this.getOptions(selectLocator);
        for (int i = 0; i < options.size(); ++i) {
            WebElement option = options.get(i);
            if (!option.isSelected()) continue;
            return String.valueOf(i);
        }
        throw new SeleniumException("No option is selected: " + selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.findSelectedOptionProperties(selectLocator, "id");
    }

    public String getSelectedId(String selectLocator) {
        return this.findSelectedOptionProperties(selectLocator, "id")[0];
    }

    public boolean isSomethingSelected(String selectLocator) {
        WebElement select = this.findElement(selectLocator);
        String name = select.getElementName().toLowerCase();
        if (!"select".equals(name)) {
            throw new SeleniumException("Specified element is not a Select");
        }
        for (WebElement option : select.findElements(By.tagName((String)"option"))) {
            if (!option.isSelected()) continue;
            return true;
        }
        return false;
    }

    public String[] getSelectOptions(String selectLocator) {
        WebElement select = this.findElement(selectLocator);
        List options = select.findElements(By.tagName((String)"option"));
        ArrayList<String> optionValues = new ArrayList<String>();
        for (WebElement option : options) {
            optionValues.add(option.getText());
        }
        return optionValues.toArray(new String[optionValues.size()]);
    }

    public String getAttribute(String attributeLocator) {
        int attributePos = attributeLocator.lastIndexOf("@");
        String elementLocator = attributeLocator.substring(0, attributePos);
        String attributeName = attributeLocator.substring(attributePos + 1);
        WebElement element = this.findElement(elementLocator);
        return element.getAttribute(attributeName);
    }

    public boolean isTextPresent(String pattern) {
        String text = this.driver.findElement(By.xpath((String)"/html/body")).getText();
        text = text.trim();
        String strategyName = "implicit";
        String use = pattern;
        Matcher matcher = TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN.matcher(pattern);
        if (matcher.matches()) {
            strategyName = matcher.group(1);
            use = matcher.group(2);
        }
        TextMatchingStrategy strategy = this.textMatchingStrategies.get(strategyName);
        return strategy.isAMatch(use, text);
    }

    public boolean isElementPresent(String locator) {
        try {
            this.findElement(locator);
            return true;
        }
        catch (SeleniumException e) {
            return false;
        }
    }

    public boolean isVisible(String locator) {
        return ((RenderedWebElement)this.findElement(locator)).isDisplayed();
    }

    public boolean isEditable(String locator) {
        WebElement element = this.findElement(locator);
        String value = element.getValue();
        String readonly = element.getAttribute("readonly");
        if (readonly == null) {
            readonly = "";
        }
        return value != null && element.isEnabled() && "".equals(readonly);
    }

    public String[] getAllButtons() {
        List allInputs = this.driver.findElements(By.xpath((String)"//input"));
        ArrayList<String> ids = new ArrayList<String>();
        for (WebElement input : allInputs) {
            String type = input.getAttribute("type").toLowerCase();
            if (!"button".equals(type) && !"submit".equals(type) && !"reset".equals(type)) continue;
            ids.add(input.getAttribute("id"));
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getAllLinks() {
        List allLinks = this.driver.findElements(By.xpath((String)"//a"));
        Iterator i = allLinks.iterator();
        ArrayList<String> links = new ArrayList<String>();
        while (i.hasNext()) {
            WebElement link = (WebElement)i.next();
            String id = link.getAttribute("id");
            if (id == null) {
                links.add("");
                continue;
            }
            links.add(id);
        }
        return links.toArray(new String[links.size()]);
    }

    public String[] getAllFields() {
        List allInputs = this.driver.findElements(By.xpath((String)"//input"));
        ArrayList<String> ids = new ArrayList<String>();
        for (WebElement input : allInputs) {
            String type = input.getAttribute("type").toLowerCase();
            if (!"text".equals(type)) continue;
            ids.add(input.getAttribute("id"));
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        String current = this.driver.getWindowHandle();
        ArrayList<String> attributes = new ArrayList<String>();
        for (String handle : this.driver.getWindowHandles()) {
            this.driver.switchTo().window(handle);
            String value = (String)((JavascriptExecutor)this.driver).executeScript("return '' + window[arguments[0]];", new Object[]{attributeName});
            attributes.add(value);
        }
        this.driver.switchTo().window(current);
        return attributes.toArray(new String[attributes.size()]);
    }

    public void dragdrop(String locator, String movementsString) {
        this.dragAndDrop(locator, movementsString);
    }

    public void setMouseSpeed(String pixels) {
        throw new UnsupportedOperationException("setMouseSpeed");
    }

    public Number getMouseSpeed() {
        throw new UnsupportedOperationException("getMouseSpeed");
    }

    public void dragAndDrop(String locator, String movementsString) {
        String[] parts = movementsString.split("\\s*,\\s*", 2);
        int xDelta = Integer.parseInt(parts[0].trim());
        int yDelta = Integer.parseInt(parts[1].trim());
        ((RenderedWebElement)this.findElement(locator)).dragAndDropBy(xDelta, yDelta);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        RenderedWebElement dragger = (RenderedWebElement)this.findElement(locatorOfObjectToBeDragged);
        RenderedWebElement draggee = (RenderedWebElement)this.findElement(locatorOfDragDestinationObject);
        dragger.dragAndDropOn(draggee);
    }

    public void windowFocus() {
        this.executeScript("window.focus()", new Object[0]);
    }

    public void windowMaximize() {
        this.executeScript("if (window.screen) { window.moveTo(0, 0); window.resizeTo(window.screen.availWidth, window.screen.availHeight);};", new Object[0]);
    }

    public String[] getAllWindowIds() {
        return this.getAttributeFromAllWindows("id");
    }

    public String[] getAllWindowNames() {
        return this.getAttributeFromAllWindows("name");
    }

    public String[] getAllWindowTitles() {
        String current = this.driver.getWindowHandle();
        ArrayList<String> attributes = new ArrayList<String>();
        for (String handle : this.driver.getWindowHandles()) {
            this.driver.switchTo().window(handle);
            attributes.add(this.driver.getTitle());
        }
        this.driver.switchTo().window(current);
        return attributes.toArray(new String[attributes.size()]);
    }

    public String getHtmlSource() {
        return this.driver.getPageSource();
    }

    public void setCursorPosition(String locator, String position) {
        throw new UnsupportedOperationException("setCursorPosition");
    }

    public Number getElementIndex(String locator) {
        WebElement element = this.findElement(locator);
        String script = "var _isCommentOrEmptyTextNode = function(node) {\n    return node.nodeType == 8 || ((node.nodeType == 3) && !(/[^\\t\\n\\r ]/.test(node.data)));\n}\n    var element = arguments[0];\n    var previousSibling;\n    var index = 0;\n    while ((previousSibling = element.previousSibling) != null) {\n        if (!_isCommentOrEmptyTextNode(previousSibling)) {\n            index++;\n        }\n        element = previousSibling;\n    }\n    return index;";
        return (Long)this.executeScript(script, element);
    }

    public boolean isOrdered(String locator1, String locator2) {
        WebElement one = this.findElement(locator1);
        WebElement two = this.findElement(locator2);
        String ordered = "    if (arguments[0] === arguments[1]) return false;\n\n    var previousSibling;\n    while ((previousSibling = arguments[1].previousSibling) != null) {\n        if (previousSibling === arguments[0]) {\n            return true;\n        }\n        arguments[1] = previousSibling;\n    }\n    return false;\n";
        Boolean result = (Boolean)this.executeScript(ordered, one, two);
        return result == null ? false : result;
    }

    public Number getElementPositionLeft(String locator) {
        Point location = ((RenderedWebElement)this.findElement(locator)).getLocation();
        return (int)location.getX();
    }

    public Number getElementPositionTop(String locator) {
        Point location = ((RenderedWebElement)this.findElement(locator)).getLocation();
        return (int)location.getY();
    }

    public Number getElementWidth(String locator) {
        Dimension size = ((RenderedWebElement)this.findElement(locator)).getSize();
        return (int)size.getWidth();
    }

    public Number getElementHeight(String locator) {
        Dimension size = ((RenderedWebElement)this.findElement(locator)).getSize();
        return (int)size.getHeight();
    }

    public Number getCursorPosition(String locator) {
        throw new UnsupportedOperationException("getCursorPosition");
    }

    public String getExpression(String expression) {
        return expression;
    }

    public Number getXpathCount(String xpath) {
        return this.driver.findElements(By.xpath((String)xpath)).size();
    }

    public void assignId(String locator, String identifier) {
        this.executeScript("arguments[0].id = arguments[1]", this.findElement(locator), identifier);
    }

    public void allowNativeXpath(String allow) {
    }

    public void ignoreAttributesWithoutValue(String ignore) {
    }

    public void waitForCondition(final String script, String timeout) {
        this.startTimeoutThread();
        new Wait(){

            public boolean until() {
                return (Boolean)((JavascriptExecutor)WebDriverBackedSelenium.this.driver).executeScript(script, new Object[0]);
            }
        }.wait("Failed to resolve " + script, Long.valueOf(timeout).longValue());
        this.stopTimeoutThreadIfExists();
    }

    public void setTimeout(String timeout) {
        this.timeout = Long.parseLong(timeout);
    }

    public void waitForPageToLoad(String timeout) {
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
    }

    public String getCookie() {
        StringBuilder builder = new StringBuilder();
        for (Cookie c : this.driver.manage().getCookies()) {
            builder.append(c.toString());
            builder.append("; ");
        }
        return builder.toString();
    }

    public String getCookieByName(String name) {
        for (Cookie cookie : this.driver.manage().getCookies()) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public boolean isCookiePresent(String name) {
        return this.getCookieByName(name) != null;
    }

    public void createCookie(String nameValuePair, String optionsString) {
        Matcher nameValuePairMatcher = this.NAME_VALUE_PAIR_PATTERN.matcher(nameValuePair);
        if (!nameValuePairMatcher.find()) {
            throw new SeleniumException("Invalid parameter: " + nameValuePair);
        }
        String name = nameValuePairMatcher.group(1);
        String value = nameValuePairMatcher.group(2);
        Matcher maxAgeMatcher = MAX_AGE_PATTERN.matcher(optionsString);
        Date maxAge = null;
        if (maxAgeMatcher.find()) {
            maxAge = new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAgeMatcher.group(1)) * 1000));
        }
        String path = null;
        Matcher pathMatcher = PATH_PATTERN.matcher(optionsString);
        if (pathMatcher.find()) {
            path = pathMatcher.group(1);
            try {
                if (path.startsWith("http")) {
                    path = new URL(path).getPath();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        Cookie cookie = new Cookie(name, value, path, maxAge);
        this.driver.manage().addCookie(cookie);
    }

    public void deleteCookie(String name, String optionsString) {
        this.driver.manage().deleteCookieNamed(name);
    }

    public void deleteAllVisibleCookies() {
        this.driver.manage().deleteAllCookies();
    }

    public void setBrowserLogLevel(String logLevel) {
    }

    public void runScript(String script) {
        this.executeScript(script, new Object[0]);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        throw new UnsupportedOperationException("addLocationStrategy");
    }

    public void captureEntirePageScreenshot(String filename, String kwargs) {
        throw new UnsupportedOperationException("captureEntirePageScreenshot");
    }

    public void rollup(String rollupName, String kwargs) {
        throw new UnsupportedOperationException("rollup");
    }

    public void useXpathLibrary(String libraryName) {
    }

    public void setContext(String context) {
    }

    public void attachFile(String fieldLocator, String fileLocator) {
        WebElement element = this.findElement(fieldLocator);
        element.clear();
        throw new UnsupportedOperationException("attachFile");
    }

    public void captureScreenshot(String filename) {
        throw new UnsupportedOperationException("captureScreenshot");
    }

    public String captureScreenshotToString() {
        throw new UnsupportedOperationException("captureScreenshotToString");
    }

    public String captureNetworkTraffic(String type) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public String captureEntirePageScreenshotToString(String kwargs) {
        throw new UnsupportedOperationException("captureEntirePageScreenshotToString");
    }

    public void shutDownSeleniumServer() {
        this.driver.quit();
    }

    public String retrieveLastRemoteControlLogs() {
        throw new UnsupportedOperationException("retrieveLastRemoteControlLogs");
    }

    public void keyDownNative(String keycode) {
        throw new UnsupportedOperationException("keyDownNative");
    }

    public void keyUpNative(String keycode) {
        throw new UnsupportedOperationException("keyUpNative");
    }

    public void keyPressNative(String keycode) {
        throw new UnsupportedOperationException("keyPressNative");
    }

    protected WebElement findElement(String locator) {
        LookupStrategy strategy = this.findStrategy(locator);
        String use = this.determineWebDriverLocator(locator);
        try {
            return strategy.find(this.driver, use);
        }
        catch (NoSuchElementException e) {
            throw new SeleniumException("Element " + locator + " not found");
        }
    }

    protected LookupStrategy findStrategy(String locator) {
        LookupStrategy strategy;
        String strategyName = "implicit";
        Matcher matcher = STRATEGY_AND_VALUE_PATTERN.matcher(locator);
        if (matcher.matches()) {
            strategyName = matcher.group(1);
        }
        if ((strategy = this.lookupStrategies.get(strategyName)) == null) {
            throw new SeleniumException("No matcher found for " + strategyName);
        }
        return strategy;
    }

    protected String determineWebDriverLocator(String locator) {
        String use = locator;
        Matcher matcher = STRATEGY_AND_VALUE_PATTERN.matcher(locator);
        if (matcher.matches()) {
            use = matcher.group(2);
        }
        return use;
    }

    private void callEmbeddedSelenium(String functionName, WebElement element, Object ... values) {
        StringBuilder builder = new StringBuilder(this.readScript(injectableSelenium));
        builder.append("return browserbot.").append(functionName).append(".apply(browserbot, arguments);");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(element);
        args.addAll(Arrays.asList(values));
        ((JavascriptExecutor)this.driver).executeScript(builder.toString(), args.toArray());
    }

    private void callEmbeddedHtmlUtils(String functionName, WebElement element, Object ... values) {
        StringBuilder builder = new StringBuilder(this.readScript(htmlUtils));
        builder.append("return htmlutils.").append(functionName).append(".apply(htmlutils, arguments);");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(element);
        args.addAll(Arrays.asList(values));
        ((JavascriptExecutor)this.driver).executeScript(builder.toString(), args.toArray());
    }

    private String readScript(String script) {
        InputStream raw = WebDriverBackedSelenium.class.getResourceAsStream(script);
        if (raw == null) {
            throw new RuntimeException("Cannot locate the embedded selenium instance");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(raw));
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line).append("\n");
                line = reader.readLine();
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                raw.close();
            }
            catch (IOException e) {}
        }
    }

    protected void select(String selectLocator, String optionLocator, boolean setSelected, boolean onlyOneOption) {
        OptionSelectStrategy strategy;
        WebElement select = this.findElement(selectLocator);
        List allOptions = select.findElements(By.tagName((String)"option"));
        boolean isMultiple = false;
        String multiple = select.getAttribute("multiple");
        if (multiple != null && "".equals(multiple)) {
            isMultiple = true;
        }
        if (onlyOneOption && isMultiple) {
            this.removeAllSelections(allOptions);
        }
        Matcher matcher = STRATEGY_AND_VALUE_PATTERN.matcher(optionLocator);
        String strategyName = "implicit";
        String use = optionLocator;
        if (matcher.matches()) {
            strategyName = matcher.group(1);
            use = matcher.group(2);
        }
        if (use == null) {
            use = "";
        }
        if ((strategy = this.optionSelectStrategies.get(strategyName)) == null) {
            throw new SeleniumException(strategyName + " (from " + optionLocator + ") is not a method for selecting options");
        }
        if (!strategy.select(allOptions, use, setSelected, isMultiple)) {
            throw new SeleniumException(optionLocator + " is not an option");
        }
    }

    private String[] findSelectedOptionProperties(String selectLocator, String property) {
        List<WebElement> options = this.getOptions(selectLocator);
        ArrayList<String> selectedOptions = new ArrayList<String>();
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            if ("text".equals(property)) {
                selectedOptions.add(option.getText());
                continue;
            }
            if ("value".equals(property)) {
                selectedOptions.add(option.getValue());
                continue;
            }
            String propVal = option.getAttribute(property);
            if (propVal == null) continue;
            selectedOptions.add(propVal);
        }
        if (selectedOptions.size() == 0) {
            throw new SeleniumException("No option selected");
        }
        return selectedOptions.toArray(new String[selectedOptions.size()]);
    }

    private List<WebElement> getOptions(String selectLocator) {
        WebElement element = this.findElement(selectLocator);
        List options = element.findElements(By.tagName((String)"option"));
        if (options.size() == 0) {
            throw new SeleniumException("Specified element is not a Select (has no options)");
        }
        return options;
    }

    private Object executeScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.driver).executeScript(script, args);
        }
        throw new UnsupportedOperationException("The underlying WebDriver instance does not support executing javascript");
    }

    public void captureEntirePageScreenshot(String s) {
        throw new UnsupportedOperationException();
    }

    public void addScript(String arg0, String arg1) {
        throw new UnsupportedOperationException("Selenium.addScript() not implemented yet.");
    }

    public void removeScript(String arg0) {
        throw new UnsupportedOperationException("Selenium.removeScript() not implemented yet.");
    }

    private final class TimeoutThread
    extends Thread {
        private long wait = 0L;
        private Thread callback;

        public TimeoutThread(Thread callback, long wait) {
            this.callback = callback;
            this.wait = wait;
        }

        public void run() {
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException e) {
                return;
            }
            this.callback.interrupt();
        }
    }
}

