/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.dawg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.dawg.DAWGTestResultSetSchema;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAWGTestResultSetParser
extends RDFHandlerBase {
    private final TupleQueryResultHandler tqrHandler;
    private Graph graph = new GraphImpl();

    public DAWGTestResultSetParser(TupleQueryResultHandler tqrHandler) {
        this.tqrHandler = tqrHandler;
    }

    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add((Object)st);
    }

    public void endRDF() throws RDFHandlerException {
        try {
            Resource resultSetNode = GraphUtil.getUniqueSubject((Graph)this.graph, (URI)RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET, (Resource[])new Resource[0]);
            List<String> bindingNames = this.getBindingNames(resultSetNode);
            this.tqrHandler.startQueryResult(bindingNames);
            Iterator solIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)resultSetNode, (URI)DAWGTestResultSetSchema.SOLUTION, (Resource[])new Resource[0]);
            while (solIter.hasNext()) {
                Value solutionNode = (Value)solIter.next();
                if (solutionNode instanceof Resource) {
                    this.reportSolution((Resource)solutionNode, bindingNames);
                    continue;
                }
                new RDFHandlerException("Value for " + DAWGTestResultSetSchema.SOLUTION + " is not a resource: " + solutionNode);
            }
            this.tqrHandler.endQueryResult();
        }
        catch (GraphUtilException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private List<String> getBindingNames(Resource resultSetNode) throws RDFHandlerException {
        ArrayList<String> bindingNames = new ArrayList<String>(16);
        Iterator varIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)resultSetNode, (URI)DAWGTestResultSetSchema.RESULTVARIABLE, (Resource[])new Resource[0]);
        while (varIter.hasNext()) {
            Value varName = (Value)varIter.next();
            if (varName instanceof Literal) {
                bindingNames.add(((Literal)varName).getLabel());
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.RESULTVARIABLE + " is not a literal: " + varName);
        }
        return bindingNames;
    }

    private void reportSolution(Resource solutionNode, List<String> bindingNames) throws RDFHandlerException, GraphUtilException {
        MapBindingSet bindingSet = new MapBindingSet(bindingNames.size());
        Iterator bindingIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)solutionNode, (URI)DAWGTestResultSetSchema.BINDING, (Resource[])new Resource[0]);
        while (bindingIter.hasNext()) {
            Value bindingNode = (Value)bindingIter.next();
            if (bindingNode instanceof Resource) {
                Binding binding = this.getBinding((Resource)bindingNode);
                bindingSet.addBinding(binding);
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.BINDING + " is not a resource: " + bindingNode);
        }
        try {
            this.tqrHandler.handleSolution(bindingSet);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private Binding getBinding(Resource bindingNode) throws GraphUtilException {
        Literal name = GraphUtil.getUniqueObjectLiteral((Graph)this.graph, (Resource)bindingNode, (URI)DAWGTestResultSetSchema.VARIABLE);
        Value value = GraphUtil.getUniqueObject((Graph)this.graph, (Resource)bindingNode, (URI)DAWGTestResultSetSchema.VALUE, (Resource[])new Resource[0]);
        return new BindingImpl(name.getLabel(), value);
    }
}

