/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import info.aduna.net.ParsedURI;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;

public abstract class RDFParserBase
implements RDFParser {
    protected RDFHandler rdfHandler;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;
    private ValueFactory valueFactory;
    private boolean verifyData;
    private boolean preserveBNodeIDs;
    private boolean stopAtFirstError;
    private RDFParser.DatatypeHandling datatypeHandling;
    private ParsedURI baseURI;
    private Map<String, BNode> bNodeIDMap = new HashMap<String, BNode>(16);
    private Map<String, String> namespaceTable = new HashMap<String, String>(16);

    public RDFParserBase() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public RDFParserBase(ValueFactory valueFactory) {
        this.setValueFactory(valueFactory);
        this.setVerifyData(true);
        this.setPreserveBNodeIDs(false);
        this.setStopAtFirstError(true);
        this.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public void setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    public void setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    public void setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    public void setVerifyData(boolean verifyData) {
        this.verifyData = verifyData;
    }

    public boolean verifyData() {
        return this.verifyData;
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    public boolean preserveBNodeIDs() {
        return this.preserveBNodeIDs;
    }

    public void setStopAtFirstError(boolean stopAtFirstError) {
        this.stopAtFirstError = stopAtFirstError;
    }

    public boolean stopAtFirstError() {
        return this.stopAtFirstError;
    }

    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        this.datatypeHandling = datatypeHandling;
    }

    public RDFParser.DatatypeHandling datatypeHandling() {
        return this.datatypeHandling;
    }

    protected void setBaseURI(String uriSpec) {
        ParsedURI baseURI = new ParsedURI(uriSpec);
        baseURI.normalize();
        this.setBaseURI(baseURI);
    }

    protected void setBaseURI(ParsedURI baseURI) {
        this.baseURI = baseURI;
    }

    protected void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
    }

    protected String getNamespace(String prefix) {
        return this.namespaceTable.get(prefix);
    }

    protected void clear() {
        this.baseURI = null;
        this.clearBNodeIDMap();
        this.namespaceTable.clear();
    }

    protected void clearBNodeIDMap() {
        this.bNodeIDMap.clear();
    }

    protected URI resolveURI(String uriSpec) throws RDFParseException {
        if (this.baseURI == null) {
            this.reportFatalError("Unable to resolve URIs, no base URI has been set");
        }
        ParsedURI uri = new ParsedURI(uriSpec);
        if (this.verifyData && uri.isRelative() && !uri.isSelfReference() && this.baseURI.isOpaque()) {
            this.reportError("Relative URI '" + uriSpec + "' cannot be resolved using the opaque base URI '" + this.baseURI + "'");
        }
        uri = this.baseURI.resolve(uri);
        return this.createURI(uri.toString());
    }

    protected URI createURI(String uri) throws RDFParseException {
        try {
            return this.valueFactory.createURI(uri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode() throws RDFParseException {
        try {
            return this.valueFactory.createBNode();
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode(String nodeID) throws RDFParseException {
        BNode result = this.bNodeIDMap.get(nodeID);
        if (result == null) {
            try {
                result = this.preserveBNodeIDs ? this.valueFactory.createBNode(nodeID) : this.valueFactory.createBNode();
            }
            catch (Exception e) {
                this.reportFatalError(e);
            }
            this.bNodeIDMap.put(nodeID, result);
        }
        return result;
    }

    protected Literal createLiteral(String label, String lang, URI datatype) throws RDFParseException {
        if (datatype != null) {
            if (this.datatypeHandling == RDFParser.DatatypeHandling.VERIFY) {
                if (!XMLDatatypeUtil.isValidValue((String)label, (URI)datatype)) {
                    this.reportError("'" + label + "' is not a valid value for datatype " + datatype);
                }
            } else if (this.datatypeHandling == RDFParser.DatatypeHandling.NORMALIZE) {
                try {
                    label = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                }
                catch (IllegalArgumentException e) {
                    this.reportError("'" + label + "' is not a valid value for datatype " + datatype + ": " + e.getMessage());
                }
            }
        }
        try {
            if (datatype != null) {
                return this.valueFactory.createLiteral(label, datatype);
            }
            if (lang != null) {
                return this.valueFactory.createLiteral(label, lang);
            }
            return this.valueFactory.createLiteral(label);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, URI pred, Value obj) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, URI pred, Value obj, Resource context) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj, context);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected void reportLocation(int lineNo, int columnNo) {
        if (this.locationListener != null) {
            this.locationListener.parseLocationUpdate(lineNo, columnNo);
        }
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, -1, -1);
    }

    protected void reportWarning(String msg, int lineNo, int columnNo) {
        if (this.errListener != null) {
            this.errListener.warning(msg, lineNo, columnNo);
        }
    }

    protected void reportError(String msg) throws RDFParseException {
        this.reportError(msg, -1, -1);
    }

    protected void reportError(String msg, int lineNo, int columnNo) throws RDFParseException {
        if (this.errListener != null) {
            this.errListener.error(msg, lineNo, columnNo);
        }
        if (this.stopAtFirstError) {
            throw new RDFParseException(msg, lineNo, columnNo);
        }
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, -1, -1);
    }

    protected void reportFatalError(String msg, int lineNo, int columnNo) throws RDFParseException {
        if (this.errListener != null) {
            this.errListener.fatalError(msg, lineNo, columnNo);
        }
        throw new RDFParseException(msg, lineNo, columnNo);
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, -1, -1);
    }

    protected void reportFatalError(Exception e, int lineNo, int columnNo) throws RDFParseException {
        if (e instanceof RDFParseException) {
            throw (RDFParseException)((Object)e);
        }
        if (this.errListener != null) {
            this.errListener.fatalError(e.getMessage(), lineNo, columnNo);
        }
        throw new RDFParseException(e, lineNo, columnNo);
    }
}

