/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class NTriplesWriter
implements RDFWriter {
    private Writer writer;
    private boolean writingStarted;

    public NTriplesWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("US-ASCII")));
    }

    public NTriplesWriter(Writer writer) {
        this.writer = writer;
        this.writingStarted = false;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            this.writeResource(subj);
            this.writer.write(" ");
            this.writeURI(pred);
            this.writer.write(" ");
            if (obj instanceof Resource) {
                this.writeResource((Resource)obj);
            } else if (obj instanceof Literal) {
                this.writeLiteral((Literal)obj);
            }
            this.writer.write(" .");
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeResource(Resource res) throws IOException {
        if (res instanceof BNode) {
            this.writeBNode((BNode)res);
        } else {
            this.writeURI((URI)res);
        }
    }

    private void writeURI(URI uri) throws IOException {
        this.writer.write(NTriplesUtil.toNTriplesString(uri));
    }

    private void writeBNode(BNode bNode) throws IOException {
        this.writer.write(NTriplesUtil.toNTriplesString(bNode));
    }

    private void writeLiteral(Literal lit) throws IOException {
        this.writer.write(NTriplesUtil.toNTriplesString(lit));
    }

    private void writeNewLine() throws IOException {
        this.writer.write("\n");
    }
}

