/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.IteratorIteration;
import info.aduna.iteration.LockingIteration;
import info.aduna.iteration.UnionIteration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelPruner;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.algebra.evaluation.util.QueryOptimizerList;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementIterator;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.openrdf.sail.memory.model.ReadMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStoreConnection
extends SailConnectionBase
implements InferencerConnection {
    protected final MemoryStore store;
    private Lock txnLock;
    private Lock txnStLock;

    protected MemoryStoreConnection(MemoryStore store) {
        super((SailBase)store);
        this.store = store;
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        if (!((tupleExpr = tupleExpr.clone()) instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        Lock stLock = this.store.getStatementsReadLock();
        try {
            int snapshot = this.store.getCurrentSnapshot();
            ReadMode readMode = ReadMode.COMMITTED;
            if (this.transactionActive()) {
                ++snapshot;
                readMode = ReadMode.TRANSACTION;
            }
            MemTripleSource tripleSource = new MemTripleSource(includeInferred, snapshot, readMode);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            QueryOptimizerList optimizerList = new QueryOptimizerList();
            optimizerList.add((QueryOptimizer)new BindingAssigner());
            optimizerList.add((QueryOptimizer)new ConstantOptimizer((EvaluationStrategy)strategy));
            optimizerList.add((QueryOptimizer)new CompareOptimizer());
            optimizerList.add((QueryOptimizer)new ConjunctiveConstraintSplitter());
            optimizerList.add((QueryOptimizer)new SameTermFilterOptimizer());
            optimizerList.add((QueryOptimizer)new QueryModelPruner());
            optimizerList.add((QueryOptimizer)new QueryJoinOptimizer((EvaluationStatistics)new MemEvaluationStatistics()));
            optimizerList.add((QueryOptimizer)new FilterOptimizer());
            optimizerList.optimize(tupleExpr, dataset, bindings);
            CloseableIteration iter = strategy.evaluate(tupleExpr, bindings);
            return new LockingIteration(stLock, (Iteration)iter);
        }
        catch (QueryEvaluationException e) {
            stLock.release();
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            stLock.release();
            throw e;
        }
    }

    protected void closeInternal() throws SailException {
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        try {
            Object iter = new UnionIteration(new Iteration[]{new IteratorIteration(this.store.getValueFactory().getMemURIs().iterator()), new IteratorIteration(this.store.getValueFactory().getMemBNodes().iterator())});
            final int snapshot = this.transactionActive() ? this.store.getCurrentSnapshot() + 1 : this.store.getCurrentSnapshot();
            final ReadMode readMode = this.transactionActive() ? ReadMode.TRANSACTION : ReadMode.COMMITTED;
            iter = new FilterIteration<MemResource, SailException>((Iteration)iter){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected boolean accept(MemResource memResource) throws SailException {
                    MemStatementList contextStatements = memResource.getContextStatementList();
                    if (contextStatements.size() == 0) {
                        return false;
                    }
                    MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, false, snapshot, readMode, new MemResource[0]);
                    try {
                        boolean bl = iter.hasNext();
                        return bl;
                    }
                    finally {
                        iter.close();
                    }
                }
            };
            iter = new LockingIteration(stLock, (Iteration)iter);
            return iter;
        }
        catch (RuntimeException e) {
            stLock.release();
            throw e;
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        try {
            int snapshot = this.store.getCurrentSnapshot();
            ReadMode readMode = ReadMode.COMMITTED;
            if (this.transactionActive()) {
                ++snapshot;
                readMode = ReadMode.TRANSACTION;
            }
            return new LockingIteration(stLock, this.store.createStatementIterator(SailException.class, subj, pred, obj, !includeInferred, snapshot, readMode, contexts));
        }
        catch (RuntimeException e) {
            stLock.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sizeInternal(Resource ... contexts) throws SailException {
        Lock stLock = this.store.getStatementsReadLock();
        try {
            long l;
            CloseableIteration<? extends Statement, SailException> iter = this.getStatementsInternal(null, null, null, false, contexts);
            try {
                long size = 0L;
                while (iter.hasNext()) {
                    iter.next();
                    ++size;
                }
                l = size;
            }
            catch (Throwable throwable) {
                iter.close();
                throw throwable;
            }
            iter.close();
            return l;
        }
        finally {
            stLock.release();
        }
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return new CloseableIteratorIteration(this.store.getNamespaceStore().iterator());
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.store.getNamespaceStore().getNamespace(prefix);
    }

    protected void startTransactionInternal() throws SailException {
        if (!this.store.isWritable()) {
            throw new SailException("Unable to start transaction: data file is read-only");
        }
        this.txnStLock = this.store.getStatementsReadLock();
        this.txnLock = this.store.getTransactionLock();
        this.store.startTransaction();
    }

    protected void commitInternal() throws SailException {
        this.store.commit();
        this.txnLock.release();
        this.txnStLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackInternal() throws SailException {
        try {
            this.store.rollback();
        }
        finally {
            this.txnLock.release();
            this.txnStLock.release();
        }
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatementInternal(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            boolean bl;
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                bl = this.addStatementInternal(subj, pred, obj, false, contexts);
            }
            catch (Throwable throwable) {
                txnLock.release();
                throw throwable;
            }
            txnLock.release();
            return bl;
        }
        finally {
            conLock.release();
        }
    }

    protected boolean addStatementInternal(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        Statement st = null;
        if (contexts.length == 0) {
            st = this.store.addStatement(subj, pred, obj, null, explicit);
            if (st != null) {
                this.notifyStatementAdded(st);
            }
        } else {
            for (Resource context : contexts) {
                st = this.store.addStatement(subj, pred, obj, context, explicit);
                if (st == null) continue;
                this.notifyStatementAdded(st);
            }
        }
        return st != null;
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.removeStatementsInternal(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            boolean bl;
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                bl = this.removeStatementsInternal(subj, pred, obj, false, contexts);
            }
            catch (Throwable throwable) {
                txnLock.release();
                throw throwable;
            }
            txnLock.release();
            return bl;
        }
        finally {
            conLock.release();
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInferred(Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.removeStatementsInternal(null, null, null, false, contexts);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    public void flushUpdates() {
    }

    protected boolean removeStatementsInternal(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        CloseableIteration<MemStatement, SailException> stIter = this.store.createStatementIterator(SailException.class, subj, pred, obj, explicit, this.store.getCurrentSnapshot() + 1, ReadMode.TRANSACTION, contexts);
        return this.removeIteratorStatements(stIter, explicit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeIteratorStatements(CloseableIteration<MemStatement, SailException> stIter, boolean explicit) throws SailException {
        boolean statementsRemoved = false;
        try {
            while (stIter.hasNext()) {
                MemStatement st = (MemStatement)((Object)stIter.next());
                if (!this.store.removeStatement(st, explicit)) continue;
                statementsRemoved = true;
                this.notifyStatementRemoved((Statement)st);
            }
        }
        finally {
            stIter.close();
        }
        return statementsRemoved;
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        try {
            this.store.getNamespaceStore().setNamespace(prefix, name);
        }
        catch (IllegalArgumentException e) {
            throw new SailException(e.getMessage());
        }
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.store.getNamespaceStore().removeNamespace(prefix);
    }

    protected void clearNamespacesInternal() throws SailException {
        this.store.getNamespaceStore().clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MemEvaluationStatistics
    extends EvaluationStatistics {
        protected MemEvaluationStatistics() {
        }

        protected EvaluationStatistics.CardinalityCalculator getCardinalityCalculator(Set<String> boundVars) {
            return new MemCardinalityCalculator(boundVars);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class MemCardinalityCalculator
        extends EvaluationStatistics.CardinalityCalculator {
            public MemCardinalityCalculator(Set<String> boundVars) {
                super(boundVars);
            }

            public void meet(StatementPattern sp) {
                Resource subj = (Resource)this.getConstantValue(sp.getSubjectVar());
                URI pred = (URI)this.getConstantValue(sp.getPredicateVar());
                Value obj = this.getConstantValue(sp.getObjectVar());
                Resource context = (Resource)this.getConstantValue(sp.getContextVar());
                MemValueFactory valueFactory = MemoryStoreConnection.this.store.getValueFactory();
                MemResource memSubj = valueFactory.getMemResource(subj);
                MemURI memPred = valueFactory.getMemURI(pred);
                MemValue memObj = valueFactory.getMemValue(obj);
                MemResource memContext = valueFactory.getMemResource(context);
                if (subj != null && memSubj == null || pred != null && memPred == null || obj != null && memObj == null || context != null && memContext == null) {
                    this.cardinality = 0.0;
                    return;
                }
                ArrayList<Integer> listSizes = new ArrayList<Integer>(4);
                if (memSubj != null) {
                    listSizes.add(memSubj.getSubjectStatementCount());
                }
                if (memPred != null) {
                    listSizes.add(memPred.getPredicateStatementCount());
                }
                if (memObj != null) {
                    listSizes.add(memObj.getObjectStatementCount());
                }
                if (memContext != null) {
                    listSizes.add(memContext.getContextStatementCount());
                }
                if (listSizes.isEmpty()) {
                    this.cardinality = MemoryStoreConnection.this.store.size();
                    int sqrtFactor = 2 * this.countBoundVars(sp);
                    if (sqrtFactor > 1) {
                        this.cardinality = Math.pow(this.cardinality, 1.0 / (double)sqrtFactor);
                    }
                } else {
                    this.cardinality = ((Integer)Collections.min(listSizes)).intValue();
                    int constantVarCount = this.countConstantVars(sp);
                    int boundVarCount = this.countBoundVars(sp);
                    int sqrtFactor = 2 * boundVarCount + Math.max(0, constantVarCount - 1);
                    if (sqrtFactor > 1) {
                        this.cardinality = Math.pow(this.cardinality, 1.0 / (double)sqrtFactor);
                    }
                }
            }

            protected Value getConstantValue(Var var) {
                if (var != null) {
                    return var.getValue();
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MemTripleSource
    implements TripleSource {
        protected final int snapshot;
        protected final ReadMode readMode;
        protected final boolean includeInferred;

        public MemTripleSource(boolean includeInferred, int snapshot, ReadMode readMode) {
            this.includeInferred = includeInferred;
            this.snapshot = snapshot;
            this.readMode = readMode;
        }

        public CloseableIteration<MemStatement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) {
            return MemoryStoreConnection.this.store.createStatementIterator(QueryEvaluationException.class, subj, pred, obj, !this.includeInferred, this.snapshot, this.readMode, contexts);
        }

        public MemValueFactory getValueFactory() {
            return MemoryStoreConnection.this.store.getValueFactory();
        }
    }
}

