/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import info.aduna.iteration.CloseableIterationBase;
import info.aduna.lang.ObjectUtil;
import java.util.NoSuchElementException;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.ReadMode;
import org.openrdf.sail.memory.model.TxnStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemStatementIterator<X extends Exception>
extends CloseableIterationBase<MemStatement, X> {
    private MemStatementList statementList;
    private MemResource subject;
    private MemURI predicate;
    private MemValue object;
    private MemResource[] contexts;
    private boolean explicitOnly;
    private int snapshot;
    private ReadMode readMode;
    private MemStatement nextStatement;
    private int nextStatementIdx;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemURI predicate, MemValue object, boolean explicitOnly, int snapshot, ReadMode readMode, MemResource ... contexts) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
        this.explicitOnly = explicitOnly;
        this.snapshot = snapshot;
        this.readMode = readMode;
        this.nextStatementIdx = -1;
    }

    private void findNextStatement() {
        ++this.nextStatementIdx;
        while (this.nextStatementIdx < this.statementList.size()) {
            block6: {
                TxnStatus txnStatus;
                block7: {
                    this.nextStatement = this.statementList.get(this.nextStatementIdx);
                    if (!this.nextStatement.isInSnapshot(this.snapshot) || this.subject != null && this.subject != this.nextStatement.getSubject() || this.predicate != null && this.predicate != this.nextStatement.getPredicate() || this.object != null && this.object != this.nextStatement.getObject()) break block6;
                    if (this.contexts == null || this.contexts.length <= 0) break block7;
                    boolean matchingContext = false;
                    for (int i = 0; i < this.contexts.length && !matchingContext; ++i) {
                        matchingContext = ObjectUtil.nullEquals((Object)this.nextStatement.getContext(), (Object)this.contexts[i]);
                    }
                    if (!matchingContext) break block6;
                }
                if (!(ReadMode.COMMITTED.equals((Object)this.readMode) ? this.nextStatement.getTxnStatus() == TxnStatus.NEW || this.explicitOnly && !this.nextStatement.isExplicit() : (ReadMode.TRANSACTION.equals((Object)this.readMode) ? TxnStatus.DEPRECATED.equals(txnStatus = this.nextStatement.getTxnStatus()) || TxnStatus.ZOMBIE.equals(txnStatus) || this.explicitOnly && (!this.nextStatement.isExplicit() && !TxnStatus.EXPLICIT.equals(txnStatus) || TxnStatus.INFERRED.equals(txnStatus)) : ReadMode.RAW.equals((Object)this.readMode) && this.explicitOnly && !this.nextStatement.isExplicit()))) {
                    return;
                }
            }
            ++this.nextStatementIdx;
        }
        this.nextStatement = null;
    }

    public boolean hasNext() {
        if (this.nextStatement == null && this.statementList != null && this.nextStatementIdx < this.statementList.size()) {
            this.findNextStatement();
        }
        return this.nextStatement != null;
    }

    public MemStatement next() {
        if (this.statementList == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        if (this.nextStatement == null && this.nextStatementIdx < this.statementList.size()) {
            this.findNextStatement();
        }
        if (this.nextStatement == null) {
            throw new NoSuchElementException("No more statements");
        }
        MemStatement result = this.nextStatement;
        this.nextStatement = null;
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void handleClose() throws X {
        this.nextStatement = null;
        this.statementList = null;
        this.subject = null;
        this.predicate = null;
        this.object = null;
        this.contexts = null;
        super.handleClose();
    }
}

