/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.platform;

import info.aduna.platform.Platform;
import java.io.File;

public abstract class PlatformBase
implements Platform {
    protected String whitespaceReplacement = "-";
    protected String separatorReplacement = "-";
    protected String colonReplacement = "";

    public File getUserHome() {
        File result = null;
        String userHome = System.getProperty("user.home");
        result = new File(userHome);
        return result;
    }

    public final File getApplicationDataDir() {
        File result = this.getOSApplicationDataDir();
        String sysProp = System.getProperty("info.aduna.platform.appdata.basedir");
        if (sysProp != null) {
            result = new File(sysProp);
        } else {
            String oldSysProp = System.getProperty("aduna.platform.applicationdata.dir");
            if (oldSysProp != null) {
                System.out.println("Old Aduna datadir property \"aduna.platform.applicationdata.dir\" detected. This property has been replaced by \"info.aduna.platform.appdata.basedir\". Support for the old property may be removed in a future version of this application.");
                result = new File(oldSysProp);
            }
        }
        return result;
    }

    public final File getApplicationDataDir(String applicationName) {
        return new File(this.getApplicationDataDir(), this.getRelativeApplicationDataDir(applicationName));
    }

    public final File getOSApplicationDataDir(String applicationName) {
        return new File(this.getOSApplicationDataDir(), this.getRelativeApplicationDataDir(applicationName));
    }

    public String getRelativeApplicationDataDir(String applicationName) {
        return this.getRelativeApplicationDataDir(applicationName, this.dataDirPreserveCase(), this.dataDirReplaceWhitespace(), this.dataDirReplaceColon());
    }

    public String getRelativeApplicationDataDir(String applicationName, boolean caseSensitive, boolean replaceWhitespace, boolean replaceColon) {
        String result = applicationName.replace(File.separator, this.separatorReplacement);
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        if (replaceWhitespace) {
            result = result.replaceAll("\\s", this.whitespaceReplacement);
        }
        if (replaceColon) {
            result = result.replace(":", this.colonReplacement);
        }
        return result;
    }
}

