/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow.internal.csv;

import java.util.regex.Pattern;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;

class Internal {
    static final Pattern ARGUMENT_MATCHER = Pattern.compile("Argument\\[(-?\\d+)\\.?\\.?(\\d+)?]");

    Internal() {
    }

    static boolean matches(JavaType parameter, String parameterSignature) {
        String parameterString = Internal.typePattern(parameter);
        if (parameterString == null) {
            return false;
        }
        if (parameterSignature.contains(".")) {
            return parameterString.equals(parameterSignature);
        }
        return parameterString.substring(parameterString.lastIndexOf(46) + 1).equals(parameterSignature);
    }

    @Nullable
    static String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            if (type.equals(JavaType.Primitive.String)) {
                return ((JavaType.Primitive)type).getClassName();
            }
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Unknown) {
            return "*";
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elemType = ((JavaType.Array)type).getElemType();
            return Internal.typePattern(elemType) + "[]";
        }
        return null;
    }
}

