/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.variable;

import fj.data.Option;
import fj.data.Validation;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.analysis.trait.member.Callable;
import org.openrewrite.analysis.trait.member.InstanceInitializer;
import org.openrewrite.analysis.trait.member.Method;
import org.openrewrite.analysis.trait.member.StaticInitializerMethod;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.LocalVariableDecl;
import org.openrewrite.analysis.trait.variable.VariableUtil;
import org.openrewrite.analysis.util.FlagUtil;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

class LocalVariableDeclBase
extends Top.Base
implements LocalVariableDecl {
    final Cursor cursor;
    final J.VariableDeclarations.NamedVariable variable;
    final J.VariableDeclarations variableDeclarations;
    final Callable callable;

    @Override
    public String getName() {
        return this.variable.getSimpleName();
    }

    @Override
    public UUID getId() {
        return this.variable.getId();
    }

    @Override
    public Option<JavaType> getType() {
        return Option.fromNull((Object)this.variable.getType());
    }

    @Override
    public Collection<VarAccess> getVarAccesses() {
        return VarAccess.findAllInScope(this.cursor.dropParentUntil(JavaSourceFile.class::isInstance), this);
    }

    @Override
    public Collection<Expr> getAssignedValues() {
        return VariableUtil.findAssignedValues(this.cursor.dropParentUntil(JavaSourceFile.class::isInstance), this);
    }

    @Override
    public Collection<Flag> getFlags() {
        return FlagUtil.fromModifiers(this.variableDeclarations.getModifiers());
    }

    static Validation<TraitErrors, Callable> findNearestParentCallable(Cursor cursor) {
        Cursor c2;
        Tree t;
        Iterator path = cursor.getPathAsCursors(c -> c.getValue() instanceof J);
        Cursor previous = null;
        while (!(!path.hasNext() || (t = (Tree)(c2 = (Cursor)path.next()).getValue()) instanceof J.ClassDeclaration || t instanceof J.NewClass && previous != null && ((J.NewClass)t).getBody() == previous.getValue())) {
            Validation<TraitErrors, Method> v;
            if (t instanceof J.Block && J.Block.isStaticOrInitBlock((Cursor)c2)) {
                J.Block block = (J.Block)t;
                if (block.isStatic()) {
                    return StaticInitializerMethod.viewOf(c2.getParentTreeCursor()).map(m -> m);
                }
                return InstanceInitializer.viewOf(c2.getParentTreeCursor()).map(m -> m);
            }
            if (t instanceof J.MethodDeclaration) {
                J.MethodDeclaration m2 = (J.MethodDeclaration)t;
                assert (previous != null) : "previous should not be null";
                if (m2.getParameters().contains(previous.getValue())) {
                    break;
                }
            } else if (t instanceof J.Lambda) {
                J.Lambda l = (J.Lambda)t;
                assert (previous != null) : "previous should not be null";
                if (l.getParameters().getParameters().contains(previous.getValue())) break;
            }
            if ((v = Method.viewOf(c2)).isSuccess()) {
                return v.map(m -> m);
            }
            previous = c2;
        }
        return TraitErrors.invalidTraitCreationError("No parent Method found");
    }

    public LocalVariableDeclBase(Cursor cursor, J.VariableDeclarations.NamedVariable variable, J.VariableDeclarations variableDeclarations, Callable callable) {
        this.cursor = cursor;
        this.variable = variable;
        this.variableDeclarations = variableDeclarations;
        this.callable = callable;
    }

    @Override
    public Callable getCallable() {
        return this.callable;
    }
}

