/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class PreferSecretsInheritWorkflow
extends Recipe {
    public String getDisplayName() {
        return "Use `secrets: inherit` if possible";
    }

    public String getDescription() {
        return "Pass all secrets to a reusable workflow using `secrets: inherit`. See [Simplify using secrets with reusable workflows](https://github.blog/changelog/2022-05-03-github-actions-simplify-using-secrets-with-reusable-workflows/) for details.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher secrets = new JsonPathMatcher("$.jobs..secrets");
        return Preconditions.check((TreeVisitor)new FindSourceFiles(".github/workflows/*.yml").getVisitor(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private static final String USE_INHERIT = "USE_INHERIT";

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                boolean allUntransformed;
                Cursor parentEntry = this.getCursor().getParent();
                if (parentEntry != null && secrets.matches(parentEntry) && (allUntransformed = mapping.getEntries().stream().allMatch(this::isUntransformedSecret))) {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Mapping.Entry.class, USE_INHERIT, (Object)true);
                }
                return super.visitMapping(mapping, (Object)ctx);
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage(USE_INHERIT, (Object)false)).booleanValue()) {
                    Yaml.Scalar inheritValue = new Yaml.Scalar(Tree.randomId(), " ", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, "inherit");
                    return e.withValue((Yaml.Block)inheritValue);
                }
                return e;
            }

            private boolean isUntransformedSecret(Yaml.Mapping.Entry entry) {
                String key = entry.getKey().getValue();
                Pattern secretPattern = Pattern.compile("\\$\\{\\{\\s*secrets." + key + "\\s*}}");
                Yaml.Block value = entry.getValue();
                return value instanceof Yaml.Scalar && secretPattern.matcher(((Yaml.Scalar)value).getValue()).matches();
            }
        });
    }

    public String toString() {
        return "PreferSecretsInheritWorkflow()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferSecretsInheritWorkflow)) {
            return false;
        }
        PreferSecretsInheritWorkflow other = (PreferSecretsInheritWorkflow)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreferSecretsInheritWorkflow;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

